/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.collection.TrieUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.SecurityTokenProvider;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.ContactsScrubber;
import org.limewire.mojito.util.EntryImpl;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LookupResponseHandler<V extends LookupResult>
extends AbstractResponseHandler<V> {
    private static final Log LOG = LogFactory.getLog(LookupResponseHandler.class);
    protected final KUID lookupId;
    private final KUID furthestId;
    protected final Set<KUID> queried = new LinkedHashSet<KUID>();
    protected final Trie<KUID, Contact> toQuery = new PatriciaTrie(KUID.KEY_ANALYZER);
    protected final Trie<KUID, Map.Entry<Contact, SecurityToken>> responsePath = new PatriciaTrie(KUID.KEY_ANALYZER);
    private final Map<KUID, Integer> hopMap = new HashMap<KUID, Integer>();
    private final Set<KUID> routeTableNodes = new LinkedHashSet<KUID>();
    private final Set<Contact> forcedContacts = new LinkedHashSet<Contact>();
    protected final Collection<Contact> collisions = new LinkedHashSet<Contact>();
    private int activeSearches = 0;
    private int currentHop = 0;
    private int resultSetSize;
    private int parellelism;
    private boolean selectAliveNodesOnly = false;
    private long startTime = -1L;
    private int routeTableFailureCount = 0;
    private int totalFailures = 0;
    private boolean deleteFurthest = true;

    protected LookupResponseHandler(Context context, KUID kUID) {
        super(context);
        this.lookupId = kUID;
        this.furthestId = kUID.invert();
        this.setMaxErrors(0);
        this.setParallelism(-1);
        this.setResultSetSize(-1);
        this.setDeleteFurthest(LookupSettings.DELETE_FURTHEST_CONTACT.getValue());
    }

    public KUID getLookupID() {
        return this.lookupId;
    }

    public void setResultSetSize(int n) {
        if (n < 0) {
            this.resultSetSize = KademliaSettings.REPLICATION_PARAMETER.getValue();
        } else if (n > 0) {
            this.resultSetSize = n;
        } else {
            throw new IllegalArgumentException("resultSetSize=" + n);
        }
    }

    public int getResultSetSize() {
        return this.resultSetSize;
    }

    public void setParallelism(int n) {
        if (n < 0) {
            this.parellelism = this.getDefaultParallelism();
        } else if (n > 0) {
            this.parellelism = n;
        } else {
            throw new IllegalArgumentException("parellelism=" + n);
        }
    }

    protected abstract int getDefaultParallelism();

    public int getParallelism() {
        return this.parellelism;
    }

    public void addForcedContact(Contact contact) {
        this.forcedContacts.add(contact);
    }

    public Collection<Contact> getForcedContacts() {
        return Collections.unmodifiableSet(this.forcedContacts);
    }

    @Override
    public long getElapsedTime() {
        if (this.startTime > 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return -1L;
    }

    public int getRouteTableFailureCount() {
        return this.routeTableFailureCount;
    }

    protected abstract boolean isTimeout(long var1);

    public void setSelectAliveNodesOnly(boolean bl) {
        this.selectAliveNodesOnly = bl;
    }

    public boolean isSelectAliveNodesOnly() {
        return this.selectAliveNodesOnly;
    }

    public void setDeleteFurthest(boolean bl) {
        this.deleteFurthest = bl;
    }

    public boolean isDeleteFurthest() {
        return this.deleteFurthest;
    }

    @Override
    protected void start() throws DHTException {
        Contact contact;
        Collection<Contact> collection = null;
        collection = this.isSelectAliveNodesOnly() ? this.context.getRouteTable().select(this.lookupId, 2 * this.getResultSetSize(), RouteTable.SelectMode.ALIVE) : this.context.getRouteTable().select(this.lookupId, this.getResultSetSize(), RouteTable.SelectMode.ALL);
        for (Contact iterator2 : collection) {
            this.addYetToBeQueried(iterator2, this.currentHop + 1);
            this.routeTableNodes.add(iterator2.getNodeID());
        }
        this.addToResponsePath(this.context.getLocalNode(), null);
        this.markAsQueried(this.context.getLocalNode());
        ArrayList<Contact> arrayList = new ArrayList<Contact>(this.getContactsToQuery(this.lookupId, this.getParallelism()));
        if (arrayList.size() >= 3 && !arrayList.contains(contact = ContactUtils.getMostRecentlySeen(collection = ContactUtils.sort(collection))) && !this.context.isLocalNode(contact)) {
            if (arrayList.size() >= this.getParallelism()) {
                arrayList.remove(arrayList.size() - 1);
            }
            arrayList.add(contact);
        }
        for (Contact contact2 : this.forcedContacts) {
            if (arrayList.contains(contact2)) continue;
            arrayList.add(0, contact2);
            this.hopMap.put(contact2.getNodeID(), this.currentHop + 1);
            int n = arrayList.size() - 1;
            if (arrayList.size() <= this.getParallelism() || this.forcedContacts.contains(arrayList.get(n))) continue;
            arrayList.remove(n);
        }
        this.startTime = System.currentTimeMillis();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Contact contact2;
            contact2 = (Contact)iterator.next();
            try {
                this.lookup(contact2);
            }
            catch (IOException iOException) {
                throw new DHTException(iOException);
            }
        }
        this.finishLookupIfDone();
    }

    @Override
    protected void response(ResponseMessage responseMessage, long l) throws IOException {
        this.decrementActiveSearches();
        Contact contact = responseMessage.getContact();
        Integer n = this.hopMap.remove(contact.getNodeID());
        assert (n != null);
        this.currentHop = n;
        if (this.nextStep(responseMessage)) {
            this.nextLookupStep();
        }
        this.finishLookupIfDone();
    }

    protected abstract boolean nextStep(ResponseMessage var1) throws IOException;

    protected final boolean handleNodeResponse(FindNodeResponse findNodeResponse) {
        Contact contact = findNodeResponse.getContact();
        Collection<? extends Contact> collection = findNodeResponse.getNodes();
        if (collection.isEmpty()) {
            if (LookupSettings.ACCEPT_EMPTY_FIND_NODE_RESPONSES.getValue()) {
                this.addToResponsePath(findNodeResponse);
            }
            return true;
        }
        ContactsScrubber contactsScrubber = ContactsScrubber.scrub(this.context, contact, collection, LookupSettings.CONTACTS_SCRUBBER_REQUIRED_RATIO.getValue());
        if (contactsScrubber.isValidResponse()) {
            for (Contact contact2 : contactsScrubber.getScrubbed()) {
                if (this.isQueried(contact2) || this.isYetToBeQueried(contact2)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Adding " + contact2 + " to the yet-to-be queried list"));
                }
                this.addYetToBeQueried(contact2, this.currentHop + 1);
                assert (!contact2.isAlive());
                this.context.getRouteTable().add(contact2);
            }
            this.collisions.addAll(contactsScrubber.getCollisions());
            this.addToResponsePath(findNodeResponse);
        }
        return true;
    }

    @Override
    protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        this.decrementActiveSearches();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(ContactUtils.toString(kUID, socketAddress) + " did not respond to our " + requestMessage));
        }
        Integer n = this.hopMap.remove(kUID);
        assert (n != null);
        if (this.routeTableNodes.contains(kUID)) {
            ++this.routeTableFailureCount;
        }
        ++this.totalFailures;
        this.currentHop = n;
        this.nextLookupStep();
        this.finishLookupIfDone();
    }

    @Override
    protected void error(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, IOException iOException) {
        if (iOException instanceof SocketException && this.hasActiveSearches()) {
            try {
                this.timeout(kUID, socketAddress, requestMessage, -1L);
            }
            catch (IOException iOException2) {
                LOG.error((Object)"IOException", (Throwable)iOException2);
                if (!this.hasActiveSearches()) {
                    this.setException(new DHTException(iOException2));
                }
            }
        } else {
            this.setException(new DHTBackendException(kUID, socketAddress, requestMessage, iOException));
        }
    }

    protected void nextLookupStep() throws IOException {
        int n;
        Object object;
        long l = this.getElapsedTime();
        if (this.isTimeout(l)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops and " + l + "ms due to timeout."));
            }
            this.killActiveSearches();
            return;
        }
        if (!this.hasActiveSearches()) {
            if (!this.hasContactsToQuery()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops and " + l + "ms. No contacts left to query."));
                }
                return;
            }
            if (!this.context.isLocalNodeID(this.lookupId) && this.responsePath.containsKey((Object)this.lookupId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops. Found target ID!"));
                }
                return;
            }
        }
        if (this.responsePath.size() >= this.getResultSetSize()) {
            KUID kUID = ((Contact)((Map.Entry)this.responsePath.select((Object)this.furthestId)).getKey()).getNodeID();
            object = null;
            if (!this.toQuery.isEmpty()) {
                object = ((Contact)this.toQuery.select((Object)this.lookupId)).getNodeID();
            }
            if (object == null || kUID.isNearerTo(this.lookupId, (KUID)object)) {
                if (!this.hasActiveSearches() && LOG.isTraceEnabled()) {
                    Contact contact = (Contact)((Map.Entry)this.responsePath.select((Object)this.lookupId)).getKey();
                    LOG.trace((Object)("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops, " + l + "ms and " + this.queried.size() + " queried Nodes with " + contact + " as best match"));
                }
                return;
            }
        }
        if ((n = this.getParallelism() - this.getActiveSearches()) > 0) {
            object = this.getContactsToQuery(this.lookupId, n);
            Iterator<Contact> iterator = object.iterator();
            while (iterator.hasNext()) {
                Contact contact = iterator.next();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Sending " + contact + " a find request for " + this.lookupId));
                }
                try {
                    this.lookup(contact);
                }
                catch (SocketException socketException) {
                    LOG.error((Object)"A SocketException occurred", (Throwable)socketException);
                }
            }
        }
    }

    protected boolean lookup(Contact contact) throws IOException {
        LookupRequest lookupRequest = this.createLookupRequest(contact);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Sending " + contact + " a " + lookupRequest));
        }
        this.markAsQueried(contact);
        boolean bl = this.context.getMessageDispatcher().send(contact, (RequestMessage)lookupRequest, (ResponseHandler)this);
        if (bl) {
            this.incrementActiveSearches();
        }
        return bl;
    }

    protected abstract LookupRequest createLookupRequest(Contact var1);

    private void finishLookupIfDone() {
        if (!(this.isDone() || this.isCancelled() || this.hasActiveSearches())) {
            this.finishLookup();
        }
    }

    protected abstract void finishLookup();

    protected void incrementActiveSearches() {
        ++this.activeSearches;
    }

    protected void decrementActiveSearches() {
        if (this.activeSearches == 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"ActiveSearches counter is already 0");
            }
            return;
        }
        --this.activeSearches;
    }

    protected void killActiveSearches() {
        this.activeSearches = 0;
    }

    protected int getActiveSearches() {
        return this.activeSearches;
    }

    protected boolean hasActiveSearches() {
        return this.getActiveSearches() > 0;
    }

    protected boolean isQueried(Contact contact) {
        return this.queried.contains(contact.getNodeID());
    }

    protected void markAsQueried(Contact contact) {
        this.queried.add(contact.getNodeID());
        this.toQuery.remove((Object)contact.getNodeID());
    }

    protected boolean isYetToBeQueried(Contact contact) {
        return this.toQuery.containsKey((Object)contact.getNodeID());
    }

    protected boolean hasContactsToQuery() {
        return !this.toQuery.isEmpty();
    }

    protected Collection<Contact> getContactsToQuery(KUID kUID, int n) {
        return TrieUtils.select(this.toQuery, (Object)kUID, (int)n);
    }

    protected boolean addYetToBeQueried(Contact contact, int n) {
        if (this.isQueried(contact)) {
            return false;
        }
        KUID kUID = contact.getNodeID();
        if (this.context.isLocalNodeID(kUID) || this.context.isLocalContactAddress(contact.getContactAddress())) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(contact + " has either the same NodeID or contact" + " address as the local Node " + this.context.getLocalNode()));
            }
            return false;
        }
        this.toQuery.put((Object)kUID, (Object)contact);
        this.hopMap.put(kUID, n);
        return true;
    }

    protected void addToResponsePath(ResponseMessage responseMessage) {
        Contact contact = responseMessage.getContact();
        SecurityToken securityToken = null;
        if (responseMessage instanceof SecurityTokenProvider) {
            securityToken = ((SecurityTokenProvider)((Object)responseMessage)).getSecurityToken();
        }
        this.addToResponsePath(contact, securityToken);
    }

    protected void addToResponsePath(Contact contact, SecurityToken securityToken) {
        EntryImpl<Contact, SecurityToken> entryImpl = new EntryImpl<Contact, SecurityToken>(contact, securityToken, true);
        this.responsePath.put((Object)contact.getNodeID(), entryImpl);
        if (this.isDeleteFurthest() && this.responsePath.size() > this.getResultSetSize()) {
            Contact contact2 = (Contact)((Map.Entry)this.responsePath.select((Object)this.furthestId)).getKey();
            this.responsePath.remove((Object)contact2.getNodeID());
        }
    }

    protected Map<Contact, SecurityToken> getPath() {
        return this.getContacts(this.responsePath.size());
    }

    protected Map<Contact, SecurityToken> getNearestContacts() {
        return this.getContacts(this.getResultSetSize());
    }

    protected Map<Contact, SecurityToken> getContacts(int n) {
        if (n < 0) {
            n = this.responsePath.size();
        }
        final int n2 = n;
        final LinkedHashMap<Contact, SecurityToken> linkedHashMap = new LinkedHashMap<Contact, SecurityToken>();
        this.responsePath.select((Object)this.lookupId, (Trie.Cursor)new Trie.Cursor<KUID, Map.Entry<Contact, SecurityToken>>(){

            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Map.Entry<Contact, SecurityToken>> entry) {
                Map.Entry<Contact, SecurityToken> entry2 = entry.getValue();
                linkedHashMap.put(entry2.getKey(), entry2.getValue());
                if (linkedHashMap.size() < n2) {
                    return Trie.Cursor.SelectStatus.CONTINUE;
                }
                return Trie.Cursor.SelectStatus.EXIT;
            }
        });
        return linkedHashMap;
    }

    protected Set<KUID> getQueried() {
        return this.queried;
    }

    public int getCurrentHop() {
        return this.currentHop;
    }

    public String toString() {
        long l = this.getElapsedTime();
        boolean bl = this.isTimeout(l);
        int n = this.getActiveSearches();
        return ", lookup: " + this.lookupId + ", time: " + l + ", timeout: " + bl + ", activeSearches: " + n;
    }
}

