/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.handler.request.FindNodeRequestHandler;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.DatabaseUtils;

public class FindValueRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(FindValueRequestHandler.class);
    private final FindNodeRequestHandler findNodeDelegate;

    public FindValueRequestHandler(Context context, FindNodeRequestHandler findNodeRequestHandler) {
        super(context);
        this.findNodeDelegate = findNodeRequestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void request(RequestMessage requestMessage) throws IOException {
        Object object;
        FindValueRequest findValueRequest = (FindValueRequest)requestMessage;
        KUID kUID = findValueRequest.getLookupID();
        DHTValueType dHTValueType = findValueRequest.getDHTValueType();
        Map<KUID, DHTValueEntity> map = null;
        float f = 0.0f;
        Database database = this.context.getDatabase();
        HashSet<KUID> hashSet = database;
        synchronized (hashSet) {
            map = database.get(kUID);
            f = database.getRequestLoad(kUID, true);
        }
        hashSet = Collections.emptySet();
        Set set = Collections.emptySet();
        Collection<KUID> collection = findValueRequest.getSecondaryKeys();
        if (map != null && !map.isEmpty()) {
            hashSet = new HashSet<KUID>();
            set = new HashSet();
            object = DatabaseUtils.filter(dHTValueType, map.values());
            if (collection.isEmpty()) {
                if (set.isEmpty() && object.size() == 1) {
                    set.addAll(object);
                } else {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        DHTValueEntity dHTValueEntity = (DHTValueEntity)iterator.next();
                        hashSet.add(dHTValueEntity.getSecondaryKey());
                    }
                }
            } else {
                Iterator<? extends DHTValueEntity> iterator = object.iterator();
                while (iterator.hasNext()) {
                    DHTValueEntity dHTValueEntity = iterator.next();
                    KUID kUID2 = dHTValueEntity.getSecondaryKey();
                    if (!collection.contains(kUID2)) continue;
                    set.add(dHTValueEntity);
                }
            }
        }
        if (set.isEmpty() && hashSet.isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No values for " + kUID + ", returning Contacts instead to " + findValueRequest.getContact()));
            }
            this.findNodeDelegate.handleRequest(requestMessage);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Return " + CollectionUtils.toString(set) + " and " + CollectionUtils.toString(hashSet) + " for " + kUID + " to " + findValueRequest.getContact()));
            }
            this.context.getNetworkStats().FIND_VALUE_REQUESTS.incrementStat();
            object = this.context.getMessageHelper().createFindValueResponse(findValueRequest, f, set, hashSet);
            this.context.getMessageDispatcher().send(findValueRequest.getContact(), (ResponseMessage)object);
        }
    }
}

