/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.result.StoreResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableModelManager {
    private static final Log LOG = LogFactory.getLog(StorableModelManager.class);
    private final Map<DHTValueType, StorableModel> models = Collections.synchronizedMap(new HashMap());

    public StorableModel addStorableModel(DHTValueType dHTValueType, StorableModel storableModel) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        if (storableModel == null) {
            throw new NullPointerException("StorableModel is null");
        }
        return this.models.put(dHTValueType, storableModel);
    }

    public StorableModel removeStorableModel(DHTValueType dHTValueType) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return this.models.remove(dHTValueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Storable> getStorables() {
        ArrayList<Storable> arrayList = new ArrayList<Storable>();
        Map<DHTValueType, StorableModel> map = this.models;
        synchronized (map) {
            block3: for (StorableModel storableModel : this.models.values()) {
                Collection<Storable> collection = storableModel.getStorables();
                if (collection == null) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)(storableModel + " returned a null Collection"));
                    continue;
                }
                for (Storable storable : collection) {
                    if (storable == null) {
                        if (!LOG.isErrorEnabled() || !LOG.isErrorEnabled()) continue block3;
                        LOG.error((Object)(storableModel + " returned a Collection with a null element"));
                        continue block3;
                    }
                    arrayList.add(storable);
                }
            }
        }
        return arrayList;
    }

    void handleStoreResult(Storable storable, StoreResult storeResult) {
        DHTValueType dHTValueType = storable.getValue().getValueType();
        StorableModel storableModel = this.models.get(dHTValueType);
        if (storableModel != null) {
            storableModel.handleStoreResult(storable, storeResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleContactChange(Context context) {
        Map<DHTValueType, StorableModel> map = this.models;
        synchronized (map) {
            for (StorableModel storableModel : this.models.values()) {
                storableModel.handleContactChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<DHTValueType, StorableModel> map = this.models;
        synchronized (map) {
            for (DHTValueType dHTValueType : this.models.keySet()) {
                StorableModel storableModel = this.models.get(dHTValueType);
                stringBuilder.append(dHTValueType).append(":\n");
                stringBuilder.append(storableModel).append("\n\n");
            }
        }
        return stringBuilder.toString();
    }
}

