/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.Evictor;
import org.limewire.mojito.db.impl.DefaultEvictor;
import org.limewire.mojito.routing.RouteTable;

public class EvictorManager {
    public static final Evictor defaultEvictor = new DefaultEvictor();
    private final Map<DHTValueType, Evictor> evictors = Collections.synchronizedMap(new HashMap());

    public Evictor addEvictor(DHTValueType dHTValueType, Evictor evictor) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        if (evictor == null) {
            throw new NullPointerException("Evictor is null");
        }
        return this.evictors.put(dHTValueType, evictor);
    }

    public Evictor removeEvictor(DHTValueType dHTValueType) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return this.evictors.remove(dHTValueType);
    }

    public Evictor getEvictor(DHTValueType dHTValueType) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        Evictor evictor = this.evictors.get(dHTValueType);
        if (evictor != null) {
            return evictor;
        }
        return defaultEvictor;
    }

    public boolean isExpired(RouteTable routeTable, DHTValueEntity dHTValueEntity) {
        DHTValueType dHTValueType = dHTValueEntity.getValue().getValueType();
        return this.getEvictor(dHTValueType).isExpired(routeTable, dHTValueEntity);
    }
}

