/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.EvictorManager;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.statistics.DatabaseStatisticContainer;

public class DatabaseCleaner
implements Runnable {
    private static final Log LOG = LogFactory.getLog(DatabaseCleaner.class);
    private final Context context;
    private final DatabaseStatisticContainer databaseStats;
    private ScheduledFuture future;

    public DatabaseCleaner(Context context) {
        this.context = context;
        this.databaseStats = context.getDatabaseStats();
    }

    public synchronized void start() {
        if (this.future == null) {
            long l;
            long l2 = l = DatabaseSettings.DATABASE_CLEANER_PERIOD.getValue();
            this.future = this.context.getDHTExecutorService().scheduleWithFixedDelay(this, l2, l, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDatabase() {
        Database database;
        EvictorManager evictorManager = this.context.getEvictorManager();
        RouteTable routeTable = this.context.getRouteTable();
        Database database2 = database = this.context.getDatabase();
        synchronized (database2) {
            for (DHTValueEntity dHTValueEntity : database.values()) {
                if (!evictorManager.isExpired(routeTable, dHTValueEntity)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(dHTValueEntity + " is expired!"));
                }
                database.remove(dHTValueEntity.getPrimaryKey(), dHTValueEntity.getSecondaryKey());
                this.databaseStats.EXPIRED_VALUES.incrementStat();
            }
        }
    }

    public void run() {
        this.cleanupDatabase();
    }
}

