/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.entity;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.http.entity.Piece;
import org.limewire.http.entity.PieceListener;
import org.limewire.http.entity.PieceReader;
import org.limewire.nio.ByteBufferCache;

public class FilePieceReader
implements PieceReader {
    private static final Log LOG = LogFactory.getLog(FilePieceReader.class);
    private static final int THREAD_COUNT = 2;
    private static final int MAX_BUFFERS = 4;
    static int BUFFER_SIZE = 4096;
    private final List<ByteBuffer> bufferPool = new LinkedList<ByteBuffer>();
    private final Queue<Piece> pieceQueue = new PriorityQueue<Piece>(4);
    private static final ExecutorService QUEUE = ExecutorsHelper.newFixedSizeThreadPool((int)2, (String)"DiskPieceReader");
    private final File file;
    private final PieceListener listener;
    private volatile FileChannel channel;
    private volatile RandomAccessFile raf;
    private final Object bufferPoolLock = new Object();
    private final ByteBufferCache bufferCache;
    private int bufferInUseCount;
    private volatile long readOffset;
    private long processingOffset;
    private long remaining;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final AtomicInteger jobCount = new AtomicInteger();

    public FilePieceReader(ByteBufferCache byteBufferCache, File file, long l, long l2, PieceListener pieceListener) {
        if (byteBufferCache == null || file == null || pieceListener == null) {
            throw new IllegalArgumentException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("length must be > 0");
        }
        this.bufferCache = byteBufferCache;
        this.file = file;
        this.readOffset = l;
        this.processingOffset = l;
        this.remaining = l2;
        this.listener = pieceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(long l, ByteBuffer byteBuffer) {
        if (this.shutdown.get()) {
            this.release(byteBuffer);
            return;
        }
        assert (l >= this.readOffset);
        Piece piece = new Piece(l, byteBuffer);
        FilePieceReader filePieceReader = this;
        synchronized (filePieceReader) {
            this.pieceQueue.add(piece);
        }
        if (l == this.readOffset) {
            this.listener.readSuccessful();
        }
    }

    protected void failed(IOException iOException) {
        this.shutdown();
        this.listener.readFailed(iOException);
    }

    public File getFile() {
        return this.file;
    }

    public synchronized boolean hasNext() throws EOFException {
        if (this.shutdown.get()) {
            throw new EOFException();
        }
        if (this.pieceQueue.isEmpty()) {
            return false;
        }
        return this.pieceQueue.peek().getOffset() == this.readOffset;
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Piece next() throws EOFException {
        if (this.shutdown.get()) {
            throw new EOFException();
        }
        Object object = this.bufferPoolLock;
        synchronized (object) {
            if (this.remaining == 0L && this.readOffset == this.processingOffset) {
                throw new EOFException();
            }
        }
        object = this.pieceQueue.peek();
        if (object != null && ((Piece)object).getOffset() == this.readOffset) {
            this.pieceQueue.remove();
            this.readOffset += (long)((Piece)object).getBuffer().remaining();
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(ByteBuffer byteBuffer) {
        Object object = this.bufferPoolLock;
        synchronized (object) {
            if (this.shutdown.get()) {
                this.bufferCache.release(byteBuffer);
                return;
            }
            this.bufferPool.add(byteBuffer);
            --this.bufferInUseCount;
            this.spawnJobs();
        }
    }

    public void release(Piece piece) {
        this.release(piece.getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return false;
        }
        Object object = this.bufferPoolLock;
        synchronized (object) {
            for (ByteBuffer comparable : this.bufferPool) {
                this.release(comparable);
            }
        }
        object = this;
        synchronized (object) {
            for (Piece piece : this.pieceQueue) {
                this.release(piece);
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {
                    LOG.warn((Object)("Error closing channel for file: " + this.file), (Throwable)iOException);
                }
            }
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    LOG.warn((Object)("Error closing file: " + this.file), (Throwable)iOException);
                }
            }
        }
        return true;
    }

    public void shutdownAndWait(long l) throws InterruptedException, TimeoutException {
        this.shutdown();
        this.waitForShutdown(l);
    }

    protected void waitForShutdown(long l) throws InterruptedException, TimeoutException {
        long l2 = System.currentTimeMillis();
        while (this.jobCount.get() > 0) {
            long l3 = l - (System.currentTimeMillis() - l2);
            if (l3 <= 0L) {
                throw new TimeoutException();
            }
            Thread.sleep(50L);
        }
    }

    public void start() {
        if (this.shutdown.get()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < 4 && (i == 0 || (long)(i * BUFFER_SIZE + 1) <= this.remaining); ++i) {
            this.bufferPool.add(this.bufferCache.getHeap(BUFFER_SIZE));
        }
        this.spawnJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnJobs() {
        Object object = this.bufferPoolLock;
        synchronized (object) {
            while (!this.shutdown.get() && this.remaining > 0L && this.bufferInUseCount < 4) {
                int n = (int)Math.min((long)BUFFER_SIZE, this.remaining);
                ByteBuffer byteBuffer = this.bufferPool.remove(0);
                ++this.bufferInUseCount;
                PieceReaderJob pieceReaderJob = new PieceReaderJob(byteBuffer, this.processingOffset, n);
                this.processingOffset += (long)n;
                this.remaining -= (long)n;
                this.jobCount.incrementAndGet();
                QUEUE.submit(pieceReaderJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChannel() throws IOException {
        if (this.channel != null) {
            return;
        }
        FilePieceReader filePieceReader = this;
        synchronized (filePieceReader) {
            if (this.channel != null) {
                return;
            }
            this.raf = new RandomAccessFile(this.file, "r");
            this.channel = this.raf.getChannel();
        }
    }

    private class PieceReaderJob
    implements Runnable {
        private final ByteBuffer buffer;
        private final long offset;
        private final int length;

        public PieceReaderJob(ByteBuffer byteBuffer, long l, int n) {
            this.buffer = byteBuffer;
            this.offset = l;
            this.length = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: {
                try {
                    if (FilePieceReader.this.shutdown.get()) {
                        FilePieceReader.this.release(this.buffer);
                        return;
                    }
                    this.buffer.clear();
                    this.buffer.limit(this.length);
                    IOException iOException = null;
                    try {
                        FilePieceReader.this.initChannel();
                        while (this.buffer.hasRemaining()) {
                            int n = FilePieceReader.this.channel.read(this.buffer, this.offset + (long)this.buffer.position());
                            if (n != -1 && (n != 0 || FilePieceReader.this.raf.length() > this.offset + (long)this.buffer.position())) continue;
                            throw new EOFException("Attempt to read beyond end of file");
                        }
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                    }
                    if (iOException != null) {
                        try {
                            FilePieceReader.this.failed(iOException);
                            break block13;
                        }
                        finally {
                            FilePieceReader.this.release(this.buffer);
                        }
                    }
                    this.buffer.flip();
                    assert (this.buffer.remaining() == this.length);
                    FilePieceReader.this.add(this.offset, this.buffer);
                }
                finally {
                    FilePieceReader.this.jobCount.decrementAndGet();
                }
            }
        }
    }
}

