/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class SynchronizedHttpProcessor
implements HttpProcessor {
    private final CopyOnWriteArrayList<HttpRequestInterceptor> requestInterceptors = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<HttpResponseInterceptor> responseInterceptors = new CopyOnWriteArrayList();

    public void addInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        this.requestInterceptors.add(httpRequestInterceptor);
    }

    public void addInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.responseInterceptors.add(httpResponseInterceptor);
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptors) {
            httpRequestInterceptor.process(httpRequest, httpContext);
        }
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        for (HttpResponseInterceptor httpResponseInterceptor : this.responseInterceptors) {
            httpResponseInterceptor.process(httpResponse, httpContext);
        }
    }

    public void removeInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        this.requestInterceptors.remove(httpRequestInterceptor);
    }

    public void removeInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.responseInterceptors.remove(httpResponseInterceptor);
    }
}

