/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.HeaderInterceptor;
import org.limewire.http.MalformedHeaderException;

public class RangeHeaderInterceptor
implements HeaderInterceptor {
    public static String RANGE_HEADER = "Range";
    private List<Range> ranges;

    public void process(Header header, HttpContext httpContext) throws HttpException, IOException {
        if (!RANGE_HEADER.equals(header.getName())) {
            return;
        }
        String string = header.getValue().trim();
        if (!string.startsWith("bytes")) {
            throw new MalformedHeaderException("bytes not present in range header");
        }
        if (string.length() <= 6) {
            throw new MalformedHeaderException("range not present in range header");
        }
        string = string.substring(6);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            Range range = this.parseRange(stringTokenizer.nextToken().trim());
            if (this.ranges == null) {
                this.ranges = new ArrayList<Range>(1);
            }
            this.ranges.add(range);
        }
    }

    private Range parseRange(String string) throws MalformedHeaderException {
        if (string.length() < 2) {
            throw new MalformedHeaderException("invalid range: " + string);
        }
        Range range = new Range();
        int n = string.indexOf("-");
        if (n == -1 || string.indexOf("-", n + 1) != -1) {
            throw new MalformedHeaderException("invalid range: " + string);
        }
        if (n == 0) {
            try {
                range.endOffset = Long.parseLong(string.substring(1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedHeaderException();
            }
        }
        if (n == string.length() - 1) {
            try {
                range.startOffset = Long.parseLong(string.substring(0, string.length() - 1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedHeaderException();
            }
        }
        try {
            range.startOffset = Long.parseLong(string.substring(0, n).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedHeaderException();
        }
        try {
            range.endOffset = Long.parseLong(string.substring(n + 1).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedHeaderException();
        }
        if (range.endOffset != -1L && range.startOffset > range.endOffset) {
            throw new MalformedHeaderException("start offset is greater than end offset (" + range.startOffset + ">" + range.endOffset + ")");
        }
        assert (range.startOffset >= 0L || range.endOffset >= 0L);
        return range;
    }

    public boolean hasRequestedRanges() {
        return this.ranges != null;
    }

    public Range[] getRequestedRanges() {
        return this.ranges != null ? this.ranges.toArray(new Range[0]) : null;
    }

    public static class Range {
        private long startOffset = -1L;
        private long endOffset = -1L;

        protected Range(long l, long l2) {
            this.startOffset = l;
            this.endOffset = l2;
        }

        private Range() {
        }

        public long getStartOffset(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException("totalSize must be >= 0");
            }
            if (this.startOffset > l - 1L) {
                return -1L;
            }
            if (this.startOffset >= 0L) {
                return this.startOffset;
            }
            if (l >= this.endOffset) {
                return l - this.endOffset;
            }
            return 0L;
        }

        public long getEndOffset(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException("totalSize must be >= 0");
            }
            if (this.startOffset >= 0L) {
                if (this.endOffset >= 0L && this.endOffset < l) {
                    return this.endOffset;
                }
                return l - 1L;
            }
            return l - 1L;
        }
    }
}

