/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.limewire.io.CRC32MessageDigest;

public class SecureOutputStream
extends FilterOutputStream {
    private final MessageDigest md;
    private final int dataSize;
    private int count = 0;
    private boolean open = true;

    public SecureOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, new CRC32MessageDigest(), 512);
    }

    public SecureOutputStream(OutputStream outputStream, MessageDigest messageDigest) throws IOException {
        this(outputStream, messageDigest, 512);
    }

    public SecureOutputStream(OutputStream outputStream, int n) throws IOException {
        this(outputStream, new CRC32MessageDigest(), n);
    }

    public SecureOutputStream(OutputStream outputStream, MessageDigest messageDigest, int n) throws IOException {
        super(outputStream);
        if (messageDigest == null) {
            throw new NullPointerException("MessageDigest is null");
        }
        int n2 = messageDigest.getDigestLength();
        if (n2 == 0) {
            throw new IllegalArgumentException("Digest length is undefined");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal block size: " + n);
        }
        if (n <= n2) {
            throw new IllegalArgumentException("Block size must be greater than digest length: " + n + " <= " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(messageDigest.getAlgorithm());
        dataOutputStream.writeInt(messageDigest.getDigestLength());
        dataOutputStream.writeInt(n);
        dataOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        outputStream.write(byArray.length >> 24 & 0xFF);
        outputStream.write(byArray.length >> 16 & 0xFF);
        outputStream.write(byArray.length >> 8 & 0xFF);
        outputStream.write(byArray.length & 0xFF);
        outputStream.write(byArray, 0, byArray.length);
        messageDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = messageDigest.digest();
        outputStream.write(byArray2, 0, byArray2.length);
        messageDigest.reset();
        this.md = messageDigest;
        this.dataSize = n - n2;
    }

    public int getBlockSize() {
        return this.dataSize + this.md.getDigestLength();
    }

    public MessageDigest getMessageDigest() {
        return this.md;
    }

    private void digest() throws IOException {
        byte[] byArray = this.md.digest();
        this.out.write(byArray, 0, byArray.length);
        this.md.reset();
    }

    public void write(int n) throws IOException {
        if (!this.open) {
            throw new IOException("Stream is closed");
        }
        super.write(n);
        this.md.update((byte)(n & 0xFF));
        ++this.count;
        if (this.count % this.dataSize == 0) {
            this.digest();
        }
    }

    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            if (this.count % this.dataSize != 0) {
                this.digest();
            }
        }
        super.close();
    }
}

