/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.IpPort;

public class IpPortImpl
implements IpPort {
    private final InetSocketAddress addr;
    private final String addrString;

    public IpPortImpl(InetSocketAddress inetSocketAddress) {
        this(inetSocketAddress, inetSocketAddress.getAddress().getHostAddress());
    }

    public IpPortImpl(InetSocketAddress inetSocketAddress, String string) {
        this.addr = inetSocketAddress;
        this.addrString = string;
    }

    public IpPortImpl(InetAddress inetAddress, int n) {
        this(new InetSocketAddress(inetAddress, n));
    }

    public IpPortImpl(String string, int n) throws UnknownHostException {
        this(new InetSocketAddress(InetAddress.getByName(string), n), string);
    }

    public IpPortImpl(byte[] byArray, int n) {
        this(new InetSocketAddress(IpPortImpl.getAddressFromBytes(byArray), n), IpPortImpl.asString(byArray));
    }

    public IpPortImpl(String string) throws UnknownHostException {
        int n = string.indexOf(":");
        if (n == string.length() - 1) {
            throw new UnknownHostException("invalid hostport: " + string);
        }
        String string2 = string;
        int n2 = 80;
        if (n != -1) {
            string2 = string.substring(0, n);
            try {
                n2 = Integer.parseInt(string.substring(n + 1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnknownHostException("invalid hostport: " + string);
            }
        }
        this.addr = new InetSocketAddress(InetAddress.getByName(string2), n2);
        this.addrString = string2;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    public String getAddress() {
        return this.addrString;
    }

    public int getPort() {
        return this.addr.getPort();
    }

    public String toString() {
        return "host: " + this.getAddress() + ", port: " + this.getPort();
    }

    private static String asString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(19);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(byArray[i] & 0xFF);
            if (i == byArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    private static InetAddress getAddressFromBytes(byte[] byArray) {
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("invalid address: " + IpPortImpl.asString(byArray));
        }
    }
}

