/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import com.google.inject.Inject;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.LocalSocketAddressProvider;

public class IpPortForSelf
implements IpPort,
Connectable {
    private final InetAddress localhost;
    private final LocalSocketAddressProvider localSocketAddressProvider;

    @Inject
    IpPortForSelf(LocalSocketAddressProvider localSocketAddressProvider) {
        this.localSocketAddressProvider = localSocketAddressProvider;
        byte[] byArray = new byte[]{127, 0, 0, 1};
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
        this.localhost = inetAddress;
    }

    public byte[] getAddressAsBytes() {
        return this.localSocketAddressProvider.getLocalAddress();
    }

    public String getAddress() {
        return this.getInetAddress().getHostName();
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByAddress(this.localSocketAddressProvider.getLocalAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return this.localhost;
        }
    }

    public int getPort() {
        return this.localSocketAddressProvider.getLocalPort();
    }

    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public String toString() {
        return this.getAddress() + ":" + this.getPort();
    }

    public boolean isTLSCapable() {
        return this.localSocketAddressProvider.isTLSCapable();
    }
}

