/* This file is part of Clementine.
   Copyright 2010, David Sansome <me@davidsansome.com>

   Clementine is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Clementine is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Clementine.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SCRIPTARCHIVE_H
#define SCRIPTARCHIVE_H

#include "scriptinfo.h"

#include <QFuture>

class ScriptManager;

class ScriptArchive {
public:
  ScriptArchive(ScriptManager* manager);
  ~ScriptArchive();

  bool LoadFromFile(const QString& filename);
  bool LoadFromDevice(QIODevice* device);
  QFuture<bool> LoadFromFileAsync(const QString& filename);
  QFuture<bool> LoadFromDeviceAsync(QIODevice* device);

  const QList<ScriptInfo>& info() const { return info_; }

  bool Install() const;

private:
  Q_DISABLE_COPY(ScriptArchive);

  ScriptManager* manager_;

  QString temp_dir_name_;
  QList<ScriptInfo> info_;
};

#endif // SCRIPTARCHIVE_H
