##############################################################################
#
# File:    FKO_Constants.pl
#
# Author:  Damien S. Stuart <dstuart@dstuart.org>
#
# Purpose: Constants for the FKO module.
#
##############################################################################
#

# Message types tag list.
#
our @MSG_TYPES = qw(
    FKO_COMMAND_MSG
    FKO_ACCESS_MSG
    FKO_NAT_ACCESS_MSG
    FKO_CLIENT_TIMEOUT_ACCESS_MSG
    FKO_CLIENT_TIMEOUT_NAT_ACCESS_MSG
    FKO_LOCAL_NAT_ACCESS_MSG
    FKO_CLIENT_TIMEOUT_LOCAL_NAT_ACCESS_MSG
);

# Digest types tag list.
#
our @DIGEST_TYPES = qw(
    FKO_DIGEST_MD5
    FKO_DIGEST_SHA1
    FKO_DIGEST_SHA256
    FKO_DIGEST_SHA384
    FKO_DIGEST_SHA512
);

# Encryption types tag list.
#
our @ENCRYPTION_TYPES = qw(
    FKO_ENCRYPTION_RIJNDAEL
    FKO_ENCRYPTION_GPG
);

# Error codes tag list.
#
our @ERROR_CODES = qw(
    FKO_SUCCESS
    FKO_ERROR_CTX_NOT_INITIALIZED
    FKO_ERROR_MEMORY_ALLOCATION
    FKO_ERROR_INVALID_DATA
    FKO_ERROR_DATA_TOO_LARGE
    FKO_ERROR_USERNAME_UNKNOWN
    FKO_ERROR_INCOMPLETE_SPA_DATA
    FKO_ERROR_MISSING_ENCODED_DATA
    FKO_ERROR_INVALID_DIGEST_TYPE
    FKO_ERROR_INVALID_ALLOW_IP
    FKO_ERROR_INVALID_SPA_COMMAND_MSG
    FKO_ERROR_INVALID_SPA_ACCESS_MSG
    FKO_ERROR_INVALID_SPA_NAT_ACCESS_MSG
    FKO_ERROR_INVALID_ENCRYPTION_TYPE
    FKO_ERROR_WRONG_ENCRYPTION_TYPE
    FKO_ERROR_DECRYPTION_SIZE
    FKO_ERROR_DECRYPTION_FAILURE
    FKO_ERROR_DIGEST_VERIFICATION_FAILED
    FKO_ERROR_UNSUPPORTED_FEATURE
    FKO_ERROR_UNKNOWN
    GPGME_ERR_START
    FKO_ERROR_MISSING_GPG_KEY_DATA
    FKO_ERROR_GPGME_NO_OPENPGP
    FKO_ERROR_GPGME_CONTEXT
    FKO_ERROR_GPGME_PLAINTEXT_DATA_OBJ
    FKO_ERROR_GPGME_SET_PROTOCOL
    FKO_ERROR_GPGME_CIPHER_DATA_OBJ
    FKO_ERROR_GPGME_BAD_PASSPHRASE
    FKO_ERROR_GPGME_ENCRYPT_SIGN
    FKO_ERROR_GPGME_CONTEXT_SIGNER_KEY
    FKO_ERROR_GPGME_SIGNER_KEYLIST_START
    FKO_ERROR_GPGME_SIGNER_KEY_NOT_FOUND
    FKO_ERROR_GPGME_SIGNER_KEY_AMBIGUOUS
    FKO_ERROR_GPGME_ADD_SIGNER
    FKO_ERROR_GPGME_CONTEXT_RECIPIENT_KEY
    FKO_ERROR_GPGME_RECIPIENT_KEYLIST_START
    FKO_ERROR_GPGME_RECIPIENT_KEY_NOT_FOUND
    FKO_ERROR_GPGME_RECIPIENT_KEY_AMBIGUOUS
    FKO_ERROR_GPGME_DECRYPT_FAILED
    FKO_ERROR_GPGME_BAD_HOME_DIR
    FKO_ERROR_GPGME_SET_HOME_DIR
    FKO_ERROR_GPGME_NO_SIGNATURE
    FKO_ERROR_GPGME_BAD_SIGNATURE
    FKO_ERROR_GPGME_SIGNATURE_VERIFY_DISABLED
);

# The FKO constants. These are manually pulled from fko.h (for now).
#
use constant {
    # Message types
    FKO_COMMAND_MSG                         => 0,
    FKO_ACCESS_MSG                          => 1,
    FKO_NAT_ACCESS_MSG                      => 2,
    FKO_CLIENT_TIMEOUT_ACCESS_MSG           => 3,
    FKO_CLIENT_TIMEOUT_NAT_ACCESS_MSG       => 4,
    FKO_LOCAL_NAT_ACCESS_MSG                => 5,
    FKO_CLIENT_TIMEOUT_LOCAL_NAT_ACCESS_MSG => 6,

    # Digest types
    FKO_DIGEST_MD5      => 1,
    FKO_DIGEST_SHA1     => 2,
    FKO_DIGEST_SHA256   => 3,
    FKO_DIGEST_SHA384   => 4,
    FKO_DIGEST_SHA512   => 5,

    # Encryption types
    FKO_ENCRYPTION_RIJNDAEL => 1,
    FKO_ENCRYPTION_GPG      => 2,

    # FKO error codes
    FKO_SUCCESS                                 => 0,
    FKO_ERROR_CTX_NOT_INITIALIZED               => 1,
    FKO_ERROR_MEMORY_ALLOCATION                 => 2,
    FKO_ERROR_INVALID_DATA                      => 3,
    FKO_ERROR_DATA_TOO_LARGE                    => 4,
    FKO_ERROR_USERNAME_UNKNOWN                  => 5,
    FKO_ERROR_INCOMPLETE_SPA_DATA               => 6,
    FKO_ERROR_MISSING_ENCODED_DATA              => 7,
    FKO_ERROR_INVALID_DIGEST_TYPE               => 8,
    FKO_ERROR_INVALID_ALLOW_IP                  => 9,
    FKO_ERROR_INVALID_SPA_COMMAND_MSG           => 10,
    FKO_ERROR_INVALID_SPA_ACCESS_MSG            => 11,
    FKO_ERROR_INVALID_SPA_NAT_ACCESS_MSG        => 12,
    FKO_ERROR_INVALID_ENCRYPTION_TYPE           => 13,
    FKO_ERROR_WRONG_ENCRYPTION_TYPE             => 14,
    FKO_ERROR_DECRYPTION_SIZE                   => 15,
    FKO_ERROR_DECRYPTION_FAILURE                => 16,
    FKO_ERROR_DIGEST_VERIFICATION_FAILED        => 17,
    FKO_ERROR_UNSUPPORTED_FEATURE               => 18,
    FKO_ERROR_UNKNOWN                           => 19,
    # Start GPGME-related errors
    GPGME_ERR_START                             => 20,
    FKO_ERROR_MISSING_GPG_KEY_DATA              => 21,
    FKO_ERROR_GPGME_NO_OPENPGP                  => 22,
    FKO_ERROR_GPGME_CONTEXT                     => 23,
    FKO_ERROR_GPGME_PLAINTEXT_DATA_OBJ          => 24,
    FKO_ERROR_GPGME_SET_PROTOCOL                => 25,
    FKO_ERROR_GPGME_CIPHER_DATA_OBJ             => 26,
    FKO_ERROR_GPGME_BAD_PASSPHRASE              => 27,
    FKO_ERROR_GPGME_ENCRYPT_SIGN                => 28,
    FKO_ERROR_GPGME_CONTEXT_SIGNER_KEY          => 29,
    FKO_ERROR_GPGME_SIGNER_KEYLIST_START        => 30,
    FKO_ERROR_GPGME_SIGNER_KEY_NOT_FOUND        => 31,
    FKO_ERROR_GPGME_SIGNER_KEY_AMBIGUOUS        => 32,
    FKO_ERROR_GPGME_ADD_SIGNER                  => 33,
    FKO_ERROR_GPGME_CONTEXT_RECIPIENT_KEY       => 34,
    FKO_ERROR_GPGME_RECIPIENT_KEYLIST_START     => 35,
    FKO_ERROR_GPGME_RECIPIENT_KEY_NOT_FOUND     => 36,
    FKO_ERROR_GPGME_RECIPIENT_KEY_AMBIGUOUS     => 37,
    FKO_ERROR_GPGME_DECRYPT_FAILED              => 38,
    FKO_ERROR_GPGME_BAD_HOME_DIR                => 39,
    FKO_ERROR_GPGME_SET_HOME_DIR                => 40,
    FKO_ERROR_GPGME_NO_SIGNATURE                => 41,
    FKO_ERROR_GPGME_BAD_SIGNATURE               => 42,
    FKO_ERROR_GPGME_SIGNATURE_VERIFY_DISABLED   => 43,
};

1;

###EOF###
