/* automatically generated by rust-bindgen 0.69.4 */

#[allow(unknown_lints, ambiguous_glob_reexports)]
pub use self::root::*;
pub use self::root::mozilla::*;
pub use self::root::mozilla::css::*;
pub use self::root::mozilla::dom::*;
pub type RustCell<T> = ::std::cell::Cell<T>;
pub type ServoNodeData = atomic_refcell::AtomicRefCell<crate::data::ElementData>;
pub type ServoWritingMode = crate::logical_geometry::WritingMode;
pub type ServoComputedCustomProperties = crate::custom_properties::ComputedCustomProperties;
pub type ServoRuleNode = Option<crate::rule_tree::StrongRuleNode>;
pub type nsACString = nsstring::nsACString;
pub type nsAString = nsstring::nsAString;
pub type nsCString = nsstring::nsCString;
pub type nsString = nsstring::nsString;
pub type nsTArray<T> = thin_vec::ThinVec<T>;
pub type CopyableTArray<T> = thin_vec::ThinVec<T>;

#[allow(non_snake_case, non_camel_case_types, non_upper_case_globals)]
pub mod root {
    #[repr(C)]
    #[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
    pub struct __BindgenBitfieldUnit<Storage> {
        storage: Storage,
    }
    impl<Storage> __BindgenBitfieldUnit<Storage> {
        #[inline]
        pub const fn new(storage: Storage) -> Self {
            Self { storage }
        }
    }
    impl<Storage> __BindgenBitfieldUnit<Storage>
    where
        Storage: AsRef<[u8]> + AsMut<[u8]>,
    {
        #[inline]
        pub fn get_bit(&self, index: usize) -> bool {
            debug_assert!(index / 8 < self.storage.as_ref().len());
            let byte_index = index / 8;
            let byte = self.storage.as_ref()[byte_index];
            let bit_index = if cfg!(target_endian = "big") {
                7 - (index % 8)
            } else {
                index % 8
            };
            let mask = 1 << bit_index;
            byte & mask == mask
        }
        #[inline]
        pub fn set_bit(&mut self, index: usize, val: bool) {
            debug_assert!(index / 8 < self.storage.as_ref().len());
            let byte_index = index / 8;
            let byte = &mut self.storage.as_mut()[byte_index];
            let bit_index = if cfg!(target_endian = "big") {
                7 - (index % 8)
            } else {
                index % 8
            };
            let mask = 1 << bit_index;
            if val {
                *byte |= mask;
            } else {
                *byte &= !mask;
            }
        }
        #[inline]
        pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
            let mut val = 0;
            for i in 0..(bit_width as usize) {
                if self.get_bit(i + bit_offset) {
                    let index = if cfg!(target_endian = "big") {
                        bit_width as usize - 1 - i
                    } else {
                        i
                    };
                    val |= 1 << index;
                }
            }
            val
        }
        #[inline]
        pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
            for i in 0..(bit_width as usize) {
                let mask = 1 << i;
                let val_bit_is_set = val & mask == mask;
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                self.set_bit(index + bit_offset, val_bit_is_set);
            }
        }
    }
    #[repr(C)]
    #[derive(Default)]
    pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
    impl<T> __IncompleteArrayField<T> {
        #[inline]
        pub const fn new() -> Self {
            __IncompleteArrayField(::std::marker::PhantomData, [])
        }
        #[inline]
        pub fn as_ptr(&self) -> *const T {
            self as *const _ as *const T
        }
        #[inline]
        pub fn as_mut_ptr(&mut self) -> *mut T {
            self as *mut _ as *mut T
        }
        #[inline]
        pub unsafe fn as_slice(&self, len: usize) -> &[T] {
            ::std::slice::from_raw_parts(self.as_ptr(), len)
        }
        #[inline]
        pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
            ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
        }
    }
    impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
        fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
            fmt.write_str("__IncompleteArrayField")
        }
    }
    #[repr(C)]
    pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
    impl<T> __BindgenUnionField<T> {
        #[inline]
        pub const fn new() -> Self {
            __BindgenUnionField(::std::marker::PhantomData)
        }
        #[inline]
        pub unsafe fn as_ref(&self) -> &T {
            ::std::mem::transmute(self)
        }
        #[inline]
        pub unsafe fn as_mut(&mut self) -> &mut T {
            ::std::mem::transmute(self)
        }
    }
    impl<T> ::std::default::Default for __BindgenUnionField<T> {
        #[inline]
        fn default() -> Self {
            Self::new()
        }
    }
    impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
        #[inline]
        fn clone(&self) -> Self {
            *self
        }
    }
    impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
    impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
        fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
            fmt.write_str("__BindgenUnionField")
        }
    }
    impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
        fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
    }
    impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
        fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
            true
        }
    }
    impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
    #[allow(unused_imports)]
    use self::super::root;
    pub const NS_FONT_STYLE_NORMAL: u32 = 0;
    pub const NS_FONT_STYLE_ITALIC: u32 = 1;
    pub const NS_FONT_STYLE_OBLIQUE: u32 = 2;
    pub const NS_FONT_WEIGHT_NORMAL: u32 = 400;
    pub const NS_FONT_WEIGHT_BOLD: u32 = 700;
    pub const NS_FONT_WEIGHT_THIN: u32 = 100;
    pub const NS_FONT_STRETCH_ULTRA_CONDENSED: u32 = 50;
    pub const NS_FONT_STRETCH_EXTRA_CONDENSED: u32 = 62;
    pub const NS_FONT_STRETCH_CONDENSED: u32 = 75;
    pub const NS_FONT_STRETCH_SEMI_CONDENSED: u32 = 87;
    pub const NS_FONT_STRETCH_NORMAL: u32 = 100;
    pub const NS_FONT_STRETCH_SEMI_EXPANDED: u32 = 112;
    pub const NS_FONT_STRETCH_EXPANDED: u32 = 125;
    pub const NS_FONT_STRETCH_EXTRA_EXPANDED: u32 = 150;
    pub const NS_FONT_STRETCH_ULTRA_EXPANDED: u32 = 200;
    pub const NS_FONT_SMOOTHING_AUTO: u32 = 0;
    pub const NS_FONT_SMOOTHING_GRAYSCALE: u32 = 1;
    pub const NS_FONT_SMOOTHING_SUBPIXEL_ANTIALIASED: u32 = 2;
    pub const NS_FONT_KERNING_AUTO: u32 = 0;
    pub const NS_FONT_KERNING_NONE: u32 = 1;
    pub const NS_FONT_KERNING_NORMAL: u32 = 2;
    pub const NS_FONT_OPTICAL_SIZING_AUTO: u32 = 0;
    pub const NS_FONT_OPTICAL_SIZING_NONE: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_ALTERNATES_HISTORICAL: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_STYLISTIC: u32 = 2;
    pub const NS_FONT_VARIANT_ALTERNATES_STYLESET: u32 = 4;
    pub const NS_FONT_VARIANT_ALTERNATES_CHARACTER_VARIANT: u32 = 8;
    pub const NS_FONT_VARIANT_ALTERNATES_SWASH: u32 = 16;
    pub const NS_FONT_VARIANT_ALTERNATES_ORNAMENTS: u32 = 32;
    pub const NS_FONT_VARIANT_ALTERNATES_ANNOTATION: u32 = 64;
    pub const NS_FONT_VARIANT_ALTERNATES_COUNT: u32 = 7;
    pub const NS_FONT_VARIANT_ALTERNATES_ENUMERATED_MASK: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_FUNCTIONAL_MASK: u32 = 126;
    pub const NS_FONT_VARIANT_CAPS_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_CAPS_SMALLCAPS: u32 = 1;
    pub const NS_FONT_VARIANT_CAPS_ALLSMALL: u32 = 2;
    pub const NS_FONT_VARIANT_CAPS_PETITECAPS: u32 = 3;
    pub const NS_FONT_VARIANT_CAPS_ALLPETITE: u32 = 4;
    pub const NS_FONT_VARIANT_CAPS_TITLING: u32 = 5;
    pub const NS_FONT_VARIANT_CAPS_UNICASE: u32 = 6;
    pub const NS_FONT_VARIANT_POSITION_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_POSITION_SUPER: u32 = 1;
    pub const NS_FONT_VARIANT_POSITION_SUB: u32 = 2;
    pub const NS_FONT_VARIANT_WIDTH_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_WIDTH_FULL: u32 = 1;
    pub const NS_FONT_VARIANT_WIDTH_HALF: u32 = 2;
    pub const NS_FONT_VARIANT_WIDTH_THIRD: u32 = 3;
    pub const NS_FONT_VARIANT_WIDTH_QUARTER: u32 = 4;
    pub const NS_FONT_SUBSCRIPT_OFFSET_RATIO: f64 = 0.2;
    pub const NS_FONT_SUPERSCRIPT_OFFSET_RATIO: f64 = 0.34;
    pub const NS_FONT_SUB_SUPER_SIZE_RATIO_SMALL: f64 = 0.82;
    pub const NS_FONT_SUB_SUPER_SIZE_RATIO_LARGE: f64 = 0.667;
    pub const NS_FONT_SUB_SUPER_SMALL_SIZE: f64 = 20.0;
    pub const NS_FONT_SUB_SUPER_LARGE_SIZE: f64 = 45.0;
    pub const CSS_PSEUDO_ELEMENT_IS_CSS2: u32 = 1;
    pub const CSS_PSEUDO_ELEMENT_SUPPORTS_USER_ACTION_STATE: u32 = 8;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_UA_SHEETS: u32 = 16;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_CHROME: u32 = 32;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_UA_SHEETS_AND_CHROME: u32 = 48;
    pub const CSS_PSEUDO_ELEMENT_IS_JS_CREATED_NAC: u32 = 64;
    pub const CSS_PSEUDO_ELEMENT_IS_FLEX_OR_GRID_ITEM: u32 = 128;
    pub const NS_ATTRVALUE_MAX_STRINGLENGTH_ATOM: u32 = 12;
    pub const NS_ATTRVALUE_INTEGERTYPE_BITS: u32 = 4;
    pub const NS_ATTRVALUE_INTEGERTYPE_MULTIPLIER: u32 = 16;
    pub const NS_ATTRVALUE_INTEGERTYPE_MAXVALUE: u32 = 134217727;
    pub const NS_ATTRVALUE_INTEGERTYPE_MINVALUE: i32 = -134217728;
    pub const NS_ATTRVALUE_ENUMTABLEINDEX_BITS: u32 = 12;
    pub const NS_ATTRVALUE_ENUMTABLE_VALUE_NEEDS_TO_UPPER: u32 = 2048;
    pub const NS_ATTRVALUE_ENUMTABLEINDEX_MAXVALUE: u32 = 2047;
    pub const NS_FONT_VARIANT_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_SMALL_CAPS: u32 = 1;
    pub const kNameSpaceID_Unknown: i32 = -1;
    pub const kNameSpaceID_XMLNS: u32 = 1;
    pub const kNameSpaceID_XML: u32 = 2;
    pub const kNameSpaceID_XHTML: u32 = 3;
    pub const kNameSpaceID_XLink: u32 = 4;
    pub const kNameSpaceID_XSLT: u32 = 5;
    pub const kNameSpaceID_MathML: u32 = 6;
    pub const kNameSpaceID_RDF: u32 = 7;
    pub const kNameSpaceID_XUL: u32 = 8;
    pub const kNameSpaceID_SVG: u32 = 9;
    pub const kNameSpaceID_disabled_MathML: u32 = 10;
    pub const kNameSpaceID_disabled_SVG: u32 = 11;
    pub const kNameSpaceID_LastBuiltin: u32 = 11;
    pub const kNameSpaceID_Wildcard: i32 = -2147483648;
    pub mod std {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub type integral_constant_value_type<_Tp> = _Tp;
        pub type integral_constant_type = u8;
        pub type true_type = u8;
        pub type false_type = u8;
        pub mod __detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct remove_const {
            pub _address: u8,
        }
        pub type remove_const_type<_Tp> = _Tp;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct remove_cv {
            pub _address: u8,
        }
        pub type remove_cv_type<_Tp> = _Tp;
        pub type remove_const_t = root::std::remove_const;
        pub type remove_cv_t = root::std::remove_cv;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct remove_reference {
            pub _address: u8,
        }
        pub type remove_reference_type<_Tp> = _Tp;
        pub type remove_reference_t = root::std::remove_reference;
        pub type make_signed_t = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct add_pointer {
            pub _address: u8,
        }
        pub type add_pointer_type<_Tp> = _Tp;
        pub type add_pointer_t = root::std::add_pointer;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct decay {
            pub _address: u8,
        }
        pub type decay_type<_Tp> = _Tp;
        pub type conditional_type<_Iftrue> = _Iftrue;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct __invoke_result {
            pub _address: u8,
        }
        pub type decay_t = root::std::decay;
        pub type conditional_t = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct invoke_result {
            pub _address: u8,
        }
        pub type invoke_result_t = root::std::invoke_result;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct nothrow_t {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_nothrow_t() {
            assert_eq!(
                ::std::mem::size_of::<nothrow_t>(),
                1usize,
                concat!("Size of: ", stringify!(nothrow_t))
            );
            assert_eq!(
                ::std::mem::align_of::<nothrow_t>(),
                1usize,
                concat!("Alignment of ", stringify!(nothrow_t))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct atomic {
            pub _address: u8,
        }
        pub type atomic_value_type<_Tp> = _Tp;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct input_iterator_tag {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_input_iterator_tag() {
            assert_eq!(
                ::std::mem::size_of::<input_iterator_tag>(),
                1usize,
                concat!("Size of: ", stringify!(input_iterator_tag))
            );
            assert_eq!(
                ::std::mem::align_of::<input_iterator_tag>(),
                1usize,
                concat!("Alignment of ", stringify!(input_iterator_tag))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct forward_iterator_tag {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_forward_iterator_tag() {
            assert_eq!(
                ::std::mem::size_of::<forward_iterator_tag>(),
                1usize,
                concat!("Size of: ", stringify!(forward_iterator_tag))
            );
            assert_eq!(
                ::std::mem::align_of::<forward_iterator_tag>(),
                1usize,
                concat!("Alignment of ", stringify!(forward_iterator_tag))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct bidirectional_iterator_tag {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_bidirectional_iterator_tag() {
            assert_eq!(
                ::std::mem::size_of::<bidirectional_iterator_tag>(),
                1usize,
                concat!("Size of: ", stringify!(bidirectional_iterator_tag))
            );
            assert_eq!(
                ::std::mem::align_of::<bidirectional_iterator_tag>(),
                1usize,
                concat!("Alignment of ", stringify!(bidirectional_iterator_tag))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct random_access_iterator_tag {
            pub _address: u8,
        }
        #[test]
        fn bindgen_test_layout_random_access_iterator_tag() {
            assert_eq!(
                ::std::mem::size_of::<random_access_iterator_tag>(),
                1usize,
                concat!("Size of: ", stringify!(random_access_iterator_tag))
            );
            assert_eq!(
                ::std::mem::align_of::<random_access_iterator_tag>(),
                1usize,
                concat!("Alignment of ", stringify!(random_access_iterator_tag))
            );
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct iterator {
            pub _address: u8,
        }
        pub type iterator_iterator_category<_Category> = _Category;
        pub type iterator_value_type<_Tp> = _Tp;
        pub type iterator_difference_type<_Distance> = _Distance;
        pub type iterator_pointer<_Pointer> = _Pointer;
        pub type iterator_reference<_Reference> = _Reference;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct __iterator_traits {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct iterator_traits {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct reverse_iterator<_Iterator> {
            pub current: _Iterator,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<_Iterator>>,
        }
        pub type reverse_iterator___traits_type = root::std::iterator_traits;
        pub type reverse_iterator_iterator_type<_Iterator> = _Iterator;
        pub type reverse_iterator_pointer = root::std::reverse_iterator___traits_type;
        pub type reverse_iterator_difference_type = root::std::reverse_iterator___traits_type;
        pub type reverse_iterator_reference = root::std::reverse_iterator___traits_type;
        #[repr(C)]
        #[derive(Debug)]
        pub struct __pair_base {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug)]
        pub struct pair<_T1, _T2> {
            pub first: _T1,
            pub second: _T2,
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<_T1>>,
            pub _phantom_1: ::std::marker::PhantomData<::std::cell::UnsafeCell<_T2>>,
        }
        pub type pair_first_type<_T1> = _T1;
        pub type pair_second_type<_T2> = _T2;
        pub type pair__PCCP = u8;
        pub type pair__PCCFP = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct pair___zero_as_null_pointer_constant {
            pub _address: u8,
        }
        pub type basic_string_view_traits_type<_Traits> = _Traits;
        pub type basic_string_view_value_type<_CharT> = _CharT;
        pub type basic_string_view_pointer<_CharT> =
            *mut root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_const_pointer<_CharT> =
            *const root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_reference<_CharT> =
            *mut root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_const_reference<_CharT> =
            *const root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_const_iterator<_CharT> =
            *const root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_iterator<_CharT> =
            root::std::basic_string_view_const_iterator<_CharT>;
        pub type basic_string_view_const_reverse_iterator<_CharT> =
            root::std::reverse_iterator<root::std::basic_string_view_const_iterator<_CharT>>;
        pub type basic_string_view_reverse_iterator<_CharT> =
            root::std::basic_string_view_const_reverse_iterator<_CharT>;
        pub type basic_string_view_size_type = usize;
        pub type basic_string_view_difference_type = isize;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct unique_ptr {
            pub _address: u8,
        }
        pub type unique_ptr__DeleterConstraint = u8;
        pub type unique_ptr_pointer = u8;
        pub type unique_ptr_element_type = u8;
        pub type unique_ptr_deleter_type = u8;
        pub type unique_ptr___safe_conversion_up = u8;
        pub mod chrono {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        pub type _Base_bitset__WordT = ::std::os::raw::c_ulong;
        pub type bitset__Base = u8;
        pub type bitset__WordT = ::std::os::raw::c_ulong;
        #[repr(C)]
        #[derive(Debug)]
        pub struct bitset_reference {
            pub _M_wp: *mut root::std::bitset__WordT,
            pub _M_bpos: usize,
        }
    }
    pub mod __gnu_cxx {
        #[allow(unused_imports)]
        use self::super::super::root;
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct __pthread_internal_list {
        pub __prev: *mut root::__pthread_internal_list,
        pub __next: *mut root::__pthread_internal_list,
    }
    #[test]
    fn bindgen_test_layout___pthread_internal_list() {
        const UNINIT: ::std::mem::MaybeUninit<__pthread_internal_list> =
            ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<__pthread_internal_list>(),
            16usize,
            concat!("Size of: ", stringify!(__pthread_internal_list))
        );
        assert_eq!(
            ::std::mem::align_of::<__pthread_internal_list>(),
            8usize,
            concat!("Alignment of ", stringify!(__pthread_internal_list))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__prev) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_internal_list),
                "::",
                stringify!(__prev)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__next) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_internal_list),
                "::",
                stringify!(__next)
            )
        );
    }
    pub type __pthread_list_t = root::__pthread_internal_list;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct __pthread_mutex_s {
        pub __lock: ::std::os::raw::c_int,
        pub __count: ::std::os::raw::c_uint,
        pub __owner: ::std::os::raw::c_int,
        pub __nusers: ::std::os::raw::c_uint,
        pub __kind: ::std::os::raw::c_int,
        pub __spins: ::std::os::raw::c_short,
        pub __elision: ::std::os::raw::c_short,
        pub __list: root::__pthread_list_t,
    }
    #[test]
    fn bindgen_test_layout___pthread_mutex_s() {
        const UNINIT: ::std::mem::MaybeUninit<__pthread_mutex_s> =
            ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<__pthread_mutex_s>(),
            40usize,
            concat!("Size of: ", stringify!(__pthread_mutex_s))
        );
        assert_eq!(
            ::std::mem::align_of::<__pthread_mutex_s>(),
            8usize,
            concat!("Alignment of ", stringify!(__pthread_mutex_s))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__lock) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__lock)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__count) as usize - ptr as usize },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__count)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__owner) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__owner)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__nusers) as usize - ptr as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__nusers)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__kind) as usize - ptr as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__kind)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__spins) as usize - ptr as usize },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__spins)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__elision) as usize - ptr as usize },
            22usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__elision)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__list) as usize - ptr as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(__pthread_mutex_s),
                "::",
                stringify!(__list)
            )
        );
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct pthread_mutex_t {
        pub __data: root::__BindgenUnionField<root::__pthread_mutex_s>,
        pub __size: root::__BindgenUnionField<[::std::os::raw::c_char; 40usize]>,
        pub __align: root::__BindgenUnionField<::std::os::raw::c_long>,
        pub bindgen_union_field: [u64; 5usize],
    }
    #[test]
    fn bindgen_test_layout_pthread_mutex_t() {
        const UNINIT: ::std::mem::MaybeUninit<pthread_mutex_t> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<pthread_mutex_t>(),
            40usize,
            concat!("Size of: ", stringify!(pthread_mutex_t))
        );
        assert_eq!(
            ::std::mem::align_of::<pthread_mutex_t>(),
            8usize,
            concat!("Alignment of ", stringify!(pthread_mutex_t))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__data) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(pthread_mutex_t),
                "::",
                stringify!(__data)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__size) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(pthread_mutex_t),
                "::",
                stringify!(__size)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__align) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(pthread_mutex_t),
                "::",
                stringify!(__align)
            )
        );
    }
    pub mod mozilla {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub use crate::color::component::ColorComponent as StyleColorComponent;
        pub use crate::color::AbsoluteColor as StyleAbsoluteColor;
        pub use crate::computed_value_flags::ComputedValueFlags as StyleComputedValueFlags;
        pub use crate::counter_style::CounterStyle as StyleCounterStyle;
        pub use crate::counter_style::SymbolsType as StyleSymbolsType;
        pub use crate::font_face::ComputedFontStretchRange as StyleComputedFontStretchRange;
        pub use crate::font_face::ComputedFontStyleDescriptor as StyleComputedFontStyleDescriptor;
        pub use crate::font_face::ComputedFontWeightRange as StyleComputedFontWeightRange;
        pub use crate::font_face::FontDisplay as StyleFontDisplay;
        pub use crate::font_face::FontFaceSourceFormatKeyword as StyleFontFaceSourceFormatKeyword;
        pub use crate::font_face::FontFaceSourceListComponent as StyleFontFaceSourceListComponent;
        pub use crate::font_face::FontFaceSourceTechFlags as StyleFontFaceSourceTechFlags;
        pub use crate::gecko::arc_types::LockedDeclarationBlock as StyleLockedDeclarationBlock;
        pub use crate::gecko::arc_types::LockedFontFaceRule as StyleLockedFontFaceRule;
        pub use crate::gecko::arc_types::LockedImportRule as StyleLockedImportRule;
        pub use crate::gecko::arc_types::LockedMediaList as StyleLockedMediaList;
        pub use crate::gecko::data::AuthorStyles as StyleAuthorStyles;
        pub use crate::gecko::media_features::ColorGamut as StyleColorGamut;
        pub use crate::gecko::media_features::DisplayMode as StyleDisplayMode;
        pub use crate::gecko::media_features::DynamicRange as StyleDynamicRange;
        pub use crate::gecko::media_features::GtkThemeFamily as StyleGtkThemeFamily;
        pub use crate::gecko::media_features::Platform as StylePlatform;
        pub use crate::gecko::media_features::PrefersContrast as StylePrefersContrast;
        pub use crate::gecko::media_features::Scripting as StyleScripting;
        pub use crate::gecko::url::ComputedUrl as StyleComputedUrl;
        pub use crate::gecko::url::CssUrl as StyleCssUrl;
        pub use crate::gecko::url::LoadData as StyleLoadData;
        pub use crate::gecko::url::SpecifiedUrl as StyleSpecifiedUrl;
        pub use crate::gecko_bindings::sugar::ownership::Strong as StyleStrong;
        pub use crate::invalidation::element::restyle_hints::RestyleHint as StyleRestyleHint;
        pub use crate::properties::animated_properties::AnimationValue as StyleAnimationValue;
        pub use crate::properties::animated_properties::AnimationValueMap as StyleAnimationValueMap;
        pub use crate::queries::condition::ComputedMozPrefFeatureValue as StyleComputedMozPrefFeatureValue;
        pub use crate::queries::values::PrefersColorScheme as StylePrefersColorScheme;
        pub use crate::stylesheets::Origin as StyleOrigin;
        pub use crate::stylesheets::StylesheetContents as StyleStylesheetContents;
        pub use crate::use_counters::UseCounters as StyleUseCounters;
        pub use crate::values::computed::align::AlignContent as StyleAlignContent;
        pub use crate::values::computed::align::ComputedJustifyItems as StyleComputedJustifyItems;
        pub use crate::values::computed::align::JustifyContent as StyleJustifyContent;
        pub use crate::values::computed::basic_shape::BasicShape as StyleBasicShape;
        pub use crate::values::computed::basic_shape::ClipPath as StyleClipPath;
        pub use crate::values::computed::basic_shape::InsetRect as StyleInsetRect;
        pub use crate::values::computed::basic_shape::Shape as StyleShape;
        pub use crate::values::computed::basic_shape::ShapeCommand as StyleShapeCommand;
        pub use crate::values::computed::basic_shape::ShapeOutside as StyleShapeOutside;
        pub use crate::values::computed::box_::WritingModeProperty as StyleWritingModeProperty;
        pub use crate::values::computed::color::CaretColor as StyleCaretColor;
        pub use crate::values::computed::counters::Content as StyleContent;
        pub use crate::values::computed::easing::TimingFunction as StyleComputedTimingFunction;
        pub use crate::values::computed::font::FontFamily as StyleFontFamily;
        pub use crate::values::computed::font::FontFamilyNameSyntax as StyleFontFamilyNameSyntax;
        pub use crate::values::computed::font::FontLanguageOverride as StyleFontLanguageOverride;
        pub use crate::values::computed::font::FontPalette as StyleFontPalette;
        pub use crate::values::computed::font::FontSizeAdjust as StyleFontSizeAdjust;
        pub use crate::values::computed::font::FontStretch as StyleFontStretch;
        pub use crate::values::computed::font::FontStyle as StyleFontStyle;
        pub use crate::values::computed::font::FontSynthesis as StyleFontSynthesis;
        pub use crate::values::computed::font::FontSynthesisStyle as StyleFontSynthesisStyle;
        pub use crate::values::computed::font::FontVariantEastAsian as StyleFontVariantEastAsian;
        pub use crate::values::computed::font::FontVariantLigatures as StyleFontVariantLigatures;
        pub use crate::values::computed::font::FontVariantNumeric as StyleFontVariantNumeric;
        pub use crate::values::computed::font::FontWeight as StyleFontWeight;
        pub use crate::values::computed::font::GenericFontFamily as StyleGenericFontFamily;
        pub use crate::values::computed::image::LineDirection as StyleLineDirection;
        pub use crate::values::computed::length::CSSPixelLength as StyleCSSPixelLength;
        pub use crate::values::computed::length::Margin as StyleMargin;
        pub use crate::values::computed::motion::OffsetPath as StyleOffsetPath;
        pub use crate::values::computed::motion::OffsetPathFunction as StyleOffsetPathFunction;
        pub use crate::values::computed::motion::OffsetPosition as StyleOffsetPosition;
        pub use crate::values::computed::motion::OffsetRotate as StyleOffsetRotate;
        pub use crate::values::computed::motion::RayFunction as StyleRayFunction;
        pub use crate::values::computed::page::PageSize as StylePageSize;
        pub use crate::values::computed::position::AnchorName as StyleAnchorName;
        pub use crate::values::computed::position::AnchorScope as StyleAnchorScope;
        pub use crate::values::computed::position::AspectRatio as StyleAspectRatio;
        pub use crate::values::computed::position::GridTemplateAreas as StyleGridTemplateAreas;
        pub use crate::values::computed::position::Inset as StyleInset;
        pub use crate::values::computed::position::PositionAnchor as StylePositionAnchor;
        pub use crate::values::computed::position::PositionArea as StylePositionArea;
        pub use crate::values::computed::position::PositionTryFallbacks as StylePositionTryFallbacks;
        pub use crate::values::computed::position::PositionTryOrder as StylePositionTryOrder;
        pub use crate::values::computed::position::PositionVisibility as StylePositionVisibility;
        pub use crate::values::computed::svg::SVGLength as StyleSVGLength;
        pub use crate::values::computed::svg::SVGOpacity as StyleSVGOpacity;
        pub use crate::values::computed::svg::SVGStrokeDashArray as StyleSVGStrokeDashArray;
        pub use crate::values::computed::svg::SVGWidth as StyleSVGWidth;
        pub use crate::values::computed::table::CaptionSide as StyleCaptionSide;
        pub use crate::values::computed::text::InitialLetter as StyleInitialLetter;
        pub use crate::values::computed::text::LetterSpacing as StyleLetterSpacing;
        pub use crate::values::computed::text::MozControlCharacterVisibility as StyleMozControlCharacterVisibility;
        pub use crate::values::computed::text::TextAlignLast as StyleTextAlignLast;
        pub use crate::values::computed::text::TextAutospace as StyleTextAutospace;
        pub use crate::values::computed::text::TextEmphasisStyle as StyleTextEmphasisStyle;
        pub use crate::values::computed::text::TextIndent as StyleTextIndent;
        pub use crate::values::computed::ui::CursorKind as StyleCursorKind;
        pub use crate::values::computed::ui::Inert as StyleInert;
        pub use crate::values::computed::ui::MozTheme as StyleMozTheme;
        pub use crate::values::computed::ui::PointerEvents as StylePointerEvents;
        pub use crate::values::computed::AlignItems as StyleAlignItems;
        pub use crate::values::computed::AlignSelf as StyleAlignSelf;
        pub use crate::values::computed::Angle as StyleAngle;
        pub use crate::values::computed::AnimationComposition as StyleAnimationComposition;
        pub use crate::values::computed::AnimationDirection as StyleAnimationDirection;
        pub use crate::values::computed::AnimationDuration as StyleAnimationDuration;
        pub use crate::values::computed::AnimationFillMode as StyleAnimationFillMode;
        pub use crate::values::computed::AnimationIterationCount as StyleAnimationIterationCount;
        pub use crate::values::computed::AnimationName as StyleAnimationName;
        pub use crate::values::computed::AnimationPlayState as StyleAnimationPlayState;
        pub use crate::values::computed::AnimationTimeline as StyleAnimationTimeline;
        pub use crate::values::computed::BackgroundSize as StyleBackgroundSize;
        pub use crate::values::computed::BaselineSource as StyleBaselineSource;
        pub use crate::values::computed::BoolInteger as StyleBoolInteger;
        pub use crate::values::computed::BorderImageSlice as StyleBorderImageSlice;
        pub use crate::values::computed::BorderSpacing as StyleBorderSpacing;
        pub use crate::values::computed::BorderStyle as StyleBorderStyle;
        pub use crate::values::computed::BreakBetween as StyleBreakBetween;
        pub use crate::values::computed::BreakWithin as StyleBreakWithin;
        pub use crate::values::computed::CSSPixelLength as StyleLength;
        pub use crate::values::computed::Clear as StyleClear;
        pub use crate::values::computed::ClipRectOrAuto as StyleClipRectOrAuto;
        pub use crate::values::computed::ColumnCount as StyleColumnCount;
        pub use crate::values::computed::Contain as StyleContain;
        pub use crate::values::computed::ContainIntrinsicSize as StyleContainIntrinsicSize;
        pub use crate::values::computed::ContainerName as StyleContainerName;
        pub use crate::values::computed::ContainerType as StyleContainerType;
        pub use crate::values::computed::ContentVisibility as StyleContentVisibility;
        pub use crate::values::computed::CounterIncrement as StyleCounterIncrement;
        pub use crate::values::computed::CounterReset as StyleCounterReset;
        pub use crate::values::computed::CounterSet as StyleCounterSet;
        pub use crate::values::computed::Cursor as StyleCursor;
        pub use crate::values::computed::FlexBasis as StyleFlexBasis;
        pub use crate::values::computed::Float as StyleFloat;
        pub use crate::values::computed::ForcedColorAdjust as StyleForcedColorAdjust;
        pub use crate::values::computed::GridAutoFlow as StyleGridAutoFlow;
        pub use crate::values::computed::HyphenateCharacter as StyleHyphenateCharacter;
        pub use crate::values::computed::HyphenateLimitChars as StyleHyphenateLimitChars;
        pub use crate::values::computed::Image as StyleImage;
        pub use crate::values::computed::ImageRendering as StyleImageRendering;
        pub use crate::values::computed::ImplicitGridTracks as StyleImplicitGridTracks;
        pub use crate::values::computed::JustifySelf as StyleJustifySelf;
        pub use crate::values::computed::LengthPercentage as StyleLengthPercentage;
        pub use crate::values::computed::LengthPercentageOrAuto as StyleLengthPercentageOrAuto;
        pub use crate::values::computed::LineBreak as StyleLineBreak;
        pub use crate::values::computed::LineClamp as StyleLineClamp;
        pub use crate::values::computed::ListStyleType as StyleListStyleType;
        pub use crate::values::computed::MaxSize as StyleMaxSize;
        pub use crate::values::computed::NonNegativeLength as StyleNonNegativeLength;
        pub use crate::values::computed::NonNegativeLengthPercentage as StyleNonNegativeLengthPercentage;
        pub use crate::values::computed::NonNegativeLengthPercentageOrAuto as StyleNonNegativeLengthPercentageOrAuto;
        pub use crate::values::computed::NonNegativeNumber as StyleNonNegativeNumber;
        pub use crate::values::computed::NumberOrPercentage as StyleNumberOrPercentage;
        pub use crate::values::computed::OutlineStyle as StyleOutlineStyle;
        pub use crate::values::computed::Overflow as StyleOverflow;
        pub use crate::values::computed::OverflowAnchor as StyleOverflowAnchor;
        pub use crate::values::computed::OverflowClipBox as StyleOverflowClipBox;
        pub use crate::values::computed::OverflowWrap as StyleOverflowWrap;
        pub use crate::values::computed::OverscrollBehavior as StyleOverscrollBehavior;
        pub use crate::values::computed::Percentage as StylePercentage;
        pub use crate::values::computed::Perspective as StylePerspective;
        pub use crate::values::computed::Position as StylePosition;
        pub use crate::values::computed::PositionOrAuto as StylePositionOrAuto;
        pub use crate::values::computed::PositionProperty as StylePositionProperty;
        pub use crate::values::computed::PrintColorAdjust as StylePrintColorAdjust;
        pub use crate::values::computed::Resize as StyleResize;
        pub use crate::values::computed::RubyPosition as StyleRubyPosition;
        pub use crate::values::computed::ScrollAxis as StyleScrollAxis;
        pub use crate::values::computed::ScrollSnapAlign as StyleScrollSnapAlign;
        pub use crate::values::computed::ScrollSnapStop as StyleScrollSnapStop;
        pub use crate::values::computed::ScrollSnapStrictness as StyleScrollSnapStrictness;
        pub use crate::values::computed::ScrollSnapType as StyleScrollSnapType;
        pub use crate::values::computed::ScrollbarGutter as StyleScrollbarGutter;
        pub use crate::values::computed::Size as StyleSize;
        pub use crate::values::computed::TextAlign as StyleTextAlign;
        pub use crate::values::computed::TextDecorationLength as StyleTextDecorationLength;
        pub use crate::values::computed::TextDecorationLine as StyleTextDecorationLine;
        pub use crate::values::computed::TextDecorationSkipInk as StyleTextDecorationSkipInk;
        pub use crate::values::computed::TextDecorationTrim as StyleTextDecorationTrim;
        pub use crate::values::computed::TextEmphasisPosition as StyleTextEmphasisPosition;
        pub use crate::values::computed::TextJustify as StyleTextJustify;
        pub use crate::values::computed::TextOverflow as StyleTextOverflow;
        pub use crate::values::computed::TextTransform as StyleTextTransform;
        pub use crate::values::computed::TextUnderlinePosition as StyleTextUnderlinePosition;
        pub use crate::values::computed::Time as StyleTime;
        pub use crate::values::computed::TimelineName as StyleTimelineName;
        pub use crate::values::computed::TouchAction as StyleTouchAction;
        pub use crate::values::computed::TransformBox as StyleTransformBox;
        pub use crate::values::computed::TransformOrigin as StyleTransformOrigin;
        pub use crate::values::computed::TransformStyle as StyleTransformStyle;
        pub use crate::values::computed::TransitionBehavior as StyleTransitionBehavior;
        pub use crate::values::computed::TransitionProperty as StyleTransitionProperty;
        pub use crate::values::computed::UserFocus as StyleUserFocus;
        pub use crate::values::computed::UserSelect as StyleUserSelect;
        pub use crate::values::computed::ViewTimelineInset as StyleViewTimelineInset;
        pub use crate::values::computed::ViewTransitionClass as StyleViewTransitionClass;
        pub use crate::values::computed::ViewTransitionName as StyleViewTransitionName;
        pub use crate::values::computed::WordBreak as StyleWordBreak;
        pub use crate::values::computed::XTextScale as StyleXTextScale;
        pub use crate::values::computed::ZIndex as StyleZIndex;
        pub use crate::values::computed::ZeroToOneNumber as StyleZeroToOneNumber;
        pub use crate::values::computed::Zoom as StyleZoom;
        pub use crate::values::generics::background::BackgroundSize as StyleGenericBackgroundSize;
        pub use crate::values::generics::basic_shape::BasicShape as StyleGenericBasicShape;
        pub use crate::values::generics::basic_shape::FillRule as StyleFillRule;
        pub use crate::values::generics::basic_shape::GenericShapeRadius as StyleGenericShapeRadius;
        pub use crate::values::generics::basic_shape::InsetRect as StyleGenericInsetRect;
        pub use crate::values::generics::basic_shape::ShapeCommand as StyleGenericShapeCommand;
        pub use crate::values::generics::border::BorderImageSideWidth as StyleGenericBorderImageSideWidth;
        pub use crate::values::generics::border::BorderRadius as StyleGenericBorderRadius;
        pub use crate::values::generics::box_::Perspective as StyleGenericPerspective;
        pub use crate::values::generics::box_::VerticalAlign as StyleGenericVerticalAlign;
        pub use crate::values::generics::box_::VerticalAlignKeyword as StyleVerticalAlignKeyword;
        pub use crate::values::generics::calc::GenericCalcNode as StyleGenericCalcNode;
        pub use crate::values::generics::color::Color as StyleGenericColor;
        pub use crate::values::generics::color::ColorOrAuto as StyleGenericColorOrAuto;
        pub use crate::values::generics::counters::GenericCounterPair as StyleGenericCounterPair;
        pub use crate::values::generics::effects::BoxShadow as StyleGenericBoxShadow;
        pub use crate::values::generics::effects::Filter as StyleGenericFilter;
        pub use crate::values::generics::effects::SimpleShadow as StyleGenericSimpleShadow;
        pub use crate::values::generics::flex::FlexBasis as StyleGenericFlexBasis;
        pub use crate::values::generics::font::LineHeight as StyleGenericLineHeight;
        pub use crate::values::generics::grid::GridLine as StyleGenericGridLine;
        pub use crate::values::generics::grid::GridTemplateComponent as StyleGenericGridTemplateComponent;
        pub use crate::values::generics::grid::ImplicitGridTracks as StyleGenericImplicitGridTracks;
        pub use crate::values::generics::grid::TrackBreadth as StyleGenericTrackBreadth;
        pub use crate::values::generics::grid::TrackList as StyleGenericTrackList;
        pub use crate::values::generics::grid::TrackListValue as StyleGenericTrackListValue;
        pub use crate::values::generics::grid::TrackRepeat as StyleGenericTrackRepeat;
        pub use crate::values::generics::grid::TrackSize as StyleGenericTrackSize;
        pub use crate::values::generics::image::Gradient as StyleGenericGradient;
        pub use crate::values::generics::length::LengthOrNumber as StyleGenericLengthOrNumber;
        pub use crate::values::generics::length::LengthPercentageOrAuto as StyleGenericLengthPercentageOrAuto;
        pub use crate::values::generics::length::LengthPercentageOrNormal as StyleGenericLengthPercentageOrNormal;
        pub use crate::values::generics::length::MaxSize as StyleGenericMaxSize;
        pub use crate::values::generics::length::Size as StyleGenericSize;
        pub use crate::values::generics::motion::OffsetPath as StyleGenericOffsetPath;
        pub use crate::values::generics::motion::OffsetPathFunction as StyleGenericOffsetPathFunction;
        pub use crate::values::generics::page::PageOrientation as StylePageOrientation;
        pub use crate::values::generics::position::GenericAnchorFunction as StyleGenericAnchorFunction;
        pub use crate::values::generics::position::GenericAnchorSide as StyleGenericAnchorSide;
        pub use crate::values::generics::position::GenericPosition as StyleGenericPosition;
        pub use crate::values::generics::position::PositionOrAuto as StyleGenericPositionOrAuto;
        pub use crate::values::generics::position::ZIndex as StyleGenericZIndex;
        pub use crate::values::generics::rect::Rect as StyleRect;
        pub use crate::values::generics::svg::SVGPaint as StyleGenericSVGPaint;
        pub use crate::values::generics::transform::Rotate as StyleGenericRotate;
        pub use crate::values::generics::transform::Scale as StyleGenericScale;
        pub use crate::values::generics::transform::Transform as StyleGenericTransform;
        pub use crate::values::generics::transform::TransformOperation as StyleGenericTransformOperation;
        pub use crate::values::generics::transform::Translate as StyleGenericTranslate;
        pub use crate::values::generics::ui::GenericCursorImage as StyleGenericCursorImage;
        pub use crate::values::generics::ui::ScrollbarColor as StyleGenericScrollbarColor;
        pub use crate::values::generics::url::UrlOrNone as StyleGenericUrlOrNone;
        pub use crate::values::generics::GenericClipRect as StyleGenericClipRect;
        pub use crate::values::specified::border::BorderImageRepeat as StyleBorderImageRepeat;
        pub use crate::values::specified::border::BorderImageRepeatKeyword as StyleBorderImageRepeatKeyword;
        pub use crate::values::specified::box_::WillChange as StyleWillChange;
        pub use crate::values::specified::color::ColorScheme as StyleColorScheme;
        pub use crate::values::specified::color::ColorSchemeFlags as StyleColorSchemeFlags;
        pub use crate::values::specified::color::ForcedColors as StyleForcedColors;
        pub use crate::values::specified::color::SystemColor as StyleSystemColor;
        pub use crate::values::specified::font::FontSizeKeyword as StyleFontSizeKeyword;
        pub use crate::values::specified::font::FontVariantAlternates as StyleFontVariantAlternates;
        pub use crate::values::specified::font::QueryFontMetricsFlags as StyleQueryFontMetricsFlags;
        pub use crate::values::specified::font::SystemFont as StyleSystemFont;
        pub use crate::values::specified::intersection_observer::IntersectionObserverMargin as StyleIntersectionObserverMargin;
        pub use crate::values::specified::list::Quotes as StyleQuotes;
        pub use crate::values::specified::page::PageName as StylePageName;
        pub use crate::values::specified::svg::DProperty as StyleDProperty;
        pub use crate::values::specified::svg::MozContextProperties as StyleMozContextProperties;
        pub use crate::values::specified::svg::SVGPaintOrder as StyleSVGPaintOrder;
        pub use crate::values::specified::svg::VectorEffect as StyleVectorEffect;
        pub use crate::values::specified::svg_path::PathCommand as StylePathCommand;
        pub use crate::values::specified::Appearance as StyleAppearance;
        pub use crate::values::specified::Display as StyleDisplay;
        pub use crate::values::specified::MasonryAutoFlow as StyleMasonryAutoFlow;
        pub use crate::values::specified::MasonryItemOrder as StyleMasonryItemOrder;
        pub use crate::values::specified::MasonryPlacement as StyleMasonryPlacement;
        pub use crate::Atom as StyleAtom;
        pub use app_units::Au as StyleAu;
        pub use cssparser::ParserState as StyleParserState;
        pub use cssparser::UnicodeRange as StyleUnicodeRange;
        pub use style_traits::arc_slice::ArcSlice as StyleArcSlice;
        pub use style_traits::arc_slice::ForgottenArcSlicePtr as StyleForgottenArcSlicePtr;
        pub use style_traits::owned_slice::OwnedSlice as StyleOwnedSlice;
        pub use style_traits::owned_str::OwnedStr as StyleOwnedStr;
        pub mod detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            pub const StringDataFlags_TERMINATED: root::mozilla::detail::StringDataFlags = 1;
            pub const StringDataFlags_VOIDED: root::mozilla::detail::StringDataFlags = 2;
            pub const StringDataFlags_REFCOUNTED: root::mozilla::detail::StringDataFlags = 4;
            pub const StringDataFlags_OWNED: root::mozilla::detail::StringDataFlags = 8;
            pub const StringDataFlags_INLINE: root::mozilla::detail::StringDataFlags = 16;
            pub const StringDataFlags_LITERAL: root::mozilla::detail::StringDataFlags = 32;
            pub const StringDataFlags_INVALID_MASK: root::mozilla::detail::StringDataFlags = 65472;
            pub type StringDataFlags = u16;
            pub const StringClassFlags_INLINE: root::mozilla::detail::StringClassFlags = 1;
            pub const StringClassFlags_NULL_TERMINATED: root::mozilla::detail::StringClassFlags = 2;
            pub const StringClassFlags_INVALID_MASK: root::mozilla::detail::StringClassFlags =
                65532;
            pub type StringClassFlags = u16;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringLengthStorage {
                pub mLength: u32,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringRepr<T> {
                pub mData: *mut root::mozilla::detail::nsTStringRepr_char_type<T>,
                pub mLength: root::mozilla::detail::nsTStringRepr_LengthStorage,
                pub mDataFlags: root::mozilla::detail::nsTStringRepr_DataFlags,
                pub mClassFlags: root::mozilla::detail::nsTStringRepr_ClassFlags,
                pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
            }
            pub type nsTStringRepr_fallible_t = root::mozilla::fallible_t;
            pub type nsTStringRepr_char_type<T> = T;
            pub type nsTStringRepr_self_type<T> = root::mozilla::detail::nsTStringRepr<T>;
            pub type nsTStringRepr_base_string_type<T> =
                root::mozilla::detail::nsTStringRepr_self_type<T>;
            #[doc = " nsTSubstring is an abstract string class. From an API perspective, this\n class is the root of the string class hierarchy. It represents a single\n contiguous array of characters, which may or may not be null-terminated.\n This type is not instantiated directly. A sub-class is instantiated\n instead. For example, see nsTString.\n\n NAMES:\n   nsAString for wide characters\n   nsACString for narrow characters\n"]
            pub type nsTStringRepr_substring_type<T> = root::nsTSubstring<T>;
            #[doc = " nsTSubstringTuple\n\n Represents a tuple of string fragments.  Built as a recursive binary tree.\n It is used to implement the concatenation of two or more string objects.\n\n NOTE: This class is a private implementation detail and should never be\n referenced outside the string code."]
            pub type nsTStringRepr_substring_tuple_type<T> = root::nsTSubstringTuple<T>;
            #[doc = " @see nsTAString"]
            pub type nsTStringRepr_const_iterator<T> =
                root::nsReadingIterator<root::mozilla::detail::nsTStringRepr_char_type<T>>;
            pub type nsTStringRepr_iterator<T> =
                *mut root::mozilla::detail::nsTStringRepr_char_type<T>;
            pub type nsTStringRepr_comparator_type<T> =
                root::nsTStringComparator<root::mozilla::detail::nsTStringRepr_char_type<T>>;
            pub type nsTStringRepr_const_char_iterator<T> =
                *const root::mozilla::detail::nsTStringRepr_char_type<T>;
            pub type nsTStringRepr_index_type = usize;
            pub type nsTStringRepr_size_type = usize;
            pub use self::super::super::super::root::mozilla::detail::StringClassFlags as nsTStringRepr_ClassFlags;
            pub use self::super::super::super::root::mozilla::detail::StringDataFlags as nsTStringRepr_DataFlags;
            pub type nsTStringRepr_LengthStorage = root::mozilla::detail::nsTStringLengthStorage;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringRepr_raw_type {
                pub _address: u8,
            }
            pub type nsTStringRepr_raw_type_type<U> = *const U;
            pub const PackingStrategy_Variant: root::mozilla::detail::PackingStrategy = 0;
            pub const PackingStrategy_NullIsOk: root::mozilla::detail::PackingStrategy = 1;
            pub const PackingStrategy_LowBitTagIsError: root::mozilla::detail::PackingStrategy = 2;
            pub const PackingStrategy_PackedVariant: root::mozilla::detail::PackingStrategy = 3;
            pub const PackingStrategy_ZeroIsEmptyError: root::mozilla::detail::PackingStrategy = 4;
            pub type PackingStrategy = ::std::os::raw::c_int;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct SelectResultImpl {
                pub _address: u8,
            }
            pub type SelectResultImpl_Type = u8;
            #[repr(C)]
            #[derive(Debug)]
            pub struct GkAtoms {
                pub SystemPrincipal_string: [u16; 19usize],
                pub _empty_string: [u16; 1usize],
                pub _0_string: [u16; 2usize],
                pub _1_string: [u16; 2usize],
                pub mozframetype_string: [u16; 13usize],
                pub _moz_abspos_string: [u16; 12usize],
                pub _moz_activated_string: [u16; 15usize],
                pub _moz_anonclass_string: [u16; 15usize],
                pub _moz_resizing_string: [u16; 14usize],
                pub moztype_string: [u16; 10usize],
                pub mozdirty_string: [u16; 11usize],
                pub mozdisallowselectionprint_string: [u16; 26usize],
                pub mozdonotsend_string: [u16; 16usize],
                pub mozfwcontainer_string: [u16; 22usize],
                pub mozgeneratedcontentbefore_string: [u16; 30usize],
                pub mozgeneratedcontentafter_string: [u16; 29usize],
                pub mozgeneratedcontentmarker_string: [u16; 30usize],
                pub mozgeneratedcontentimage_string: [u16; 29usize],
                pub mozquote_string: [u16; 11usize],
                pub mozsignature_string: [u16; 14usize],
                pub _moz_bullet_font_string: [u16; 17usize],
                pub _moz_is_glyph_string: [u16; 14usize],
                pub _moz_in_android_pip_mode_string: [u16; 25usize],
                pub _moz_original_size_string: [u16; 19usize],
                pub _moz_print_preview_string: [u16; 19usize],
                pub menuactive_string: [u16; 16usize],
                pub _poundDefault_string: [u16; 9usize],
                pub _asterisk_string: [u16; 2usize],
                pub a_string: [u16; 2usize],
                pub abbr_string: [u16; 5usize],
                pub abort_string: [u16; 6usize],
                pub above_string: [u16; 6usize],
                pub acceltext_string: [u16; 10usize],
                pub accept_string: [u16; 7usize],
                pub acceptcharset_string: [u16; 15usize],
                pub accessiblenode_string: [u16; 16usize],
                pub accesskey_string: [u16; 10usize],
                pub acronym_string: [u16; 8usize],
                pub action_string: [u16; 7usize],
                pub active_string: [u16; 7usize],
                pub activateontab_string: [u16; 14usize],
                pub actuate_string: [u16; 8usize],
                pub address_string: [u16; 8usize],
                pub adoptedsheetclones_string: [u16; 19usize],
                pub after_string: [u16; 6usize],
                pub align_string: [u16; 6usize],
                pub alink_string: [u16; 6usize],
                pub all_string: [u16; 4usize],
                pub allow_string: [u16; 6usize],
                pub allowdownloads_string: [u16; 16usize],
                pub allowevents_string: [u16; 12usize],
                pub allowforms_string: [u16; 12usize],
                pub allowfullscreen_string: [u16; 16usize],
                pub allowmodals_string: [u16; 13usize],
                pub alloworientationlock_string: [u16; 23usize],
                pub allowpointerlock_string: [u16; 19usize],
                pub allowpopupstoescapesandbox_string: [u16; 31usize],
                pub allowpopups_string: [u16; 13usize],
                pub allowpresentation_string: [u16; 19usize],
                pub allowstorageaccessbyuseractivatetion_string: [u16; 40usize],
                pub allowsameorigin_string: [u16; 18usize],
                pub allowscripts_string: [u16; 14usize],
                pub allowscriptstoclose_string: [u16; 20usize],
                pub allowtopnavigation_string: [u16; 21usize],
                pub allowtopnavigationbyuseractivation_string: [u16; 40usize],
                pub allowtopnavigationcustomprotocols_string: [u16; 41usize],
                pub allowuntrusted_string: [u16; 15usize],
                pub alt_string: [u16; 4usize],
                pub alternate_string: [u16; 10usize],
                pub always_string: [u16; 7usize],
                pub ancestor_string: [u16; 9usize],
                pub ancestorOrSelf_string: [u16; 17usize],
                pub anchor_string: [u16; 7usize],
                pub _and_string: [u16; 4usize],
                pub animations_string: [u16; 11usize],
                pub anonid_string: [u16; 7usize],
                pub anonlocation_string: [u16; 13usize],
                pub any_string: [u16; 4usize],
                pub any_hover_string: [u16; 10usize],
                pub any_pointer_string: [u16; 12usize],
                pub applet_string: [u16; 7usize],
                pub applyImports_string: [u16; 14usize],
                pub applyTemplates_string: [u16; 16usize],
                pub archive_string: [u16; 8usize],
                pub area_string: [u16; 5usize],
                pub aria_string: [u16; 5usize],
                pub aria_activedescendant_string: [u16; 22usize],
                pub aria_atomic_string: [u16; 12usize],
                pub aria_autocomplete_string: [u16; 18usize],
                pub aria_braillelabel_string: [u16; 18usize],
                pub aria_brailleroledescription_string: [u16; 28usize],
                pub aria_busy_string: [u16; 10usize],
                pub aria_checked_string: [u16; 13usize],
                pub aria_controls_string: [u16; 14usize],
                pub aria_current_string: [u16; 13usize],
                pub aria_describedby_string: [u16; 17usize],
                pub aria_description_string: [u16; 17usize],
                pub aria_disabled_string: [u16; 14usize],
                pub aria_dropeffect_string: [u16; 16usize],
                pub aria_expanded_string: [u16; 14usize],
                pub aria_flowto_string: [u16; 12usize],
                pub aria_haspopup_string: [u16; 14usize],
                pub aria_hidden_string: [u16; 12usize],
                pub aria_invalid_string: [u16; 13usize],
                pub aria_labelledby_string: [u16; 16usize],
                pub aria_level_string: [u16; 11usize],
                pub aria_live_string: [u16; 10usize],
                pub aria_multiline_string: [u16; 15usize],
                pub aria_multiselectable_string: [u16; 21usize],
                pub aria_owns_string: [u16; 10usize],
                pub aria_posinset_string: [u16; 14usize],
                pub aria_pressed_string: [u16; 13usize],
                pub aria_readonly_string: [u16; 14usize],
                pub aria_relevant_string: [u16; 14usize],
                pub aria_required_string: [u16; 14usize],
                pub aria_selected_string: [u16; 14usize],
                pub aria_setsize_string: [u16; 13usize],
                pub aria_sort_string: [u16; 10usize],
                pub aria_valuemax_string: [u16; 14usize],
                pub aria_valuemin_string: [u16; 14usize],
                pub aria_valuenow_string: [u16; 14usize],
                pub arrow_string: [u16; 6usize],
                pub article_string: [u16; 8usize],
                pub as_string: [u16; 3usize],
                pub ascending_string: [u16; 10usize],
                pub aside_string: [u16; 6usize],
                pub aspectRatio_string: [u16; 13usize],
                pub async_string: [u16; 6usize],
                pub attribute_string: [u16; 10usize],
                pub attributes_string: [u16; 11usize],
                pub attributeSet_string: [u16; 14usize],
                pub _auto_string: [u16; 5usize],
                pub autocapitalize_string: [u16; 15usize],
                pub autocheck_string: [u16; 10usize],
                pub autocomplete_string: [u16; 13usize],
                pub autocomplete_richlistbox_string: [u16; 25usize],
                pub autofocus_string: [u16; 10usize],
                pub autoplay_string: [u16; 9usize],
                pub axis_string: [u16; 5usize],
                pub b_string: [u16; 2usize],
                pub background_string: [u16; 11usize],
                pub badge_string: [u16; 6usize],
                pub bar_string: [u16; 4usize],
                pub base_string: [u16; 5usize],
                pub basefont_string: [u16; 9usize],
                pub baseline_string: [u16; 9usize],
                pub bdi_string: [u16; 4usize],
                pub bdo_string: [u16; 4usize],
                pub before_string: [u16; 7usize],
                pub behavior_string: [u16; 9usize],
                pub below_string: [u16; 6usize],
                pub bgcolor_string: [u16; 8usize],
                pub bgsound_string: [u16; 8usize],
                pub big_string: [u16; 4usize],
                pub binding_string: [u16; 8usize],
                pub bindings_string: [u16; 9usize],
                pub bindToUntrustedContent_string: [u16; 23usize],
                pub black_string: [u16; 6usize],
                pub block_string: [u16; 6usize],
                pub block_size_string: [u16; 11usize],
                pub blocking_string: [u16; 9usize],
                pub blockquote_string: [u16; 11usize],
                pub blur_string: [u16; 5usize],
                pub body_string: [u16; 5usize],
                pub boolean_string: [u16; 8usize],
                pub border_string: [u16; 7usize],
                pub bordercolor_string: [u16; 12usize],
                pub both_string: [u16; 5usize],
                pub bottom_string: [u16; 7usize],
                pub bottomend_string: [u16; 10usize],
                pub bottomstart_string: [u16; 12usize],
                pub bottomleft_string: [u16; 11usize],
                pub bottommargin_string: [u16; 13usize],
                pub bottomright_string: [u16; 12usize],
                pub box_string: [u16; 4usize],
                pub br_string: [u16; 3usize],
                pub browser_string: [u16; 8usize],
                pub button_string: [u16; 7usize],
                pub callTemplate_string: [u16; 14usize],
                pub canvas_string: [u16; 7usize],
                pub caption_string: [u16; 8usize],
                pub captionBox_string: [u16; 12usize],
                pub capture_string: [u16; 8usize],
                pub caseOrder_string: [u16; 11usize],
                pub cdataSectionElements_string: [u16; 23usize],
                pub ceiling_string: [u16; 8usize],
                pub cell_string: [u16; 5usize],
                pub cellpadding_string: [u16; 12usize],
                pub cellspacing_string: [u16; 12usize],
                pub center_string: [u16; 7usize],
                pub change_string: [u16; 7usize],
                pub _char_string: [u16; 5usize],
                pub characterData_string: [u16; 14usize],
                pub charcode_string: [u16; 9usize],
                pub charoff_string: [u16; 8usize],
                pub charset_string: [u16; 8usize],
                pub checkbox_string: [u16; 9usize],
                pub checkboxLabel_string: [u16; 15usize],
                pub checked_string: [u16; 8usize],
                pub child_string: [u16; 6usize],
                pub children_string: [u16; 9usize],
                pub childList_string: [u16; 10usize],
                pub child_item_count_string: [u16; 17usize],
                pub choose_string: [u16; 7usize],
                pub customtitlebar_string: [u16; 15usize],
                pub exposeToUntrustedContent_string: [u16; 25usize],
                pub circ_string: [u16; 5usize],
                pub circle_string: [u16; 7usize],
                pub cite_string: [u16; 5usize],
                pub _class_string: [u16; 6usize],
                pub classid_string: [u16; 8usize],
                pub clear_string: [u16; 6usize],
                pub click_string: [u16; 6usize],
                pub clickcount_string: [u16; 11usize],
                pub movetoclick_string: [u16; 12usize],
                pub clip_string: [u16; 5usize],
                pub close_string: [u16; 6usize],
                pub closed_string: [u16; 7usize],
                pub closedby_string: [u16; 9usize],
                pub closemenu_string: [u16; 10usize],
                pub code_string: [u16; 5usize],
                pub codebase_string: [u16; 9usize],
                pub codetype_string: [u16; 9usize],
                pub col_string: [u16; 4usize],
                pub colgroup_string: [u16; 9usize],
                pub collapse_string: [u16; 9usize],
                pub collapsed_string: [u16; 10usize],
                pub color_string: [u16; 6usize],
                pub color_gamut_string: [u16; 12usize],
                pub color_index_string: [u16; 12usize],
                pub color_scheme_string: [u16; 13usize],
                pub cols_string: [u16; 5usize],
                pub colspan_string: [u16; 8usize],
                pub combobox_string: [u16; 9usize],
                pub command_string: [u16; 8usize],
                pub commandfor_string: [u16; 11usize],
                pub commandupdater_string: [u16; 15usize],
                pub comment_string: [u16; 8usize],
                pub compact_string: [u16; 8usize],
                pub concat_string: [u16; 7usize],
                pub constructor_string: [u16; 12usize],
                pub consumeoutsideclicks_string: [u16; 21usize],
                pub container_string: [u16; 10usize],
                pub contains_string: [u16; 9usize],
                pub content_string: [u16; 8usize],
                pub contenteditable_string: [u16; 16usize],
                pub headerContentDisposition_string: [u16; 20usize],
                pub headerContentLanguage_string: [u16; 17usize],
                pub contentLocation_string: [u16; 17usize],
                pub headerContentScriptType_string: [u16; 20usize],
                pub headerContentStyleType_string: [u16; 19usize],
                pub headerContentType_string: [u16; 13usize],
                pub consumeanchor_string: [u16; 14usize],
                pub context_string: [u16; 8usize],
                pub contextmenu_string: [u16; 12usize],
                pub control_string: [u16; 8usize],
                pub controls_string: [u16; 9usize],
                pub coords_string: [u16; 7usize],
                pub copy_string: [u16; 5usize],
                pub copyOf_string: [u16; 8usize],
                pub count_string: [u16; 6usize],
                pub crop_string: [u16; 5usize],
                pub crossorigin_string: [u16; 12usize],
                pub curpos_string: [u16; 7usize],
                pub current_string: [u16; 8usize],
                pub cutoutregion_string: [u16; 13usize],
                pub cycler_string: [u16; 7usize],
                pub dashed_string: [u16; 7usize],
                pub data_string: [u16; 5usize],
                pub dataAtShortcutkeys_string: [u16; 21usize],
                pub datalist_string: [u16; 9usize],
                pub datal10nid_string: [u16; 13usize],
                pub datal10nargs_string: [u16; 15usize],
                pub datal10nattrs_string: [u16; 16usize],
                pub datal10nname_string: [u16; 15usize],
                pub datal10nsync_string: [u16; 15usize],
                pub dataType_string: [u16; 10usize],
                pub dateTime_string: [u16; 10usize],
                pub date_string: [u16; 5usize],
                pub datetime_string: [u16; 9usize],
                pub datetime_local_string: [u16; 15usize],
                pub datetimeInputBoxWrapper_string: [u16; 27usize],
                pub dd_string: [u16; 3usize],
                pub decimal_string: [u16; 8usize],
                pub decimalFormat_string: [u16; 15usize],
                pub decimalSeparator_string: [u16; 18usize],
                pub declare_string: [u16; 8usize],
                pub decoderDoctor_string: [u16; 15usize],
                pub decoding_string: [u16; 9usize],
                pub decrement_string: [u16; 10usize],
                pub _default_string: [u16; 8usize],
                pub headerDefaultStyle_string: [u16; 14usize],
                pub defer_string: [u16; 6usize],
                pub del_string: [u16; 4usize],
                pub delegatesanchor_string: [u16; 16usize],
                pub deletion_string: [u16; 9usize],
                pub deprecation_string: [u16; 12usize],
                pub descendant_string: [u16; 11usize],
                pub descendantOrSelf_string: [u16; 19usize],
                pub descending_string: [u16; 11usize],
                pub description_string: [u16; 12usize],
                pub destructor_string: [u16; 11usize],
                pub details_string: [u16; 8usize],
                pub deviceAspectRatio_string: [u16; 20usize],
                pub deviceHeight_string: [u16; 14usize],
                pub devicePixelRatio_string: [u16; 19usize],
                pub deviceWidth_string: [u16; 13usize],
                pub dfn_string: [u16; 4usize],
                pub dialog_string: [u16; 7usize],
                pub difference_string: [u16; 11usize],
                pub digit_string: [u16; 6usize],
                pub dir_string: [u16; 4usize],
                pub directory_string: [u16; 10usize],
                pub dirname_string: [u16; 8usize],
                pub disableOutputEscaping_string: [u16; 24usize],
                pub disabled_string: [u16; 9usize],
                pub disableglobalhistory_string: [u16; 21usize],
                pub disablehistory_string: [u16; 15usize],
                pub disablefullscreen_string: [u16; 18usize],
                pub disablepictureinpicture_string: [u16; 24usize],
                pub disclosure_closed_string: [u16; 18usize],
                pub disclosure_open_string: [u16; 16usize],
                pub display_string: [u16; 8usize],
                pub displayMode_string: [u16; 13usize],
                pub distinct_string: [u16; 9usize],
                pub div_string: [u16; 4usize],
                pub dl_string: [u16; 3usize],
                pub docAbstract_string: [u16; 13usize],
                pub docAcknowledgments_string: [u16; 20usize],
                pub docAfterword_string: [u16; 14usize],
                pub docAppendix_string: [u16; 13usize],
                pub docBacklink_string: [u16; 13usize],
                pub docBiblioentry_string: [u16; 16usize],
                pub docBibliography_string: [u16; 17usize],
                pub docBiblioref_string: [u16; 14usize],
                pub docChapter_string: [u16; 12usize],
                pub docColophon_string: [u16; 13usize],
                pub docConclusion_string: [u16; 15usize],
                pub docCover_string: [u16; 10usize],
                pub docCredit_string: [u16; 11usize],
                pub docCredits_string: [u16; 12usize],
                pub docDedication_string: [u16; 15usize],
                pub docEndnote_string: [u16; 12usize],
                pub docEndnotes_string: [u16; 13usize],
                pub docEpigraph_string: [u16; 13usize],
                pub docEpilogue_string: [u16; 13usize],
                pub docErrata_string: [u16; 11usize],
                pub docExample_string: [u16; 12usize],
                pub docFootnote_string: [u16; 13usize],
                pub docForeword_string: [u16; 13usize],
                pub docGlossary_string: [u16; 13usize],
                pub docGlossref_string: [u16; 13usize],
                pub docIndex_string: [u16; 10usize],
                pub docIntroduction_string: [u16; 17usize],
                pub docNoteref_string: [u16; 12usize],
                pub docNotice_string: [u16; 11usize],
                pub docPagebreak_string: [u16; 14usize],
                pub docPagefooter_string: [u16; 15usize],
                pub docPageheader_string: [u16; 15usize],
                pub docPagelist_string: [u16; 13usize],
                pub docPart_string: [u16; 9usize],
                pub docPreface_string: [u16; 12usize],
                pub docPrologue_string: [u16; 13usize],
                pub docPullquote_string: [u16; 14usize],
                pub docQna_string: [u16; 8usize],
                pub docSubtitle_string: [u16; 13usize],
                pub docTip_string: [u16; 8usize],
                pub docToc_string: [u16; 8usize],
                pub doctypePublic_string: [u16; 15usize],
                pub doctypeSystem_string: [u16; 15usize],
                pub document_string: [u16; 9usize],
                pub down_string: [u16; 5usize],
                pub download_string: [u16; 9usize],
                pub drag_string: [u16; 5usize],
                pub draggable_string: [u16; 10usize],
                pub dragging_string: [u16; 9usize],
                pub dragSession_string: [u16; 12usize],
                pub drawtitle_string: [u16; 10usize],
                pub dropAfter_string: [u16; 10usize],
                pub dropBefore_string: [u16; 11usize],
                pub dropOn_string: [u16; 7usize],
                pub dropMarker_string: [u16; 11usize],
                pub dt_string: [u16; 3usize],
                pub e_string: [u16; 2usize],
                pub editable_string: [u16; 9usize],
                pub editing_string: [u16; 8usize],
                pub editor_string: [u16; 7usize],
                pub element_string: [u16; 8usize],
                pub elementAvailable_string: [u16; 18usize],
                pub elements_string: [u16; 9usize],
                pub em_string: [u16; 3usize],
                pub embed_string: [u16; 6usize],
                pub emphasis_string: [u16; 9usize],
                pub empty_string: [u16; 6usize],
                pub encoding_string: [u16; 9usize],
                pub enctype_string: [u16; 8usize],
                pub end_string: [u16; 4usize],
                pub endEvent_string: [u16; 9usize],
                pub enterkeyhint_string: [u16; 13usize],
                pub error_string: [u16; 6usize],
                pub ethiopic_numeric_string: [u16; 17usize],
                pub even_string: [u16; 5usize],
                pub event_string: [u16; 6usize],
                pub events_string: [u16; 7usize],
                pub excludeResultPrefixes_string: [u16; 24usize],
                pub exportparts_string: [u16; 12usize],
                pub explicit_name_string: [u16; 14usize],
                pub extends_string: [u16; 8usize],
                pub extensionElementPrefixes_string: [u16; 27usize],
                pub face_string: [u16; 5usize],
                pub fallback_string: [u16; 9usize],
                pub _false_string: [u16; 6usize],
                pub farthest_string: [u16; 9usize],
                pub featurePolicyViolation_string: [u16; 25usize],
                pub fetchpriority_string: [u16; 14usize],
                pub field_string: [u16; 6usize],
                pub fieldset_string: [u16; 9usize],
                pub file_string: [u16; 5usize],
                pub figcaption_string: [u16; 11usize],
                pub figure_string: [u16; 7usize],
                pub findbar_string: [u16; 8usize],
                pub firstColumn_string: [u16; 13usize],
                pub firstInput_string: [u16; 12usize],
                pub fixed_string: [u16; 6usize],
                pub flags_string: [u16; 6usize],
                pub flex_string: [u16; 5usize],
                pub flip_string: [u16; 5usize],
                pub floor_string: [u16; 6usize],
                pub flowlength_string: [u16; 11usize],
                pub focus_string: [u16; 6usize],
                pub focused_string: [u16; 8usize],
                pub followanchor_string: [u16; 13usize],
                pub following_string: [u16; 10usize],
                pub followingSibling_string: [u16; 18usize],
                pub font_string: [u16; 5usize],
                pub footer_string: [u16; 7usize],
                pub _for_string: [u16; 4usize],
                pub forEach_string: [u16; 9usize],
                pub forcedColors_string: [u16; 14usize],
                pub invertedColors_string: [u16; 16usize],
                pub forceOwnRefreshDriver_string: [u16; 22usize],
                pub form_string: [u16; 5usize],
                pub formaction_string: [u16; 11usize],
                pub format_string: [u16; 7usize],
                pub formatNumber_string: [u16; 14usize],
                pub formenctype_string: [u16; 12usize],
                pub formmethod_string: [u16; 11usize],
                pub formnovalidate_string: [u16; 15usize],
                pub formtarget_string: [u16; 11usize],
                pub frame_string: [u16; 6usize],
                pub frameborder_string: [u16; 12usize],
                pub frameset_string: [u16; 9usize],
                pub from_string: [u16; 5usize],
                pub fullscreenchange_string: [u16; 17usize],
                pub fullscreenerror_string: [u16; 16usize],
                pub functionAvailable_string: [u16; 19usize],
                pub generateId_string: [u16; 12usize],
                pub generic_string: [u16; 8usize],
                pub getter_string: [u16; 7usize],
                pub graphicsDocument_string: [u16; 18usize],
                pub graphicsObject_string: [u16; 16usize],
                pub graphicsSymbol_string: [u16; 16usize],
                pub grid_string: [u16; 5usize],
                pub group_string: [u16; 6usize],
                pub groups_string: [u16; 7usize],
                pub groupbox_string: [u16; 9usize],
                pub groupingSeparator_string: [u16; 19usize],
                pub groupingSize_string: [u16; 14usize],
                pub grow_string: [u16; 5usize],
                pub h1_string: [u16; 3usize],
                pub h2_string: [u16; 3usize],
                pub h3_string: [u16; 3usize],
                pub h4_string: [u16; 3usize],
                pub h5_string: [u16; 3usize],
                pub h6_string: [u16; 3usize],
                pub hairline_string: [u16; 9usize],
                pub handheldFriendly_string: [u16; 17usize],
                pub handler_string: [u16; 8usize],
                pub handlers_string: [u16; 9usize],
                pub HARD_string: [u16; 5usize],
                pub hasSameNode_string: [u16; 14usize],
                pub hbox_string: [u16; 5usize],
                pub head_string: [u16; 5usize],
                pub header_string: [u16; 7usize],
                pub headers_string: [u16; 8usize],
                pub hebrew_string: [u16; 7usize],
                pub height_string: [u16; 7usize],
                pub hgroup_string: [u16; 7usize],
                pub hidden_string: [u16; 7usize],
                pub hidechrome_string: [u16; 11usize],
                pub hidecolumnpicker_string: [u16; 17usize],
                pub hide_popover_string: [u16; 13usize],
                pub high_string: [u16; 5usize],
                pub highest_string: [u16; 8usize],
                pub horizontal_string: [u16; 11usize],
                pub hover_string: [u16; 6usize],
                pub hr_string: [u16; 3usize],
                pub href_string: [u16; 5usize],
                pub hreflang_string: [u16; 9usize],
                pub hsides_string: [u16; 7usize],
                pub hspace_string: [u16; 7usize],
                pub html_string: [u16; 5usize],
                pub httpEquiv_string: [u16; 11usize],
                pub i_string: [u16; 2usize],
                pub icon_string: [u16; 5usize],
                pub id_string: [u16; 3usize],
                pub _if_string: [u16; 3usize],
                pub iframe_string: [u16; 7usize],
                pub ignorekeys_string: [u16; 11usize],
                pub ignoreuserfocus_string: [u16; 16usize],
                pub image_string: [u16; 6usize],
                pub imageClickedPoint_string: [u16; 20usize],
                pub imagesizes_string: [u16; 11usize],
                pub imagesrcset_string: [u16; 12usize],
                pub img_string: [u16; 4usize],
                pub implementation_string: [u16; 15usize],
                pub implements_string: [u16; 11usize],
                pub import_string: [u16; 7usize],
                pub include_string: [u16; 8usize],
                pub includes_string: [u16; 9usize],
                pub incontentshell_string: [u16; 15usize],
                pub increment_string: [u16; 10usize],
                pub indent_string: [u16; 7usize],
                pub indeterminate_string: [u16; 14usize],
                pub index_string: [u16; 6usize],
                pub inert_string: [u16; 6usize],
                pub innerHTML_string: [u16; 10usize],
                pub innerText_string: [u16; 10usize],
                pub infinity_string: [u16; 9usize],
                pub inherits_string: [u16; 9usize],
                pub inheritOverflow_string: [u16; 17usize],
                pub inheritstyle_string: [u16; 13usize],
                pub initial_scale_string: [u16; 14usize],
                pub input_string: [u16; 6usize],
                pub inputmode_string: [u16; 10usize],
                pub ins_string: [u16; 4usize],
                pub insertafter_string: [u16; 12usize],
                pub insertbefore_string: [u16; 13usize],
                pub insertion_string: [u16; 10usize],
                pub integer_string: [u16; 8usize],
                pub integrity_string: [u16; 10usize],
                pub interactive_widget_string: [u16; 19usize],
                pub internal_string: [u16; 9usize],
                pub internals_string: [u16; 10usize],
                pub intersection_string: [u16; 13usize],
                pub is_string: [u16; 3usize],
                pub ismap_string: [u16; 6usize],
                pub ispopup_string: [u16; 8usize],
                pub itemid_string: [u16; 7usize],
                pub itemprop_string: [u16; 9usize],
                pub itemref_string: [u16; 8usize],
                pub itemscope_string: [u16; 10usize],
                pub itemtype_string: [u16; 9usize],
                pub japanese_formal_string: [u16; 16usize],
                pub japanese_informal_string: [u16; 18usize],
                pub kbd_string: [u16; 4usize],
                pub keepcurrentinview_string: [u16; 18usize],
                pub key_string: [u16; 4usize],
                pub keycode_string: [u16; 8usize],
                pub keydown_string: [u16; 8usize],
                pub keygen_string: [u16; 7usize],
                pub keypress_string: [u16; 9usize],
                pub keyset_string: [u16; 7usize],
                pub keysystem_string: [u16; 10usize],
                pub keyup_string: [u16; 6usize],
                pub kind_string: [u16; 5usize],
                pub korean_hangul_formal_string: [u16; 21usize],
                pub korean_hanja_formal_string: [u16; 20usize],
                pub korean_hanja_informal_string: [u16; 22usize],
                pub label_string: [u16; 6usize],
                pub lang_string: [u16; 5usize],
                pub language_string: [u16; 9usize],
                pub last_string: [u16; 5usize],
                pub layer_string: [u16; 6usize],
                pub LayerActivity_string: [u16; 14usize],
                pub layout_guess_string: [u16; 13usize],
                pub leading_string: [u16; 8usize],
                pub leaf_string: [u16; 5usize],
                pub left_string: [u16; 5usize],
                pub leftmargin_string: [u16; 11usize],
                pub legend_string: [u16; 7usize],
                pub length_string: [u16; 7usize],
                pub letterValue_string: [u16; 13usize],
                pub level_string: [u16; 6usize],
                pub lhs_string: [u16; 4usize],
                pub li_string: [u16; 3usize],
                pub line_string: [u16; 5usize],
                pub link_string: [u16; 5usize],
                pub linkset_string: [u16; 8usize],
                pub listbox_string: [u16; 8usize],
                pub listener_string: [u16; 9usize],
                pub listheader_string: [u16; 11usize],
                pub listing_string: [u16; 8usize],
                pub listitem_string: [u16; 9usize],
                pub load_string: [u16; 5usize],
                pub loading_string: [u16; 8usize],
                pub touchmode_string: [u16; 10usize],
                pub triggeringprincipal_string: [u16; 20usize],
                pub localedir_string: [u16; 10usize],
                pub localName_string: [u16; 11usize],
                pub localization_string: [u16; 13usize],
                pub longdesc_string: [u16; 9usize],
                pub loop_string: [u16; 5usize],
                pub low_string: [u16; 4usize],
                pub lowerFirst_string: [u16; 12usize],
                pub lowest_string: [u16; 7usize],
                pub lowsrc_string: [u16; 7usize],
                pub ltr_string: [u16; 4usize],
                pub main_string: [u16; 5usize],
                pub map_string: [u16; 4usize],
                pub manifest_string: [u16; 9usize],
                pub marginBottom_string: [u16; 14usize],
                pub marginLeft_string: [u16; 12usize],
                pub marginRight_string: [u16; 13usize],
                pub marginTop_string: [u16; 11usize],
                pub marginheight_string: [u16; 13usize],
                pub marginwidth_string: [u16; 12usize],
                pub mark_string: [u16; 5usize],
                pub marquee_string: [u16; 8usize],
                pub match_string: [u16; 6usize],
                pub max_string: [u16; 4usize],
                pub maxheight_string: [u16; 10usize],
                pub maximum_scale_string: [u16; 14usize],
                pub maxlength_string: [u16; 10usize],
                pub maxpos_string: [u16; 7usize],
                pub maxwidth_string: [u16; 9usize],
                pub measure_string: [u16; 8usize],
                pub media_string: [u16; 6usize],
                pub mediaType_string: [u16; 11usize],
                pub menu_string: [u16; 5usize],
                pub menubar_string: [u16; 8usize],
                pub menucaption_string: [u16; 12usize],
                pub menugroup_string: [u16; 10usize],
                pub menuitem_string: [u16; 9usize],
                pub menulist_string: [u16; 9usize],
                pub menupopup_string: [u16; 10usize],
                pub menuseparator_string: [u16; 14usize],
                pub mesh_string: [u16; 5usize],
                pub message_string: [u16; 8usize],
                pub meta_string: [u16; 5usize],
                pub referrer_string: [u16; 9usize],
                pub referrerpolicy_string: [u16; 15usize],
                pub renderroot_string: [u16; 11usize],
                pub headerReferrerPolicy_string: [u16; 16usize],
                pub meter_string: [u16; 6usize],
                pub method_string: [u16; 7usize],
                pub middle_string: [u16; 7usize],
                pub min_string: [u16; 4usize],
                pub minheight_string: [u16; 10usize],
                pub minimum_scale_string: [u16; 14usize],
                pub minlength_string: [u16; 10usize],
                pub minpos_string: [u16; 7usize],
                pub minusSign_string: [u16; 11usize],
                pub minwidth_string: [u16; 9usize],
                pub mixed_string: [u16; 6usize],
                pub messagemanagergroup_string: [u16; 20usize],
                pub mod_string: [u16; 4usize],
                pub _module_string: [u16; 7usize],
                pub mode_string: [u16; 5usize],
                pub modifiers_string: [u16; 10usize],
                pub monochrome_string: [u16; 11usize],
                pub mouseover_string: [u16; 10usize],
                pub mozAccessiblecaret_string: [u16; 20usize],
                pub mozCustomContentContainer_string: [u16; 29usize],
                pub mozGrabber_string: [u16; 11usize],
                pub mozNativeAnonymous_string: [u16; 22usize],
                pub mozprivatebrowsing_string: [u16; 19usize],
                pub mozResizer_string: [u16; 11usize],
                pub mozResizingInfo_string: [u16; 16usize],
                pub mozResizingShadow_string: [u16; 18usize],
                pub mozTableAddColumnAfter_string: [u16; 23usize],
                pub mozTableAddColumnBefore_string: [u16; 24usize],
                pub mozTableAddRowAfter_string: [u16; 20usize],
                pub mozTableAddRowBefore_string: [u16; 21usize],
                pub mozTableRemoveRow_string: [u16; 18usize],
                pub mozTableRemoveColumn_string: [u16; 21usize],
                pub moz_opaque_string: [u16; 11usize],
                pub multicol_string: [u16; 9usize],
                pub multiple_string: [u16; 9usize],
                pub muted_string: [u16; 6usize],
                pub name_string: [u16; 5usize],
                pub native_string: [u16; 7usize],
                pub _namespace_string: [u16; 10usize],
                pub namespaceAlias_string: [u16; 16usize],
                pub namespaceUri_string: [u16; 14usize],
                pub NaN_string: [u16; 4usize],
                pub n_string: [u16; 2usize],
                pub nav_string: [u16; 4usize],
                pub ne_string: [u16; 3usize],
                pub never_string: [u16; 6usize],
                pub neverhidden_string: [u16; 12usize],
                pub _new_string: [u16; 4usize],
                pub newline_string: [u16; 8usize],
                pub nextRemoteTabId_string: [u16; 16usize],
                pub no_string: [u16; 3usize],
                pub noautofocus_string: [u16; 12usize],
                pub noautohide_string: [u16; 11usize],
                pub norolluponanchor_string: [u16; 17usize],
                pub noBar_string: [u16; 7usize],
                pub nobr_string: [u16; 5usize],
                pub nodefaultsrc_string: [u16; 13usize],
                pub nodeSet_string: [u16; 9usize],
                pub noembed_string: [u16; 8usize],
                pub noframes_string: [u16; 9usize],
                pub nohref_string: [u16; 7usize],
                pub noinitialselection_string: [u16; 19usize],
                pub nomodule_string: [u16; 9usize],
                pub nonce_string: [u16; 6usize],
                pub none_string: [u16; 5usize],
                pub noresize_string: [u16; 9usize],
                pub normal_string: [u16; 7usize],
                pub normalizeSpace_string: [u16; 16usize],
                pub noscript_string: [u16; 9usize],
                pub noshade_string: [u16; 8usize],
                pub notification_string: [u16; 13usize],
                pub novalidate_string: [u16; 11usize],
                pub _not_string: [u16; 4usize],
                pub nowrap_string: [u16; 7usize],
                pub number_string: [u16; 7usize],
                pub nw_string: [u16; 3usize],
                pub object_string: [u16; 7usize],
                pub objectType_string: [u16; 12usize],
                pub observes_string: [u16; 9usize],
                pub odd_string: [u16; 4usize],
                pub OFF_string: [u16; 4usize],
                pub ol_string: [u16; 3usize],
                pub omitXmlDeclaration_string: [u16; 21usize],
                pub onabort_string: [u16; 8usize],
                pub onmozaccesskeynotfound_string: [u16; 23usize],
                pub onactivate_string: [u16; 11usize],
                pub onafterprint_string: [u16; 13usize],
                pub onafterscriptexecute_string: [u16; 21usize],
                pub onanimationcancel_string: [u16; 18usize],
                pub onanimationend_string: [u16; 15usize],
                pub onanimationiteration_string: [u16; 21usize],
                pub onanimationstart_string: [u16; 17usize],
                pub onAppCommand_string: [u16; 13usize],
                pub onaudioprocess_string: [u16; 15usize],
                pub onauxclick_string: [u16; 11usize],
                pub onbeforecopy_string: [u16; 13usize],
                pub onbeforecut_string: [u16; 12usize],
                pub onbeforeinput_string: [u16; 14usize],
                pub onbeforematch_string: [u16; 14usize],
                pub onbeforepaste_string: [u16; 14usize],
                pub onbeforeprint_string: [u16; 14usize],
                pub onbeforescriptexecute_string: [u16; 22usize],
                pub onbeforeunload_string: [u16; 15usize],
                pub onblocked_string: [u16; 10usize],
                pub onblur_string: [u16; 7usize],
                pub onboundschange_string: [u16; 15usize],
                pub onbroadcast_string: [u16; 12usize],
                pub onbufferedamountlow_string: [u16; 20usize],
                pub oncached_string: [u16; 9usize],
                pub oncancel_string: [u16; 9usize],
                pub onchange_string: [u16; 9usize],
                pub onchargingchange_string: [u16; 17usize],
                pub onchargingtimechange_string: [u16; 21usize],
                pub onchecking_string: [u16; 11usize],
                pub onCheckboxStateChange_string: [u16; 22usize],
                pub onCheckKeyPressEventModel_string: [u16; 26usize],
                pub onclick_string: [u16; 8usize],
                pub onclose_string: [u16; 8usize],
                pub oncontentvisibilityautostatechange_string: [u16; 35usize],
                pub oncommand_string: [u16; 10usize],
                pub oncommandupdate_string: [u16; 16usize],
                pub oncomplete_string: [u16; 11usize],
                pub oncompositionend_string: [u16; 17usize],
                pub oncompositionstart_string: [u16; 19usize],
                pub oncompositionupdate_string: [u16; 20usize],
                pub onconnect_string: [u16; 10usize],
                pub onconnectionavailable_string: [u16; 22usize],
                pub oncontextmenu_string: [u16; 14usize],
                pub oncontextlost_string: [u16; 14usize],
                pub oncontextrestored_string: [u16; 18usize],
                pub oncookiechange_string: [u16; 15usize],
                pub oncopy_string: [u16; 7usize],
                pub oncut_string: [u16; 6usize],
                pub oncurrententrychange_string: [u16; 21usize],
                pub ondblclick_string: [u16; 11usize],
                pub ondischargingtimechange_string: [u16; 24usize],
                pub ondispose_string: [u16; 10usize],
                pub ondownloading_string: [u16; 14usize],
                pub onDOMActivate_string: [u16; 14usize],
                pub onDOMAttrModified_string: [u16; 18usize],
                pub onDOMCharacterDataModified_string: [u16; 27usize],
                pub onDOMFocusIn_string: [u16; 13usize],
                pub onDOMFocusOut_string: [u16; 14usize],
                pub onDOMMouseScroll_string: [u16; 17usize],
                pub onDOMNodeInserted_string: [u16; 18usize],
                pub onDOMNodeInsertedIntoDocument_string: [u16; 30usize],
                pub onDOMNodeRemoved_string: [u16; 17usize],
                pub onDOMNodeRemovedFromDocument_string: [u16; 29usize],
                pub onDOMSubtreeModified_string: [u16; 21usize],
                pub ondata_string: [u16; 7usize],
                pub ondrag_string: [u16; 7usize],
                pub ondragdrop_string: [u16; 11usize],
                pub ondragend_string: [u16; 10usize],
                pub ondragenter_string: [u16; 12usize],
                pub ondragexit_string: [u16; 11usize],
                pub ondragleave_string: [u16; 12usize],
                pub ondragover_string: [u16; 11usize],
                pub ondragstart_string: [u16; 12usize],
                pub ondrain_string: [u16; 8usize],
                pub ondrop_string: [u16; 7usize],
                pub onerror_string: [u16; 8usize],
                pub onfinish_string: [u16; 9usize],
                pub onfocus_string: [u16; 8usize],
                pub onfocusin_string: [u16; 10usize],
                pub onfocusout_string: [u16; 11usize],
                pub onfullscreenchange_string: [u16; 19usize],
                pub onfullscreenerror_string: [u16; 18usize],
                pub ongatheringstatechange_string: [u16; 23usize],
                pub onget_string: [u16; 6usize],
                pub onhashchange_string: [u16; 13usize],
                pub oninput_string: [u16; 8usize],
                pub oninputsourceschange_string: [u16; 21usize],
                pub oninstall_string: [u16; 10usize],
                pub oninvalid_string: [u16; 10usize],
                pub onkeydown_string: [u16; 10usize],
                pub onkeypress_string: [u16; 11usize],
                pub onkeyup_string: [u16; 8usize],
                pub onlanguagechange_string: [u16; 17usize],
                pub onlevelchange_string: [u16; 14usize],
                pub onload_string: [u16; 7usize],
                pub onloading_string: [u16; 10usize],
                pub onloadingdone_string: [u16; 14usize],
                pub onloadingerror_string: [u16; 15usize],
                pub onpopstate_string: [u16; 11usize],
                pub only_string: [u16; 5usize],
                pub onmerchantvalidation_string: [u16; 21usize],
                pub onmessage_string: [u16; 10usize],
                pub onmessageerror_string: [u16; 15usize],
                pub onmidimessage_string: [u16; 14usize],
                pub onmousedown_string: [u16; 12usize],
                pub onmouseenter_string: [u16; 13usize],
                pub onmouseleave_string: [u16; 13usize],
                pub onmouselongtap_string: [u16; 15usize],
                pub onmousemove_string: [u16; 12usize],
                pub onmouseout_string: [u16; 11usize],
                pub onmouseover_string: [u16; 12usize],
                pub onMozMouseHittest_string: [u16; 18usize],
                pub onMozMouseExploreByTouch_string: [u16; 25usize],
                pub onmouseup_string: [u16; 10usize],
                pub onMozAfterPaint_string: [u16; 16usize],
                pub onmozfullscreenchange_string: [u16; 22usize],
                pub onmozfullscreenerror_string: [u16; 21usize],
                pub onmozpointerlockchange_string: [u16; 23usize],
                pub onmozpointerlockerror_string: [u16; 22usize],
                pub onMozMousePixelScroll_string: [u16; 22usize],
                pub onMozScrolledAreaChanged_string: [u16; 25usize],
                pub onmute_string: [u16; 7usize],
                pub onnavigate_string: [u16; 11usize],
                pub onnavigatesuccess_string: [u16; 18usize],
                pub onnavigateerror_string: [u16; 16usize],
                pub onnotificationclick_string: [u16; 20usize],
                pub onnotificationclose_string: [u16; 20usize],
                pub onnoupdate_string: [u16; 11usize],
                pub onobsolete_string: [u16; 11usize],
                pub ononline_string: [u16; 9usize],
                pub onoffline_string: [u16; 10usize],
                pub onopen_string: [u16; 7usize],
                pub onorientationchange_string: [u16; 20usize],
                pub onoverflow_string: [u16; 11usize],
                pub onpagehide_string: [u16; 11usize],
                pub onpageshow_string: [u16; 11usize],
                pub onpaste_string: [u16; 8usize],
                pub onpayerdetailchange_string: [u16; 20usize],
                pub onpaymentmethodchange_string: [u16; 22usize],
                pub onpointerlockchange_string: [u16; 20usize],
                pub onpointerlockerror_string: [u16; 19usize],
                pub onpopuphidden_string: [u16; 14usize],
                pub onpopuphiding_string: [u16; 14usize],
                pub onpopuppositioned_string: [u16; 18usize],
                pub onpopupshowing_string: [u16; 15usize],
                pub onpopupshown_string: [u16; 13usize],
                pub onprocessorerror_string: [u16; 17usize],
                pub onprioritychange_string: [u16; 17usize],
                pub onpush_string: [u16; 7usize],
                pub onpushsubscriptionchange_string: [u16; 25usize],
                pub onRadioStateChange_string: [u16; 19usize],
                pub onreadystatechange_string: [u16; 19usize],
                pub onrejectionhandled_string: [u16; 19usize],
                pub onremove_string: [u16; 9usize],
                pub onrequestprogress_string: [u16; 18usize],
                pub onresourcetimingbufferfull_string: [u16; 27usize],
                pub onresponseprogress_string: [u16; 19usize],
                pub onRequest_string: [u16; 10usize],
                pub onreset_string: [u16; 8usize],
                pub onresize_string: [u16; 9usize],
                pub onscroll_string: [u16; 9usize],
                pub onsecuritypolicyviolation_string: [u16; 26usize],
                pub onselect_string: [u16; 9usize],
                pub onselectionchange_string: [u16; 18usize],
                pub onselectend_string: [u16; 12usize],
                pub onselectstart_string: [u16; 14usize],
                pub onset_string: [u16; 6usize],
                pub onshippingaddresschange_string: [u16; 24usize],
                pub onshippingoptionchange_string: [u16; 23usize],
                pub onshow_string: [u16; 7usize],
                pub onslotchange_string: [u16; 13usize],
                pub onsqueeze_string: [u16; 10usize],
                pub onsqueezeend_string: [u16; 13usize],
                pub onsqueezestart_string: [u16; 15usize],
                pub onstatechange_string: [u16; 14usize],
                pub onstorage_string: [u16; 10usize],
                pub onsubmit_string: [u16; 9usize],
                pub onsuccess_string: [u16; 10usize],
                pub onsystemstatusbarclick_string: [u16; 23usize],
                pub ontypechange_string: [u16; 13usize],
                pub onterminate_string: [u16; 12usize],
                pub ontext_string: [u16; 7usize],
                pub ontextInput_string: [u16; 12usize],
                pub ontoggle_string: [u16; 9usize],
                pub ontonechange_string: [u16; 13usize],
                pub ontouchstart_string: [u16; 13usize],
                pub ontouchend_string: [u16; 11usize],
                pub ontouchmove_string: [u16; 12usize],
                pub ontouchcancel_string: [u16; 14usize],
                pub ontransitioncancel_string: [u16; 19usize],
                pub ontransitionend_string: [u16; 16usize],
                pub ontransitionrun_string: [u16; 16usize],
                pub ontransitionstart_string: [u16; 18usize],
                pub onuncapturederror_string: [u16; 18usize],
                pub onunderflow_string: [u16; 12usize],
                pub onunhandledrejection_string: [u16; 21usize],
                pub onunload_string: [u16; 9usize],
                pub onunmute_string: [u16; 9usize],
                pub onupdatefound_string: [u16; 14usize],
                pub onupdateready_string: [u16; 14usize],
                pub onupgradeneeded_string: [u16; 16usize],
                pub onversionchange_string: [u16; 16usize],
                pub onvisibilitychange_string: [u16; 19usize],
                pub onvoiceschanged_string: [u16; 16usize],
                pub onvrdisplayactivate_string: [u16; 20usize],
                pub onvrdisplayconnect_string: [u16; 19usize],
                pub onvrdisplaydeactivate_string: [u16; 22usize],
                pub onvrdisplaydisconnect_string: [u16; 22usize],
                pub onvrdisplaypresentchange_string: [u16; 25usize],
                pub onwebkitAnimationEnd_string: [u16; 21usize],
                pub onwebkitAnimationIteration_string: [u16; 27usize],
                pub onwebkitAnimationStart_string: [u16; 23usize],
                pub onwebkitTransitionEnd_string: [u16; 22usize],
                pub onwebkitanimationend_string: [u16; 21usize],
                pub onwebkitanimationiteration_string: [u16; 27usize],
                pub onwebkitanimationstart_string: [u16; 23usize],
                pub onwebkittransitionend_string: [u16; 22usize],
                pub onwheel_string: [u16; 8usize],
                pub open_string: [u16; 5usize],
                pub optgroup_string: [u16; 9usize],
                pub optimum_string: [u16; 8usize],
                pub option_string: [u16; 7usize],
                pub _or_string: [u16; 3usize],
                pub order_string: [u16; 6usize],
                pub ordinal_string: [u16; 8usize],
                pub orient_string: [u16; 7usize],
                pub orientation_string: [u16; 12usize],
                pub origin_trial_string: [u16; 13usize],
                pub otherwise_string: [u16; 10usize],
                pub outerHTML_string: [u16; 10usize],
                pub output_string: [u16; 7usize],
                pub overflow_string: [u16; 9usize],
                pub overflowBlock_string: [u16; 15usize],
                pub overflowInline_string: [u16; 16usize],
                pub overlay_string: [u16; 8usize],
                pub p_string: [u16; 2usize],
                pub pack_string: [u16; 5usize],
                pub page_string: [u16; 5usize],
                pub pageincrement_string: [u16; 14usize],
                pub paint_string: [u16; 6usize],
                pub paint_order_string: [u16; 12usize],
                pub panel_string: [u16; 6usize],
                pub paragraph_string: [u16; 10usize],
                pub param_string: [u16; 6usize],
                pub parameter_string: [u16; 10usize],
                pub parent_string: [u16; 7usize],
                pub parsererror_string: [u16; 12usize],
                pub part_string: [u16; 5usize],
                pub password_string: [u16; 9usize],
                pub pattern_string: [u16; 8usize],
                pub patternSeparator_string: [u16; 18usize],
                pub perMille_string: [u16; 10usize],
                pub percent_string: [u16; 8usize],
                pub persist_string: [u16; 8usize],
                pub phase_string: [u16; 6usize],
                pub picture_string: [u16; 8usize],
                pub ping_string: [u16; 5usize],
                pub pinned_string: [u16; 7usize],
                pub placeholder_string: [u16; 12usize],
                pub plaintext_string: [u16; 10usize],
                pub plaintextOnly_string: [u16; 15usize],
                pub playbackrate_string: [u16; 13usize],
                pub pointSize_string: [u16; 11usize],
                pub poly_string: [u16; 5usize],
                pub polygon_string: [u16; 8usize],
                pub popover_string: [u16; 8usize],
                pub popovertarget_string: [u16; 14usize],
                pub popovertargetaction_string: [u16; 20usize],
                pub popup_string: [u16; 6usize],
                pub popupalign_string: [u16; 11usize],
                pub popupanchor_string: [u16; 12usize],
                pub popupgroup_string: [u16; 11usize],
                pub popupset_string: [u16; 9usize],
                pub popupsinherittooltip_string: [u16; 21usize],
                pub portal_string: [u16; 7usize],
                pub position_string: [u16; 9usize],
                pub poster_string: [u16; 7usize],
                pub pre_string: [u16; 4usize],
                pub preceding_string: [u16; 10usize],
                pub precedingSibling_string: [u16; 18usize],
                pub prefersReducedMotion_string: [u16; 23usize],
                pub prefersReducedTransparency_string: [u16; 29usize],
                pub prefersColorScheme_string: [u16; 21usize],
                pub prefersContrast_string: [u16; 17usize],
                pub prefix_string: [u16; 7usize],
                pub prefwidth_string: [u16; 10usize],
                pub queue_string: [u16; 6usize],
                pub dynamicRange_string: [u16; 14usize],
                pub videoDynamicRange_string: [u16; 20usize],
                pub scripting_string: [u16; 10usize],
                pub preload_string: [u16; 8usize],
                pub preserve_string: [u16; 9usize],
                pub preserveSpace_string: [u16; 15usize],
                pub preventdefault_string: [u16; 15usize],
                pub previewDiv_string: [u16; 12usize],
                pub primary_string: [u16; 8usize],
                pub print_string: [u16; 6usize],
                pub printisfocuseddoc_string: [u16; 18usize],
                pub printselectionranges_string: [u16; 21usize],
                pub priority_string: [u16; 9usize],
                pub processingInstruction_string: [u16; 23usize],
                pub profile_string: [u16; 8usize],
                pub progress_string: [u16; 9usize],
                pub prompt_string: [u16; 7usize],
                pub properties_string: [u16; 11usize],
                pub property_string: [u16; 9usize],
                pub pubdate_string: [u16; 8usize],
                pub q_string: [u16; 2usize],
                pub radio_string: [u16; 6usize],
                pub radioLabel_string: [u16; 12usize],
                pub radiogroup_string: [u16; 11usize],
                pub range_string: [u16; 6usize],
                pub readonly_string: [u16; 9usize],
                pub rect_string: [u16; 5usize],
                pub rectangle_string: [u16; 10usize],
                pub refresh_string: [u16; 8usize],
                pub rel_string: [u16; 4usize],
                pub relativeBounds_string: [u16; 16usize],
                pub rem_string: [u16; 4usize],
                pub remote_string: [u16; 7usize],
                pub removeelement_string: [u16; 14usize],
                pub render_string: [u16; 7usize],
                pub renderingobserverset_string: [u16; 21usize],
                pub repeat_string: [u16; 7usize],
                pub replace_string: [u16; 8usize],
                pub requestcontextid_string: [u16; 17usize],
                pub required_string: [u16; 9usize],
                pub reserved_string: [u16; 9usize],
                pub reset_string: [u16; 6usize],
                pub resizeafter_string: [u16; 12usize],
                pub resizebefore_string: [u16; 13usize],
                pub resizer_string: [u16; 8usize],
                pub resolution_string: [u16; 11usize],
                pub resources_string: [u16; 10usize],
                pub result_string: [u16; 7usize],
                pub resultPrefix_string: [u16; 14usize],
                pub retargetdocumentfocus_string: [u16; 22usize],
                pub rev_string: [u16; 4usize],
                pub reverse_string: [u16; 8usize],
                pub reversed_string: [u16; 9usize],
                pub rhs_string: [u16; 4usize],
                pub richlistbox_string: [u16; 12usize],
                pub richlistitem_string: [u16; 13usize],
                pub right_string: [u16; 6usize],
                pub rightmargin_string: [u16; 12usize],
                pub role_string: [u16; 5usize],
                pub rolluponmousewheel_string: [u16; 19usize],
                pub round_string: [u16; 6usize],
                pub row_string: [u16; 4usize],
                pub rows_string: [u16; 5usize],
                pub rowspan_string: [u16; 8usize],
                pub rb_string: [u16; 3usize],
                pub rp_string: [u16; 3usize],
                pub rt_string: [u16; 3usize],
                pub rtc_string: [u16; 4usize],
                pub rtl_string: [u16; 4usize],
                pub ruby_string: [u16; 5usize],
                pub rubyBase_string: [u16; 10usize],
                pub rubyBaseContainer_string: [u16; 20usize],
                pub rubyText_string: [u16; 10usize],
                pub rubyTextContainer_string: [u16; 20usize],
                pub rules_string: [u16; 6usize],
                pub s_string: [u16; 2usize],
                pub safe_area_inset_top_string: [u16; 20usize],
                pub safe_area_inset_bottom_string: [u16; 23usize],
                pub safe_area_inset_left_string: [u16; 21usize],
                pub safe_area_inset_right_string: [u16; 22usize],
                pub samp_string: [u16; 5usize],
                pub sandbox_string: [u16; 8usize],
                pub sbattr_string: [u16; 7usize],
                pub scale_string: [u16; 6usize],
                pub scan_string: [u16; 5usize],
                pub scheme_string: [u16; 7usize],
                pub scope_string: [u16; 6usize],
                pub scoped_string: [u16; 7usize],
                pub screen_string: [u16; 7usize],
                pub screenX_string: [u16; 8usize],
                pub screenx_string: [u16; 8usize],
                pub screenY_string: [u16; 8usize],
                pub screeny_string: [u16; 8usize],
                pub script_string: [u16; 7usize],
                pub scrollbar_string: [u16; 10usize],
                pub scrollbarThumb_string: [u16; 16usize],
                pub scrollamount_string: [u16; 13usize],
                pub scrollbarbutton_string: [u16; 16usize],
                pub scrollbarDownBottom_string: [u16; 22usize],
                pub scrollbarDownTop_string: [u16; 19usize],
                pub scrollbarInlineSize_string: [u16; 22usize],
                pub scrollbarUpBottom_string: [u16; 20usize],
                pub scrollbarUpTop_string: [u16; 17usize],
                pub scrollbox_string: [u16; 10usize],
                pub scrollcorner_string: [u16; 13usize],
                pub scrolldelay_string: [u16; 12usize],
                pub scrolling_string: [u16; 10usize],
                pub scrollPosition_string: [u16; 16usize],
                pub se_string: [u16; 3usize],
                pub section_string: [u16; 8usize],
                pub select_string: [u16; 7usize],
                pub selected_string: [u16; 9usize],
                pub selectedIndex_string: [u16; 14usize],
                pub selectedindex_string: [u16; 14usize],
                pub selectmenu_string: [u16; 11usize],
                pub self_string: [u16; 5usize],
                pub seltype_string: [u16; 8usize],
                pub setcookie_string: [u16; 11usize],
                pub setter_string: [u16; 7usize],
                pub shadow_string: [u16; 7usize],
                pub shape_string: [u16; 6usize],
                pub show_string: [u16; 5usize],
                pub showcaret_string: [u16; 10usize],
                pub show_modal_string: [u16; 11usize],
                pub show_popover_string: [u16; 13usize],
                pub showservicesmenu_string: [u16; 17usize],
                pub sibling_string: [u16; 8usize],
                pub simple_string: [u16; 7usize],
                pub simp_chinese_formal_string: [u16; 20usize],
                pub simp_chinese_informal_string: [u16; 22usize],
                pub single_string: [u16; 7usize],
                pub size_string: [u16; 5usize],
                pub sizes_string: [u16; 6usize],
                pub sizemode_string: [u16; 9usize],
                pub sizetopopup_string: [u16; 12usize],
                pub slider_string: [u16; 7usize],
                pub small_string: [u16; 6usize],
                pub smooth_string: [u16; 7usize],
                pub snap_string: [u16; 5usize],
                pub solid_string: [u16; 6usize],
                pub sort_string: [u16; 5usize],
                pub sortActive_string: [u16; 11usize],
                pub sortDirection_string: [u16; 14usize],
                pub sorted_string: [u16; 7usize],
                pub sorthints_string: [u16; 10usize],
                pub source_string: [u16; 7usize],
                pub sourcetext_string: [u16; 11usize],
                pub space_string: [u16; 6usize],
                pub spacer_string: [u16; 7usize],
                pub span_string: [u16; 5usize],
                pub spellcheck_string: [u16; 11usize],
                pub split_string: [u16; 6usize],
                pub splitter_string: [u16; 9usize],
                pub square_string: [u16; 7usize],
                pub src_string: [u16; 4usize],
                pub srcdoc_string: [u16; 7usize],
                pub srclang_string: [u16; 8usize],
                pub srcset_string: [u16; 7usize],
                pub standalone_string: [u16; 11usize],
                pub standby_string: [u16; 8usize],
                pub start_string: [u16; 6usize],
                pub startsWith_string: [u16; 12usize],
                pub state_string: [u16; 6usize],
                pub statusbar_string: [u16; 10usize],
                pub step_string: [u16; 5usize],
                pub stop_string: [u16; 5usize],
                pub stretch_string: [u16; 8usize],
                pub strike_string: [u16; 7usize],
                pub string_string: [u16; 7usize],
                pub stringLength_string: [u16; 14usize],
                pub stripSpace_string: [u16; 12usize],
                pub strong_string: [u16; 7usize],
                pub style_string: [u16; 6usize],
                pub stylesheet_string: [u16; 11usize],
                pub stylesheetPrefix_string: [u16; 18usize],
                pub submit_string: [u16; 7usize],
                pub substate_string: [u16; 9usize],
                pub substring_string: [u16; 10usize],
                pub substringAfter_string: [u16; 16usize],
                pub substringBefore_string: [u16; 17usize],
                pub sub_string: [u16; 4usize],
                pub suggestion_string: [u16; 11usize],
                pub sum_string: [u16; 4usize],
                pub sup_string: [u16; 4usize],
                pub summary_string: [u16; 8usize],
                pub sw_string: [u16; 3usize],
                pub systemProperty_string: [u16; 16usize],
                pub tab_string: [u16; 4usize],
                pub tabindex_string: [u16; 9usize],
                pub table_string: [u16; 6usize],
                pub tabpanel_string: [u16; 9usize],
                pub tabpanels_string: [u16; 10usize],
                pub tag_string: [u16; 4usize],
                pub target_string: [u16; 7usize],
                pub targets_string: [u16; 8usize],
                pub tbody_string: [u16; 6usize],
                pub td_string: [u16; 3usize],
                pub tel_string: [u16; 4usize],
                pub _template_string: [u16; 9usize],
                pub text_decoration_string: [u16; 16usize],
                pub terminate_string: [u16; 10usize],
                pub term_string: [u16; 5usize],
                pub test_string: [u16; 5usize],
                pub text_string: [u16; 5usize],
                pub textAlign_string: [u16; 11usize],
                pub textarea_string: [u16; 9usize],
                pub textbox_string: [u16; 8usize],
                pub textContent_string: [u16; 12usize],
                pub textLink_string: [u16; 10usize],
                pub textOverlay_string: [u16; 13usize],
                pub tfoot_string: [u16; 6usize],
                pub th_string: [u16; 3usize],
                pub thead_string: [u16; 6usize],
                pub thumb_string: [u16; 6usize],
                pub time_string: [u16; 5usize],
                pub title_string: [u16; 6usize],
                pub titletip_string: [u16; 9usize],
                pub toggle_string: [u16; 7usize],
                pub toggle_popover_string: [u16; 15usize],
                pub token_string: [u16; 6usize],
                pub tokenize_string: [u16; 9usize],
                pub toolbar_string: [u16; 8usize],
                pub toolbarbutton_string: [u16; 14usize],
                pub toolbaritem_string: [u16; 12usize],
                pub toolbarpaletteitem_string: [u16; 19usize],
                pub toolbox_string: [u16; 8usize],
                pub tooltip_string: [u16; 8usize],
                pub tooltiptext_string: [u16; 12usize],
                pub top_string: [u16; 4usize],
                pub topleft_string: [u16; 8usize],
                pub topmargin_string: [u16; 10usize],
                pub topright_string: [u16; 9usize],
                pub tr_string: [u16; 3usize],
                pub track_string: [u16; 6usize],
                pub trad_chinese_formal_string: [u16; 20usize],
                pub trad_chinese_informal_string: [u16; 22usize],
                pub trailing_string: [u16; 9usize],
                pub transform_string: [u16; 10usize],
                pub transform_3d_string: [u16; 13usize],
                pub transformiix_string: [u16; 13usize],
                pub translate_string: [u16; 10usize],
                pub transparent_string: [u16; 12usize],
                pub tree_string: [u16; 5usize],
                pub treecell_string: [u16; 9usize],
                pub treechildren_string: [u16; 13usize],
                pub treecol_string: [u16; 8usize],
                pub treecolpicker_string: [u16; 14usize],
                pub treecols_string: [u16; 9usize],
                pub treeitem_string: [u16; 9usize],
                pub treerow_string: [u16; 8usize],
                pub treeseparator_string: [u16; 14usize],
                pub _true_string: [u16; 5usize],
                pub truespeed_string: [u16; 10usize],
                pub tt_string: [u16; 3usize],
                pub type_string: [u16; 5usize],
                pub u_string: [u16; 2usize],
                pub ul_string: [u16; 3usize],
                pub unparsedEntityUri_string: [u16; 20usize],
                pub untilFound_string: [u16; 12usize],
                pub up_string: [u16; 3usize],
                pub update_string: [u16; 7usize],
                pub upperFirst_string: [u16; 12usize],
                pub use_string: [u16; 4usize],
                pub useAttributeSets_string: [u16; 19usize],
                pub usemap_string: [u16; 7usize],
                pub user_scalable_string: [u16; 14usize],
                pub validate_string: [u16; 9usize],
                pub valign_string: [u16; 7usize],
                pub value_string: [u16; 6usize],
                pub values_string: [u16; 7usize],
                pub valueOf_string: [u16; 9usize],
                pub valuetype_string: [u16; 10usize],
                pub var_string: [u16; 4usize],
                pub variable_string: [u16; 9usize],
                pub vendor_string: [u16; 7usize],
                pub vendorUrl_string: [u16; 11usize],
                pub version_string: [u16; 8usize],
                pub vertical_string: [u16; 9usize],
                pub audio_string: [u16; 6usize],
                pub video_string: [u16; 6usize],
                pub viewport_string: [u16; 9usize],
                pub viewport_fit_string: [u16; 13usize],
                pub viewport_height_string: [u16; 16usize],
                pub viewport_initial_scale_string: [u16; 23usize],
                pub viewport_maximum_scale_string: [u16; 23usize],
                pub viewport_minimum_scale_string: [u16; 23usize],
                pub viewport_user_scalable_string: [u16; 23usize],
                pub viewport_width_string: [u16; 15usize],
                pub visibility_string: [u16; 11usize],
                pub visuallyselected_string: [u16; 17usize],
                pub vlink_string: [u16; 6usize],
                pub _void_string: [u16; 5usize],
                pub vsides_string: [u16; 7usize],
                pub vspace_string: [u16; 7usize],
                pub w_string: [u16; 2usize],
                pub wbr_string: [u16; 4usize],
                pub webkitdirectory_string: [u16; 16usize],
                pub when_string: [u16; 5usize],
                pub white_string: [u16; 6usize],
                pub width_string: [u16; 6usize],
                pub willChange_string: [u16; 12usize],
                pub window_string: [u16; 7usize],
                pub headerWindowTarget_string: [u16; 14usize],
                pub windowtype_string: [u16; 11usize],
                pub withParam_string: [u16; 11usize],
                pub wrap_string: [u16; 5usize],
                pub headerDNSPrefetchControl_string: [u16; 23usize],
                pub headerCSP_string: [u16; 24usize],
                pub headerCSPReportOnly_string: [u16; 36usize],
                pub headerXFO_string: [u16; 16usize],
                pub x_western_string: [u16; 10usize],
                pub xml_string: [u16; 4usize],
                pub xml_stylesheet_string: [u16; 15usize],
                pub xmlns_string: [u16; 6usize],
                pub xmp_string: [u16; 4usize],
                pub xul_string: [u16; 4usize],
                pub yes_string: [u16; 4usize],
                pub z_index_string: [u16; 8usize],
                pub zeroDigit_string: [u16; 11usize],
                pub zlevel_string: [u16; 7usize],
                pub percentage_string: [u16; 2usize],
                pub A_string: [u16; 2usize],
                pub alignment_baseline_string: [u16; 19usize],
                pub amplitude_string: [u16; 10usize],
                pub animate_string: [u16; 8usize],
                pub animateColor_string: [u16; 13usize],
                pub animateMotion_string: [u16; 14usize],
                pub animateTransform_string: [u16; 17usize],
                pub arithmetic_string: [u16; 11usize],
                pub atop_string: [u16; 5usize],
                pub azimuth_string: [u16; 8usize],
                pub B_string: [u16; 2usize],
                pub background_color_string: [u16; 17usize],
                pub background_image_string: [u16; 17usize],
                pub baseFrequency_string: [u16; 14usize],
                pub baseline_shift_string: [u16; 15usize],
                pub bias_string: [u16; 5usize],
                pub caption_side_string: [u16; 13usize],
                pub clip_path_string: [u16; 10usize],
                pub clip_rule_string: [u16; 10usize],
                pub clipPath_string: [u16; 9usize],
                pub clipPathUnits_string: [u16; 14usize],
                pub cm_string: [u16; 3usize],
                pub color_burn_string: [u16; 11usize],
                pub color_dodge_string: [u16; 12usize],
                pub color_interpolation_string: [u16; 20usize],
                pub color_interpolation_filters_string: [u16; 28usize],
                pub color_profile_string: [u16; 14usize],
                pub cursor_string: [u16; 7usize],
                pub cx_string: [u16; 3usize],
                pub cy_string: [u16; 3usize],
                pub d_string: [u16; 2usize],
                pub darken_string: [u16; 7usize],
                pub defs_string: [u16; 5usize],
                pub deg_string: [u16; 4usize],
                pub desc_string: [u16; 5usize],
                pub diffuseConstant_string: [u16; 16usize],
                pub dilate_string: [u16; 7usize],
                pub direction_string: [u16; 10usize],
                pub disable_string: [u16; 8usize],
                pub disc_string: [u16; 5usize],
                pub discrete_string: [u16; 9usize],
                pub divisor_string: [u16; 8usize],
                pub dominant_baseline_string: [u16; 18usize],
                pub duplicate_string: [u16; 10usize],
                pub dx_string: [u16; 3usize],
                pub dy_string: [u16; 3usize],
                pub edgeMode_string: [u16; 9usize],
                pub ellipse_string: [u16; 8usize],
                pub elevation_string: [u16; 10usize],
                pub erode_string: [u16; 6usize],
                pub ex_string: [u16; 3usize],
                pub exact_string: [u16; 6usize],
                pub exclusion_string: [u16; 10usize],
                pub exponent_string: [u16; 9usize],
                pub feBlend_string: [u16; 8usize],
                pub feColorMatrix_string: [u16; 14usize],
                pub feComponentTransfer_string: [u16; 20usize],
                pub feComposite_string: [u16; 12usize],
                pub feConvolveMatrix_string: [u16; 17usize],
                pub feDiffuseLighting_string: [u16; 18usize],
                pub feDisplacementMap_string: [u16; 18usize],
                pub feDistantLight_string: [u16; 15usize],
                pub feDropShadow_string: [u16; 13usize],
                pub feFlood_string: [u16; 8usize],
                pub feFuncA_string: [u16; 8usize],
                pub feFuncB_string: [u16; 8usize],
                pub feFuncG_string: [u16; 8usize],
                pub feFuncR_string: [u16; 8usize],
                pub feGaussianBlur_string: [u16; 15usize],
                pub feImage_string: [u16; 8usize],
                pub feMerge_string: [u16; 8usize],
                pub feMergeNode_string: [u16; 12usize],
                pub feMorphology_string: [u16; 13usize],
                pub feOffset_string: [u16; 9usize],
                pub fePointLight_string: [u16; 13usize],
                pub feSpecularLighting_string: [u16; 19usize],
                pub feSpotLight_string: [u16; 12usize],
                pub feTile_string: [u16; 7usize],
                pub feTurbulence_string: [u16; 13usize],
                pub fill_string: [u16; 5usize],
                pub fill_opacity_string: [u16; 13usize],
                pub fill_rule_string: [u16; 10usize],
                pub filter_string: [u16; 7usize],
                pub filterUnits_string: [u16; 12usize],
                pub _float_string: [u16; 6usize],
                pub flood_color_string: [u16; 12usize],
                pub flood_opacity_string: [u16; 14usize],
                pub font_face_string: [u16; 10usize],
                pub font_face_format_string: [u16; 17usize],
                pub font_face_name_string: [u16; 15usize],
                pub font_face_src_string: [u16; 14usize],
                pub font_face_uri_string: [u16; 14usize],
                pub font_family_string: [u16; 12usize],
                pub font_size_string: [u16; 10usize],
                pub font_size_adjust_string: [u16; 17usize],
                pub font_stretch_string: [u16; 13usize],
                pub font_style_string: [u16; 11usize],
                pub font_variant_string: [u16; 13usize],
                pub font_weight_string: [u16; 12usize],
                pub formatting_string: [u16; 11usize],
                pub foreignObject_string: [u16; 14usize],
                pub fractalNoise_string: [u16; 13usize],
                pub fr_string: [u16; 3usize],
                pub fx_string: [u16; 3usize],
                pub fy_string: [u16; 3usize],
                pub G_string: [u16; 2usize],
                pub g_string: [u16; 2usize],
                pub gamma_string: [u16; 6usize],
                pub glyphRef_string: [u16; 9usize],
                pub grad_string: [u16; 5usize],
                pub gradientTransform_string: [u16; 18usize],
                pub gradientUnits_string: [u16; 14usize],
                pub hardLight_string: [u16; 11usize],
                pub hue_string: [u16; 4usize],
                pub hueRotate_string: [u16; 10usize],
                pub identity_string: [u16; 9usize],
                pub image_rendering_string: [u16; 16usize],
                pub in_string: [u16; 3usize],
                pub in2_string: [u16; 4usize],
                pub intercept_string: [u16; 10usize],
                pub k1_string: [u16; 3usize],
                pub k2_string: [u16; 3usize],
                pub k3_string: [u16; 3usize],
                pub k4_string: [u16; 3usize],
                pub kernelMatrix_string: [u16; 13usize],
                pub kernelUnitLength_string: [u16; 17usize],
                pub lengthAdjust_string: [u16; 13usize],
                pub letter_spacing_string: [u16; 15usize],
                pub lighten_string: [u16; 8usize],
                pub lighter_string: [u16; 8usize],
                pub lighting_color_string: [u16; 15usize],
                pub limitingConeAngle_string: [u16; 18usize],
                pub linear_string: [u16; 7usize],
                pub linearGradient_string: [u16; 15usize],
                pub list_item_string: [u16; 10usize],
                pub list_style_type_string: [u16; 16usize],
                pub luminanceToAlpha_string: [u16; 17usize],
                pub luminosity_string: [u16; 11usize],
                pub magnify_string: [u16; 8usize],
                pub marker_string: [u16; 7usize],
                pub marker_end_string: [u16; 11usize],
                pub marker_mid_string: [u16; 11usize],
                pub marker_start_string: [u16; 13usize],
                pub markerHeight_string: [u16; 13usize],
                pub markerUnits_string: [u16; 12usize],
                pub markerWidth_string: [u16; 12usize],
                pub mask_string: [u16; 5usize],
                pub maskContentUnits_string: [u16; 17usize],
                pub mask_type_string: [u16; 10usize],
                pub maskUnits_string: [u16; 10usize],
                pub matrix_string: [u16; 7usize],
                pub metadata_string: [u16; 9usize],
                pub missingGlyph_string: [u16; 14usize],
                pub mm_string: [u16; 3usize],
                pub mpath_string: [u16; 6usize],
                pub noStitch_string: [u16; 9usize],
                pub numOctaves_string: [u16; 11usize],
                pub multiply_string: [u16; 9usize],
                pub objectBoundingBox_string: [u16; 18usize],
                pub offset_string: [u16; 7usize],
                pub onSVGLoad_string: [u16; 10usize],
                pub onSVGScroll_string: [u16; 12usize],
                pub onzoom_string: [u16; 7usize],
                pub opacity_string: [u16; 8usize],
                pub _operator_string: [u16; 9usize],
                pub out_string: [u16; 4usize],
                pub over_string: [u16; 5usize],
                pub overridePreserveAspectRatio_string: [u16; 28usize],
                pub pad_string: [u16; 4usize],
                pub path_string: [u16; 5usize],
                pub pathLength_string: [u16; 11usize],
                pub patternContentUnits_string: [u16; 20usize],
                pub patternTransform_string: [u16; 17usize],
                pub patternUnits_string: [u16; 13usize],
                pub pc_string: [u16; 3usize],
                pub pointer_string: [u16; 8usize],
                pub pointer_events_string: [u16; 15usize],
                pub points_string: [u16; 7usize],
                pub pointsAtX_string: [u16; 10usize],
                pub pointsAtY_string: [u16; 10usize],
                pub pointsAtZ_string: [u16; 10usize],
                pub polyline_string: [u16; 9usize],
                pub preserveAlpha_string: [u16; 14usize],
                pub preserveAspectRatio_string: [u16; 20usize],
                pub primitiveUnits_string: [u16; 15usize],
                pub pt_string: [u16; 3usize],
                pub px_string: [u16; 3usize],
                pub R_string: [u16; 2usize],
                pub r_string: [u16; 2usize],
                pub rad_string: [u16; 4usize],
                pub radialGradient_string: [u16; 15usize],
                pub radius_string: [u16; 7usize],
                pub reflect_string: [u16; 8usize],
                pub refX_string: [u16; 5usize],
                pub refY_string: [u16; 5usize],
                pub requiredExtensions_string: [u16; 19usize],
                pub requiredFeatures_string: [u16; 17usize],
                pub rotate_string: [u16; 7usize],
                pub rx_string: [u16; 3usize],
                pub ry_string: [u16; 3usize],
                pub saturate_string: [u16; 9usize],
                pub saturation_string: [u16; 11usize],
                pub set_string: [u16; 4usize],
                pub seed_string: [u16; 5usize],
                pub shape_rendering_string: [u16; 16usize],
                pub simpleScopeChain_string: [u16; 17usize],
                pub skewX_string: [u16; 6usize],
                pub skewY_string: [u16; 6usize],
                pub slope_string: [u16; 6usize],
                pub slot_string: [u16; 5usize],
                pub softLight_string: [u16; 11usize],
                pub spacing_string: [u16; 8usize],
                pub spacingAndGlyphs_string: [u16; 17usize],
                pub specularConstant_string: [u16; 17usize],
                pub specularExponent_string: [u16; 17usize],
                pub spreadMethod_string: [u16; 13usize],
                pub startOffset_string: [u16; 12usize],
                pub stdDeviation_string: [u16; 13usize],
                pub stitch_string: [u16; 7usize],
                pub stitchTiles_string: [u16; 12usize],
                pub stop_color_string: [u16; 11usize],
                pub stop_opacity_string: [u16; 13usize],
                pub stroke_string: [u16; 7usize],
                pub stroke_dasharray_string: [u16; 17usize],
                pub stroke_dashoffset_string: [u16; 18usize],
                pub stroke_linecap_string: [u16; 15usize],
                pub stroke_linejoin_string: [u16; 16usize],
                pub stroke_miterlimit_string: [u16; 18usize],
                pub stroke_opacity_string: [u16; 15usize],
                pub stroke_width_string: [u16; 13usize],
                pub strokeWidth_string: [u16; 12usize],
                pub surfaceScale_string: [u16; 13usize],
                pub svg_string: [u16; 4usize],
                pub svgSwitch_string: [u16; 7usize],
                pub symbol_string: [u16; 7usize],
                pub systemLanguage_string: [u16; 15usize],
                pub tableValues_string: [u16; 12usize],
                pub targetX_string: [u16; 8usize],
                pub targetY_string: [u16; 8usize],
                pub text_anchor_string: [u16; 12usize],
                pub text_overflow_string: [u16; 14usize],
                pub text_rendering_string: [u16; 15usize],
                pub textLength_string: [u16; 11usize],
                pub textPath_string: [u16; 9usize],
                pub transform_origin_string: [u16; 17usize],
                pub tref_string: [u16; 5usize],
                pub tspan_string: [u16; 6usize],
                pub turbulence_string: [u16; 11usize],
                pub unicode_bidi_string: [u16; 13usize],
                pub userSpaceOnUse_string: [u16; 15usize],
                pub view_string: [u16; 5usize],
                pub viewBox_string: [u16; 8usize],
                pub viewTarget_string: [u16; 11usize],
                pub white_space_string: [u16; 12usize],
                pub windowsmica_string: [u16; 12usize],
                pub word_spacing_string: [u16; 13usize],
                pub writing_mode_string: [u16; 13usize],
                pub x_string: [u16; 2usize],
                pub x1_string: [u16; 3usize],
                pub x2_string: [u16; 3usize],
                pub xChannelSelector_string: [u16; 17usize],
                pub xor__string: [u16; 4usize],
                pub y_string: [u16; 2usize],
                pub y1_string: [u16; 3usize],
                pub y2_string: [u16; 3usize],
                pub yChannelSelector_string: [u16; 17usize],
                pub z_string: [u16; 2usize],
                pub zoomAndPan_string: [u16; 11usize],
                pub vector_effect_string: [u16; 14usize],
                pub vertical_align_string: [u16; 15usize],
                pub accumulate_string: [u16; 11usize],
                pub additive_string: [u16; 9usize],
                pub attributeName_string: [u16; 14usize],
                pub attributeType_string: [u16; 14usize],
                pub auto_reverse_string: [u16; 13usize],
                pub begin_string: [u16; 6usize],
                pub beginEvent_string: [u16; 11usize],
                pub by_string: [u16; 3usize],
                pub calcMode_string: [u16; 9usize],
                pub dur_string: [u16; 4usize],
                pub keyPoints_string: [u16; 10usize],
                pub keySplines_string: [u16; 11usize],
                pub keyTimes_string: [u16; 9usize],
                pub mozAnimateMotionDummyAttr_string: [u16; 27usize],
                pub onbegin_string: [u16; 8usize],
                pub onbeginEvent_string: [u16; 13usize],
                pub onend_string: [u16; 6usize],
                pub onendEvent_string: [u16; 11usize],
                pub onrelease_string: [u16; 10usize],
                pub onrepeat_string: [u16; 9usize],
                pub onrepeatEvent_string: [u16; 14usize],
                pub repeatCount_string: [u16; 12usize],
                pub repeatDur_string: [u16; 10usize],
                pub repeatEvent_string: [u16; 12usize],
                pub restart_string: [u16; 8usize],
                pub to_string: [u16; 3usize],
                pub abs_string: [u16; 4usize],
                pub accent_string: [u16; 7usize],
                pub accentunder_string: [u16; 12usize],
                pub actiontype_string: [u16; 11usize],
                pub alignmentscope_string: [u16; 15usize],
                pub altimg_string: [u16; 7usize],
                pub altimg_height_string: [u16; 14usize],
                pub altimg_valign_string: [u16; 14usize],
                pub altimg_width_string: [u16; 13usize],
                pub annotation_string: [u16; 11usize],
                pub annotation_xml_string: [u16; 15usize],
                pub apply_string: [u16; 6usize],
                pub approx_string: [u16; 7usize],
                pub arccos_string: [u16; 7usize],
                pub arccosh_string: [u16; 8usize],
                pub arccot_string: [u16; 7usize],
                pub arccoth_string: [u16; 8usize],
                pub arccsc_string: [u16; 7usize],
                pub arccsch_string: [u16; 8usize],
                pub arcsec_string: [u16; 7usize],
                pub arcsech_string: [u16; 8usize],
                pub arcsin_string: [u16; 7usize],
                pub arcsinh_string: [u16; 8usize],
                pub arctan_string: [u16; 7usize],
                pub arctanh_string: [u16; 8usize],
                pub arg_string: [u16; 4usize],
                pub bevelled_string: [u16; 9usize],
                pub bind_string: [u16; 5usize],
                pub bvar_string: [u16; 5usize],
                pub card_string: [u16; 5usize],
                pub cartesianproduct_string: [u16; 17usize],
                pub cbytes_string: [u16; 7usize],
                pub cd_string: [u16; 3usize],
                pub cdgroup_string: [u16; 8usize],
                pub cerror_string: [u16; 7usize],
                pub charalign_string: [u16; 10usize],
                pub ci_string: [u16; 3usize],
                pub closure_string: [u16; 8usize],
                pub cn_string: [u16; 3usize],
                pub codomain_string: [u16; 9usize],
                pub columnalign_string: [u16; 12usize],
                pub columnalignment_string: [u16; 16usize],
                pub columnlines_string: [u16; 12usize],
                pub columnspacing_string: [u16; 14usize],
                pub columnspan_string: [u16; 11usize],
                pub columnwidth_string: [u16; 12usize],
                pub complexes_string: [u16; 10usize],
                pub compose_string: [u16; 8usize],
                pub condition_string: [u16; 10usize],
                pub conjugate_string: [u16; 10usize],
                pub cos_string: [u16; 4usize],
                pub cosh_string: [u16; 5usize],
                pub cot_string: [u16; 4usize],
                pub coth_string: [u16; 5usize],
                pub crossout_string: [u16; 9usize],
                pub csc_string: [u16; 4usize],
                pub csch_string: [u16; 5usize],
                pub cs_string: [u16; 3usize],
                pub csymbol_string: [u16; 8usize],
                pub csp_string: [u16; 4usize],
                pub cspViolation_string: [u16; 14usize],
                pub curl_string: [u16; 5usize],
                pub decimalpoint_string: [u16; 13usize],
                pub definition_string: [u16; 11usize],
                pub definitionURL_string: [u16; 14usize],
                pub degree_string: [u16; 7usize],
                pub denomalign_string: [u16; 11usize],
                pub depth_string: [u16; 6usize],
                pub determinant_string: [u16; 12usize],
                pub diff_string: [u16; 5usize],
                pub displaystyle_string: [u16; 13usize],
                pub divergence_string: [u16; 11usize],
                pub divide_string: [u16; 7usize],
                pub dom_viewTransitions_enabled_string: [u16; 28usize],
                pub domain_string: [u16; 7usize],
                pub domainofapplication_string: [u16; 20usize],
                pub edge_string: [u16; 5usize],
                pub el_string: [u16; 3usize],
                pub emptyset_string: [u16; 9usize],
                pub eq_string: [u16; 3usize],
                pub equalcolumns_string: [u16; 13usize],
                pub equalrows_string: [u16; 10usize],
                pub equivalent_string: [u16; 11usize],
                pub eulergamma_string: [u16; 11usize],
                pub exists_string: [u16; 7usize],
                pub exp_string: [u16; 4usize],
                pub exponentiale_string: [u16; 13usize],
                pub factorial_string: [u16; 10usize],
                pub factorof_string: [u16; 9usize],
                pub fence_string: [u16; 6usize],
                pub fn_string: [u16; 3usize],
                pub fontfamily_string: [u16; 11usize],
                pub fontsize_string: [u16; 9usize],
                pub fontstyle_string: [u16; 10usize],
                pub fontweight_string: [u16; 11usize],
                pub forall_string: [u16; 7usize],
                pub framespacing_string: [u16; 13usize],
                pub gcd_string: [u16; 4usize],
                pub geq_string: [u16; 4usize],
                pub groupalign_string: [u16; 11usize],
                pub gt_string: [u16; 3usize],
                pub ident_string: [u16; 6usize],
                pub imaginaryi_string: [u16; 11usize],
                pub imaginary_string: [u16; 10usize],
                pub implies_string: [u16; 8usize],
                pub indentalignfirst_string: [u16; 17usize],
                pub indentalign_string: [u16; 12usize],
                pub indentalignlast_string: [u16; 16usize],
                pub indentshiftfirst_string: [u16; 17usize],
                pub indentshift_string: [u16; 12usize],
                pub indenttarget_string: [u16; 13usize],
                pub integers_string: [u16; 9usize],
                pub intersect_string: [u16; 10usize],
                pub interval_string: [u16; 9usize],
                pub int__string: [u16; 4usize],
                pub inverse_string: [u16; 8usize],
                pub lambda_string: [u16; 7usize],
                pub laplacian_string: [u16; 10usize],
                pub largeop_string: [u16; 8usize],
                pub lcm_string: [u16; 4usize],
                pub leq_string: [u16; 4usize],
                pub limit_string: [u16; 6usize],
                pub linebreak_string: [u16; 10usize],
                pub linebreakmultchar_string: [u16; 18usize],
                pub linebreakstyle_string: [u16; 15usize],
                pub linethickness_string: [u16; 14usize],
                pub list_string: [u16; 5usize],
                pub ln_string: [u16; 3usize],
                pub location_string: [u16; 9usize],
                pub logbase_string: [u16; 8usize],
                pub log_string: [u16; 4usize],
                pub longdivstyle_string: [u16; 13usize],
                pub lowlimit_string: [u16; 9usize],
                pub lquote_string: [u16; 7usize],
                pub lspace_string: [u16; 7usize],
                pub lt_string: [u16; 3usize],
                pub maction_string: [u16; 8usize],
                pub maligngroup_string: [u16; 12usize],
                pub malignmark_string: [u16; 11usize],
                pub mathbackground_string: [u16; 15usize],
                pub mathcolor_string: [u16; 10usize],
                pub mathsize_string: [u16; 9usize],
                pub mathvariant_string: [u16; 12usize],
                pub matrixrow_string: [u16; 10usize],
                pub maxsize_string: [u16; 8usize],
                pub mean_string: [u16; 5usize],
                pub median_string: [u16; 7usize],
                pub menclose_string: [u16; 9usize],
                pub merror_string: [u16; 7usize],
                pub mfenced_string: [u16; 8usize],
                pub mfrac_string: [u16; 6usize],
                pub mglyph_string: [u16; 7usize],
                pub mi_string: [u16; 3usize],
                pub minlabelspacing_string: [u16; 16usize],
                pub minsize_string: [u16; 8usize],
                pub minus_string: [u16; 6usize],
                pub mlabeledtr_string: [u16; 11usize],
                pub mlongdiv_string: [u16; 9usize],
                pub mmultiscripts_string: [u16; 14usize],
                pub mn_string: [u16; 3usize],
                pub momentabout_string: [u16; 12usize],
                pub moment_string: [u16; 7usize],
                pub mo_string: [u16; 3usize],
                pub movablelimits_string: [u16; 14usize],
                pub mover_string: [u16; 6usize],
                pub mpadded_string: [u16; 8usize],
                pub mphantom_string: [u16; 9usize],
                pub mprescripts_string: [u16; 12usize],
                pub mroot_string: [u16; 6usize],
                pub mrow_string: [u16; 5usize],
                pub mscarries_string: [u16; 10usize],
                pub mscarry_string: [u16; 8usize],
                pub msgroup_string: [u16; 8usize],
                pub msline_string: [u16; 7usize],
                pub ms_string: [u16; 3usize],
                pub mspace_string: [u16; 7usize],
                pub msqrt_string: [u16; 6usize],
                pub msrow_string: [u16; 6usize],
                pub mstack_string: [u16; 7usize],
                pub mstyle_string: [u16; 7usize],
                pub msub_string: [u16; 5usize],
                pub msubsup_string: [u16; 8usize],
                pub msup_string: [u16; 5usize],
                pub mtable_string: [u16; 7usize],
                pub mtd_string: [u16; 4usize],
                pub mtext_string: [u16; 6usize],
                pub mtr_string: [u16; 4usize],
                pub munder_string: [u16; 7usize],
                pub munderover_string: [u16; 11usize],
                pub naturalnumbers_string: [u16; 15usize],
                pub neq_string: [u16; 4usize],
                pub notanumber_string: [u16; 11usize],
                pub notation_string: [u16; 9usize],
                pub note_string: [u16; 5usize],
                pub notin_string: [u16; 6usize],
                pub notprsubset_string: [u16; 12usize],
                pub notsubset_string: [u16; 10usize],
                pub numalign_string: [u16; 9usize],
                pub other_string: [u16; 6usize],
                pub outerproduct_string: [u16; 13usize],
                pub partialdiff_string: [u16; 12usize],
                pub piece_string: [u16; 6usize],
                pub piecewise_string: [u16; 10usize],
                pub pi_string: [u16; 3usize],
                pub plus_string: [u16; 5usize],
                pub power_string: [u16; 6usize],
                pub primes_string: [u16; 7usize],
                pub product_string: [u16; 8usize],
                pub prsubset_string: [u16; 9usize],
                pub quotient_string: [u16; 9usize],
                pub rationals_string: [u16; 10usize],
                pub real_string: [u16; 5usize],
                pub reals_string: [u16; 6usize],
                pub reln_string: [u16; 5usize],
                pub root_string: [u16; 5usize],
                pub rowalign_string: [u16; 9usize],
                pub rowlines_string: [u16; 9usize],
                pub rowspacing_string: [u16; 11usize],
                pub rquote_string: [u16; 7usize],
                pub rspace_string: [u16; 7usize],
                pub scalarproduct_string: [u16; 14usize],
                pub schemaLocation_string: [u16; 15usize],
                pub scriptlevel_string: [u16; 12usize],
                pub scriptminsize_string: [u16; 14usize],
                pub scriptsizemultiplier_string: [u16; 21usize],
                pub scriptsize_string: [u16; 11usize],
                pub sdev_string: [u16; 5usize],
                pub sech_string: [u16; 5usize],
                pub sec_string: [u16; 4usize],
                pub selection_string: [u16; 10usize],
                pub selector_string: [u16; 9usize],
                pub semantics_string: [u16; 10usize],
                pub separator_string: [u16; 10usize],
                pub separators_string: [u16; 11usize],
                pub sep_string: [u16; 4usize],
                pub setdiff_string: [u16; 8usize],
                pub share_string: [u16; 6usize],
                pub shift_string: [u16; 6usize],
                pub side_string: [u16; 5usize],
                pub sinh_string: [u16; 5usize],
                pub sin_string: [u16; 4usize],
                pub stackalign_string: [u16; 11usize],
                pub stretchy_string: [u16; 9usize],
                pub subscriptshift_string: [u16; 15usize],
                pub subset_string: [u16; 7usize],
                pub superscriptshift_string: [u16; 17usize],
                pub symmetric_string: [u16; 10usize],
                pub tanh_string: [u16; 5usize],
                pub tan_string: [u16; 4usize],
                pub tendsto_string: [u16; 8usize],
                pub times_string: [u16; 6usize],
                pub transpose_string: [u16; 10usize],
                pub union__string: [u16; 6usize],
                pub uplimit_string: [u16; 8usize],
                pub variance_string: [u16; 9usize],
                pub vectorproduct_string: [u16; 14usize],
                pub vector_string: [u16; 7usize],
                pub voffset_string: [u16; 8usize],
                pub xref_string: [u16; 5usize],
                pub math_string: [u16; 5usize],
                pub booleanFromString_string: [u16; 20usize],
                pub countNonEmpty_string: [u16; 16usize],
                pub daysFromDate_string: [u16; 15usize],
                pub secondsFromDateTime_string: [u16; 22usize],
                pub tabbrowser_arrowscrollbox_string: [u16; 26usize],
                pub onMozSwipeGestureMayStart_string: [u16; 26usize],
                pub onMozSwipeGestureStart_string: [u16; 23usize],
                pub onMozSwipeGestureUpdate_string: [u16; 24usize],
                pub onMozSwipeGestureEnd_string: [u16; 21usize],
                pub onMozSwipeGesture_string: [u16; 18usize],
                pub onMozMagnifyGestureStart_string: [u16; 25usize],
                pub onMozMagnifyGestureUpdate_string: [u16; 26usize],
                pub onMozMagnifyGesture_string: [u16; 20usize],
                pub onMozRotateGestureStart_string: [u16; 24usize],
                pub onMozRotateGestureUpdate_string: [u16; 25usize],
                pub onMozRotateGesture_string: [u16; 19usize],
                pub onMozTapGesture_string: [u16; 16usize],
                pub onMozPressTapGesture_string: [u16; 21usize],
                pub onMozEdgeUIStarted_string: [u16; 19usize],
                pub onMozEdgeUICanceled_string: [u16; 20usize],
                pub onMozEdgeUICompleted_string: [u16; 21usize],
                pub onpointerdown_string: [u16; 14usize],
                pub onpointermove_string: [u16; 14usize],
                pub onpointerup_string: [u16; 12usize],
                pub onpointercancel_string: [u16; 16usize],
                pub onpointerover_string: [u16; 14usize],
                pub onpointerout_string: [u16; 13usize],
                pub onpointerenter_string: [u16; 15usize],
                pub onpointerleave_string: [u16; 15usize],
                pub onpointerrawupdate_string: [u16; 19usize],
                pub ongotpointercapture_string: [u16; 20usize],
                pub onlostpointercapture_string: [u16; 21usize],
                pub ondevicemotion_string: [u16; 15usize],
                pub ondeviceorientation_string: [u16; 20usize],
                pub ondeviceorientationabsolute_string: [u16; 28usize],
                pub onmozorientationchange_string: [u16; 23usize],
                pub onuserproximity_string: [u16; 16usize],
                pub ondevicelight_string: [u16; 14usize],
                pub ondevicechange_string: [u16; 15usize],
                pub onrtctransform_string: [u16; 15usize],
                pub onmozvisualresize_string: [u16; 18usize],
                pub onmozvisualscroll_string: [u16; 18usize],
                pub onDOMContentLoaded_string: [u16; 19usize],
                pub onDOMDocElementInserted_string: [u16; 24usize],
                pub onDOMFormBeforeSubmit_string: [u16; 22usize],
                pub onDOMFormHasPassword_string: [u16; 21usize],
                pub onDOMFrameContentLoaded_string: [u16; 24usize],
                pub onDOMHeadElementParsed_string: [u16; 23usize],
                pub onDOMInputPasswordAdded_string: [u16; 24usize],
                pub onDOMLinkAdded_string: [u16; 15usize],
                pub onDOMLinkChanged_string: [u16; 17usize],
                pub onDOMMetaAdded_string: [u16; 15usize],
                pub onDOMMetaChanged_string: [u16; 17usize],
                pub onDOMMetaRemoved_string: [u16; 17usize],
                pub onDOMPopupBlocked_string: [u16; 18usize],
                pub onDOMTitleChanged_string: [u16; 18usize],
                pub onDOMWindowClose_string: [u16; 17usize],
                pub onDOMWindowCreated_string: [u16; 19usize],
                pub onDOMWindowFocus_string: [u16; 17usize],
                pub onFullZoomChange_string: [u16; 17usize],
                pub onGloballyAutoplayBlocked_string: [u16; 26usize],
                pub onMozDOMFullscreen_Entered_string: [u16; 27usize],
                pub onMozDOMFullscreen_Exit_string: [u16; 24usize],
                pub onMozDOMFullscreen_Exited_string: [u16; 26usize],
                pub onMozDOMFullscreen_NewOrigin_string: [u16; 29usize],
                pub onMozDOMFullscreen_Request_string: [u16; 27usize],
                pub onMozDOMPointerLock_Entered_string: [u16; 28usize],
                pub onMozDOMPointerLock_Exited_string: [u16; 27usize],
                pub onMozInvalidForm_string: [u16; 17usize],
                pub onMozLocalStorageChanged_string: [u16; 25usize],
                pub onMozOpenDateTimePicker_string: [u16; 24usize],
                pub onMozSessionStorageChanged_string: [u16; 27usize],
                pub onMozTogglePictureInPicture_string: [u16; 28usize],
                pub onPluginCrashed_string: [u16; 16usize],
                pub onPrintingError_string: [u16; 16usize],
                pub onTextZoomChange_string: [u16; 17usize],
                pub onUAWidgetSetupOrChange_string: [u16; 24usize],
                pub onUAWidgetTeardown_string: [u16; 19usize],
                pub onUnselectedTabHover_Disable_string: [u16; 29usize],
                pub onUnselectedTabHover_Enable_string: [u16; 28usize],
                pub onmozshowdropdown_string: [u16; 18usize],
                pub onmozshowdropdown_sourcetouch_string: [u16; 30usize],
                pub onprintPreviewUpdate_string: [u16; 21usize],
                pub onscrollend_string: [u16; 12usize],
                pub onbeforetoggle_string: [u16; 15usize],
                pub moz_extension_string: [u16; 14usize],
                pub all_urlsPermission_string: [u16; 11usize],
                pub clipboardRead_string: [u16; 14usize],
                pub clipboardWrite_string: [u16; 15usize],
                pub debugger_string: [u16; 9usize],
                pub mozillaAddons_string: [u16; 14usize],
                pub tabs_string: [u16; 5usize],
                pub webRequestBlocking_string: [u16; 19usize],
                pub webRequestFilterResponse_serviceWorkerScript_string: [u16; 45usize],
                pub blob_string: [u16; 5usize],
                pub http_string: [u16; 5usize],
                pub https_string: [u16; 6usize],
                pub view_source_string: [u16; 12usize],
                pub ws_string: [u16; 3usize],
                pub wss_string: [u16; 4usize],
                pub ftp_string: [u16; 4usize],
                pub chrome_string: [u16; 7usize],
                pub moz_string: [u16; 4usize],
                pub moz_icon_string: [u16; 9usize],
                pub moz_gio_string: [u16; 8usize],
                pub proxy_string: [u16; 6usize],
                pub privateBrowsingAllowedPermission_string: [u16; 32usize],
                pub svgContextPropertiesAllowedPermission_string: [u16; 37usize],
                pub theme_string: [u16; 6usize],
                pub userScripts_string: [u16; 12usize],
                pub decimal_leading_zero_string: [u16; 21usize],
                pub arabic_indic_string: [u16; 13usize],
                pub armenian_string: [u16; 9usize],
                pub upper_armenian_string: [u16; 15usize],
                pub lower_armenian_string: [u16; 15usize],
                pub bengali_string: [u16; 8usize],
                pub cambodian_string: [u16; 10usize],
                pub khmer_string: [u16; 6usize],
                pub cjk_decimal_string: [u16; 12usize],
                pub devanagari_string: [u16; 11usize],
                pub georgian_string: [u16; 9usize],
                pub gujarati_string: [u16; 9usize],
                pub gurmukhi_string: [u16; 9usize],
                pub kannada_string: [u16; 8usize],
                pub lao_string: [u16; 4usize],
                pub malayalam_string: [u16; 10usize],
                pub mongolian_string: [u16; 10usize],
                pub myanmar_string: [u16; 8usize],
                pub oriya_string: [u16; 6usize],
                pub persian_string: [u16; 8usize],
                pub lower_roman_string: [u16; 12usize],
                pub upper_roman_string: [u16; 12usize],
                pub tamil_string: [u16; 6usize],
                pub telugu_string: [u16; 7usize],
                pub thai_string: [u16; 5usize],
                pub tibetan_string: [u16; 8usize],
                pub lower_alpha_string: [u16; 12usize],
                pub lower_latin_string: [u16; 12usize],
                pub upper_alpha_string: [u16; 12usize],
                pub upper_latin_string: [u16; 12usize],
                pub cjk_heavenly_stem_string: [u16; 18usize],
                pub cjk_earthly_branch_string: [u16; 19usize],
                pub lower_greek_string: [u16; 12usize],
                pub hiragana_string: [u16; 9usize],
                pub hiragana_iroha_string: [u16; 15usize],
                pub katakana_string: [u16; 9usize],
                pub katakana_iroha_string: [u16; 15usize],
                pub cjk_ideographic_string: [u16; 16usize],
                pub _moz_arabic_indic_string: [u16; 18usize],
                pub _moz_persian_string: [u16; 13usize],
                pub _moz_urdu_string: [u16; 10usize],
                pub _moz_devanagari_string: [u16; 16usize],
                pub _moz_bengali_string: [u16; 13usize],
                pub _moz_gurmukhi_string: [u16; 14usize],
                pub _moz_gujarati_string: [u16; 14usize],
                pub _moz_oriya_string: [u16; 11usize],
                pub _moz_tamil_string: [u16; 11usize],
                pub _moz_telugu_string: [u16; 12usize],
                pub _moz_kannada_string: [u16; 13usize],
                pub _moz_malayalam_string: [u16; 15usize],
                pub _moz_thai_string: [u16; 10usize],
                pub _moz_lao_string: [u16; 9usize],
                pub _moz_myanmar_string: [u16; 13usize],
                pub _moz_khmer_string: [u16; 11usize],
                pub _moz_cjk_heavenly_stem_string: [u16; 23usize],
                pub _moz_cjk_earthly_branch_string: [u16; 24usize],
                pub _moz_hangul_string: [u16; 12usize],
                pub _moz_hangul_consonant_string: [u16; 22usize],
                pub _moz_ethiopic_halehame_string: [u16; 23usize],
                pub _moz_ethiopic_halehame_am_string: [u16; 26usize],
                pub _moz_ethiopic_halehame_ti_er_string: [u16; 29usize],
                pub _moz_ethiopic_halehame_ti_et_string: [u16; 29usize],
                pub _moz_trad_chinese_informal_string: [u16; 27usize],
                pub _moz_trad_chinese_formal_string: [u16; 25usize],
                pub _moz_simp_chinese_informal_string: [u16; 27usize],
                pub _moz_simp_chinese_formal_string: [u16; 25usize],
                pub _moz_japanese_informal_string: [u16; 23usize],
                pub _moz_japanese_formal_string: [u16; 21usize],
                pub _moz_ethiopic_numeric_string: [u16; 22usize],
                pub cdataTagName_string: [u16; 15usize],
                pub commentTagName_string: [u16; 9usize],
                pub documentNodeName_string: [u16; 10usize],
                pub documentFragmentNodeName_string: [u16; 19usize],
                pub documentTypeNodeName_string: [u16; 15usize],
                pub processingInstructionTagName_string: [u16; 24usize],
                pub textTagName_string: [u16; 6usize],
                pub placeholderFrame_string: [u16; 17usize],
                pub onloadend_string: [u16; 10usize],
                pub onloadstart_string: [u16; 12usize],
                pub onprogress_string: [u16; 11usize],
                pub onsuspend_string: [u16; 10usize],
                pub onemptied_string: [u16; 10usize],
                pub onstalled_string: [u16; 10usize],
                pub onplay_string: [u16; 7usize],
                pub onpause_string: [u16; 8usize],
                pub onloadedmetadata_string: [u16; 17usize],
                pub onloadeddata_string: [u16; 13usize],
                pub onwaiting_string: [u16; 10usize],
                pub onplaying_string: [u16; 10usize],
                pub oncanplay_string: [u16; 10usize],
                pub oncanplaythrough_string: [u16; 17usize],
                pub onseeking_string: [u16; 10usize],
                pub onseeked_string: [u16; 9usize],
                pub ontimeout_string: [u16; 10usize],
                pub ontimeupdate_string: [u16; 13usize],
                pub onended_string: [u16; 8usize],
                pub onformdata_string: [u16; 11usize],
                pub onratechange_string: [u16; 13usize],
                pub ondurationchange_string: [u16; 17usize],
                pub onvolumechange_string: [u16; 15usize],
                pub onaddtrack_string: [u16; 11usize],
                pub oncontrollerchange_string: [u16; 19usize],
                pub oncuechange_string: [u16; 12usize],
                pub onenter_string: [u16; 8usize],
                pub onexit_string: [u16; 7usize],
                pub onencrypted_string: [u16; 12usize],
                pub onwaitingforkey_string: [u16; 16usize],
                pub onkeystatuseschange_string: [u16; 20usize],
                pub onremovetrack_string: [u16; 14usize],
                pub loadstart_string: [u16; 10usize],
                pub suspend_string: [u16; 8usize],
                pub emptied_string: [u16; 8usize],
                pub play_string: [u16; 5usize],
                pub pause_string: [u16; 6usize],
                pub loadedmetadata_string: [u16; 15usize],
                pub loadeddata_string: [u16; 11usize],
                pub waiting_string: [u16; 8usize],
                pub playing_string: [u16; 8usize],
                pub timeupdate_string: [u16; 11usize],
                pub canplay_string: [u16; 8usize],
                pub canplaythrough_string: [u16; 15usize],
                pub ondataavailable_string: [u16; 16usize],
                pub onwarning_string: [u16; 10usize],
                pub onstart_string: [u16; 8usize],
                pub onstop_string: [u16; 7usize],
                pub onphoto_string: [u16; 8usize],
                pub ongamepadbuttondown_string: [u16; 20usize],
                pub ongamepadbuttonup_string: [u16; 18usize],
                pub ongamepadaxismove_string: [u16; 18usize],
                pub ongamepadconnected_string: [u16; 19usize],
                pub ongamepaddisconnected_string: [u16; 22usize],
                pub onfetch_string: [u16; 8usize],
                pub afterPseudoProperty_string: [u16; 20usize],
                pub beforePseudoProperty_string: [u16; 21usize],
                pub cssPseudoElementBeforeProperty_string: [u16; 31usize],
                pub cssPseudoElementAfterProperty_string: [u16; 30usize],
                pub cssPseudoElementMarkerProperty_string: [u16; 31usize],
                pub genConInitializerProperty_string: [u16; 18usize],
                pub labelMouseDownPtProperty_string: [u16; 25usize],
                pub lockedStyleStates_string: [u16; 18usize],
                pub apzCallbackTransform_string: [u16; 21usize],
                pub apzDisabled_string: [u16; 12usize],
                pub restylableAnonymousNode_string: [u16; 24usize],
                pub docLevelNativeAnonymousContent_string: [u16; 31usize],
                pub paintRequestTime_string: [u16; 17usize],
                pub pseudoProperty_string: [u16; 15usize],
                pub manualNACProperty_string: [u16; 18usize],
                pub markerPseudoProperty_string: [u16; 21usize],
                pub Japanese_string: [u16; 3usize],
                pub Chinese_string: [u16; 6usize],
                pub Taiwanese_string: [u16; 6usize],
                pub HongKongChinese_string: [u16; 6usize],
                pub Unicode_string: [u16; 10usize],
                pub ko_string: [u16; 3usize],
                pub zh_cn_string: [u16; 6usize],
                pub zh_tw_string: [u16; 6usize],
                pub x_cyrillic_string: [u16; 11usize],
                pub he_string: [u16; 3usize],
                pub ar_string: [u16; 3usize],
                pub x_devanagari_string: [u16; 13usize],
                pub x_tamil_string: [u16; 8usize],
                pub x_armn_string: [u16; 7usize],
                pub x_beng_string: [u16; 7usize],
                pub x_cans_string: [u16; 7usize],
                pub x_ethi_string: [u16; 7usize],
                pub x_geor_string: [u16; 7usize],
                pub x_gujr_string: [u16; 7usize],
                pub x_guru_string: [u16; 7usize],
                pub x_khmr_string: [u16; 7usize],
                pub x_knda_string: [u16; 7usize],
                pub x_mlym_string: [u16; 7usize],
                pub x_orya_string: [u16; 7usize],
                pub x_sinh_string: [u16; 7usize],
                pub x_telu_string: [u16; 7usize],
                pub x_tibt_string: [u16; 7usize],
                pub az_string: [u16; 3usize],
                pub ba_string: [u16; 3usize],
                pub crh_string: [u16; 4usize],
                pub ga_string: [u16; 3usize],
                pub nl_string: [u16; 3usize],
                pub x_math_string: [u16; 7usize],
                pub zh_string: [u16; 3usize],
                pub TypingTxnName_string: [u16; 7usize],
                pub IMETxnName_string: [u16; 4usize],
                pub DeleteTxnName_string: [u16; 9usize],
                pub serif_string: [u16; 6usize],
                pub sans_serif_string: [u16; 11usize],
                pub cursive_string: [u16; 8usize],
                pub fantasy_string: [u16; 8usize],
                pub monospace_string: [u16; 10usize],
                pub mozfixed_string: [u16; 11usize],
                pub moz_fixed_pos_containing_block_string: [u16; 32usize],
                pub light_string: [u16; 6usize],
                pub dark_string: [u16; 5usize],
                pub RemoteId_string: [u16; 11usize],
                pub RemoteType_string: [u16; 11usize],
                pub DisplayPort_string: [u16; 13usize],
                pub DisplayPortMargins_string: [u16; 20usize],
                pub DisplayPortBase_string: [u16; 17usize],
                pub MinimalDisplayPort_string: [u16; 20usize],
                pub forceMousewheelAutodir_string: [u16; 26usize],
                pub forceMousewheelAutodirHonourRoot_string: [u16; 37usize],
                pub forcemessagemanager_string: [u16; 20usize],
                pub initialBrowsingContextGroupId_string: [u16; 30usize],
                pub manualactiveness_string: [u16; 17usize],
                pub _moz_bool_pref_string: [u16; 15usize],
                pub _moz_overlay_scrollbars_string: [u16; 24usize],
                pub _moz_overlay_scrollbar_fade_duration_string: [u16; 37usize],
                pub _moz_windows_accent_color_in_titlebar_string: [u16; 38usize],
                pub _moz_windows_accent_color_in_tabs_string: [u16; 34usize],
                pub _moz_windows_mica_string: [u16; 18usize],
                pub _moz_windows_mica_popups_string: [u16; 25usize],
                pub _moz_mac_big_sur_theme_string: [u16; 23usize],
                pub _moz_mac_rtl_string: [u16; 13usize],
                pub _moz_mac_titlebar_height_string: [u16; 25usize],
                pub _moz_platform_string: [u16; 14usize],
                pub _moz_gtk_theme_family_string: [u16; 22usize],
                pub _moz_menubar_drag_string: [u16; 18usize],
                pub _moz_device_pixel_ratio_string: [u16; 24usize],
                pub _moz_device_orientation_string: [u16; 24usize],
                pub _moz_is_resource_document_string: [u16; 26usize],
                pub _moz_swipe_animation_enabled_string: [u16; 29usize],
                pub _moz_gtk_csd_available_string: [u16; 23usize],
                pub _moz_gtk_csd_transparency_available_string: [u16; 36usize],
                pub _moz_gtk_csd_titlebar_radius_string: [u16; 29usize],
                pub _moz_gtk_csd_tooltip_radius_string: [u16; 28usize],
                pub _moz_gtk_csd_titlebar_button_spacing_string: [u16; 37usize],
                pub _moz_gtk_csd_minimize_button_string: [u16; 29usize],
                pub _moz_gtk_csd_minimize_button_position_string: [u16; 38usize],
                pub _moz_gtk_csd_maximize_button_string: [u16; 29usize],
                pub _moz_gtk_csd_maximize_button_position_string: [u16; 38usize],
                pub _moz_gtk_csd_close_button_string: [u16; 26usize],
                pub _moz_gtk_csd_close_button_position_string: [u16; 35usize],
                pub _moz_gtk_csd_reversed_placement_string: [u16; 32usize],
                pub _moz_gtk_csd_rounded_bottom_corners_string: [u16; 36usize],
                pub _moz_content_prefers_color_scheme_string: [u16; 34usize],
                pub _moz_content_preferred_color_scheme_string: [u16; 36usize],
                pub _moz_system_dark_theme_string: [u16; 23usize],
                pub _moz_panel_animations_string: [u16; 22usize],
                pub Back_string: [u16; 5usize],
                pub Forward_string: [u16; 8usize],
                pub Reload_string: [u16; 7usize],
                pub Stop_string: [u16; 5usize],
                pub Search_string: [u16; 7usize],
                pub Bookmarks_string: [u16; 10usize],
                pub Home_string: [u16; 5usize],
                pub NextTrack_string: [u16; 10usize],
                pub PreviousTrack_string: [u16; 14usize],
                pub MediaStop_string: [u16; 10usize],
                pub PlayPause_string: [u16; 10usize],
                pub New_string: [u16; 4usize],
                pub Open_string: [u16; 5usize],
                pub Close_string: [u16; 6usize],
                pub Save_string: [u16; 5usize],
                pub Find_string: [u16; 5usize],
                pub Help_string: [u16; 5usize],
                pub Print_string: [u16; 6usize],
                pub SendMail_string: [u16; 9usize],
                pub ForwardMail_string: [u16; 12usize],
                pub ReplyToMail_string: [u16; 12usize],
                pub alert_string: [u16; 6usize],
                pub alertdialog_string: [u16; 12usize],
                pub application_string: [u16; 12usize],
                pub aria_colcount_string: [u16; 14usize],
                pub aria_colindex_string: [u16; 14usize],
                pub aria_colindextext_string: [u16; 18usize],
                pub aria_colspan_string: [u16; 13usize],
                pub aria_details_string: [u16; 13usize],
                pub aria_errormessage_string: [u16; 18usize],
                pub aria_grabbed_string: [u16; 13usize],
                pub aria_keyshortcuts_string: [u16; 18usize],
                pub aria_label_string: [u16; 11usize],
                pub aria_modal_string: [u16; 11usize],
                pub aria_orientation_string: [u16; 17usize],
                pub aria_placeholder_string: [u16; 17usize],
                pub aria_roledescription_string: [u16; 21usize],
                pub aria_rowcount_string: [u16; 14usize],
                pub aria_rowindex_string: [u16; 14usize],
                pub aria_rowindextext_string: [u16; 18usize],
                pub aria_rowspan_string: [u16; 13usize],
                pub aria_valuetext_string: [u16; 15usize],
                pub assertive_string: [u16; 10usize],
                pub auto_generated_string: [u16; 15usize],
                pub banner_string: [u16; 7usize],
                pub checkable_string: [u16; 10usize],
                pub columnheader_string: [u16; 13usize],
                pub complementary_string: [u16; 14usize],
                pub containerAtomic_string: [u16; 17usize],
                pub containerBusy_string: [u16; 15usize],
                pub containerLive_string: [u16; 15usize],
                pub containerLiveRole_string: [u16; 20usize],
                pub containerRelevant_string: [u16; 19usize],
                pub contentinfo_string: [u16; 12usize],
                pub cycles_string: [u16; 7usize],
                pub datatable_string: [u16; 10usize],
                pub feed_string: [u16; 5usize],
                pub grammar_string: [u16; 8usize],
                pub gridcell_string: [u16; 9usize],
                pub heading_string: [u16; 8usize],
                pub inlinevalue_string: [u16; 7usize],
                pub inline_size_string: [u16; 12usize],
                pub invalid_string: [u16; 8usize],
                pub lineNumber_string: [u16; 12usize],
                pub menuitemcheckbox_string: [u16; 17usize],
                pub menuitemradio_string: [u16; 14usize],
                pub navigation_string: [u16; 11usize],
                pub polite_string: [u16; 7usize],
                pub posinset_string: [u16; 9usize],
                pub presentation_string: [u16; 13usize],
                pub progressbar_string: [u16; 12usize],
                pub region_string: [u16; 7usize],
                pub rowgroup_string: [u16; 9usize],
                pub rowheader_string: [u16; 10usize],
                pub search_string: [u16; 7usize],
                pub searchbox_string: [u16; 10usize],
                pub setsize_string: [u16; 8usize],
                pub spelling_string: [u16; 9usize],
                pub spinbutton_string: [u16; 11usize],
                pub status_string: [u16; 7usize],
                pub tableCellIndex_string: [u16; 17usize],
                pub tablist_string: [u16; 8usize],
                pub textIndent_string: [u16; 12usize],
                pub textInputType_string: [u16; 16usize],
                pub textLineThroughColor_string: [u16; 24usize],
                pub textLineThroughStyle_string: [u16; 24usize],
                pub textPosition_string: [u16; 14usize],
                pub textUnderlineColor_string: [u16; 21usize],
                pub textUnderlineStyle_string: [u16; 21usize],
                pub timer_string: [u16; 6usize],
                pub toolbarname_string: [u16; 12usize],
                pub toolbarseparator_string: [u16; 17usize],
                pub toolbarspacer_string: [u16; 14usize],
                pub toolbarspring_string: [u16; 14usize],
                pub treegrid_string: [u16; 9usize],
                pub _undefined_string: [u16; 10usize],
                pub xmlroles_string: [u16; 10usize],
                pub close_fence_string: [u16; 12usize],
                pub denominator_string: [u16; 12usize],
                pub numerator_string: [u16; 10usize],
                pub open_fence_string: [u16; 11usize],
                pub overscript_string: [u16; 11usize],
                pub presubscript_string: [u16; 13usize],
                pub presuperscript_string: [u16; 15usize],
                pub root_index_string: [u16; 11usize],
                pub subscript_string: [u16; 10usize],
                pub superscript_string: [u16; 12usize],
                pub underscript_string: [u16; 12usize],
                pub onaudiostart_string: [u16; 13usize],
                pub onaudioend_string: [u16; 11usize],
                pub onsoundstart_string: [u16; 13usize],
                pub onsoundend_string: [u16; 11usize],
                pub onspeechstart_string: [u16; 14usize],
                pub onspeechend_string: [u16; 12usize],
                pub onresult_string: [u16; 9usize],
                pub onnomatch_string: [u16; 10usize],
                pub onresume_string: [u16; 9usize],
                pub onmark_string: [u16; 7usize],
                pub onboundary_string: [u16; 11usize],
                pub onactivated_string: [u16; 12usize],
                pub ondeactivated_string: [u16; 14usize],
                pub onmetadatachange_string: [u16; 17usize],
                pub onplaybackstatechange_string: [u16; 22usize],
                pub onpositionstatechange_string: [u16; 22usize],
                pub onsupportedkeyschange_string: [u16; 22usize],
                pub mathml_legacy_mathvariant_attribute_disabled_string: [u16; 45usize],
                pub layout_css_always_underline_links_string: [u16; 34usize],
                pub layout_css_android_pip_enabled_string: [u16; 31usize],
                pub layout_css_cached_scrollbar_styles_enabled_string: [u16; 43usize],
                pub layout_testing_scrollbars_always_hidden_string: [u16; 40usize],
                pub usercontextid_string: [u16; 14usize],
                pub geckoViewSessionContextId_string: [u16; 26usize],
                pub nsuri_xmlns_string: [u16; 30usize],
                pub nsuri_xml_string: [u16; 37usize],
                pub nsuri_xhtml_string: [u16; 29usize],
                pub nsuri_xlink_string: [u16; 29usize],
                pub nsuri_xslt_string: [u16; 37usize],
                pub nsuri_mathml_string: [u16; 35usize],
                pub nsuri_rdf_string: [u16; 44usize],
                pub nsuri_xul_string: [u16; 62usize],
                pub nsuri_svg_string: [u16; 27usize],
                pub nsuri_parsererror_string: [u16; 53usize],
                pub onsourceopen_string: [u16; 13usize],
                pub onsourceended_string: [u16; 14usize],
                pub onsourceclose_string: [u16; 14usize],
                pub onupdatestart_string: [u16; 14usize],
                pub onupdate_string: [u16; 9usize],
                pub onupdateend_string: [u16; 12usize],
                pub onaddsourcebuffer_string: [u16; 18usize],
                pub onremovesourcebuffer_string: [u16; 21usize],
                pub ondequeue_string: [u16; 10usize],
                pub about_string: [u16; 6usize],
                pub ID_string: [u16; 3usize],
                pub nodeID_string: [u16; 7usize],
                pub aboutEach_string: [u16; 10usize],
                pub resource_string: [u16; 9usize],
                pub RDF_string: [u16; 4usize],
                pub Description_string: [u16; 12usize],
                pub Bag_string: [u16; 4usize],
                pub Seq_string: [u16; 4usize],
                pub Alt_string: [u16; 4usize],
                pub parseType_string: [u16; 10usize],
                pub DirectoryService_CurrentProcess_string: [u16; 10usize],
                pub DirectoryService_GRE_Directory_string: [u16; 5usize],
                pub DirectoryService_GRE_BinDirectory_string: [u16; 8usize],
                pub DirectoryService_OS_TemporaryDirectory_string: [u16; 5usize],
                pub DirectoryService_OS_CurrentProcessDirectory_string: [u16; 9usize],
                pub DirectoryService_OS_CurrentWorkingDirectory_string: [u16; 9usize],
                pub DirectoryService_OS_SystemConfigDir_string: [u16; 9usize],
                pub DirectoryService_OS_DesktopDirectory_string: [u16; 5usize],
                pub DirectoryService_OS_DocumentsDirectory_string: [u16; 5usize],
                pub DirectoryService_InitCurrentProcess_dummy_string: [u16; 8usize],
                pub DirectoryService_SystemDirectory_string: [u16; 5usize],
                pub DirectoryService_UserLibDirectory_string: [u16; 8usize],
                pub DirectoryService_DefaultDownloadDirectory_string: [u16; 10usize],
                pub DirectoryService_LocalApplicationsDirectory_string: [u16; 7usize],
                pub DirectoryService_UserPreferencesDirectory_string: [u16; 8usize],
                pub DirectoryService_PictureDocumentsDirectory_string: [u16; 4usize],
                pub DirectoryService_DefaultScreenshotDirectory_string: [u16; 9usize],
                pub DirectoryService_WindowsDirectory_string: [u16; 5usize],
                pub DirectoryService_WindowsProgramFiles_string: [u16; 6usize],
                pub DirectoryService_Programs_string: [u16; 6usize],
                pub DirectoryService_Favorites_string: [u16; 5usize],
                pub DirectoryService_Appdata_string: [u16; 8usize],
                pub DirectoryService_LocalAppdata_string: [u16; 13usize],
                pub DirectoryService_WinCookiesDirectory_string: [u16; 6usize],
                pub _ua_view_transition_fade_out_string: [u16; 29usize],
                pub _ua_view_transition_fade_in_string: [u16; 28usize],
                pub _ua_mix_blend_mode_plus_lighter_string: [u16; 32usize],
                pub PseudoElement_after_string: [u16; 7usize],
                pub PseudoElement_before_string: [u16; 8usize],
                pub PseudoElement_marker_string: [u16; 8usize],
                pub PseudoElement_backdrop_string: [u16; 10usize],
                pub PseudoElement_cue_string: [u16; 5usize],
                pub PseudoElement_firstLetter_string: [u16; 14usize],
                pub PseudoElement_firstLine_string: [u16; 12usize],
                pub PseudoElement_highlight_string: [u16; 11usize],
                pub PseudoElement_selection_string: [u16; 11usize],
                pub PseudoElement_targetText_string: [u16; 13usize],
                pub PseudoElement_viewTransition_string: [u16; 17usize],
                pub PseudoElement_viewTransitionGroup_string: [u16; 23usize],
                pub PseudoElement_viewTransitionImagePair_string: [u16; 28usize],
                pub PseudoElement_viewTransitionOld_string: [u16; 21usize],
                pub PseudoElement_viewTransitionNew_string: [u16; 21usize],
                pub PseudoElement_mozSnapshotContainingBlock_string: [u16; 32usize],
                pub PseudoElement_mozNumberSpinBox_string: [u16; 22usize],
                pub PseudoElement_mozNumberSpinUp_string: [u16; 21usize],
                pub PseudoElement_mozNumberSpinDown_string: [u16; 23usize],
                pub PseudoElement_mozSearchClearButton_string: [u16; 26usize],
                pub PseudoElement_mozProgressBar_string: [u16; 19usize],
                pub PseudoElement_mozRangeTrack_string: [u16; 18usize],
                pub PseudoElement_mozRangeProgress_string: [u16; 21usize],
                pub PseudoElement_mozRangeThumb_string: [u16; 18usize],
                pub PseudoElement_mozMeterBar_string: [u16; 16usize],
                pub PseudoElement_placeholder_string: [u16; 13usize],
                pub PseudoElement_mozColorSwatch_string: [u16; 19usize],
                pub PseudoElement_mozTextControlEditingRoot_string: [u16; 32usize],
                pub PseudoElement_mozTextControlPreview_string: [u16; 27usize],
                pub PseudoElement_mozReveal_string: [u16; 13usize],
                pub PseudoElement_fileSelectorButton_string: [u16; 22usize],
                pub PseudoElement_sliderTrack_string: [u16; 14usize],
                pub PseudoElement_sliderThumb_string: [u16; 14usize],
                pub PseudoElement_sliderFill_string: [u16; 13usize],
                pub PseudoElement_detailsContent_string: [u16; 17usize],
                pub AnonBox_oofPlaceholder_string: [u16; 22usize],
                pub AnonBox_horizontalFramesetBorder_string: [u16; 23usize],
                pub AnonBox_verticalFramesetBorder_string: [u16; 23usize],
                pub AnonBox_framesetBlank_string: [u16; 21usize],
                pub AnonBox_tableColGroup_string: [u16; 25usize],
                pub AnonBox_tableCol_string: [u16; 19usize],
                pub AnonBox_page_string: [u16; 11usize],
                pub AnonBox_pageBreak_string: [u16; 17usize],
                pub AnonBox_pageContent_string: [u16; 19usize],
                pub AnonBox_printedSheet_string: [u16; 20usize],
                pub AnonBox_columnSpanWrapper_string: [u16; 26usize],
                pub AnonBox_mozText_string: [u16; 11usize],
                pub AnonBox_firstLetterContinuation_string: [u16; 32usize],
                pub AnonBox_mozBlockInsideInlineWrapper_string: [u16; 34usize],
                pub AnonBox_mozMathMLAnonymousBlock_string: [u16; 29usize],
                pub AnonBox_mozLineFrame_string: [u16; 17usize],
                pub AnonBox_cellContent_string: [u16; 19usize],
                pub AnonBox_dropDownList_string: [u16; 20usize],
                pub AnonBox_fieldsetContent_string: [u16; 23usize],
                pub AnonBox_htmlCanvasContent_string: [u16; 26usize],
                pub AnonBox_inlineTable_string: [u16; 19usize],
                pub AnonBox_table_string: [u16; 12usize],
                pub AnonBox_tableCell_string: [u16; 17usize],
                pub AnonBox_tableWrapper_string: [u16; 20usize],
                pub AnonBox_tableRowGroup_string: [u16; 22usize],
                pub AnonBox_tableRow_string: [u16; 16usize],
                pub AnonBox_canvas_string: [u16; 13usize],
                pub AnonBox_pageSequence_string: [u16; 20usize],
                pub AnonBox_scrolledContent_string: [u16; 23usize],
                pub AnonBox_scrolledCanvas_string: [u16; 22usize],
                pub AnonBox_columnSet_string: [u16; 17usize],
                pub AnonBox_columnContent_string: [u16; 21usize],
                pub AnonBox_viewport_string: [u16; 15usize],
                pub AnonBox_viewportScroll_string: [u16; 22usize],
                pub AnonBox_anonymousItem_string: [u16; 21usize],
                pub AnonBox_blockRubyContent_string: [u16; 25usize],
                pub AnonBox_ruby_string: [u16; 11usize],
                pub AnonBox_rubyBase_string: [u16; 16usize],
                pub AnonBox_rubyBaseContainer_string: [u16; 26usize],
                pub AnonBox_rubyText_string: [u16; 16usize],
                pub AnonBox_rubyTextContainer_string: [u16; 26usize],
                pub AnonBox_mozTreeColumn_string: [u16; 18usize],
                pub AnonBox_mozTreeRow_string: [u16; 15usize],
                pub AnonBox_mozTreeSeparator_string: [u16; 21usize],
                pub AnonBox_mozTreeCell_string: [u16; 16usize],
                pub AnonBox_mozTreeIndentation_string: [u16; 23usize],
                pub AnonBox_mozTreeLine_string: [u16; 16usize],
                pub AnonBox_mozTreeTwisty_string: [u16; 18usize],
                pub AnonBox_mozTreeImage_string: [u16; 17usize],
                pub AnonBox_mozTreeCellText_string: [u16; 21usize],
                pub AnonBox_mozTreeCheckbox_string: [u16; 20usize],
                pub AnonBox_mozTreeDropFeedback_string: [u16; 25usize],
                pub AnonBox_mozSVGMarkerAnonChild_string: [u16; 28usize],
                pub AnonBox_mozSVGOuterSVGAnonChild_string: [u16; 31usize],
                pub AnonBox_mozSVGForeignContent_string: [u16; 26usize],
                pub AnonBox_mozSVGText_string: [u16; 15usize],
                pub xlink_string: [u16; 6usize],
                pub xml_space_string: [u16; 10usize],
                pub xml_lang_string: [u16; 9usize],
                pub aria_grab_string: [u16; 10usize],
                pub aria_channel_string: [u16; 13usize],
                pub aria_secret_string: [u16; 12usize],
                pub aria_templateid_string: [u16; 16usize],
                pub aria_datatype_string: [u16; 14usize],
                pub local_string: [u16; 6usize],
                pub xchannelselector_string: [u16; 17usize],
                pub ychannelselector_string: [u16; 17usize],
                pub enable_background_string: [u16; 18usize],
                pub calcmode_string: [u16; 9usize],
                pub specularexponent_string: [u16; 17usize],
                pub specularconstant_string: [u16; 17usize],
                pub gradienttransform_string: [u16; 18usize],
                pub gradientunits_string: [u16; 14usize],
                pub rendering_intent_string: [u16; 17usize],
                pub shadowrootmode_string: [u16; 15usize],
                pub shadowrootclonable_string: [u16; 19usize],
                pub shadowrootserializable_string: [u16; 23usize],
                pub stddeviation_string: [u16; 13usize],
                pub shadowrootdelegatesfocus_string: [u16; 25usize],
                pub basefrequency_string: [u16; 14usize],
                pub baseprofile_string: [u16; 12usize],
                pub baseProfile_string: [u16; 12usize],
                pub edgemode_string: [u16; 9usize],
                pub repeatcount_string: [u16; 12usize],
                pub repeatdur_string: [u16; 10usize],
                pub spreadmethod_string: [u16; 13usize],
                pub diffuseconstant_string: [u16; 16usize],
                pub surfacescale_string: [u16; 13usize],
                pub lengthadjust_string: [u16; 13usize],
                pub origin_string: [u16; 7usize],
                pub targetx_string: [u16; 8usize],
                pub targety_string: [u16; 8usize],
                pub pathlength_string: [u16; 11usize],
                pub definitionurl_string: [u16; 14usize],
                pub limitingconeangle_string: [u16; 18usize],
                pub markerheight_string: [u16; 13usize],
                pub markerwidth_string: [u16; 12usize],
                pub maskunits_string: [u16; 10usize],
                pub markerunits_string: [u16; 12usize],
                pub maskcontentunits_string: [u16; 17usize],
                pub tablevalues_string: [u16; 12usize],
                pub primitiveunits_string: [u16; 15usize],
                pub zoomandpan_string: [u16; 11usize],
                pub kernelmatrix_string: [u16; 13usize],
                pub kerning_string: [u16; 8usize],
                pub kernelunitlength_string: [u16; 17usize],
                pub pointsatx_string: [u16; 10usize],
                pub pointsaty_string: [u16; 10usize],
                pub pointsatz_string: [u16; 10usize],
                pub xlink_href_string: [u16; 11usize],
                pub xlink_title_string: [u16; 12usize],
                pub xlink_role_string: [u16; 11usize],
                pub xlink_arcrole_string: [u16; 14usize],
                pub arcrole_string: [u16; 8usize],
                pub xmlns_xlink_string: [u16; 12usize],
                pub xlink_type_string: [u16; 11usize],
                pub xlink_show_string: [u16; 11usize],
                pub xlink_actuate_string: [u16; 14usize],
                pub autocorrect_string: [u16; 12usize],
                pub color_rendering_string: [u16; 16usize],
                pub numoctaves_string: [u16; 11usize],
                pub onmousewheel_string: [u16; 13usize],
                pub clippathunits_string: [u16; 14usize],
                pub glyph_orientation_vertical_string: [u16; 27usize],
                pub glyph_orientation_horizontal_string: [u16; 29usize],
                pub glyphref_string: [u16; 9usize],
                pub keypoints_string: [u16; 10usize],
                pub attributename_string: [u16; 14usize],
                pub attributetype_string: [u16; 14usize],
                pub startoffset_string: [u16; 12usize],
                pub keysplines_string: [u16; 11usize],
                pub preservealpha_string: [u16; 14usize],
                pub preserveaspectratio_string: [u16; 20usize],
                pub alttext_string: [u16; 8usize],
                pub filterunits_string: [u16; 12usize],
                pub keytimes_string: [u16; 9usize],
                pub patterntransform_string: [u16; 17usize],
                pub patternunits_string: [u16; 13usize],
                pub patterncontentunits_string: [u16; 20usize],
                pub stitchtiles_string: [u16; 12usize],
                pub systemlanguage_string: [u16; 15usize],
                pub textlength_string: [u16; 11usize],
                pub requiredfeatures_string: [u16; 17usize],
                pub requiredextensions_string: [u16; 19usize],
                pub viewtarget_string: [u16; 11usize],
                pub viewbox_string: [u16; 8usize],
                pub refx_string: [u16; 5usize],
                pub refy_string: [u16; 5usize],
                pub fefunca_string: [u16; 8usize],
                pub fefuncb_string: [u16; 8usize],
                pub feblend_string: [u16; 8usize],
                pub feflood_string: [u16; 8usize],
                pub feturbulence_string: [u16; 13usize],
                pub femergenode_string: [u16; 12usize],
                pub feimage_string: [u16; 8usize],
                pub femerge_string: [u16; 8usize],
                pub fetile_string: [u16; 7usize],
                pub fecomposite_string: [u16; 12usize],
                pub altglyphdef_string: [u16; 12usize],
                pub altGlyphDef_string: [u16; 12usize],
                pub fefuncg_string: [u16; 8usize],
                pub fediffuselighting_string: [u16; 18usize],
                pub fespecularlighting_string: [u16; 19usize],
                pub altglyph_string: [u16; 9usize],
                pub altGlyph_string: [u16; 9usize],
                pub clippath_string: [u16; 9usize],
                pub textpath_string: [u16; 9usize],
                pub altglyphitem_string: [u16; 13usize],
                pub altGlyphItem_string: [u16; 13usize],
                pub animatetransform_string: [u16; 17usize],
                pub animatemotion_string: [u16; 14usize],
                pub fedisplacementmap_string: [u16; 18usize],
                pub animatecolor_string: [u16; 13usize],
                pub fefuncr_string: [u16; 8usize],
                pub fecomponenttransfer_string: [u16; 20usize],
                pub fegaussianblur_string: [u16; 15usize],
                pub foreignobject_string: [u16; 14usize],
                pub feoffset_string: [u16; 9usize],
                pub fespotlight_string: [u16; 12usize],
                pub fepointlight_string: [u16; 13usize],
                pub fedistantlight_string: [u16; 15usize],
                pub lineargradient_string: [u16; 15usize],
                pub radialgradient_string: [u16; 15usize],
                pub fedropshadow_string: [u16; 13usize],
                pub fecolormatrix_string: [u16; 14usize],
                pub feconvolvematrix_string: [u16; 17usize],
                pub femorphology_string: [u16; 13usize],
                pub mAtoms: [root::nsStaticAtom; 2653usize],
            }
            pub const GkAtoms_Atoms_SystemPrincipal: root::mozilla::detail::GkAtoms_Atoms = 0;
            pub const GkAtoms_Atoms__empty: root::mozilla::detail::GkAtoms_Atoms = 1;
            pub const GkAtoms_Atoms__0: root::mozilla::detail::GkAtoms_Atoms = 2;
            pub const GkAtoms_Atoms__1: root::mozilla::detail::GkAtoms_Atoms = 3;
            pub const GkAtoms_Atoms_mozframetype: root::mozilla::detail::GkAtoms_Atoms = 4;
            pub const GkAtoms_Atoms__moz_abspos: root::mozilla::detail::GkAtoms_Atoms = 5;
            pub const GkAtoms_Atoms__moz_activated: root::mozilla::detail::GkAtoms_Atoms = 6;
            pub const GkAtoms_Atoms__moz_anonclass: root::mozilla::detail::GkAtoms_Atoms = 7;
            pub const GkAtoms_Atoms__moz_resizing: root::mozilla::detail::GkAtoms_Atoms = 8;
            pub const GkAtoms_Atoms_moztype: root::mozilla::detail::GkAtoms_Atoms = 9;
            pub const GkAtoms_Atoms_mozdirty: root::mozilla::detail::GkAtoms_Atoms = 10;
            pub const GkAtoms_Atoms_mozdisallowselectionprint:
                root::mozilla::detail::GkAtoms_Atoms = 11;
            pub const GkAtoms_Atoms_mozdonotsend: root::mozilla::detail::GkAtoms_Atoms = 12;
            pub const GkAtoms_Atoms_mozfwcontainer: root::mozilla::detail::GkAtoms_Atoms = 13;
            pub const GkAtoms_Atoms_mozgeneratedcontentbefore:
                root::mozilla::detail::GkAtoms_Atoms = 14;
            pub const GkAtoms_Atoms_mozgeneratedcontentafter: root::mozilla::detail::GkAtoms_Atoms =
                15;
            pub const GkAtoms_Atoms_mozgeneratedcontentmarker:
                root::mozilla::detail::GkAtoms_Atoms = 16;
            pub const GkAtoms_Atoms_mozgeneratedcontentimage: root::mozilla::detail::GkAtoms_Atoms =
                17;
            pub const GkAtoms_Atoms_mozquote: root::mozilla::detail::GkAtoms_Atoms = 18;
            pub const GkAtoms_Atoms_mozsignature: root::mozilla::detail::GkAtoms_Atoms = 19;
            pub const GkAtoms_Atoms__moz_bullet_font: root::mozilla::detail::GkAtoms_Atoms = 20;
            pub const GkAtoms_Atoms__moz_is_glyph: root::mozilla::detail::GkAtoms_Atoms = 21;
            pub const GkAtoms_Atoms__moz_in_android_pip_mode: root::mozilla::detail::GkAtoms_Atoms =
                22;
            pub const GkAtoms_Atoms__moz_original_size: root::mozilla::detail::GkAtoms_Atoms = 23;
            pub const GkAtoms_Atoms__moz_print_preview: root::mozilla::detail::GkAtoms_Atoms = 24;
            pub const GkAtoms_Atoms_menuactive: root::mozilla::detail::GkAtoms_Atoms = 25;
            pub const GkAtoms_Atoms__poundDefault: root::mozilla::detail::GkAtoms_Atoms = 26;
            pub const GkAtoms_Atoms__asterisk: root::mozilla::detail::GkAtoms_Atoms = 27;
            pub const GkAtoms_Atoms_a: root::mozilla::detail::GkAtoms_Atoms = 28;
            pub const GkAtoms_Atoms_abbr: root::mozilla::detail::GkAtoms_Atoms = 29;
            pub const GkAtoms_Atoms_abort: root::mozilla::detail::GkAtoms_Atoms = 30;
            pub const GkAtoms_Atoms_above: root::mozilla::detail::GkAtoms_Atoms = 31;
            pub const GkAtoms_Atoms_acceltext: root::mozilla::detail::GkAtoms_Atoms = 32;
            pub const GkAtoms_Atoms_accept: root::mozilla::detail::GkAtoms_Atoms = 33;
            pub const GkAtoms_Atoms_acceptcharset: root::mozilla::detail::GkAtoms_Atoms = 34;
            pub const GkAtoms_Atoms_accessiblenode: root::mozilla::detail::GkAtoms_Atoms = 35;
            pub const GkAtoms_Atoms_accesskey: root::mozilla::detail::GkAtoms_Atoms = 36;
            pub const GkAtoms_Atoms_acronym: root::mozilla::detail::GkAtoms_Atoms = 37;
            pub const GkAtoms_Atoms_action: root::mozilla::detail::GkAtoms_Atoms = 38;
            pub const GkAtoms_Atoms_active: root::mozilla::detail::GkAtoms_Atoms = 39;
            pub const GkAtoms_Atoms_activateontab: root::mozilla::detail::GkAtoms_Atoms = 40;
            pub const GkAtoms_Atoms_actuate: root::mozilla::detail::GkAtoms_Atoms = 41;
            pub const GkAtoms_Atoms_address: root::mozilla::detail::GkAtoms_Atoms = 42;
            pub const GkAtoms_Atoms_adoptedsheetclones: root::mozilla::detail::GkAtoms_Atoms = 43;
            pub const GkAtoms_Atoms_after: root::mozilla::detail::GkAtoms_Atoms = 44;
            pub const GkAtoms_Atoms_align: root::mozilla::detail::GkAtoms_Atoms = 45;
            pub const GkAtoms_Atoms_alink: root::mozilla::detail::GkAtoms_Atoms = 46;
            pub const GkAtoms_Atoms_all: root::mozilla::detail::GkAtoms_Atoms = 47;
            pub const GkAtoms_Atoms_allow: root::mozilla::detail::GkAtoms_Atoms = 48;
            pub const GkAtoms_Atoms_allowdownloads: root::mozilla::detail::GkAtoms_Atoms = 49;
            pub const GkAtoms_Atoms_allowevents: root::mozilla::detail::GkAtoms_Atoms = 50;
            pub const GkAtoms_Atoms_allowforms: root::mozilla::detail::GkAtoms_Atoms = 51;
            pub const GkAtoms_Atoms_allowfullscreen: root::mozilla::detail::GkAtoms_Atoms = 52;
            pub const GkAtoms_Atoms_allowmodals: root::mozilla::detail::GkAtoms_Atoms = 53;
            pub const GkAtoms_Atoms_alloworientationlock: root::mozilla::detail::GkAtoms_Atoms = 54;
            pub const GkAtoms_Atoms_allowpointerlock: root::mozilla::detail::GkAtoms_Atoms = 55;
            pub const GkAtoms_Atoms_allowpopupstoescapesandbox:
                root::mozilla::detail::GkAtoms_Atoms = 56;
            pub const GkAtoms_Atoms_allowpopups: root::mozilla::detail::GkAtoms_Atoms = 57;
            pub const GkAtoms_Atoms_allowpresentation: root::mozilla::detail::GkAtoms_Atoms = 58;
            pub const GkAtoms_Atoms_allowstorageaccessbyuseractivatetion:
                root::mozilla::detail::GkAtoms_Atoms = 59;
            pub const GkAtoms_Atoms_allowsameorigin: root::mozilla::detail::GkAtoms_Atoms = 60;
            pub const GkAtoms_Atoms_allowscripts: root::mozilla::detail::GkAtoms_Atoms = 61;
            pub const GkAtoms_Atoms_allowscriptstoclose: root::mozilla::detail::GkAtoms_Atoms = 62;
            pub const GkAtoms_Atoms_allowtopnavigation: root::mozilla::detail::GkAtoms_Atoms = 63;
            pub const GkAtoms_Atoms_allowtopnavigationbyuseractivation:
                root::mozilla::detail::GkAtoms_Atoms = 64;
            pub const GkAtoms_Atoms_allowtopnavigationcustomprotocols:
                root::mozilla::detail::GkAtoms_Atoms = 65;
            pub const GkAtoms_Atoms_allowuntrusted: root::mozilla::detail::GkAtoms_Atoms = 66;
            pub const GkAtoms_Atoms_alt: root::mozilla::detail::GkAtoms_Atoms = 67;
            pub const GkAtoms_Atoms_alternate: root::mozilla::detail::GkAtoms_Atoms = 68;
            pub const GkAtoms_Atoms_always: root::mozilla::detail::GkAtoms_Atoms = 69;
            pub const GkAtoms_Atoms_ancestor: root::mozilla::detail::GkAtoms_Atoms = 70;
            pub const GkAtoms_Atoms_ancestorOrSelf: root::mozilla::detail::GkAtoms_Atoms = 71;
            pub const GkAtoms_Atoms_anchor: root::mozilla::detail::GkAtoms_Atoms = 72;
            pub const GkAtoms_Atoms__and: root::mozilla::detail::GkAtoms_Atoms = 73;
            pub const GkAtoms_Atoms_animations: root::mozilla::detail::GkAtoms_Atoms = 74;
            pub const GkAtoms_Atoms_anonid: root::mozilla::detail::GkAtoms_Atoms = 75;
            pub const GkAtoms_Atoms_anonlocation: root::mozilla::detail::GkAtoms_Atoms = 76;
            pub const GkAtoms_Atoms_any: root::mozilla::detail::GkAtoms_Atoms = 77;
            pub const GkAtoms_Atoms_any_hover: root::mozilla::detail::GkAtoms_Atoms = 78;
            pub const GkAtoms_Atoms_any_pointer: root::mozilla::detail::GkAtoms_Atoms = 79;
            pub const GkAtoms_Atoms_applet: root::mozilla::detail::GkAtoms_Atoms = 80;
            pub const GkAtoms_Atoms_applyImports: root::mozilla::detail::GkAtoms_Atoms = 81;
            pub const GkAtoms_Atoms_applyTemplates: root::mozilla::detail::GkAtoms_Atoms = 82;
            pub const GkAtoms_Atoms_archive: root::mozilla::detail::GkAtoms_Atoms = 83;
            pub const GkAtoms_Atoms_area: root::mozilla::detail::GkAtoms_Atoms = 84;
            pub const GkAtoms_Atoms_aria: root::mozilla::detail::GkAtoms_Atoms = 85;
            pub const GkAtoms_Atoms_aria_activedescendant: root::mozilla::detail::GkAtoms_Atoms =
                86;
            pub const GkAtoms_Atoms_aria_atomic: root::mozilla::detail::GkAtoms_Atoms = 87;
            pub const GkAtoms_Atoms_aria_autocomplete: root::mozilla::detail::GkAtoms_Atoms = 88;
            pub const GkAtoms_Atoms_aria_braillelabel: root::mozilla::detail::GkAtoms_Atoms = 89;
            pub const GkAtoms_Atoms_aria_brailleroledescription:
                root::mozilla::detail::GkAtoms_Atoms = 90;
            pub const GkAtoms_Atoms_aria_busy: root::mozilla::detail::GkAtoms_Atoms = 91;
            pub const GkAtoms_Atoms_aria_checked: root::mozilla::detail::GkAtoms_Atoms = 92;
            pub const GkAtoms_Atoms_aria_controls: root::mozilla::detail::GkAtoms_Atoms = 93;
            pub const GkAtoms_Atoms_aria_current: root::mozilla::detail::GkAtoms_Atoms = 94;
            pub const GkAtoms_Atoms_aria_describedby: root::mozilla::detail::GkAtoms_Atoms = 95;
            pub const GkAtoms_Atoms_aria_description: root::mozilla::detail::GkAtoms_Atoms = 96;
            pub const GkAtoms_Atoms_aria_disabled: root::mozilla::detail::GkAtoms_Atoms = 97;
            pub const GkAtoms_Atoms_aria_dropeffect: root::mozilla::detail::GkAtoms_Atoms = 98;
            pub const GkAtoms_Atoms_aria_expanded: root::mozilla::detail::GkAtoms_Atoms = 99;
            pub const GkAtoms_Atoms_aria_flowto: root::mozilla::detail::GkAtoms_Atoms = 100;
            pub const GkAtoms_Atoms_aria_haspopup: root::mozilla::detail::GkAtoms_Atoms = 101;
            pub const GkAtoms_Atoms_aria_hidden: root::mozilla::detail::GkAtoms_Atoms = 102;
            pub const GkAtoms_Atoms_aria_invalid: root::mozilla::detail::GkAtoms_Atoms = 103;
            pub const GkAtoms_Atoms_aria_labelledby: root::mozilla::detail::GkAtoms_Atoms = 104;
            pub const GkAtoms_Atoms_aria_level: root::mozilla::detail::GkAtoms_Atoms = 105;
            pub const GkAtoms_Atoms_aria_live: root::mozilla::detail::GkAtoms_Atoms = 106;
            pub const GkAtoms_Atoms_aria_multiline: root::mozilla::detail::GkAtoms_Atoms = 107;
            pub const GkAtoms_Atoms_aria_multiselectable: root::mozilla::detail::GkAtoms_Atoms =
                108;
            pub const GkAtoms_Atoms_aria_owns: root::mozilla::detail::GkAtoms_Atoms = 109;
            pub const GkAtoms_Atoms_aria_posinset: root::mozilla::detail::GkAtoms_Atoms = 110;
            pub const GkAtoms_Atoms_aria_pressed: root::mozilla::detail::GkAtoms_Atoms = 111;
            pub const GkAtoms_Atoms_aria_readonly: root::mozilla::detail::GkAtoms_Atoms = 112;
            pub const GkAtoms_Atoms_aria_relevant: root::mozilla::detail::GkAtoms_Atoms = 113;
            pub const GkAtoms_Atoms_aria_required: root::mozilla::detail::GkAtoms_Atoms = 114;
            pub const GkAtoms_Atoms_aria_selected: root::mozilla::detail::GkAtoms_Atoms = 115;
            pub const GkAtoms_Atoms_aria_setsize: root::mozilla::detail::GkAtoms_Atoms = 116;
            pub const GkAtoms_Atoms_aria_sort: root::mozilla::detail::GkAtoms_Atoms = 117;
            pub const GkAtoms_Atoms_aria_valuemax: root::mozilla::detail::GkAtoms_Atoms = 118;
            pub const GkAtoms_Atoms_aria_valuemin: root::mozilla::detail::GkAtoms_Atoms = 119;
            pub const GkAtoms_Atoms_aria_valuenow: root::mozilla::detail::GkAtoms_Atoms = 120;
            pub const GkAtoms_Atoms_arrow: root::mozilla::detail::GkAtoms_Atoms = 121;
            pub const GkAtoms_Atoms_article: root::mozilla::detail::GkAtoms_Atoms = 122;
            pub const GkAtoms_Atoms_as_: root::mozilla::detail::GkAtoms_Atoms = 123;
            pub const GkAtoms_Atoms_ascending: root::mozilla::detail::GkAtoms_Atoms = 124;
            pub const GkAtoms_Atoms_aside: root::mozilla::detail::GkAtoms_Atoms = 125;
            pub const GkAtoms_Atoms_aspectRatio: root::mozilla::detail::GkAtoms_Atoms = 126;
            pub const GkAtoms_Atoms_async_: root::mozilla::detail::GkAtoms_Atoms = 127;
            pub const GkAtoms_Atoms_attribute: root::mozilla::detail::GkAtoms_Atoms = 128;
            pub const GkAtoms_Atoms_attributes: root::mozilla::detail::GkAtoms_Atoms = 129;
            pub const GkAtoms_Atoms_attributeSet: root::mozilla::detail::GkAtoms_Atoms = 130;
            pub const GkAtoms_Atoms__auto: root::mozilla::detail::GkAtoms_Atoms = 131;
            pub const GkAtoms_Atoms_autocapitalize: root::mozilla::detail::GkAtoms_Atoms = 132;
            pub const GkAtoms_Atoms_autocheck: root::mozilla::detail::GkAtoms_Atoms = 133;
            pub const GkAtoms_Atoms_autocomplete: root::mozilla::detail::GkAtoms_Atoms = 134;
            pub const GkAtoms_Atoms_autocomplete_richlistbox: root::mozilla::detail::GkAtoms_Atoms =
                135;
            pub const GkAtoms_Atoms_autofocus: root::mozilla::detail::GkAtoms_Atoms = 136;
            pub const GkAtoms_Atoms_autoplay: root::mozilla::detail::GkAtoms_Atoms = 137;
            pub const GkAtoms_Atoms_axis: root::mozilla::detail::GkAtoms_Atoms = 138;
            pub const GkAtoms_Atoms_b: root::mozilla::detail::GkAtoms_Atoms = 139;
            pub const GkAtoms_Atoms_background: root::mozilla::detail::GkAtoms_Atoms = 140;
            pub const GkAtoms_Atoms_badge: root::mozilla::detail::GkAtoms_Atoms = 141;
            pub const GkAtoms_Atoms_bar: root::mozilla::detail::GkAtoms_Atoms = 142;
            pub const GkAtoms_Atoms_base: root::mozilla::detail::GkAtoms_Atoms = 143;
            pub const GkAtoms_Atoms_basefont: root::mozilla::detail::GkAtoms_Atoms = 144;
            pub const GkAtoms_Atoms_baseline: root::mozilla::detail::GkAtoms_Atoms = 145;
            pub const GkAtoms_Atoms_bdi: root::mozilla::detail::GkAtoms_Atoms = 146;
            pub const GkAtoms_Atoms_bdo: root::mozilla::detail::GkAtoms_Atoms = 147;
            pub const GkAtoms_Atoms_before: root::mozilla::detail::GkAtoms_Atoms = 148;
            pub const GkAtoms_Atoms_behavior: root::mozilla::detail::GkAtoms_Atoms = 149;
            pub const GkAtoms_Atoms_below: root::mozilla::detail::GkAtoms_Atoms = 150;
            pub const GkAtoms_Atoms_bgcolor: root::mozilla::detail::GkAtoms_Atoms = 151;
            pub const GkAtoms_Atoms_bgsound: root::mozilla::detail::GkAtoms_Atoms = 152;
            pub const GkAtoms_Atoms_big: root::mozilla::detail::GkAtoms_Atoms = 153;
            pub const GkAtoms_Atoms_binding: root::mozilla::detail::GkAtoms_Atoms = 154;
            pub const GkAtoms_Atoms_bindings: root::mozilla::detail::GkAtoms_Atoms = 155;
            pub const GkAtoms_Atoms_bindToUntrustedContent: root::mozilla::detail::GkAtoms_Atoms =
                156;
            pub const GkAtoms_Atoms_black: root::mozilla::detail::GkAtoms_Atoms = 157;
            pub const GkAtoms_Atoms_block: root::mozilla::detail::GkAtoms_Atoms = 158;
            pub const GkAtoms_Atoms_block_size: root::mozilla::detail::GkAtoms_Atoms = 159;
            pub const GkAtoms_Atoms_blocking: root::mozilla::detail::GkAtoms_Atoms = 160;
            pub const GkAtoms_Atoms_blockquote: root::mozilla::detail::GkAtoms_Atoms = 161;
            pub const GkAtoms_Atoms_blur: root::mozilla::detail::GkAtoms_Atoms = 162;
            pub const GkAtoms_Atoms_body: root::mozilla::detail::GkAtoms_Atoms = 163;
            pub const GkAtoms_Atoms_boolean: root::mozilla::detail::GkAtoms_Atoms = 164;
            pub const GkAtoms_Atoms_border: root::mozilla::detail::GkAtoms_Atoms = 165;
            pub const GkAtoms_Atoms_bordercolor: root::mozilla::detail::GkAtoms_Atoms = 166;
            pub const GkAtoms_Atoms_both: root::mozilla::detail::GkAtoms_Atoms = 167;
            pub const GkAtoms_Atoms_bottom: root::mozilla::detail::GkAtoms_Atoms = 168;
            pub const GkAtoms_Atoms_bottomend: root::mozilla::detail::GkAtoms_Atoms = 169;
            pub const GkAtoms_Atoms_bottomstart: root::mozilla::detail::GkAtoms_Atoms = 170;
            pub const GkAtoms_Atoms_bottomleft: root::mozilla::detail::GkAtoms_Atoms = 171;
            pub const GkAtoms_Atoms_bottommargin: root::mozilla::detail::GkAtoms_Atoms = 172;
            pub const GkAtoms_Atoms_bottomright: root::mozilla::detail::GkAtoms_Atoms = 173;
            pub const GkAtoms_Atoms_box_: root::mozilla::detail::GkAtoms_Atoms = 174;
            pub const GkAtoms_Atoms_br: root::mozilla::detail::GkAtoms_Atoms = 175;
            pub const GkAtoms_Atoms_browser: root::mozilla::detail::GkAtoms_Atoms = 176;
            pub const GkAtoms_Atoms_button: root::mozilla::detail::GkAtoms_Atoms = 177;
            pub const GkAtoms_Atoms_callTemplate: root::mozilla::detail::GkAtoms_Atoms = 178;
            pub const GkAtoms_Atoms_canvas: root::mozilla::detail::GkAtoms_Atoms = 179;
            pub const GkAtoms_Atoms_caption: root::mozilla::detail::GkAtoms_Atoms = 180;
            pub const GkAtoms_Atoms_captionBox: root::mozilla::detail::GkAtoms_Atoms = 181;
            pub const GkAtoms_Atoms_capture: root::mozilla::detail::GkAtoms_Atoms = 182;
            pub const GkAtoms_Atoms_caseOrder: root::mozilla::detail::GkAtoms_Atoms = 183;
            pub const GkAtoms_Atoms_cdataSectionElements: root::mozilla::detail::GkAtoms_Atoms =
                184;
            pub const GkAtoms_Atoms_ceiling: root::mozilla::detail::GkAtoms_Atoms = 185;
            pub const GkAtoms_Atoms_cell: root::mozilla::detail::GkAtoms_Atoms = 186;
            pub const GkAtoms_Atoms_cellpadding: root::mozilla::detail::GkAtoms_Atoms = 187;
            pub const GkAtoms_Atoms_cellspacing: root::mozilla::detail::GkAtoms_Atoms = 188;
            pub const GkAtoms_Atoms_center: root::mozilla::detail::GkAtoms_Atoms = 189;
            pub const GkAtoms_Atoms_change: root::mozilla::detail::GkAtoms_Atoms = 190;
            pub const GkAtoms_Atoms__char: root::mozilla::detail::GkAtoms_Atoms = 191;
            pub const GkAtoms_Atoms_characterData: root::mozilla::detail::GkAtoms_Atoms = 192;
            pub const GkAtoms_Atoms_charcode: root::mozilla::detail::GkAtoms_Atoms = 193;
            pub const GkAtoms_Atoms_charoff: root::mozilla::detail::GkAtoms_Atoms = 194;
            pub const GkAtoms_Atoms_charset: root::mozilla::detail::GkAtoms_Atoms = 195;
            pub const GkAtoms_Atoms_checkbox: root::mozilla::detail::GkAtoms_Atoms = 196;
            pub const GkAtoms_Atoms_checkboxLabel: root::mozilla::detail::GkAtoms_Atoms = 197;
            pub const GkAtoms_Atoms_checked: root::mozilla::detail::GkAtoms_Atoms = 198;
            pub const GkAtoms_Atoms_child: root::mozilla::detail::GkAtoms_Atoms = 199;
            pub const GkAtoms_Atoms_children: root::mozilla::detail::GkAtoms_Atoms = 200;
            pub const GkAtoms_Atoms_childList: root::mozilla::detail::GkAtoms_Atoms = 201;
            pub const GkAtoms_Atoms_child_item_count: root::mozilla::detail::GkAtoms_Atoms = 202;
            pub const GkAtoms_Atoms_choose: root::mozilla::detail::GkAtoms_Atoms = 203;
            pub const GkAtoms_Atoms_customtitlebar: root::mozilla::detail::GkAtoms_Atoms = 204;
            pub const GkAtoms_Atoms_exposeToUntrustedContent: root::mozilla::detail::GkAtoms_Atoms =
                205;
            pub const GkAtoms_Atoms_circ: root::mozilla::detail::GkAtoms_Atoms = 206;
            pub const GkAtoms_Atoms_circle: root::mozilla::detail::GkAtoms_Atoms = 207;
            pub const GkAtoms_Atoms_cite: root::mozilla::detail::GkAtoms_Atoms = 208;
            pub const GkAtoms_Atoms__class: root::mozilla::detail::GkAtoms_Atoms = 209;
            pub const GkAtoms_Atoms_classid: root::mozilla::detail::GkAtoms_Atoms = 210;
            pub const GkAtoms_Atoms_clear: root::mozilla::detail::GkAtoms_Atoms = 211;
            pub const GkAtoms_Atoms_click: root::mozilla::detail::GkAtoms_Atoms = 212;
            pub const GkAtoms_Atoms_clickcount: root::mozilla::detail::GkAtoms_Atoms = 213;
            pub const GkAtoms_Atoms_movetoclick: root::mozilla::detail::GkAtoms_Atoms = 214;
            pub const GkAtoms_Atoms_clip: root::mozilla::detail::GkAtoms_Atoms = 215;
            pub const GkAtoms_Atoms_close: root::mozilla::detail::GkAtoms_Atoms = 216;
            pub const GkAtoms_Atoms_closed: root::mozilla::detail::GkAtoms_Atoms = 217;
            pub const GkAtoms_Atoms_closedby: root::mozilla::detail::GkAtoms_Atoms = 218;
            pub const GkAtoms_Atoms_closemenu: root::mozilla::detail::GkAtoms_Atoms = 219;
            pub const GkAtoms_Atoms_code: root::mozilla::detail::GkAtoms_Atoms = 220;
            pub const GkAtoms_Atoms_codebase: root::mozilla::detail::GkAtoms_Atoms = 221;
            pub const GkAtoms_Atoms_codetype: root::mozilla::detail::GkAtoms_Atoms = 222;
            pub const GkAtoms_Atoms_col: root::mozilla::detail::GkAtoms_Atoms = 223;
            pub const GkAtoms_Atoms_colgroup: root::mozilla::detail::GkAtoms_Atoms = 224;
            pub const GkAtoms_Atoms_collapse: root::mozilla::detail::GkAtoms_Atoms = 225;
            pub const GkAtoms_Atoms_collapsed: root::mozilla::detail::GkAtoms_Atoms = 226;
            pub const GkAtoms_Atoms_color: root::mozilla::detail::GkAtoms_Atoms = 227;
            pub const GkAtoms_Atoms_color_gamut: root::mozilla::detail::GkAtoms_Atoms = 228;
            pub const GkAtoms_Atoms_color_index: root::mozilla::detail::GkAtoms_Atoms = 229;
            pub const GkAtoms_Atoms_color_scheme: root::mozilla::detail::GkAtoms_Atoms = 230;
            pub const GkAtoms_Atoms_cols: root::mozilla::detail::GkAtoms_Atoms = 231;
            pub const GkAtoms_Atoms_colspan: root::mozilla::detail::GkAtoms_Atoms = 232;
            pub const GkAtoms_Atoms_combobox: root::mozilla::detail::GkAtoms_Atoms = 233;
            pub const GkAtoms_Atoms_command: root::mozilla::detail::GkAtoms_Atoms = 234;
            pub const GkAtoms_Atoms_commandfor: root::mozilla::detail::GkAtoms_Atoms = 235;
            pub const GkAtoms_Atoms_commandupdater: root::mozilla::detail::GkAtoms_Atoms = 236;
            pub const GkAtoms_Atoms_comment: root::mozilla::detail::GkAtoms_Atoms = 237;
            pub const GkAtoms_Atoms_compact: root::mozilla::detail::GkAtoms_Atoms = 238;
            pub const GkAtoms_Atoms_concat: root::mozilla::detail::GkAtoms_Atoms = 239;
            pub const GkAtoms_Atoms_constructor: root::mozilla::detail::GkAtoms_Atoms = 240;
            pub const GkAtoms_Atoms_consumeoutsideclicks: root::mozilla::detail::GkAtoms_Atoms =
                241;
            pub const GkAtoms_Atoms_container: root::mozilla::detail::GkAtoms_Atoms = 242;
            pub const GkAtoms_Atoms_contains: root::mozilla::detail::GkAtoms_Atoms = 243;
            pub const GkAtoms_Atoms_content: root::mozilla::detail::GkAtoms_Atoms = 244;
            pub const GkAtoms_Atoms_contenteditable: root::mozilla::detail::GkAtoms_Atoms = 245;
            pub const GkAtoms_Atoms_headerContentDisposition: root::mozilla::detail::GkAtoms_Atoms =
                246;
            pub const GkAtoms_Atoms_headerContentLanguage: root::mozilla::detail::GkAtoms_Atoms =
                247;
            pub const GkAtoms_Atoms_contentLocation: root::mozilla::detail::GkAtoms_Atoms = 248;
            pub const GkAtoms_Atoms_headerContentScriptType: root::mozilla::detail::GkAtoms_Atoms =
                249;
            pub const GkAtoms_Atoms_headerContentStyleType: root::mozilla::detail::GkAtoms_Atoms =
                250;
            pub const GkAtoms_Atoms_headerContentType: root::mozilla::detail::GkAtoms_Atoms = 251;
            pub const GkAtoms_Atoms_consumeanchor: root::mozilla::detail::GkAtoms_Atoms = 252;
            pub const GkAtoms_Atoms_context: root::mozilla::detail::GkAtoms_Atoms = 253;
            pub const GkAtoms_Atoms_contextmenu: root::mozilla::detail::GkAtoms_Atoms = 254;
            pub const GkAtoms_Atoms_control: root::mozilla::detail::GkAtoms_Atoms = 255;
            pub const GkAtoms_Atoms_controls: root::mozilla::detail::GkAtoms_Atoms = 256;
            pub const GkAtoms_Atoms_coords: root::mozilla::detail::GkAtoms_Atoms = 257;
            pub const GkAtoms_Atoms_copy: root::mozilla::detail::GkAtoms_Atoms = 258;
            pub const GkAtoms_Atoms_copyOf: root::mozilla::detail::GkAtoms_Atoms = 259;
            pub const GkAtoms_Atoms_count: root::mozilla::detail::GkAtoms_Atoms = 260;
            pub const GkAtoms_Atoms_crop: root::mozilla::detail::GkAtoms_Atoms = 261;
            pub const GkAtoms_Atoms_crossorigin: root::mozilla::detail::GkAtoms_Atoms = 262;
            pub const GkAtoms_Atoms_curpos: root::mozilla::detail::GkAtoms_Atoms = 263;
            pub const GkAtoms_Atoms_current: root::mozilla::detail::GkAtoms_Atoms = 264;
            pub const GkAtoms_Atoms_cutoutregion: root::mozilla::detail::GkAtoms_Atoms = 265;
            pub const GkAtoms_Atoms_cycler: root::mozilla::detail::GkAtoms_Atoms = 266;
            pub const GkAtoms_Atoms_dashed: root::mozilla::detail::GkAtoms_Atoms = 267;
            pub const GkAtoms_Atoms_data: root::mozilla::detail::GkAtoms_Atoms = 268;
            pub const GkAtoms_Atoms_dataAtShortcutkeys: root::mozilla::detail::GkAtoms_Atoms = 269;
            pub const GkAtoms_Atoms_datalist: root::mozilla::detail::GkAtoms_Atoms = 270;
            pub const GkAtoms_Atoms_datal10nid: root::mozilla::detail::GkAtoms_Atoms = 271;
            pub const GkAtoms_Atoms_datal10nargs: root::mozilla::detail::GkAtoms_Atoms = 272;
            pub const GkAtoms_Atoms_datal10nattrs: root::mozilla::detail::GkAtoms_Atoms = 273;
            pub const GkAtoms_Atoms_datal10nname: root::mozilla::detail::GkAtoms_Atoms = 274;
            pub const GkAtoms_Atoms_datal10nsync: root::mozilla::detail::GkAtoms_Atoms = 275;
            pub const GkAtoms_Atoms_dataType: root::mozilla::detail::GkAtoms_Atoms = 276;
            pub const GkAtoms_Atoms_dateTime: root::mozilla::detail::GkAtoms_Atoms = 277;
            pub const GkAtoms_Atoms_date: root::mozilla::detail::GkAtoms_Atoms = 278;
            pub const GkAtoms_Atoms_datetime: root::mozilla::detail::GkAtoms_Atoms = 279;
            pub const GkAtoms_Atoms_datetime_local: root::mozilla::detail::GkAtoms_Atoms = 280;
            pub const GkAtoms_Atoms_datetimeInputBoxWrapper: root::mozilla::detail::GkAtoms_Atoms =
                281;
            pub const GkAtoms_Atoms_dd: root::mozilla::detail::GkAtoms_Atoms = 282;
            pub const GkAtoms_Atoms_decimal: root::mozilla::detail::GkAtoms_Atoms = 283;
            pub const GkAtoms_Atoms_decimalFormat: root::mozilla::detail::GkAtoms_Atoms = 284;
            pub const GkAtoms_Atoms_decimalSeparator: root::mozilla::detail::GkAtoms_Atoms = 285;
            pub const GkAtoms_Atoms_declare: root::mozilla::detail::GkAtoms_Atoms = 286;
            pub const GkAtoms_Atoms_decoderDoctor: root::mozilla::detail::GkAtoms_Atoms = 287;
            pub const GkAtoms_Atoms_decoding: root::mozilla::detail::GkAtoms_Atoms = 288;
            pub const GkAtoms_Atoms_decrement: root::mozilla::detail::GkAtoms_Atoms = 289;
            pub const GkAtoms_Atoms__default: root::mozilla::detail::GkAtoms_Atoms = 290;
            pub const GkAtoms_Atoms_headerDefaultStyle: root::mozilla::detail::GkAtoms_Atoms = 291;
            pub const GkAtoms_Atoms_defer: root::mozilla::detail::GkAtoms_Atoms = 292;
            pub const GkAtoms_Atoms_del: root::mozilla::detail::GkAtoms_Atoms = 293;
            pub const GkAtoms_Atoms_delegatesanchor: root::mozilla::detail::GkAtoms_Atoms = 294;
            pub const GkAtoms_Atoms_deletion: root::mozilla::detail::GkAtoms_Atoms = 295;
            pub const GkAtoms_Atoms_deprecation: root::mozilla::detail::GkAtoms_Atoms = 296;
            pub const GkAtoms_Atoms_descendant: root::mozilla::detail::GkAtoms_Atoms = 297;
            pub const GkAtoms_Atoms_descendantOrSelf: root::mozilla::detail::GkAtoms_Atoms = 298;
            pub const GkAtoms_Atoms_descending: root::mozilla::detail::GkAtoms_Atoms = 299;
            pub const GkAtoms_Atoms_description: root::mozilla::detail::GkAtoms_Atoms = 300;
            pub const GkAtoms_Atoms_destructor: root::mozilla::detail::GkAtoms_Atoms = 301;
            pub const GkAtoms_Atoms_details: root::mozilla::detail::GkAtoms_Atoms = 302;
            pub const GkAtoms_Atoms_deviceAspectRatio: root::mozilla::detail::GkAtoms_Atoms = 303;
            pub const GkAtoms_Atoms_deviceHeight: root::mozilla::detail::GkAtoms_Atoms = 304;
            pub const GkAtoms_Atoms_devicePixelRatio: root::mozilla::detail::GkAtoms_Atoms = 305;
            pub const GkAtoms_Atoms_deviceWidth: root::mozilla::detail::GkAtoms_Atoms = 306;
            pub const GkAtoms_Atoms_dfn: root::mozilla::detail::GkAtoms_Atoms = 307;
            pub const GkAtoms_Atoms_dialog: root::mozilla::detail::GkAtoms_Atoms = 308;
            pub const GkAtoms_Atoms_difference: root::mozilla::detail::GkAtoms_Atoms = 309;
            pub const GkAtoms_Atoms_digit: root::mozilla::detail::GkAtoms_Atoms = 310;
            pub const GkAtoms_Atoms_dir: root::mozilla::detail::GkAtoms_Atoms = 311;
            pub const GkAtoms_Atoms_directory: root::mozilla::detail::GkAtoms_Atoms = 312;
            pub const GkAtoms_Atoms_dirname: root::mozilla::detail::GkAtoms_Atoms = 313;
            pub const GkAtoms_Atoms_disableOutputEscaping: root::mozilla::detail::GkAtoms_Atoms =
                314;
            pub const GkAtoms_Atoms_disabled: root::mozilla::detail::GkAtoms_Atoms = 315;
            pub const GkAtoms_Atoms_disableglobalhistory: root::mozilla::detail::GkAtoms_Atoms =
                316;
            pub const GkAtoms_Atoms_disablehistory: root::mozilla::detail::GkAtoms_Atoms = 317;
            pub const GkAtoms_Atoms_disablefullscreen: root::mozilla::detail::GkAtoms_Atoms = 318;
            pub const GkAtoms_Atoms_disablepictureinpicture: root::mozilla::detail::GkAtoms_Atoms =
                319;
            pub const GkAtoms_Atoms_disclosure_closed: root::mozilla::detail::GkAtoms_Atoms = 320;
            pub const GkAtoms_Atoms_disclosure_open: root::mozilla::detail::GkAtoms_Atoms = 321;
            pub const GkAtoms_Atoms_display: root::mozilla::detail::GkAtoms_Atoms = 322;
            pub const GkAtoms_Atoms_displayMode: root::mozilla::detail::GkAtoms_Atoms = 323;
            pub const GkAtoms_Atoms_distinct: root::mozilla::detail::GkAtoms_Atoms = 324;
            pub const GkAtoms_Atoms_div: root::mozilla::detail::GkAtoms_Atoms = 325;
            pub const GkAtoms_Atoms_dl: root::mozilla::detail::GkAtoms_Atoms = 326;
            pub const GkAtoms_Atoms_docAbstract: root::mozilla::detail::GkAtoms_Atoms = 327;
            pub const GkAtoms_Atoms_docAcknowledgments: root::mozilla::detail::GkAtoms_Atoms = 328;
            pub const GkAtoms_Atoms_docAfterword: root::mozilla::detail::GkAtoms_Atoms = 329;
            pub const GkAtoms_Atoms_docAppendix: root::mozilla::detail::GkAtoms_Atoms = 330;
            pub const GkAtoms_Atoms_docBacklink: root::mozilla::detail::GkAtoms_Atoms = 331;
            pub const GkAtoms_Atoms_docBiblioentry: root::mozilla::detail::GkAtoms_Atoms = 332;
            pub const GkAtoms_Atoms_docBibliography: root::mozilla::detail::GkAtoms_Atoms = 333;
            pub const GkAtoms_Atoms_docBiblioref: root::mozilla::detail::GkAtoms_Atoms = 334;
            pub const GkAtoms_Atoms_docChapter: root::mozilla::detail::GkAtoms_Atoms = 335;
            pub const GkAtoms_Atoms_docColophon: root::mozilla::detail::GkAtoms_Atoms = 336;
            pub const GkAtoms_Atoms_docConclusion: root::mozilla::detail::GkAtoms_Atoms = 337;
            pub const GkAtoms_Atoms_docCover: root::mozilla::detail::GkAtoms_Atoms = 338;
            pub const GkAtoms_Atoms_docCredit: root::mozilla::detail::GkAtoms_Atoms = 339;
            pub const GkAtoms_Atoms_docCredits: root::mozilla::detail::GkAtoms_Atoms = 340;
            pub const GkAtoms_Atoms_docDedication: root::mozilla::detail::GkAtoms_Atoms = 341;
            pub const GkAtoms_Atoms_docEndnote: root::mozilla::detail::GkAtoms_Atoms = 342;
            pub const GkAtoms_Atoms_docEndnotes: root::mozilla::detail::GkAtoms_Atoms = 343;
            pub const GkAtoms_Atoms_docEpigraph: root::mozilla::detail::GkAtoms_Atoms = 344;
            pub const GkAtoms_Atoms_docEpilogue: root::mozilla::detail::GkAtoms_Atoms = 345;
            pub const GkAtoms_Atoms_docErrata: root::mozilla::detail::GkAtoms_Atoms = 346;
            pub const GkAtoms_Atoms_docExample: root::mozilla::detail::GkAtoms_Atoms = 347;
            pub const GkAtoms_Atoms_docFootnote: root::mozilla::detail::GkAtoms_Atoms = 348;
            pub const GkAtoms_Atoms_docForeword: root::mozilla::detail::GkAtoms_Atoms = 349;
            pub const GkAtoms_Atoms_docGlossary: root::mozilla::detail::GkAtoms_Atoms = 350;
            pub const GkAtoms_Atoms_docGlossref: root::mozilla::detail::GkAtoms_Atoms = 351;
            pub const GkAtoms_Atoms_docIndex: root::mozilla::detail::GkAtoms_Atoms = 352;
            pub const GkAtoms_Atoms_docIntroduction: root::mozilla::detail::GkAtoms_Atoms = 353;
            pub const GkAtoms_Atoms_docNoteref: root::mozilla::detail::GkAtoms_Atoms = 354;
            pub const GkAtoms_Atoms_docNotice: root::mozilla::detail::GkAtoms_Atoms = 355;
            pub const GkAtoms_Atoms_docPagebreak: root::mozilla::detail::GkAtoms_Atoms = 356;
            pub const GkAtoms_Atoms_docPagefooter: root::mozilla::detail::GkAtoms_Atoms = 357;
            pub const GkAtoms_Atoms_docPageheader: root::mozilla::detail::GkAtoms_Atoms = 358;
            pub const GkAtoms_Atoms_docPagelist: root::mozilla::detail::GkAtoms_Atoms = 359;
            pub const GkAtoms_Atoms_docPart: root::mozilla::detail::GkAtoms_Atoms = 360;
            pub const GkAtoms_Atoms_docPreface: root::mozilla::detail::GkAtoms_Atoms = 361;
            pub const GkAtoms_Atoms_docPrologue: root::mozilla::detail::GkAtoms_Atoms = 362;
            pub const GkAtoms_Atoms_docPullquote: root::mozilla::detail::GkAtoms_Atoms = 363;
            pub const GkAtoms_Atoms_docQna: root::mozilla::detail::GkAtoms_Atoms = 364;
            pub const GkAtoms_Atoms_docSubtitle: root::mozilla::detail::GkAtoms_Atoms = 365;
            pub const GkAtoms_Atoms_docTip: root::mozilla::detail::GkAtoms_Atoms = 366;
            pub const GkAtoms_Atoms_docToc: root::mozilla::detail::GkAtoms_Atoms = 367;
            pub const GkAtoms_Atoms_doctypePublic: root::mozilla::detail::GkAtoms_Atoms = 368;
            pub const GkAtoms_Atoms_doctypeSystem: root::mozilla::detail::GkAtoms_Atoms = 369;
            pub const GkAtoms_Atoms_document: root::mozilla::detail::GkAtoms_Atoms = 370;
            pub const GkAtoms_Atoms_down: root::mozilla::detail::GkAtoms_Atoms = 371;
            pub const GkAtoms_Atoms_download: root::mozilla::detail::GkAtoms_Atoms = 372;
            pub const GkAtoms_Atoms_drag: root::mozilla::detail::GkAtoms_Atoms = 373;
            pub const GkAtoms_Atoms_draggable: root::mozilla::detail::GkAtoms_Atoms = 374;
            pub const GkAtoms_Atoms_dragging: root::mozilla::detail::GkAtoms_Atoms = 375;
            pub const GkAtoms_Atoms_dragSession: root::mozilla::detail::GkAtoms_Atoms = 376;
            pub const GkAtoms_Atoms_drawtitle: root::mozilla::detail::GkAtoms_Atoms = 377;
            pub const GkAtoms_Atoms_dropAfter: root::mozilla::detail::GkAtoms_Atoms = 378;
            pub const GkAtoms_Atoms_dropBefore: root::mozilla::detail::GkAtoms_Atoms = 379;
            pub const GkAtoms_Atoms_dropOn: root::mozilla::detail::GkAtoms_Atoms = 380;
            pub const GkAtoms_Atoms_dropMarker: root::mozilla::detail::GkAtoms_Atoms = 381;
            pub const GkAtoms_Atoms_dt: root::mozilla::detail::GkAtoms_Atoms = 382;
            pub const GkAtoms_Atoms_e: root::mozilla::detail::GkAtoms_Atoms = 383;
            pub const GkAtoms_Atoms_editable: root::mozilla::detail::GkAtoms_Atoms = 384;
            pub const GkAtoms_Atoms_editing: root::mozilla::detail::GkAtoms_Atoms = 385;
            pub const GkAtoms_Atoms_editor: root::mozilla::detail::GkAtoms_Atoms = 386;
            pub const GkAtoms_Atoms_element: root::mozilla::detail::GkAtoms_Atoms = 387;
            pub const GkAtoms_Atoms_elementAvailable: root::mozilla::detail::GkAtoms_Atoms = 388;
            pub const GkAtoms_Atoms_elements: root::mozilla::detail::GkAtoms_Atoms = 389;
            pub const GkAtoms_Atoms_em: root::mozilla::detail::GkAtoms_Atoms = 390;
            pub const GkAtoms_Atoms_embed: root::mozilla::detail::GkAtoms_Atoms = 391;
            pub const GkAtoms_Atoms_emphasis: root::mozilla::detail::GkAtoms_Atoms = 392;
            pub const GkAtoms_Atoms_empty: root::mozilla::detail::GkAtoms_Atoms = 393;
            pub const GkAtoms_Atoms_encoding: root::mozilla::detail::GkAtoms_Atoms = 394;
            pub const GkAtoms_Atoms_enctype: root::mozilla::detail::GkAtoms_Atoms = 395;
            pub const GkAtoms_Atoms_end: root::mozilla::detail::GkAtoms_Atoms = 396;
            pub const GkAtoms_Atoms_endEvent: root::mozilla::detail::GkAtoms_Atoms = 397;
            pub const GkAtoms_Atoms_enterkeyhint: root::mozilla::detail::GkAtoms_Atoms = 398;
            pub const GkAtoms_Atoms_error: root::mozilla::detail::GkAtoms_Atoms = 399;
            pub const GkAtoms_Atoms_ethiopic_numeric: root::mozilla::detail::GkAtoms_Atoms = 400;
            pub const GkAtoms_Atoms_even: root::mozilla::detail::GkAtoms_Atoms = 401;
            pub const GkAtoms_Atoms_event: root::mozilla::detail::GkAtoms_Atoms = 402;
            pub const GkAtoms_Atoms_events: root::mozilla::detail::GkAtoms_Atoms = 403;
            pub const GkAtoms_Atoms_excludeResultPrefixes: root::mozilla::detail::GkAtoms_Atoms =
                404;
            pub const GkAtoms_Atoms_exportparts: root::mozilla::detail::GkAtoms_Atoms = 405;
            pub const GkAtoms_Atoms_explicit_name: root::mozilla::detail::GkAtoms_Atoms = 406;
            pub const GkAtoms_Atoms_extends: root::mozilla::detail::GkAtoms_Atoms = 407;
            pub const GkAtoms_Atoms_extensionElementPrefixes: root::mozilla::detail::GkAtoms_Atoms =
                408;
            pub const GkAtoms_Atoms_face: root::mozilla::detail::GkAtoms_Atoms = 409;
            pub const GkAtoms_Atoms_fallback: root::mozilla::detail::GkAtoms_Atoms = 410;
            pub const GkAtoms_Atoms__false: root::mozilla::detail::GkAtoms_Atoms = 411;
            pub const GkAtoms_Atoms_farthest: root::mozilla::detail::GkAtoms_Atoms = 412;
            pub const GkAtoms_Atoms_featurePolicyViolation: root::mozilla::detail::GkAtoms_Atoms =
                413;
            pub const GkAtoms_Atoms_fetchpriority: root::mozilla::detail::GkAtoms_Atoms = 414;
            pub const GkAtoms_Atoms_field: root::mozilla::detail::GkAtoms_Atoms = 415;
            pub const GkAtoms_Atoms_fieldset: root::mozilla::detail::GkAtoms_Atoms = 416;
            pub const GkAtoms_Atoms_file: root::mozilla::detail::GkAtoms_Atoms = 417;
            pub const GkAtoms_Atoms_figcaption: root::mozilla::detail::GkAtoms_Atoms = 418;
            pub const GkAtoms_Atoms_figure: root::mozilla::detail::GkAtoms_Atoms = 419;
            pub const GkAtoms_Atoms_findbar: root::mozilla::detail::GkAtoms_Atoms = 420;
            pub const GkAtoms_Atoms_firstColumn: root::mozilla::detail::GkAtoms_Atoms = 421;
            pub const GkAtoms_Atoms_firstInput: root::mozilla::detail::GkAtoms_Atoms = 422;
            pub const GkAtoms_Atoms_fixed: root::mozilla::detail::GkAtoms_Atoms = 423;
            pub const GkAtoms_Atoms_flags: root::mozilla::detail::GkAtoms_Atoms = 424;
            pub const GkAtoms_Atoms_flex: root::mozilla::detail::GkAtoms_Atoms = 425;
            pub const GkAtoms_Atoms_flip: root::mozilla::detail::GkAtoms_Atoms = 426;
            pub const GkAtoms_Atoms_floor: root::mozilla::detail::GkAtoms_Atoms = 427;
            pub const GkAtoms_Atoms_flowlength: root::mozilla::detail::GkAtoms_Atoms = 428;
            pub const GkAtoms_Atoms_focus: root::mozilla::detail::GkAtoms_Atoms = 429;
            pub const GkAtoms_Atoms_focused: root::mozilla::detail::GkAtoms_Atoms = 430;
            pub const GkAtoms_Atoms_followanchor: root::mozilla::detail::GkAtoms_Atoms = 431;
            pub const GkAtoms_Atoms_following: root::mozilla::detail::GkAtoms_Atoms = 432;
            pub const GkAtoms_Atoms_followingSibling: root::mozilla::detail::GkAtoms_Atoms = 433;
            pub const GkAtoms_Atoms_font: root::mozilla::detail::GkAtoms_Atoms = 434;
            pub const GkAtoms_Atoms_footer: root::mozilla::detail::GkAtoms_Atoms = 435;
            pub const GkAtoms_Atoms__for: root::mozilla::detail::GkAtoms_Atoms = 436;
            pub const GkAtoms_Atoms_forEach: root::mozilla::detail::GkAtoms_Atoms = 437;
            pub const GkAtoms_Atoms_forcedColors: root::mozilla::detail::GkAtoms_Atoms = 438;
            pub const GkAtoms_Atoms_invertedColors: root::mozilla::detail::GkAtoms_Atoms = 439;
            pub const GkAtoms_Atoms_forceOwnRefreshDriver: root::mozilla::detail::GkAtoms_Atoms =
                440;
            pub const GkAtoms_Atoms_form: root::mozilla::detail::GkAtoms_Atoms = 441;
            pub const GkAtoms_Atoms_formaction: root::mozilla::detail::GkAtoms_Atoms = 442;
            pub const GkAtoms_Atoms_format: root::mozilla::detail::GkAtoms_Atoms = 443;
            pub const GkAtoms_Atoms_formatNumber: root::mozilla::detail::GkAtoms_Atoms = 444;
            pub const GkAtoms_Atoms_formenctype: root::mozilla::detail::GkAtoms_Atoms = 445;
            pub const GkAtoms_Atoms_formmethod: root::mozilla::detail::GkAtoms_Atoms = 446;
            pub const GkAtoms_Atoms_formnovalidate: root::mozilla::detail::GkAtoms_Atoms = 447;
            pub const GkAtoms_Atoms_formtarget: root::mozilla::detail::GkAtoms_Atoms = 448;
            pub const GkAtoms_Atoms_frame: root::mozilla::detail::GkAtoms_Atoms = 449;
            pub const GkAtoms_Atoms_frameborder: root::mozilla::detail::GkAtoms_Atoms = 450;
            pub const GkAtoms_Atoms_frameset: root::mozilla::detail::GkAtoms_Atoms = 451;
            pub const GkAtoms_Atoms_from: root::mozilla::detail::GkAtoms_Atoms = 452;
            pub const GkAtoms_Atoms_fullscreenchange: root::mozilla::detail::GkAtoms_Atoms = 453;
            pub const GkAtoms_Atoms_fullscreenerror: root::mozilla::detail::GkAtoms_Atoms = 454;
            pub const GkAtoms_Atoms_functionAvailable: root::mozilla::detail::GkAtoms_Atoms = 455;
            pub const GkAtoms_Atoms_generateId: root::mozilla::detail::GkAtoms_Atoms = 456;
            pub const GkAtoms_Atoms_generic: root::mozilla::detail::GkAtoms_Atoms = 457;
            pub const GkAtoms_Atoms_getter: root::mozilla::detail::GkAtoms_Atoms = 458;
            pub const GkAtoms_Atoms_graphicsDocument: root::mozilla::detail::GkAtoms_Atoms = 459;
            pub const GkAtoms_Atoms_graphicsObject: root::mozilla::detail::GkAtoms_Atoms = 460;
            pub const GkAtoms_Atoms_graphicsSymbol: root::mozilla::detail::GkAtoms_Atoms = 461;
            pub const GkAtoms_Atoms_grid: root::mozilla::detail::GkAtoms_Atoms = 462;
            pub const GkAtoms_Atoms_group: root::mozilla::detail::GkAtoms_Atoms = 463;
            pub const GkAtoms_Atoms_groups: root::mozilla::detail::GkAtoms_Atoms = 464;
            pub const GkAtoms_Atoms_groupbox: root::mozilla::detail::GkAtoms_Atoms = 465;
            pub const GkAtoms_Atoms_groupingSeparator: root::mozilla::detail::GkAtoms_Atoms = 466;
            pub const GkAtoms_Atoms_groupingSize: root::mozilla::detail::GkAtoms_Atoms = 467;
            pub const GkAtoms_Atoms_grow: root::mozilla::detail::GkAtoms_Atoms = 468;
            pub const GkAtoms_Atoms_h1: root::mozilla::detail::GkAtoms_Atoms = 469;
            pub const GkAtoms_Atoms_h2: root::mozilla::detail::GkAtoms_Atoms = 470;
            pub const GkAtoms_Atoms_h3: root::mozilla::detail::GkAtoms_Atoms = 471;
            pub const GkAtoms_Atoms_h4: root::mozilla::detail::GkAtoms_Atoms = 472;
            pub const GkAtoms_Atoms_h5: root::mozilla::detail::GkAtoms_Atoms = 473;
            pub const GkAtoms_Atoms_h6: root::mozilla::detail::GkAtoms_Atoms = 474;
            pub const GkAtoms_Atoms_hairline: root::mozilla::detail::GkAtoms_Atoms = 475;
            pub const GkAtoms_Atoms_handheldFriendly: root::mozilla::detail::GkAtoms_Atoms = 476;
            pub const GkAtoms_Atoms_handler: root::mozilla::detail::GkAtoms_Atoms = 477;
            pub const GkAtoms_Atoms_handlers: root::mozilla::detail::GkAtoms_Atoms = 478;
            pub const GkAtoms_Atoms_HARD: root::mozilla::detail::GkAtoms_Atoms = 479;
            pub const GkAtoms_Atoms_hasSameNode: root::mozilla::detail::GkAtoms_Atoms = 480;
            pub const GkAtoms_Atoms_hbox: root::mozilla::detail::GkAtoms_Atoms = 481;
            pub const GkAtoms_Atoms_head: root::mozilla::detail::GkAtoms_Atoms = 482;
            pub const GkAtoms_Atoms_header: root::mozilla::detail::GkAtoms_Atoms = 483;
            pub const GkAtoms_Atoms_headers: root::mozilla::detail::GkAtoms_Atoms = 484;
            pub const GkAtoms_Atoms_hebrew: root::mozilla::detail::GkAtoms_Atoms = 485;
            pub const GkAtoms_Atoms_height: root::mozilla::detail::GkAtoms_Atoms = 486;
            pub const GkAtoms_Atoms_hgroup: root::mozilla::detail::GkAtoms_Atoms = 487;
            pub const GkAtoms_Atoms_hidden: root::mozilla::detail::GkAtoms_Atoms = 488;
            pub const GkAtoms_Atoms_hidechrome: root::mozilla::detail::GkAtoms_Atoms = 489;
            pub const GkAtoms_Atoms_hidecolumnpicker: root::mozilla::detail::GkAtoms_Atoms = 490;
            pub const GkAtoms_Atoms_hide_popover: root::mozilla::detail::GkAtoms_Atoms = 491;
            pub const GkAtoms_Atoms_high: root::mozilla::detail::GkAtoms_Atoms = 492;
            pub const GkAtoms_Atoms_highest: root::mozilla::detail::GkAtoms_Atoms = 493;
            pub const GkAtoms_Atoms_horizontal: root::mozilla::detail::GkAtoms_Atoms = 494;
            pub const GkAtoms_Atoms_hover: root::mozilla::detail::GkAtoms_Atoms = 495;
            pub const GkAtoms_Atoms_hr: root::mozilla::detail::GkAtoms_Atoms = 496;
            pub const GkAtoms_Atoms_href: root::mozilla::detail::GkAtoms_Atoms = 497;
            pub const GkAtoms_Atoms_hreflang: root::mozilla::detail::GkAtoms_Atoms = 498;
            pub const GkAtoms_Atoms_hsides: root::mozilla::detail::GkAtoms_Atoms = 499;
            pub const GkAtoms_Atoms_hspace: root::mozilla::detail::GkAtoms_Atoms = 500;
            pub const GkAtoms_Atoms_html: root::mozilla::detail::GkAtoms_Atoms = 501;
            pub const GkAtoms_Atoms_httpEquiv: root::mozilla::detail::GkAtoms_Atoms = 502;
            pub const GkAtoms_Atoms_i: root::mozilla::detail::GkAtoms_Atoms = 503;
            pub const GkAtoms_Atoms_icon: root::mozilla::detail::GkAtoms_Atoms = 504;
            pub const GkAtoms_Atoms_id: root::mozilla::detail::GkAtoms_Atoms = 505;
            pub const GkAtoms_Atoms__if: root::mozilla::detail::GkAtoms_Atoms = 506;
            pub const GkAtoms_Atoms_iframe: root::mozilla::detail::GkAtoms_Atoms = 507;
            pub const GkAtoms_Atoms_ignorekeys: root::mozilla::detail::GkAtoms_Atoms = 508;
            pub const GkAtoms_Atoms_ignoreuserfocus: root::mozilla::detail::GkAtoms_Atoms = 509;
            pub const GkAtoms_Atoms_image: root::mozilla::detail::GkAtoms_Atoms = 510;
            pub const GkAtoms_Atoms_imageClickedPoint: root::mozilla::detail::GkAtoms_Atoms = 511;
            pub const GkAtoms_Atoms_imagesizes: root::mozilla::detail::GkAtoms_Atoms = 512;
            pub const GkAtoms_Atoms_imagesrcset: root::mozilla::detail::GkAtoms_Atoms = 513;
            pub const GkAtoms_Atoms_img: root::mozilla::detail::GkAtoms_Atoms = 514;
            pub const GkAtoms_Atoms_implementation: root::mozilla::detail::GkAtoms_Atoms = 515;
            pub const GkAtoms_Atoms_implements: root::mozilla::detail::GkAtoms_Atoms = 516;
            pub const GkAtoms_Atoms_import: root::mozilla::detail::GkAtoms_Atoms = 517;
            pub const GkAtoms_Atoms_include: root::mozilla::detail::GkAtoms_Atoms = 518;
            pub const GkAtoms_Atoms_includes: root::mozilla::detail::GkAtoms_Atoms = 519;
            pub const GkAtoms_Atoms_incontentshell: root::mozilla::detail::GkAtoms_Atoms = 520;
            pub const GkAtoms_Atoms_increment: root::mozilla::detail::GkAtoms_Atoms = 521;
            pub const GkAtoms_Atoms_indent: root::mozilla::detail::GkAtoms_Atoms = 522;
            pub const GkAtoms_Atoms_indeterminate: root::mozilla::detail::GkAtoms_Atoms = 523;
            pub const GkAtoms_Atoms_index: root::mozilla::detail::GkAtoms_Atoms = 524;
            pub const GkAtoms_Atoms_inert: root::mozilla::detail::GkAtoms_Atoms = 525;
            pub const GkAtoms_Atoms_innerHTML: root::mozilla::detail::GkAtoms_Atoms = 526;
            pub const GkAtoms_Atoms_innerText: root::mozilla::detail::GkAtoms_Atoms = 527;
            pub const GkAtoms_Atoms_infinity: root::mozilla::detail::GkAtoms_Atoms = 528;
            pub const GkAtoms_Atoms_inherits: root::mozilla::detail::GkAtoms_Atoms = 529;
            pub const GkAtoms_Atoms_inheritOverflow: root::mozilla::detail::GkAtoms_Atoms = 530;
            pub const GkAtoms_Atoms_inheritstyle: root::mozilla::detail::GkAtoms_Atoms = 531;
            pub const GkAtoms_Atoms_initial_scale: root::mozilla::detail::GkAtoms_Atoms = 532;
            pub const GkAtoms_Atoms_input: root::mozilla::detail::GkAtoms_Atoms = 533;
            pub const GkAtoms_Atoms_inputmode: root::mozilla::detail::GkAtoms_Atoms = 534;
            pub const GkAtoms_Atoms_ins: root::mozilla::detail::GkAtoms_Atoms = 535;
            pub const GkAtoms_Atoms_insertafter: root::mozilla::detail::GkAtoms_Atoms = 536;
            pub const GkAtoms_Atoms_insertbefore: root::mozilla::detail::GkAtoms_Atoms = 537;
            pub const GkAtoms_Atoms_insertion: root::mozilla::detail::GkAtoms_Atoms = 538;
            pub const GkAtoms_Atoms_integer: root::mozilla::detail::GkAtoms_Atoms = 539;
            pub const GkAtoms_Atoms_integrity: root::mozilla::detail::GkAtoms_Atoms = 540;
            pub const GkAtoms_Atoms_interactive_widget: root::mozilla::detail::GkAtoms_Atoms = 541;
            pub const GkAtoms_Atoms_internal: root::mozilla::detail::GkAtoms_Atoms = 542;
            pub const GkAtoms_Atoms_internals: root::mozilla::detail::GkAtoms_Atoms = 543;
            pub const GkAtoms_Atoms_intersection: root::mozilla::detail::GkAtoms_Atoms = 544;
            pub const GkAtoms_Atoms_is: root::mozilla::detail::GkAtoms_Atoms = 545;
            pub const GkAtoms_Atoms_ismap: root::mozilla::detail::GkAtoms_Atoms = 546;
            pub const GkAtoms_Atoms_ispopup: root::mozilla::detail::GkAtoms_Atoms = 547;
            pub const GkAtoms_Atoms_itemid: root::mozilla::detail::GkAtoms_Atoms = 548;
            pub const GkAtoms_Atoms_itemprop: root::mozilla::detail::GkAtoms_Atoms = 549;
            pub const GkAtoms_Atoms_itemref: root::mozilla::detail::GkAtoms_Atoms = 550;
            pub const GkAtoms_Atoms_itemscope: root::mozilla::detail::GkAtoms_Atoms = 551;
            pub const GkAtoms_Atoms_itemtype: root::mozilla::detail::GkAtoms_Atoms = 552;
            pub const GkAtoms_Atoms_japanese_formal: root::mozilla::detail::GkAtoms_Atoms = 553;
            pub const GkAtoms_Atoms_japanese_informal: root::mozilla::detail::GkAtoms_Atoms = 554;
            pub const GkAtoms_Atoms_kbd: root::mozilla::detail::GkAtoms_Atoms = 555;
            pub const GkAtoms_Atoms_keepcurrentinview: root::mozilla::detail::GkAtoms_Atoms = 556;
            pub const GkAtoms_Atoms_key: root::mozilla::detail::GkAtoms_Atoms = 557;
            pub const GkAtoms_Atoms_keycode: root::mozilla::detail::GkAtoms_Atoms = 558;
            pub const GkAtoms_Atoms_keydown: root::mozilla::detail::GkAtoms_Atoms = 559;
            pub const GkAtoms_Atoms_keygen: root::mozilla::detail::GkAtoms_Atoms = 560;
            pub const GkAtoms_Atoms_keypress: root::mozilla::detail::GkAtoms_Atoms = 561;
            pub const GkAtoms_Atoms_keyset: root::mozilla::detail::GkAtoms_Atoms = 562;
            pub const GkAtoms_Atoms_keysystem: root::mozilla::detail::GkAtoms_Atoms = 563;
            pub const GkAtoms_Atoms_keyup: root::mozilla::detail::GkAtoms_Atoms = 564;
            pub const GkAtoms_Atoms_kind: root::mozilla::detail::GkAtoms_Atoms = 565;
            pub const GkAtoms_Atoms_korean_hangul_formal: root::mozilla::detail::GkAtoms_Atoms =
                566;
            pub const GkAtoms_Atoms_korean_hanja_formal: root::mozilla::detail::GkAtoms_Atoms = 567;
            pub const GkAtoms_Atoms_korean_hanja_informal: root::mozilla::detail::GkAtoms_Atoms =
                568;
            pub const GkAtoms_Atoms_label: root::mozilla::detail::GkAtoms_Atoms = 569;
            pub const GkAtoms_Atoms_lang: root::mozilla::detail::GkAtoms_Atoms = 570;
            pub const GkAtoms_Atoms_language: root::mozilla::detail::GkAtoms_Atoms = 571;
            pub const GkAtoms_Atoms_last: root::mozilla::detail::GkAtoms_Atoms = 572;
            pub const GkAtoms_Atoms_layer: root::mozilla::detail::GkAtoms_Atoms = 573;
            pub const GkAtoms_Atoms_LayerActivity: root::mozilla::detail::GkAtoms_Atoms = 574;
            pub const GkAtoms_Atoms_layout_guess: root::mozilla::detail::GkAtoms_Atoms = 575;
            pub const GkAtoms_Atoms_leading: root::mozilla::detail::GkAtoms_Atoms = 576;
            pub const GkAtoms_Atoms_leaf: root::mozilla::detail::GkAtoms_Atoms = 577;
            pub const GkAtoms_Atoms_left: root::mozilla::detail::GkAtoms_Atoms = 578;
            pub const GkAtoms_Atoms_leftmargin: root::mozilla::detail::GkAtoms_Atoms = 579;
            pub const GkAtoms_Atoms_legend: root::mozilla::detail::GkAtoms_Atoms = 580;
            pub const GkAtoms_Atoms_length: root::mozilla::detail::GkAtoms_Atoms = 581;
            pub const GkAtoms_Atoms_letterValue: root::mozilla::detail::GkAtoms_Atoms = 582;
            pub const GkAtoms_Atoms_level: root::mozilla::detail::GkAtoms_Atoms = 583;
            pub const GkAtoms_Atoms_lhs: root::mozilla::detail::GkAtoms_Atoms = 584;
            pub const GkAtoms_Atoms_li: root::mozilla::detail::GkAtoms_Atoms = 585;
            pub const GkAtoms_Atoms_line: root::mozilla::detail::GkAtoms_Atoms = 586;
            pub const GkAtoms_Atoms_link: root::mozilla::detail::GkAtoms_Atoms = 587;
            pub const GkAtoms_Atoms_linkset: root::mozilla::detail::GkAtoms_Atoms = 588;
            pub const GkAtoms_Atoms_listbox: root::mozilla::detail::GkAtoms_Atoms = 589;
            pub const GkAtoms_Atoms_listener: root::mozilla::detail::GkAtoms_Atoms = 590;
            pub const GkAtoms_Atoms_listheader: root::mozilla::detail::GkAtoms_Atoms = 591;
            pub const GkAtoms_Atoms_listing: root::mozilla::detail::GkAtoms_Atoms = 592;
            pub const GkAtoms_Atoms_listitem: root::mozilla::detail::GkAtoms_Atoms = 593;
            pub const GkAtoms_Atoms_load: root::mozilla::detail::GkAtoms_Atoms = 594;
            pub const GkAtoms_Atoms_loading: root::mozilla::detail::GkAtoms_Atoms = 595;
            pub const GkAtoms_Atoms_touchmode: root::mozilla::detail::GkAtoms_Atoms = 596;
            pub const GkAtoms_Atoms_triggeringprincipal: root::mozilla::detail::GkAtoms_Atoms = 597;
            pub const GkAtoms_Atoms_localedir: root::mozilla::detail::GkAtoms_Atoms = 598;
            pub const GkAtoms_Atoms_localName: root::mozilla::detail::GkAtoms_Atoms = 599;
            pub const GkAtoms_Atoms_localization: root::mozilla::detail::GkAtoms_Atoms = 600;
            pub const GkAtoms_Atoms_longdesc: root::mozilla::detail::GkAtoms_Atoms = 601;
            pub const GkAtoms_Atoms_loop_: root::mozilla::detail::GkAtoms_Atoms = 602;
            pub const GkAtoms_Atoms_low: root::mozilla::detail::GkAtoms_Atoms = 603;
            pub const GkAtoms_Atoms_lowerFirst: root::mozilla::detail::GkAtoms_Atoms = 604;
            pub const GkAtoms_Atoms_lowest: root::mozilla::detail::GkAtoms_Atoms = 605;
            pub const GkAtoms_Atoms_lowsrc: root::mozilla::detail::GkAtoms_Atoms = 606;
            pub const GkAtoms_Atoms_ltr: root::mozilla::detail::GkAtoms_Atoms = 607;
            pub const GkAtoms_Atoms_main: root::mozilla::detail::GkAtoms_Atoms = 608;
            pub const GkAtoms_Atoms_map: root::mozilla::detail::GkAtoms_Atoms = 609;
            pub const GkAtoms_Atoms_manifest: root::mozilla::detail::GkAtoms_Atoms = 610;
            pub const GkAtoms_Atoms_marginBottom: root::mozilla::detail::GkAtoms_Atoms = 611;
            pub const GkAtoms_Atoms_marginLeft: root::mozilla::detail::GkAtoms_Atoms = 612;
            pub const GkAtoms_Atoms_marginRight: root::mozilla::detail::GkAtoms_Atoms = 613;
            pub const GkAtoms_Atoms_marginTop: root::mozilla::detail::GkAtoms_Atoms = 614;
            pub const GkAtoms_Atoms_marginheight: root::mozilla::detail::GkAtoms_Atoms = 615;
            pub const GkAtoms_Atoms_marginwidth: root::mozilla::detail::GkAtoms_Atoms = 616;
            pub const GkAtoms_Atoms_mark: root::mozilla::detail::GkAtoms_Atoms = 617;
            pub const GkAtoms_Atoms_marquee: root::mozilla::detail::GkAtoms_Atoms = 618;
            pub const GkAtoms_Atoms_match_: root::mozilla::detail::GkAtoms_Atoms = 619;
            pub const GkAtoms_Atoms_max: root::mozilla::detail::GkAtoms_Atoms = 620;
            pub const GkAtoms_Atoms_maxheight: root::mozilla::detail::GkAtoms_Atoms = 621;
            pub const GkAtoms_Atoms_maximum_scale: root::mozilla::detail::GkAtoms_Atoms = 622;
            pub const GkAtoms_Atoms_maxlength: root::mozilla::detail::GkAtoms_Atoms = 623;
            pub const GkAtoms_Atoms_maxpos: root::mozilla::detail::GkAtoms_Atoms = 624;
            pub const GkAtoms_Atoms_maxwidth: root::mozilla::detail::GkAtoms_Atoms = 625;
            pub const GkAtoms_Atoms_measure: root::mozilla::detail::GkAtoms_Atoms = 626;
            pub const GkAtoms_Atoms_media: root::mozilla::detail::GkAtoms_Atoms = 627;
            pub const GkAtoms_Atoms_mediaType: root::mozilla::detail::GkAtoms_Atoms = 628;
            pub const GkAtoms_Atoms_menu: root::mozilla::detail::GkAtoms_Atoms = 629;
            pub const GkAtoms_Atoms_menubar: root::mozilla::detail::GkAtoms_Atoms = 630;
            pub const GkAtoms_Atoms_menucaption: root::mozilla::detail::GkAtoms_Atoms = 631;
            pub const GkAtoms_Atoms_menugroup: root::mozilla::detail::GkAtoms_Atoms = 632;
            pub const GkAtoms_Atoms_menuitem: root::mozilla::detail::GkAtoms_Atoms = 633;
            pub const GkAtoms_Atoms_menulist: root::mozilla::detail::GkAtoms_Atoms = 634;
            pub const GkAtoms_Atoms_menupopup: root::mozilla::detail::GkAtoms_Atoms = 635;
            pub const GkAtoms_Atoms_menuseparator: root::mozilla::detail::GkAtoms_Atoms = 636;
            pub const GkAtoms_Atoms_mesh: root::mozilla::detail::GkAtoms_Atoms = 637;
            pub const GkAtoms_Atoms_message: root::mozilla::detail::GkAtoms_Atoms = 638;
            pub const GkAtoms_Atoms_meta: root::mozilla::detail::GkAtoms_Atoms = 639;
            pub const GkAtoms_Atoms_referrer: root::mozilla::detail::GkAtoms_Atoms = 640;
            pub const GkAtoms_Atoms_referrerpolicy: root::mozilla::detail::GkAtoms_Atoms = 641;
            pub const GkAtoms_Atoms_renderroot: root::mozilla::detail::GkAtoms_Atoms = 642;
            pub const GkAtoms_Atoms_headerReferrerPolicy: root::mozilla::detail::GkAtoms_Atoms =
                643;
            pub const GkAtoms_Atoms_meter: root::mozilla::detail::GkAtoms_Atoms = 644;
            pub const GkAtoms_Atoms_method: root::mozilla::detail::GkAtoms_Atoms = 645;
            pub const GkAtoms_Atoms_middle: root::mozilla::detail::GkAtoms_Atoms = 646;
            pub const GkAtoms_Atoms_min: root::mozilla::detail::GkAtoms_Atoms = 647;
            pub const GkAtoms_Atoms_minheight: root::mozilla::detail::GkAtoms_Atoms = 648;
            pub const GkAtoms_Atoms_minimum_scale: root::mozilla::detail::GkAtoms_Atoms = 649;
            pub const GkAtoms_Atoms_minlength: root::mozilla::detail::GkAtoms_Atoms = 650;
            pub const GkAtoms_Atoms_minpos: root::mozilla::detail::GkAtoms_Atoms = 651;
            pub const GkAtoms_Atoms_minusSign: root::mozilla::detail::GkAtoms_Atoms = 652;
            pub const GkAtoms_Atoms_minwidth: root::mozilla::detail::GkAtoms_Atoms = 653;
            pub const GkAtoms_Atoms_mixed: root::mozilla::detail::GkAtoms_Atoms = 654;
            pub const GkAtoms_Atoms_messagemanagergroup: root::mozilla::detail::GkAtoms_Atoms = 655;
            pub const GkAtoms_Atoms_mod_: root::mozilla::detail::GkAtoms_Atoms = 656;
            pub const GkAtoms_Atoms__module: root::mozilla::detail::GkAtoms_Atoms = 657;
            pub const GkAtoms_Atoms_mode: root::mozilla::detail::GkAtoms_Atoms = 658;
            pub const GkAtoms_Atoms_modifiers: root::mozilla::detail::GkAtoms_Atoms = 659;
            pub const GkAtoms_Atoms_monochrome: root::mozilla::detail::GkAtoms_Atoms = 660;
            pub const GkAtoms_Atoms_mouseover: root::mozilla::detail::GkAtoms_Atoms = 661;
            pub const GkAtoms_Atoms_mozAccessiblecaret: root::mozilla::detail::GkAtoms_Atoms = 662;
            pub const GkAtoms_Atoms_mozCustomContentContainer:
                root::mozilla::detail::GkAtoms_Atoms = 663;
            pub const GkAtoms_Atoms_mozGrabber: root::mozilla::detail::GkAtoms_Atoms = 664;
            pub const GkAtoms_Atoms_mozNativeAnonymous: root::mozilla::detail::GkAtoms_Atoms = 665;
            pub const GkAtoms_Atoms_mozprivatebrowsing: root::mozilla::detail::GkAtoms_Atoms = 666;
            pub const GkAtoms_Atoms_mozResizer: root::mozilla::detail::GkAtoms_Atoms = 667;
            pub const GkAtoms_Atoms_mozResizingInfo: root::mozilla::detail::GkAtoms_Atoms = 668;
            pub const GkAtoms_Atoms_mozResizingShadow: root::mozilla::detail::GkAtoms_Atoms = 669;
            pub const GkAtoms_Atoms_mozTableAddColumnAfter: root::mozilla::detail::GkAtoms_Atoms =
                670;
            pub const GkAtoms_Atoms_mozTableAddColumnBefore: root::mozilla::detail::GkAtoms_Atoms =
                671;
            pub const GkAtoms_Atoms_mozTableAddRowAfter: root::mozilla::detail::GkAtoms_Atoms = 672;
            pub const GkAtoms_Atoms_mozTableAddRowBefore: root::mozilla::detail::GkAtoms_Atoms =
                673;
            pub const GkAtoms_Atoms_mozTableRemoveRow: root::mozilla::detail::GkAtoms_Atoms = 674;
            pub const GkAtoms_Atoms_mozTableRemoveColumn: root::mozilla::detail::GkAtoms_Atoms =
                675;
            pub const GkAtoms_Atoms_moz_opaque: root::mozilla::detail::GkAtoms_Atoms = 676;
            pub const GkAtoms_Atoms_multicol: root::mozilla::detail::GkAtoms_Atoms = 677;
            pub const GkAtoms_Atoms_multiple: root::mozilla::detail::GkAtoms_Atoms = 678;
            pub const GkAtoms_Atoms_muted: root::mozilla::detail::GkAtoms_Atoms = 679;
            pub const GkAtoms_Atoms_name: root::mozilla::detail::GkAtoms_Atoms = 680;
            pub const GkAtoms_Atoms_native: root::mozilla::detail::GkAtoms_Atoms = 681;
            pub const GkAtoms_Atoms__namespace: root::mozilla::detail::GkAtoms_Atoms = 682;
            pub const GkAtoms_Atoms_namespaceAlias: root::mozilla::detail::GkAtoms_Atoms = 683;
            pub const GkAtoms_Atoms_namespaceUri: root::mozilla::detail::GkAtoms_Atoms = 684;
            pub const GkAtoms_Atoms_NaN: root::mozilla::detail::GkAtoms_Atoms = 685;
            pub const GkAtoms_Atoms_n: root::mozilla::detail::GkAtoms_Atoms = 686;
            pub const GkAtoms_Atoms_nav: root::mozilla::detail::GkAtoms_Atoms = 687;
            pub const GkAtoms_Atoms_ne: root::mozilla::detail::GkAtoms_Atoms = 688;
            pub const GkAtoms_Atoms_never: root::mozilla::detail::GkAtoms_Atoms = 689;
            pub const GkAtoms_Atoms_neverhidden: root::mozilla::detail::GkAtoms_Atoms = 690;
            pub const GkAtoms_Atoms__new: root::mozilla::detail::GkAtoms_Atoms = 691;
            pub const GkAtoms_Atoms_newline: root::mozilla::detail::GkAtoms_Atoms = 692;
            pub const GkAtoms_Atoms_nextRemoteTabId: root::mozilla::detail::GkAtoms_Atoms = 693;
            pub const GkAtoms_Atoms_no: root::mozilla::detail::GkAtoms_Atoms = 694;
            pub const GkAtoms_Atoms_noautofocus: root::mozilla::detail::GkAtoms_Atoms = 695;
            pub const GkAtoms_Atoms_noautohide: root::mozilla::detail::GkAtoms_Atoms = 696;
            pub const GkAtoms_Atoms_norolluponanchor: root::mozilla::detail::GkAtoms_Atoms = 697;
            pub const GkAtoms_Atoms_noBar: root::mozilla::detail::GkAtoms_Atoms = 698;
            pub const GkAtoms_Atoms_nobr: root::mozilla::detail::GkAtoms_Atoms = 699;
            pub const GkAtoms_Atoms_nodefaultsrc: root::mozilla::detail::GkAtoms_Atoms = 700;
            pub const GkAtoms_Atoms_nodeSet: root::mozilla::detail::GkAtoms_Atoms = 701;
            pub const GkAtoms_Atoms_noembed: root::mozilla::detail::GkAtoms_Atoms = 702;
            pub const GkAtoms_Atoms_noframes: root::mozilla::detail::GkAtoms_Atoms = 703;
            pub const GkAtoms_Atoms_nohref: root::mozilla::detail::GkAtoms_Atoms = 704;
            pub const GkAtoms_Atoms_noinitialselection: root::mozilla::detail::GkAtoms_Atoms = 705;
            pub const GkAtoms_Atoms_nomodule: root::mozilla::detail::GkAtoms_Atoms = 706;
            pub const GkAtoms_Atoms_nonce: root::mozilla::detail::GkAtoms_Atoms = 707;
            pub const GkAtoms_Atoms_none: root::mozilla::detail::GkAtoms_Atoms = 708;
            pub const GkAtoms_Atoms_noresize: root::mozilla::detail::GkAtoms_Atoms = 709;
            pub const GkAtoms_Atoms_normal: root::mozilla::detail::GkAtoms_Atoms = 710;
            pub const GkAtoms_Atoms_normalizeSpace: root::mozilla::detail::GkAtoms_Atoms = 711;
            pub const GkAtoms_Atoms_noscript: root::mozilla::detail::GkAtoms_Atoms = 712;
            pub const GkAtoms_Atoms_noshade: root::mozilla::detail::GkAtoms_Atoms = 713;
            pub const GkAtoms_Atoms_notification: root::mozilla::detail::GkAtoms_Atoms = 714;
            pub const GkAtoms_Atoms_novalidate: root::mozilla::detail::GkAtoms_Atoms = 715;
            pub const GkAtoms_Atoms__not: root::mozilla::detail::GkAtoms_Atoms = 716;
            pub const GkAtoms_Atoms_nowrap: root::mozilla::detail::GkAtoms_Atoms = 717;
            pub const GkAtoms_Atoms_number: root::mozilla::detail::GkAtoms_Atoms = 718;
            pub const GkAtoms_Atoms_nw: root::mozilla::detail::GkAtoms_Atoms = 719;
            pub const GkAtoms_Atoms_object: root::mozilla::detail::GkAtoms_Atoms = 720;
            pub const GkAtoms_Atoms_objectType: root::mozilla::detail::GkAtoms_Atoms = 721;
            pub const GkAtoms_Atoms_observes: root::mozilla::detail::GkAtoms_Atoms = 722;
            pub const GkAtoms_Atoms_odd: root::mozilla::detail::GkAtoms_Atoms = 723;
            pub const GkAtoms_Atoms_OFF: root::mozilla::detail::GkAtoms_Atoms = 724;
            pub const GkAtoms_Atoms_ol: root::mozilla::detail::GkAtoms_Atoms = 725;
            pub const GkAtoms_Atoms_omitXmlDeclaration: root::mozilla::detail::GkAtoms_Atoms = 726;
            pub const GkAtoms_Atoms_onabort: root::mozilla::detail::GkAtoms_Atoms = 727;
            pub const GkAtoms_Atoms_onmozaccesskeynotfound: root::mozilla::detail::GkAtoms_Atoms =
                728;
            pub const GkAtoms_Atoms_onactivate: root::mozilla::detail::GkAtoms_Atoms = 729;
            pub const GkAtoms_Atoms_onafterprint: root::mozilla::detail::GkAtoms_Atoms = 730;
            pub const GkAtoms_Atoms_onafterscriptexecute: root::mozilla::detail::GkAtoms_Atoms =
                731;
            pub const GkAtoms_Atoms_onanimationcancel: root::mozilla::detail::GkAtoms_Atoms = 732;
            pub const GkAtoms_Atoms_onanimationend: root::mozilla::detail::GkAtoms_Atoms = 733;
            pub const GkAtoms_Atoms_onanimationiteration: root::mozilla::detail::GkAtoms_Atoms =
                734;
            pub const GkAtoms_Atoms_onanimationstart: root::mozilla::detail::GkAtoms_Atoms = 735;
            pub const GkAtoms_Atoms_onAppCommand: root::mozilla::detail::GkAtoms_Atoms = 736;
            pub const GkAtoms_Atoms_onaudioprocess: root::mozilla::detail::GkAtoms_Atoms = 737;
            pub const GkAtoms_Atoms_onauxclick: root::mozilla::detail::GkAtoms_Atoms = 738;
            pub const GkAtoms_Atoms_onbeforecopy: root::mozilla::detail::GkAtoms_Atoms = 739;
            pub const GkAtoms_Atoms_onbeforecut: root::mozilla::detail::GkAtoms_Atoms = 740;
            pub const GkAtoms_Atoms_onbeforeinput: root::mozilla::detail::GkAtoms_Atoms = 741;
            pub const GkAtoms_Atoms_onbeforematch: root::mozilla::detail::GkAtoms_Atoms = 742;
            pub const GkAtoms_Atoms_onbeforepaste: root::mozilla::detail::GkAtoms_Atoms = 743;
            pub const GkAtoms_Atoms_onbeforeprint: root::mozilla::detail::GkAtoms_Atoms = 744;
            pub const GkAtoms_Atoms_onbeforescriptexecute: root::mozilla::detail::GkAtoms_Atoms =
                745;
            pub const GkAtoms_Atoms_onbeforeunload: root::mozilla::detail::GkAtoms_Atoms = 746;
            pub const GkAtoms_Atoms_onblocked: root::mozilla::detail::GkAtoms_Atoms = 747;
            pub const GkAtoms_Atoms_onblur: root::mozilla::detail::GkAtoms_Atoms = 748;
            pub const GkAtoms_Atoms_onboundschange: root::mozilla::detail::GkAtoms_Atoms = 749;
            pub const GkAtoms_Atoms_onbroadcast: root::mozilla::detail::GkAtoms_Atoms = 750;
            pub const GkAtoms_Atoms_onbufferedamountlow: root::mozilla::detail::GkAtoms_Atoms = 751;
            pub const GkAtoms_Atoms_oncached: root::mozilla::detail::GkAtoms_Atoms = 752;
            pub const GkAtoms_Atoms_oncancel: root::mozilla::detail::GkAtoms_Atoms = 753;
            pub const GkAtoms_Atoms_onchange: root::mozilla::detail::GkAtoms_Atoms = 754;
            pub const GkAtoms_Atoms_onchargingchange: root::mozilla::detail::GkAtoms_Atoms = 755;
            pub const GkAtoms_Atoms_onchargingtimechange: root::mozilla::detail::GkAtoms_Atoms =
                756;
            pub const GkAtoms_Atoms_onchecking: root::mozilla::detail::GkAtoms_Atoms = 757;
            pub const GkAtoms_Atoms_onCheckboxStateChange: root::mozilla::detail::GkAtoms_Atoms =
                758;
            pub const GkAtoms_Atoms_onCheckKeyPressEventModel:
                root::mozilla::detail::GkAtoms_Atoms = 759;
            pub const GkAtoms_Atoms_onclick: root::mozilla::detail::GkAtoms_Atoms = 760;
            pub const GkAtoms_Atoms_onclose: root::mozilla::detail::GkAtoms_Atoms = 761;
            pub const GkAtoms_Atoms_oncontentvisibilityautostatechange:
                root::mozilla::detail::GkAtoms_Atoms = 762;
            pub const GkAtoms_Atoms_oncommand: root::mozilla::detail::GkAtoms_Atoms = 763;
            pub const GkAtoms_Atoms_oncommandupdate: root::mozilla::detail::GkAtoms_Atoms = 764;
            pub const GkAtoms_Atoms_oncomplete: root::mozilla::detail::GkAtoms_Atoms = 765;
            pub const GkAtoms_Atoms_oncompositionend: root::mozilla::detail::GkAtoms_Atoms = 766;
            pub const GkAtoms_Atoms_oncompositionstart: root::mozilla::detail::GkAtoms_Atoms = 767;
            pub const GkAtoms_Atoms_oncompositionupdate: root::mozilla::detail::GkAtoms_Atoms = 768;
            pub const GkAtoms_Atoms_onconnect: root::mozilla::detail::GkAtoms_Atoms = 769;
            pub const GkAtoms_Atoms_onconnectionavailable: root::mozilla::detail::GkAtoms_Atoms =
                770;
            pub const GkAtoms_Atoms_oncontextmenu: root::mozilla::detail::GkAtoms_Atoms = 771;
            pub const GkAtoms_Atoms_oncontextlost: root::mozilla::detail::GkAtoms_Atoms = 772;
            pub const GkAtoms_Atoms_oncontextrestored: root::mozilla::detail::GkAtoms_Atoms = 773;
            pub const GkAtoms_Atoms_oncookiechange: root::mozilla::detail::GkAtoms_Atoms = 774;
            pub const GkAtoms_Atoms_oncopy: root::mozilla::detail::GkAtoms_Atoms = 775;
            pub const GkAtoms_Atoms_oncut: root::mozilla::detail::GkAtoms_Atoms = 776;
            pub const GkAtoms_Atoms_oncurrententrychange: root::mozilla::detail::GkAtoms_Atoms =
                777;
            pub const GkAtoms_Atoms_ondblclick: root::mozilla::detail::GkAtoms_Atoms = 778;
            pub const GkAtoms_Atoms_ondischargingtimechange: root::mozilla::detail::GkAtoms_Atoms =
                779;
            pub const GkAtoms_Atoms_ondispose: root::mozilla::detail::GkAtoms_Atoms = 780;
            pub const GkAtoms_Atoms_ondownloading: root::mozilla::detail::GkAtoms_Atoms = 781;
            pub const GkAtoms_Atoms_onDOMActivate: root::mozilla::detail::GkAtoms_Atoms = 782;
            pub const GkAtoms_Atoms_onDOMAttrModified: root::mozilla::detail::GkAtoms_Atoms = 783;
            pub const GkAtoms_Atoms_onDOMCharacterDataModified:
                root::mozilla::detail::GkAtoms_Atoms = 784;
            pub const GkAtoms_Atoms_onDOMFocusIn: root::mozilla::detail::GkAtoms_Atoms = 785;
            pub const GkAtoms_Atoms_onDOMFocusOut: root::mozilla::detail::GkAtoms_Atoms = 786;
            pub const GkAtoms_Atoms_onDOMMouseScroll: root::mozilla::detail::GkAtoms_Atoms = 787;
            pub const GkAtoms_Atoms_onDOMNodeInserted: root::mozilla::detail::GkAtoms_Atoms = 788;
            pub const GkAtoms_Atoms_onDOMNodeInsertedIntoDocument:
                root::mozilla::detail::GkAtoms_Atoms = 789;
            pub const GkAtoms_Atoms_onDOMNodeRemoved: root::mozilla::detail::GkAtoms_Atoms = 790;
            pub const GkAtoms_Atoms_onDOMNodeRemovedFromDocument:
                root::mozilla::detail::GkAtoms_Atoms = 791;
            pub const GkAtoms_Atoms_onDOMSubtreeModified: root::mozilla::detail::GkAtoms_Atoms =
                792;
            pub const GkAtoms_Atoms_ondata: root::mozilla::detail::GkAtoms_Atoms = 793;
            pub const GkAtoms_Atoms_ondrag: root::mozilla::detail::GkAtoms_Atoms = 794;
            pub const GkAtoms_Atoms_ondragdrop: root::mozilla::detail::GkAtoms_Atoms = 795;
            pub const GkAtoms_Atoms_ondragend: root::mozilla::detail::GkAtoms_Atoms = 796;
            pub const GkAtoms_Atoms_ondragenter: root::mozilla::detail::GkAtoms_Atoms = 797;
            pub const GkAtoms_Atoms_ondragexit: root::mozilla::detail::GkAtoms_Atoms = 798;
            pub const GkAtoms_Atoms_ondragleave: root::mozilla::detail::GkAtoms_Atoms = 799;
            pub const GkAtoms_Atoms_ondragover: root::mozilla::detail::GkAtoms_Atoms = 800;
            pub const GkAtoms_Atoms_ondragstart: root::mozilla::detail::GkAtoms_Atoms = 801;
            pub const GkAtoms_Atoms_ondrain: root::mozilla::detail::GkAtoms_Atoms = 802;
            pub const GkAtoms_Atoms_ondrop: root::mozilla::detail::GkAtoms_Atoms = 803;
            pub const GkAtoms_Atoms_onerror: root::mozilla::detail::GkAtoms_Atoms = 804;
            pub const GkAtoms_Atoms_onfinish: root::mozilla::detail::GkAtoms_Atoms = 805;
            pub const GkAtoms_Atoms_onfocus: root::mozilla::detail::GkAtoms_Atoms = 806;
            pub const GkAtoms_Atoms_onfocusin: root::mozilla::detail::GkAtoms_Atoms = 807;
            pub const GkAtoms_Atoms_onfocusout: root::mozilla::detail::GkAtoms_Atoms = 808;
            pub const GkAtoms_Atoms_onfullscreenchange: root::mozilla::detail::GkAtoms_Atoms = 809;
            pub const GkAtoms_Atoms_onfullscreenerror: root::mozilla::detail::GkAtoms_Atoms = 810;
            pub const GkAtoms_Atoms_ongatheringstatechange: root::mozilla::detail::GkAtoms_Atoms =
                811;
            pub const GkAtoms_Atoms_onget: root::mozilla::detail::GkAtoms_Atoms = 812;
            pub const GkAtoms_Atoms_onhashchange: root::mozilla::detail::GkAtoms_Atoms = 813;
            pub const GkAtoms_Atoms_oninput: root::mozilla::detail::GkAtoms_Atoms = 814;
            pub const GkAtoms_Atoms_oninputsourceschange: root::mozilla::detail::GkAtoms_Atoms =
                815;
            pub const GkAtoms_Atoms_oninstall: root::mozilla::detail::GkAtoms_Atoms = 816;
            pub const GkAtoms_Atoms_oninvalid: root::mozilla::detail::GkAtoms_Atoms = 817;
            pub const GkAtoms_Atoms_onkeydown: root::mozilla::detail::GkAtoms_Atoms = 818;
            pub const GkAtoms_Atoms_onkeypress: root::mozilla::detail::GkAtoms_Atoms = 819;
            pub const GkAtoms_Atoms_onkeyup: root::mozilla::detail::GkAtoms_Atoms = 820;
            pub const GkAtoms_Atoms_onlanguagechange: root::mozilla::detail::GkAtoms_Atoms = 821;
            pub const GkAtoms_Atoms_onlevelchange: root::mozilla::detail::GkAtoms_Atoms = 822;
            pub const GkAtoms_Atoms_onload: root::mozilla::detail::GkAtoms_Atoms = 823;
            pub const GkAtoms_Atoms_onloading: root::mozilla::detail::GkAtoms_Atoms = 824;
            pub const GkAtoms_Atoms_onloadingdone: root::mozilla::detail::GkAtoms_Atoms = 825;
            pub const GkAtoms_Atoms_onloadingerror: root::mozilla::detail::GkAtoms_Atoms = 826;
            pub const GkAtoms_Atoms_onpopstate: root::mozilla::detail::GkAtoms_Atoms = 827;
            pub const GkAtoms_Atoms_only: root::mozilla::detail::GkAtoms_Atoms = 828;
            pub const GkAtoms_Atoms_onmerchantvalidation: root::mozilla::detail::GkAtoms_Atoms =
                829;
            pub const GkAtoms_Atoms_onmessage: root::mozilla::detail::GkAtoms_Atoms = 830;
            pub const GkAtoms_Atoms_onmessageerror: root::mozilla::detail::GkAtoms_Atoms = 831;
            pub const GkAtoms_Atoms_onmidimessage: root::mozilla::detail::GkAtoms_Atoms = 832;
            pub const GkAtoms_Atoms_onmousedown: root::mozilla::detail::GkAtoms_Atoms = 833;
            pub const GkAtoms_Atoms_onmouseenter: root::mozilla::detail::GkAtoms_Atoms = 834;
            pub const GkAtoms_Atoms_onmouseleave: root::mozilla::detail::GkAtoms_Atoms = 835;
            pub const GkAtoms_Atoms_onmouselongtap: root::mozilla::detail::GkAtoms_Atoms = 836;
            pub const GkAtoms_Atoms_onmousemove: root::mozilla::detail::GkAtoms_Atoms = 837;
            pub const GkAtoms_Atoms_onmouseout: root::mozilla::detail::GkAtoms_Atoms = 838;
            pub const GkAtoms_Atoms_onmouseover: root::mozilla::detail::GkAtoms_Atoms = 839;
            pub const GkAtoms_Atoms_onMozMouseHittest: root::mozilla::detail::GkAtoms_Atoms = 840;
            pub const GkAtoms_Atoms_onMozMouseExploreByTouch: root::mozilla::detail::GkAtoms_Atoms =
                841;
            pub const GkAtoms_Atoms_onmouseup: root::mozilla::detail::GkAtoms_Atoms = 842;
            pub const GkAtoms_Atoms_onMozAfterPaint: root::mozilla::detail::GkAtoms_Atoms = 843;
            pub const GkAtoms_Atoms_onmozfullscreenchange: root::mozilla::detail::GkAtoms_Atoms =
                844;
            pub const GkAtoms_Atoms_onmozfullscreenerror: root::mozilla::detail::GkAtoms_Atoms =
                845;
            pub const GkAtoms_Atoms_onmozpointerlockchange: root::mozilla::detail::GkAtoms_Atoms =
                846;
            pub const GkAtoms_Atoms_onmozpointerlockerror: root::mozilla::detail::GkAtoms_Atoms =
                847;
            pub const GkAtoms_Atoms_onMozMousePixelScroll: root::mozilla::detail::GkAtoms_Atoms =
                848;
            pub const GkAtoms_Atoms_onMozScrolledAreaChanged: root::mozilla::detail::GkAtoms_Atoms =
                849;
            pub const GkAtoms_Atoms_onmute: root::mozilla::detail::GkAtoms_Atoms = 850;
            pub const GkAtoms_Atoms_onnavigate: root::mozilla::detail::GkAtoms_Atoms = 851;
            pub const GkAtoms_Atoms_onnavigatesuccess: root::mozilla::detail::GkAtoms_Atoms = 852;
            pub const GkAtoms_Atoms_onnavigateerror: root::mozilla::detail::GkAtoms_Atoms = 853;
            pub const GkAtoms_Atoms_onnotificationclick: root::mozilla::detail::GkAtoms_Atoms = 854;
            pub const GkAtoms_Atoms_onnotificationclose: root::mozilla::detail::GkAtoms_Atoms = 855;
            pub const GkAtoms_Atoms_onnoupdate: root::mozilla::detail::GkAtoms_Atoms = 856;
            pub const GkAtoms_Atoms_onobsolete: root::mozilla::detail::GkAtoms_Atoms = 857;
            pub const GkAtoms_Atoms_ononline: root::mozilla::detail::GkAtoms_Atoms = 858;
            pub const GkAtoms_Atoms_onoffline: root::mozilla::detail::GkAtoms_Atoms = 859;
            pub const GkAtoms_Atoms_onopen: root::mozilla::detail::GkAtoms_Atoms = 860;
            pub const GkAtoms_Atoms_onorientationchange: root::mozilla::detail::GkAtoms_Atoms = 861;
            pub const GkAtoms_Atoms_onoverflow: root::mozilla::detail::GkAtoms_Atoms = 862;
            pub const GkAtoms_Atoms_onpagehide: root::mozilla::detail::GkAtoms_Atoms = 863;
            pub const GkAtoms_Atoms_onpageshow: root::mozilla::detail::GkAtoms_Atoms = 864;
            pub const GkAtoms_Atoms_onpaste: root::mozilla::detail::GkAtoms_Atoms = 865;
            pub const GkAtoms_Atoms_onpayerdetailchange: root::mozilla::detail::GkAtoms_Atoms = 866;
            pub const GkAtoms_Atoms_onpaymentmethodchange: root::mozilla::detail::GkAtoms_Atoms =
                867;
            pub const GkAtoms_Atoms_onpointerlockchange: root::mozilla::detail::GkAtoms_Atoms = 868;
            pub const GkAtoms_Atoms_onpointerlockerror: root::mozilla::detail::GkAtoms_Atoms = 869;
            pub const GkAtoms_Atoms_onpopuphidden: root::mozilla::detail::GkAtoms_Atoms = 870;
            pub const GkAtoms_Atoms_onpopuphiding: root::mozilla::detail::GkAtoms_Atoms = 871;
            pub const GkAtoms_Atoms_onpopuppositioned: root::mozilla::detail::GkAtoms_Atoms = 872;
            pub const GkAtoms_Atoms_onpopupshowing: root::mozilla::detail::GkAtoms_Atoms = 873;
            pub const GkAtoms_Atoms_onpopupshown: root::mozilla::detail::GkAtoms_Atoms = 874;
            pub const GkAtoms_Atoms_onprocessorerror: root::mozilla::detail::GkAtoms_Atoms = 875;
            pub const GkAtoms_Atoms_onprioritychange: root::mozilla::detail::GkAtoms_Atoms = 876;
            pub const GkAtoms_Atoms_onpush: root::mozilla::detail::GkAtoms_Atoms = 877;
            pub const GkAtoms_Atoms_onpushsubscriptionchange: root::mozilla::detail::GkAtoms_Atoms =
                878;
            pub const GkAtoms_Atoms_onRadioStateChange: root::mozilla::detail::GkAtoms_Atoms = 879;
            pub const GkAtoms_Atoms_onreadystatechange: root::mozilla::detail::GkAtoms_Atoms = 880;
            pub const GkAtoms_Atoms_onrejectionhandled: root::mozilla::detail::GkAtoms_Atoms = 881;
            pub const GkAtoms_Atoms_onremove: root::mozilla::detail::GkAtoms_Atoms = 882;
            pub const GkAtoms_Atoms_onrequestprogress: root::mozilla::detail::GkAtoms_Atoms = 883;
            pub const GkAtoms_Atoms_onresourcetimingbufferfull:
                root::mozilla::detail::GkAtoms_Atoms = 884;
            pub const GkAtoms_Atoms_onresponseprogress: root::mozilla::detail::GkAtoms_Atoms = 885;
            pub const GkAtoms_Atoms_onRequest: root::mozilla::detail::GkAtoms_Atoms = 886;
            pub const GkAtoms_Atoms_onreset: root::mozilla::detail::GkAtoms_Atoms = 887;
            pub const GkAtoms_Atoms_onresize: root::mozilla::detail::GkAtoms_Atoms = 888;
            pub const GkAtoms_Atoms_onscroll: root::mozilla::detail::GkAtoms_Atoms = 889;
            pub const GkAtoms_Atoms_onsecuritypolicyviolation:
                root::mozilla::detail::GkAtoms_Atoms = 890;
            pub const GkAtoms_Atoms_onselect: root::mozilla::detail::GkAtoms_Atoms = 891;
            pub const GkAtoms_Atoms_onselectionchange: root::mozilla::detail::GkAtoms_Atoms = 892;
            pub const GkAtoms_Atoms_onselectend: root::mozilla::detail::GkAtoms_Atoms = 893;
            pub const GkAtoms_Atoms_onselectstart: root::mozilla::detail::GkAtoms_Atoms = 894;
            pub const GkAtoms_Atoms_onset: root::mozilla::detail::GkAtoms_Atoms = 895;
            pub const GkAtoms_Atoms_onshippingaddresschange: root::mozilla::detail::GkAtoms_Atoms =
                896;
            pub const GkAtoms_Atoms_onshippingoptionchange: root::mozilla::detail::GkAtoms_Atoms =
                897;
            pub const GkAtoms_Atoms_onshow: root::mozilla::detail::GkAtoms_Atoms = 898;
            pub const GkAtoms_Atoms_onslotchange: root::mozilla::detail::GkAtoms_Atoms = 899;
            pub const GkAtoms_Atoms_onsqueeze: root::mozilla::detail::GkAtoms_Atoms = 900;
            pub const GkAtoms_Atoms_onsqueezeend: root::mozilla::detail::GkAtoms_Atoms = 901;
            pub const GkAtoms_Atoms_onsqueezestart: root::mozilla::detail::GkAtoms_Atoms = 902;
            pub const GkAtoms_Atoms_onstatechange: root::mozilla::detail::GkAtoms_Atoms = 903;
            pub const GkAtoms_Atoms_onstorage: root::mozilla::detail::GkAtoms_Atoms = 904;
            pub const GkAtoms_Atoms_onsubmit: root::mozilla::detail::GkAtoms_Atoms = 905;
            pub const GkAtoms_Atoms_onsuccess: root::mozilla::detail::GkAtoms_Atoms = 906;
            pub const GkAtoms_Atoms_onsystemstatusbarclick: root::mozilla::detail::GkAtoms_Atoms =
                907;
            pub const GkAtoms_Atoms_ontypechange: root::mozilla::detail::GkAtoms_Atoms = 908;
            pub const GkAtoms_Atoms_onterminate: root::mozilla::detail::GkAtoms_Atoms = 909;
            pub const GkAtoms_Atoms_ontext: root::mozilla::detail::GkAtoms_Atoms = 910;
            pub const GkAtoms_Atoms_ontextInput: root::mozilla::detail::GkAtoms_Atoms = 911;
            pub const GkAtoms_Atoms_ontoggle: root::mozilla::detail::GkAtoms_Atoms = 912;
            pub const GkAtoms_Atoms_ontonechange: root::mozilla::detail::GkAtoms_Atoms = 913;
            pub const GkAtoms_Atoms_ontouchstart: root::mozilla::detail::GkAtoms_Atoms = 914;
            pub const GkAtoms_Atoms_ontouchend: root::mozilla::detail::GkAtoms_Atoms = 915;
            pub const GkAtoms_Atoms_ontouchmove: root::mozilla::detail::GkAtoms_Atoms = 916;
            pub const GkAtoms_Atoms_ontouchcancel: root::mozilla::detail::GkAtoms_Atoms = 917;
            pub const GkAtoms_Atoms_ontransitioncancel: root::mozilla::detail::GkAtoms_Atoms = 918;
            pub const GkAtoms_Atoms_ontransitionend: root::mozilla::detail::GkAtoms_Atoms = 919;
            pub const GkAtoms_Atoms_ontransitionrun: root::mozilla::detail::GkAtoms_Atoms = 920;
            pub const GkAtoms_Atoms_ontransitionstart: root::mozilla::detail::GkAtoms_Atoms = 921;
            pub const GkAtoms_Atoms_onuncapturederror: root::mozilla::detail::GkAtoms_Atoms = 922;
            pub const GkAtoms_Atoms_onunderflow: root::mozilla::detail::GkAtoms_Atoms = 923;
            pub const GkAtoms_Atoms_onunhandledrejection: root::mozilla::detail::GkAtoms_Atoms =
                924;
            pub const GkAtoms_Atoms_onunload: root::mozilla::detail::GkAtoms_Atoms = 925;
            pub const GkAtoms_Atoms_onunmute: root::mozilla::detail::GkAtoms_Atoms = 926;
            pub const GkAtoms_Atoms_onupdatefound: root::mozilla::detail::GkAtoms_Atoms = 927;
            pub const GkAtoms_Atoms_onupdateready: root::mozilla::detail::GkAtoms_Atoms = 928;
            pub const GkAtoms_Atoms_onupgradeneeded: root::mozilla::detail::GkAtoms_Atoms = 929;
            pub const GkAtoms_Atoms_onversionchange: root::mozilla::detail::GkAtoms_Atoms = 930;
            pub const GkAtoms_Atoms_onvisibilitychange: root::mozilla::detail::GkAtoms_Atoms = 931;
            pub const GkAtoms_Atoms_onvoiceschanged: root::mozilla::detail::GkAtoms_Atoms = 932;
            pub const GkAtoms_Atoms_onvrdisplayactivate: root::mozilla::detail::GkAtoms_Atoms = 933;
            pub const GkAtoms_Atoms_onvrdisplayconnect: root::mozilla::detail::GkAtoms_Atoms = 934;
            pub const GkAtoms_Atoms_onvrdisplaydeactivate: root::mozilla::detail::GkAtoms_Atoms =
                935;
            pub const GkAtoms_Atoms_onvrdisplaydisconnect: root::mozilla::detail::GkAtoms_Atoms =
                936;
            pub const GkAtoms_Atoms_onvrdisplaypresentchange: root::mozilla::detail::GkAtoms_Atoms =
                937;
            pub const GkAtoms_Atoms_onwebkitAnimationEnd: root::mozilla::detail::GkAtoms_Atoms =
                938;
            pub const GkAtoms_Atoms_onwebkitAnimationIteration:
                root::mozilla::detail::GkAtoms_Atoms = 939;
            pub const GkAtoms_Atoms_onwebkitAnimationStart: root::mozilla::detail::GkAtoms_Atoms =
                940;
            pub const GkAtoms_Atoms_onwebkitTransitionEnd: root::mozilla::detail::GkAtoms_Atoms =
                941;
            pub const GkAtoms_Atoms_onwebkitanimationend: root::mozilla::detail::GkAtoms_Atoms =
                942;
            pub const GkAtoms_Atoms_onwebkitanimationiteration:
                root::mozilla::detail::GkAtoms_Atoms = 943;
            pub const GkAtoms_Atoms_onwebkitanimationstart: root::mozilla::detail::GkAtoms_Atoms =
                944;
            pub const GkAtoms_Atoms_onwebkittransitionend: root::mozilla::detail::GkAtoms_Atoms =
                945;
            pub const GkAtoms_Atoms_onwheel: root::mozilla::detail::GkAtoms_Atoms = 946;
            pub const GkAtoms_Atoms_open: root::mozilla::detail::GkAtoms_Atoms = 947;
            pub const GkAtoms_Atoms_optgroup: root::mozilla::detail::GkAtoms_Atoms = 948;
            pub const GkAtoms_Atoms_optimum: root::mozilla::detail::GkAtoms_Atoms = 949;
            pub const GkAtoms_Atoms_option: root::mozilla::detail::GkAtoms_Atoms = 950;
            pub const GkAtoms_Atoms__or: root::mozilla::detail::GkAtoms_Atoms = 951;
            pub const GkAtoms_Atoms_order: root::mozilla::detail::GkAtoms_Atoms = 952;
            pub const GkAtoms_Atoms_ordinal: root::mozilla::detail::GkAtoms_Atoms = 953;
            pub const GkAtoms_Atoms_orient: root::mozilla::detail::GkAtoms_Atoms = 954;
            pub const GkAtoms_Atoms_orientation: root::mozilla::detail::GkAtoms_Atoms = 955;
            pub const GkAtoms_Atoms_origin_trial: root::mozilla::detail::GkAtoms_Atoms = 956;
            pub const GkAtoms_Atoms_otherwise: root::mozilla::detail::GkAtoms_Atoms = 957;
            pub const GkAtoms_Atoms_outerHTML: root::mozilla::detail::GkAtoms_Atoms = 958;
            pub const GkAtoms_Atoms_output: root::mozilla::detail::GkAtoms_Atoms = 959;
            pub const GkAtoms_Atoms_overflow: root::mozilla::detail::GkAtoms_Atoms = 960;
            pub const GkAtoms_Atoms_overflowBlock: root::mozilla::detail::GkAtoms_Atoms = 961;
            pub const GkAtoms_Atoms_overflowInline: root::mozilla::detail::GkAtoms_Atoms = 962;
            pub const GkAtoms_Atoms_overlay: root::mozilla::detail::GkAtoms_Atoms = 963;
            pub const GkAtoms_Atoms_p: root::mozilla::detail::GkAtoms_Atoms = 964;
            pub const GkAtoms_Atoms_pack: root::mozilla::detail::GkAtoms_Atoms = 965;
            pub const GkAtoms_Atoms_page: root::mozilla::detail::GkAtoms_Atoms = 966;
            pub const GkAtoms_Atoms_pageincrement: root::mozilla::detail::GkAtoms_Atoms = 967;
            pub const GkAtoms_Atoms_paint: root::mozilla::detail::GkAtoms_Atoms = 968;
            pub const GkAtoms_Atoms_paint_order: root::mozilla::detail::GkAtoms_Atoms = 969;
            pub const GkAtoms_Atoms_panel: root::mozilla::detail::GkAtoms_Atoms = 970;
            pub const GkAtoms_Atoms_paragraph: root::mozilla::detail::GkAtoms_Atoms = 971;
            pub const GkAtoms_Atoms_param: root::mozilla::detail::GkAtoms_Atoms = 972;
            pub const GkAtoms_Atoms_parameter: root::mozilla::detail::GkAtoms_Atoms = 973;
            pub const GkAtoms_Atoms_parent: root::mozilla::detail::GkAtoms_Atoms = 974;
            pub const GkAtoms_Atoms_parsererror: root::mozilla::detail::GkAtoms_Atoms = 975;
            pub const GkAtoms_Atoms_part: root::mozilla::detail::GkAtoms_Atoms = 976;
            pub const GkAtoms_Atoms_password: root::mozilla::detail::GkAtoms_Atoms = 977;
            pub const GkAtoms_Atoms_pattern: root::mozilla::detail::GkAtoms_Atoms = 978;
            pub const GkAtoms_Atoms_patternSeparator: root::mozilla::detail::GkAtoms_Atoms = 979;
            pub const GkAtoms_Atoms_perMille: root::mozilla::detail::GkAtoms_Atoms = 980;
            pub const GkAtoms_Atoms_percent: root::mozilla::detail::GkAtoms_Atoms = 981;
            pub const GkAtoms_Atoms_persist: root::mozilla::detail::GkAtoms_Atoms = 982;
            pub const GkAtoms_Atoms_phase: root::mozilla::detail::GkAtoms_Atoms = 983;
            pub const GkAtoms_Atoms_picture: root::mozilla::detail::GkAtoms_Atoms = 984;
            pub const GkAtoms_Atoms_ping: root::mozilla::detail::GkAtoms_Atoms = 985;
            pub const GkAtoms_Atoms_pinned: root::mozilla::detail::GkAtoms_Atoms = 986;
            pub const GkAtoms_Atoms_placeholder: root::mozilla::detail::GkAtoms_Atoms = 987;
            pub const GkAtoms_Atoms_plaintext: root::mozilla::detail::GkAtoms_Atoms = 988;
            pub const GkAtoms_Atoms_plaintextOnly: root::mozilla::detail::GkAtoms_Atoms = 989;
            pub const GkAtoms_Atoms_playbackrate: root::mozilla::detail::GkAtoms_Atoms = 990;
            pub const GkAtoms_Atoms_pointSize: root::mozilla::detail::GkAtoms_Atoms = 991;
            pub const GkAtoms_Atoms_poly: root::mozilla::detail::GkAtoms_Atoms = 992;
            pub const GkAtoms_Atoms_polygon: root::mozilla::detail::GkAtoms_Atoms = 993;
            pub const GkAtoms_Atoms_popover: root::mozilla::detail::GkAtoms_Atoms = 994;
            pub const GkAtoms_Atoms_popovertarget: root::mozilla::detail::GkAtoms_Atoms = 995;
            pub const GkAtoms_Atoms_popovertargetaction: root::mozilla::detail::GkAtoms_Atoms = 996;
            pub const GkAtoms_Atoms_popup: root::mozilla::detail::GkAtoms_Atoms = 997;
            pub const GkAtoms_Atoms_popupalign: root::mozilla::detail::GkAtoms_Atoms = 998;
            pub const GkAtoms_Atoms_popupanchor: root::mozilla::detail::GkAtoms_Atoms = 999;
            pub const GkAtoms_Atoms_popupgroup: root::mozilla::detail::GkAtoms_Atoms = 1000;
            pub const GkAtoms_Atoms_popupset: root::mozilla::detail::GkAtoms_Atoms = 1001;
            pub const GkAtoms_Atoms_popupsinherittooltip: root::mozilla::detail::GkAtoms_Atoms =
                1002;
            pub const GkAtoms_Atoms_portal: root::mozilla::detail::GkAtoms_Atoms = 1003;
            pub const GkAtoms_Atoms_position: root::mozilla::detail::GkAtoms_Atoms = 1004;
            pub const GkAtoms_Atoms_poster: root::mozilla::detail::GkAtoms_Atoms = 1005;
            pub const GkAtoms_Atoms_pre: root::mozilla::detail::GkAtoms_Atoms = 1006;
            pub const GkAtoms_Atoms_preceding: root::mozilla::detail::GkAtoms_Atoms = 1007;
            pub const GkAtoms_Atoms_precedingSibling: root::mozilla::detail::GkAtoms_Atoms = 1008;
            pub const GkAtoms_Atoms_prefersReducedMotion: root::mozilla::detail::GkAtoms_Atoms =
                1009;
            pub const GkAtoms_Atoms_prefersReducedTransparency:
                root::mozilla::detail::GkAtoms_Atoms = 1010;
            pub const GkAtoms_Atoms_prefersColorScheme: root::mozilla::detail::GkAtoms_Atoms = 1011;
            pub const GkAtoms_Atoms_prefersContrast: root::mozilla::detail::GkAtoms_Atoms = 1012;
            pub const GkAtoms_Atoms_prefix: root::mozilla::detail::GkAtoms_Atoms = 1013;
            pub const GkAtoms_Atoms_prefwidth: root::mozilla::detail::GkAtoms_Atoms = 1014;
            pub const GkAtoms_Atoms_queue: root::mozilla::detail::GkAtoms_Atoms = 1015;
            pub const GkAtoms_Atoms_dynamicRange: root::mozilla::detail::GkAtoms_Atoms = 1016;
            pub const GkAtoms_Atoms_videoDynamicRange: root::mozilla::detail::GkAtoms_Atoms = 1017;
            pub const GkAtoms_Atoms_scripting: root::mozilla::detail::GkAtoms_Atoms = 1018;
            pub const GkAtoms_Atoms_preload: root::mozilla::detail::GkAtoms_Atoms = 1019;
            pub const GkAtoms_Atoms_preserve: root::mozilla::detail::GkAtoms_Atoms = 1020;
            pub const GkAtoms_Atoms_preserveSpace: root::mozilla::detail::GkAtoms_Atoms = 1021;
            pub const GkAtoms_Atoms_preventdefault: root::mozilla::detail::GkAtoms_Atoms = 1022;
            pub const GkAtoms_Atoms_previewDiv: root::mozilla::detail::GkAtoms_Atoms = 1023;
            pub const GkAtoms_Atoms_primary: root::mozilla::detail::GkAtoms_Atoms = 1024;
            pub const GkAtoms_Atoms_print: root::mozilla::detail::GkAtoms_Atoms = 1025;
            pub const GkAtoms_Atoms_printisfocuseddoc: root::mozilla::detail::GkAtoms_Atoms = 1026;
            pub const GkAtoms_Atoms_printselectionranges: root::mozilla::detail::GkAtoms_Atoms =
                1027;
            pub const GkAtoms_Atoms_priority: root::mozilla::detail::GkAtoms_Atoms = 1028;
            pub const GkAtoms_Atoms_processingInstruction: root::mozilla::detail::GkAtoms_Atoms =
                1029;
            pub const GkAtoms_Atoms_profile: root::mozilla::detail::GkAtoms_Atoms = 1030;
            pub const GkAtoms_Atoms_progress: root::mozilla::detail::GkAtoms_Atoms = 1031;
            pub const GkAtoms_Atoms_prompt: root::mozilla::detail::GkAtoms_Atoms = 1032;
            pub const GkAtoms_Atoms_properties: root::mozilla::detail::GkAtoms_Atoms = 1033;
            pub const GkAtoms_Atoms_property: root::mozilla::detail::GkAtoms_Atoms = 1034;
            pub const GkAtoms_Atoms_pubdate: root::mozilla::detail::GkAtoms_Atoms = 1035;
            pub const GkAtoms_Atoms_q: root::mozilla::detail::GkAtoms_Atoms = 1036;
            pub const GkAtoms_Atoms_radio: root::mozilla::detail::GkAtoms_Atoms = 1037;
            pub const GkAtoms_Atoms_radioLabel: root::mozilla::detail::GkAtoms_Atoms = 1038;
            pub const GkAtoms_Atoms_radiogroup: root::mozilla::detail::GkAtoms_Atoms = 1039;
            pub const GkAtoms_Atoms_range: root::mozilla::detail::GkAtoms_Atoms = 1040;
            pub const GkAtoms_Atoms_readonly: root::mozilla::detail::GkAtoms_Atoms = 1041;
            pub const GkAtoms_Atoms_rect: root::mozilla::detail::GkAtoms_Atoms = 1042;
            pub const GkAtoms_Atoms_rectangle: root::mozilla::detail::GkAtoms_Atoms = 1043;
            pub const GkAtoms_Atoms_refresh: root::mozilla::detail::GkAtoms_Atoms = 1044;
            pub const GkAtoms_Atoms_rel: root::mozilla::detail::GkAtoms_Atoms = 1045;
            pub const GkAtoms_Atoms_relativeBounds: root::mozilla::detail::GkAtoms_Atoms = 1046;
            pub const GkAtoms_Atoms_rem: root::mozilla::detail::GkAtoms_Atoms = 1047;
            pub const GkAtoms_Atoms_remote: root::mozilla::detail::GkAtoms_Atoms = 1048;
            pub const GkAtoms_Atoms_removeelement: root::mozilla::detail::GkAtoms_Atoms = 1049;
            pub const GkAtoms_Atoms_render: root::mozilla::detail::GkAtoms_Atoms = 1050;
            pub const GkAtoms_Atoms_renderingobserverset: root::mozilla::detail::GkAtoms_Atoms =
                1051;
            pub const GkAtoms_Atoms_repeat: root::mozilla::detail::GkAtoms_Atoms = 1052;
            pub const GkAtoms_Atoms_replace: root::mozilla::detail::GkAtoms_Atoms = 1053;
            pub const GkAtoms_Atoms_requestcontextid: root::mozilla::detail::GkAtoms_Atoms = 1054;
            pub const GkAtoms_Atoms_required: root::mozilla::detail::GkAtoms_Atoms = 1055;
            pub const GkAtoms_Atoms_reserved: root::mozilla::detail::GkAtoms_Atoms = 1056;
            pub const GkAtoms_Atoms_reset: root::mozilla::detail::GkAtoms_Atoms = 1057;
            pub const GkAtoms_Atoms_resizeafter: root::mozilla::detail::GkAtoms_Atoms = 1058;
            pub const GkAtoms_Atoms_resizebefore: root::mozilla::detail::GkAtoms_Atoms = 1059;
            pub const GkAtoms_Atoms_resizer: root::mozilla::detail::GkAtoms_Atoms = 1060;
            pub const GkAtoms_Atoms_resolution: root::mozilla::detail::GkAtoms_Atoms = 1061;
            pub const GkAtoms_Atoms_resources: root::mozilla::detail::GkAtoms_Atoms = 1062;
            pub const GkAtoms_Atoms_result: root::mozilla::detail::GkAtoms_Atoms = 1063;
            pub const GkAtoms_Atoms_resultPrefix: root::mozilla::detail::GkAtoms_Atoms = 1064;
            pub const GkAtoms_Atoms_retargetdocumentfocus: root::mozilla::detail::GkAtoms_Atoms =
                1065;
            pub const GkAtoms_Atoms_rev: root::mozilla::detail::GkAtoms_Atoms = 1066;
            pub const GkAtoms_Atoms_reverse: root::mozilla::detail::GkAtoms_Atoms = 1067;
            pub const GkAtoms_Atoms_reversed: root::mozilla::detail::GkAtoms_Atoms = 1068;
            pub const GkAtoms_Atoms_rhs: root::mozilla::detail::GkAtoms_Atoms = 1069;
            pub const GkAtoms_Atoms_richlistbox: root::mozilla::detail::GkAtoms_Atoms = 1070;
            pub const GkAtoms_Atoms_richlistitem: root::mozilla::detail::GkAtoms_Atoms = 1071;
            pub const GkAtoms_Atoms_right: root::mozilla::detail::GkAtoms_Atoms = 1072;
            pub const GkAtoms_Atoms_rightmargin: root::mozilla::detail::GkAtoms_Atoms = 1073;
            pub const GkAtoms_Atoms_role: root::mozilla::detail::GkAtoms_Atoms = 1074;
            pub const GkAtoms_Atoms_rolluponmousewheel: root::mozilla::detail::GkAtoms_Atoms = 1075;
            pub const GkAtoms_Atoms_round: root::mozilla::detail::GkAtoms_Atoms = 1076;
            pub const GkAtoms_Atoms_row: root::mozilla::detail::GkAtoms_Atoms = 1077;
            pub const GkAtoms_Atoms_rows: root::mozilla::detail::GkAtoms_Atoms = 1078;
            pub const GkAtoms_Atoms_rowspan: root::mozilla::detail::GkAtoms_Atoms = 1079;
            pub const GkAtoms_Atoms_rb: root::mozilla::detail::GkAtoms_Atoms = 1080;
            pub const GkAtoms_Atoms_rp: root::mozilla::detail::GkAtoms_Atoms = 1081;
            pub const GkAtoms_Atoms_rt: root::mozilla::detail::GkAtoms_Atoms = 1082;
            pub const GkAtoms_Atoms_rtc: root::mozilla::detail::GkAtoms_Atoms = 1083;
            pub const GkAtoms_Atoms_rtl: root::mozilla::detail::GkAtoms_Atoms = 1084;
            pub const GkAtoms_Atoms_ruby: root::mozilla::detail::GkAtoms_Atoms = 1085;
            pub const GkAtoms_Atoms_rubyBase: root::mozilla::detail::GkAtoms_Atoms = 1086;
            pub const GkAtoms_Atoms_rubyBaseContainer: root::mozilla::detail::GkAtoms_Atoms = 1087;
            pub const GkAtoms_Atoms_rubyText: root::mozilla::detail::GkAtoms_Atoms = 1088;
            pub const GkAtoms_Atoms_rubyTextContainer: root::mozilla::detail::GkAtoms_Atoms = 1089;
            pub const GkAtoms_Atoms_rules: root::mozilla::detail::GkAtoms_Atoms = 1090;
            pub const GkAtoms_Atoms_s: root::mozilla::detail::GkAtoms_Atoms = 1091;
            pub const GkAtoms_Atoms_safe_area_inset_top: root::mozilla::detail::GkAtoms_Atoms =
                1092;
            pub const GkAtoms_Atoms_safe_area_inset_bottom: root::mozilla::detail::GkAtoms_Atoms =
                1093;
            pub const GkAtoms_Atoms_safe_area_inset_left: root::mozilla::detail::GkAtoms_Atoms =
                1094;
            pub const GkAtoms_Atoms_safe_area_inset_right: root::mozilla::detail::GkAtoms_Atoms =
                1095;
            pub const GkAtoms_Atoms_samp: root::mozilla::detail::GkAtoms_Atoms = 1096;
            pub const GkAtoms_Atoms_sandbox: root::mozilla::detail::GkAtoms_Atoms = 1097;
            pub const GkAtoms_Atoms_sbattr: root::mozilla::detail::GkAtoms_Atoms = 1098;
            pub const GkAtoms_Atoms_scale: root::mozilla::detail::GkAtoms_Atoms = 1099;
            pub const GkAtoms_Atoms_scan: root::mozilla::detail::GkAtoms_Atoms = 1100;
            pub const GkAtoms_Atoms_scheme: root::mozilla::detail::GkAtoms_Atoms = 1101;
            pub const GkAtoms_Atoms_scope: root::mozilla::detail::GkAtoms_Atoms = 1102;
            pub const GkAtoms_Atoms_scoped: root::mozilla::detail::GkAtoms_Atoms = 1103;
            pub const GkAtoms_Atoms_screen: root::mozilla::detail::GkAtoms_Atoms = 1104;
            pub const GkAtoms_Atoms_screenX: root::mozilla::detail::GkAtoms_Atoms = 1105;
            pub const GkAtoms_Atoms_screenx: root::mozilla::detail::GkAtoms_Atoms = 1106;
            pub const GkAtoms_Atoms_screenY: root::mozilla::detail::GkAtoms_Atoms = 1107;
            pub const GkAtoms_Atoms_screeny: root::mozilla::detail::GkAtoms_Atoms = 1108;
            pub const GkAtoms_Atoms_script: root::mozilla::detail::GkAtoms_Atoms = 1109;
            pub const GkAtoms_Atoms_scrollbar: root::mozilla::detail::GkAtoms_Atoms = 1110;
            pub const GkAtoms_Atoms_scrollbarThumb: root::mozilla::detail::GkAtoms_Atoms = 1111;
            pub const GkAtoms_Atoms_scrollamount: root::mozilla::detail::GkAtoms_Atoms = 1112;
            pub const GkAtoms_Atoms_scrollbarbutton: root::mozilla::detail::GkAtoms_Atoms = 1113;
            pub const GkAtoms_Atoms_scrollbarDownBottom: root::mozilla::detail::GkAtoms_Atoms =
                1114;
            pub const GkAtoms_Atoms_scrollbarDownTop: root::mozilla::detail::GkAtoms_Atoms = 1115;
            pub const GkAtoms_Atoms_scrollbarInlineSize: root::mozilla::detail::GkAtoms_Atoms =
                1116;
            pub const GkAtoms_Atoms_scrollbarUpBottom: root::mozilla::detail::GkAtoms_Atoms = 1117;
            pub const GkAtoms_Atoms_scrollbarUpTop: root::mozilla::detail::GkAtoms_Atoms = 1118;
            pub const GkAtoms_Atoms_scrollbox: root::mozilla::detail::GkAtoms_Atoms = 1119;
            pub const GkAtoms_Atoms_scrollcorner: root::mozilla::detail::GkAtoms_Atoms = 1120;
            pub const GkAtoms_Atoms_scrolldelay: root::mozilla::detail::GkAtoms_Atoms = 1121;
            pub const GkAtoms_Atoms_scrolling: root::mozilla::detail::GkAtoms_Atoms = 1122;
            pub const GkAtoms_Atoms_scrollPosition: root::mozilla::detail::GkAtoms_Atoms = 1123;
            pub const GkAtoms_Atoms_se: root::mozilla::detail::GkAtoms_Atoms = 1124;
            pub const GkAtoms_Atoms_section: root::mozilla::detail::GkAtoms_Atoms = 1125;
            pub const GkAtoms_Atoms_select: root::mozilla::detail::GkAtoms_Atoms = 1126;
            pub const GkAtoms_Atoms_selected: root::mozilla::detail::GkAtoms_Atoms = 1127;
            pub const GkAtoms_Atoms_selectedIndex: root::mozilla::detail::GkAtoms_Atoms = 1128;
            pub const GkAtoms_Atoms_selectedindex: root::mozilla::detail::GkAtoms_Atoms = 1129;
            pub const GkAtoms_Atoms_selectmenu: root::mozilla::detail::GkAtoms_Atoms = 1130;
            pub const GkAtoms_Atoms_self_: root::mozilla::detail::GkAtoms_Atoms = 1131;
            pub const GkAtoms_Atoms_seltype: root::mozilla::detail::GkAtoms_Atoms = 1132;
            pub const GkAtoms_Atoms_setcookie: root::mozilla::detail::GkAtoms_Atoms = 1133;
            pub const GkAtoms_Atoms_setter: root::mozilla::detail::GkAtoms_Atoms = 1134;
            pub const GkAtoms_Atoms_shadow: root::mozilla::detail::GkAtoms_Atoms = 1135;
            pub const GkAtoms_Atoms_shape: root::mozilla::detail::GkAtoms_Atoms = 1136;
            pub const GkAtoms_Atoms_show: root::mozilla::detail::GkAtoms_Atoms = 1137;
            pub const GkAtoms_Atoms_showcaret: root::mozilla::detail::GkAtoms_Atoms = 1138;
            pub const GkAtoms_Atoms_show_modal: root::mozilla::detail::GkAtoms_Atoms = 1139;
            pub const GkAtoms_Atoms_show_popover: root::mozilla::detail::GkAtoms_Atoms = 1140;
            pub const GkAtoms_Atoms_showservicesmenu: root::mozilla::detail::GkAtoms_Atoms = 1141;
            pub const GkAtoms_Atoms_sibling: root::mozilla::detail::GkAtoms_Atoms = 1142;
            pub const GkAtoms_Atoms_simple: root::mozilla::detail::GkAtoms_Atoms = 1143;
            pub const GkAtoms_Atoms_simp_chinese_formal: root::mozilla::detail::GkAtoms_Atoms =
                1144;
            pub const GkAtoms_Atoms_simp_chinese_informal: root::mozilla::detail::GkAtoms_Atoms =
                1145;
            pub const GkAtoms_Atoms_single: root::mozilla::detail::GkAtoms_Atoms = 1146;
            pub const GkAtoms_Atoms_size: root::mozilla::detail::GkAtoms_Atoms = 1147;
            pub const GkAtoms_Atoms_sizes: root::mozilla::detail::GkAtoms_Atoms = 1148;
            pub const GkAtoms_Atoms_sizemode: root::mozilla::detail::GkAtoms_Atoms = 1149;
            pub const GkAtoms_Atoms_sizetopopup: root::mozilla::detail::GkAtoms_Atoms = 1150;
            pub const GkAtoms_Atoms_slider: root::mozilla::detail::GkAtoms_Atoms = 1151;
            pub const GkAtoms_Atoms_small: root::mozilla::detail::GkAtoms_Atoms = 1152;
            pub const GkAtoms_Atoms_smooth: root::mozilla::detail::GkAtoms_Atoms = 1153;
            pub const GkAtoms_Atoms_snap: root::mozilla::detail::GkAtoms_Atoms = 1154;
            pub const GkAtoms_Atoms_solid: root::mozilla::detail::GkAtoms_Atoms = 1155;
            pub const GkAtoms_Atoms_sort: root::mozilla::detail::GkAtoms_Atoms = 1156;
            pub const GkAtoms_Atoms_sortActive: root::mozilla::detail::GkAtoms_Atoms = 1157;
            pub const GkAtoms_Atoms_sortDirection: root::mozilla::detail::GkAtoms_Atoms = 1158;
            pub const GkAtoms_Atoms_sorted: root::mozilla::detail::GkAtoms_Atoms = 1159;
            pub const GkAtoms_Atoms_sorthints: root::mozilla::detail::GkAtoms_Atoms = 1160;
            pub const GkAtoms_Atoms_source: root::mozilla::detail::GkAtoms_Atoms = 1161;
            pub const GkAtoms_Atoms_sourcetext: root::mozilla::detail::GkAtoms_Atoms = 1162;
            pub const GkAtoms_Atoms_space: root::mozilla::detail::GkAtoms_Atoms = 1163;
            pub const GkAtoms_Atoms_spacer: root::mozilla::detail::GkAtoms_Atoms = 1164;
            pub const GkAtoms_Atoms_span: root::mozilla::detail::GkAtoms_Atoms = 1165;
            pub const GkAtoms_Atoms_spellcheck: root::mozilla::detail::GkAtoms_Atoms = 1166;
            pub const GkAtoms_Atoms_split: root::mozilla::detail::GkAtoms_Atoms = 1167;
            pub const GkAtoms_Atoms_splitter: root::mozilla::detail::GkAtoms_Atoms = 1168;
            pub const GkAtoms_Atoms_square: root::mozilla::detail::GkAtoms_Atoms = 1169;
            pub const GkAtoms_Atoms_src: root::mozilla::detail::GkAtoms_Atoms = 1170;
            pub const GkAtoms_Atoms_srcdoc: root::mozilla::detail::GkAtoms_Atoms = 1171;
            pub const GkAtoms_Atoms_srclang: root::mozilla::detail::GkAtoms_Atoms = 1172;
            pub const GkAtoms_Atoms_srcset: root::mozilla::detail::GkAtoms_Atoms = 1173;
            pub const GkAtoms_Atoms_standalone: root::mozilla::detail::GkAtoms_Atoms = 1174;
            pub const GkAtoms_Atoms_standby: root::mozilla::detail::GkAtoms_Atoms = 1175;
            pub const GkAtoms_Atoms_start: root::mozilla::detail::GkAtoms_Atoms = 1176;
            pub const GkAtoms_Atoms_startsWith: root::mozilla::detail::GkAtoms_Atoms = 1177;
            pub const GkAtoms_Atoms_state: root::mozilla::detail::GkAtoms_Atoms = 1178;
            pub const GkAtoms_Atoms_statusbar: root::mozilla::detail::GkAtoms_Atoms = 1179;
            pub const GkAtoms_Atoms_step: root::mozilla::detail::GkAtoms_Atoms = 1180;
            pub const GkAtoms_Atoms_stop: root::mozilla::detail::GkAtoms_Atoms = 1181;
            pub const GkAtoms_Atoms_stretch: root::mozilla::detail::GkAtoms_Atoms = 1182;
            pub const GkAtoms_Atoms_strike: root::mozilla::detail::GkAtoms_Atoms = 1183;
            pub const GkAtoms_Atoms_string: root::mozilla::detail::GkAtoms_Atoms = 1184;
            pub const GkAtoms_Atoms_stringLength: root::mozilla::detail::GkAtoms_Atoms = 1185;
            pub const GkAtoms_Atoms_stripSpace: root::mozilla::detail::GkAtoms_Atoms = 1186;
            pub const GkAtoms_Atoms_strong: root::mozilla::detail::GkAtoms_Atoms = 1187;
            pub const GkAtoms_Atoms_style: root::mozilla::detail::GkAtoms_Atoms = 1188;
            pub const GkAtoms_Atoms_stylesheet: root::mozilla::detail::GkAtoms_Atoms = 1189;
            pub const GkAtoms_Atoms_stylesheetPrefix: root::mozilla::detail::GkAtoms_Atoms = 1190;
            pub const GkAtoms_Atoms_submit: root::mozilla::detail::GkAtoms_Atoms = 1191;
            pub const GkAtoms_Atoms_substate: root::mozilla::detail::GkAtoms_Atoms = 1192;
            pub const GkAtoms_Atoms_substring: root::mozilla::detail::GkAtoms_Atoms = 1193;
            pub const GkAtoms_Atoms_substringAfter: root::mozilla::detail::GkAtoms_Atoms = 1194;
            pub const GkAtoms_Atoms_substringBefore: root::mozilla::detail::GkAtoms_Atoms = 1195;
            pub const GkAtoms_Atoms_sub: root::mozilla::detail::GkAtoms_Atoms = 1196;
            pub const GkAtoms_Atoms_suggestion: root::mozilla::detail::GkAtoms_Atoms = 1197;
            pub const GkAtoms_Atoms_sum: root::mozilla::detail::GkAtoms_Atoms = 1198;
            pub const GkAtoms_Atoms_sup: root::mozilla::detail::GkAtoms_Atoms = 1199;
            pub const GkAtoms_Atoms_summary: root::mozilla::detail::GkAtoms_Atoms = 1200;
            pub const GkAtoms_Atoms_sw: root::mozilla::detail::GkAtoms_Atoms = 1201;
            pub const GkAtoms_Atoms_systemProperty: root::mozilla::detail::GkAtoms_Atoms = 1202;
            pub const GkAtoms_Atoms_tab: root::mozilla::detail::GkAtoms_Atoms = 1203;
            pub const GkAtoms_Atoms_tabindex: root::mozilla::detail::GkAtoms_Atoms = 1204;
            pub const GkAtoms_Atoms_table: root::mozilla::detail::GkAtoms_Atoms = 1205;
            pub const GkAtoms_Atoms_tabpanel: root::mozilla::detail::GkAtoms_Atoms = 1206;
            pub const GkAtoms_Atoms_tabpanels: root::mozilla::detail::GkAtoms_Atoms = 1207;
            pub const GkAtoms_Atoms_tag: root::mozilla::detail::GkAtoms_Atoms = 1208;
            pub const GkAtoms_Atoms_target: root::mozilla::detail::GkAtoms_Atoms = 1209;
            pub const GkAtoms_Atoms_targets: root::mozilla::detail::GkAtoms_Atoms = 1210;
            pub const GkAtoms_Atoms_tbody: root::mozilla::detail::GkAtoms_Atoms = 1211;
            pub const GkAtoms_Atoms_td: root::mozilla::detail::GkAtoms_Atoms = 1212;
            pub const GkAtoms_Atoms_tel: root::mozilla::detail::GkAtoms_Atoms = 1213;
            pub const GkAtoms_Atoms__template: root::mozilla::detail::GkAtoms_Atoms = 1214;
            pub const GkAtoms_Atoms_text_decoration: root::mozilla::detail::GkAtoms_Atoms = 1215;
            pub const GkAtoms_Atoms_terminate: root::mozilla::detail::GkAtoms_Atoms = 1216;
            pub const GkAtoms_Atoms_term: root::mozilla::detail::GkAtoms_Atoms = 1217;
            pub const GkAtoms_Atoms_test: root::mozilla::detail::GkAtoms_Atoms = 1218;
            pub const GkAtoms_Atoms_text: root::mozilla::detail::GkAtoms_Atoms = 1219;
            pub const GkAtoms_Atoms_textAlign: root::mozilla::detail::GkAtoms_Atoms = 1220;
            pub const GkAtoms_Atoms_textarea: root::mozilla::detail::GkAtoms_Atoms = 1221;
            pub const GkAtoms_Atoms_textbox: root::mozilla::detail::GkAtoms_Atoms = 1222;
            pub const GkAtoms_Atoms_textContent: root::mozilla::detail::GkAtoms_Atoms = 1223;
            pub const GkAtoms_Atoms_textLink: root::mozilla::detail::GkAtoms_Atoms = 1224;
            pub const GkAtoms_Atoms_textOverlay: root::mozilla::detail::GkAtoms_Atoms = 1225;
            pub const GkAtoms_Atoms_tfoot: root::mozilla::detail::GkAtoms_Atoms = 1226;
            pub const GkAtoms_Atoms_th: root::mozilla::detail::GkAtoms_Atoms = 1227;
            pub const GkAtoms_Atoms_thead: root::mozilla::detail::GkAtoms_Atoms = 1228;
            pub const GkAtoms_Atoms_thumb: root::mozilla::detail::GkAtoms_Atoms = 1229;
            pub const GkAtoms_Atoms_time: root::mozilla::detail::GkAtoms_Atoms = 1230;
            pub const GkAtoms_Atoms_title: root::mozilla::detail::GkAtoms_Atoms = 1231;
            pub const GkAtoms_Atoms_titletip: root::mozilla::detail::GkAtoms_Atoms = 1232;
            pub const GkAtoms_Atoms_toggle: root::mozilla::detail::GkAtoms_Atoms = 1233;
            pub const GkAtoms_Atoms_toggle_popover: root::mozilla::detail::GkAtoms_Atoms = 1234;
            pub const GkAtoms_Atoms_token: root::mozilla::detail::GkAtoms_Atoms = 1235;
            pub const GkAtoms_Atoms_tokenize: root::mozilla::detail::GkAtoms_Atoms = 1236;
            pub const GkAtoms_Atoms_toolbar: root::mozilla::detail::GkAtoms_Atoms = 1237;
            pub const GkAtoms_Atoms_toolbarbutton: root::mozilla::detail::GkAtoms_Atoms = 1238;
            pub const GkAtoms_Atoms_toolbaritem: root::mozilla::detail::GkAtoms_Atoms = 1239;
            pub const GkAtoms_Atoms_toolbarpaletteitem: root::mozilla::detail::GkAtoms_Atoms = 1240;
            pub const GkAtoms_Atoms_toolbox: root::mozilla::detail::GkAtoms_Atoms = 1241;
            pub const GkAtoms_Atoms_tooltip: root::mozilla::detail::GkAtoms_Atoms = 1242;
            pub const GkAtoms_Atoms_tooltiptext: root::mozilla::detail::GkAtoms_Atoms = 1243;
            pub const GkAtoms_Atoms_top: root::mozilla::detail::GkAtoms_Atoms = 1244;
            pub const GkAtoms_Atoms_topleft: root::mozilla::detail::GkAtoms_Atoms = 1245;
            pub const GkAtoms_Atoms_topmargin: root::mozilla::detail::GkAtoms_Atoms = 1246;
            pub const GkAtoms_Atoms_topright: root::mozilla::detail::GkAtoms_Atoms = 1247;
            pub const GkAtoms_Atoms_tr: root::mozilla::detail::GkAtoms_Atoms = 1248;
            pub const GkAtoms_Atoms_track: root::mozilla::detail::GkAtoms_Atoms = 1249;
            pub const GkAtoms_Atoms_trad_chinese_formal: root::mozilla::detail::GkAtoms_Atoms =
                1250;
            pub const GkAtoms_Atoms_trad_chinese_informal: root::mozilla::detail::GkAtoms_Atoms =
                1251;
            pub const GkAtoms_Atoms_trailing: root::mozilla::detail::GkAtoms_Atoms = 1252;
            pub const GkAtoms_Atoms_transform: root::mozilla::detail::GkAtoms_Atoms = 1253;
            pub const GkAtoms_Atoms_transform_3d: root::mozilla::detail::GkAtoms_Atoms = 1254;
            pub const GkAtoms_Atoms_transformiix: root::mozilla::detail::GkAtoms_Atoms = 1255;
            pub const GkAtoms_Atoms_translate: root::mozilla::detail::GkAtoms_Atoms = 1256;
            pub const GkAtoms_Atoms_transparent: root::mozilla::detail::GkAtoms_Atoms = 1257;
            pub const GkAtoms_Atoms_tree: root::mozilla::detail::GkAtoms_Atoms = 1258;
            pub const GkAtoms_Atoms_treecell: root::mozilla::detail::GkAtoms_Atoms = 1259;
            pub const GkAtoms_Atoms_treechildren: root::mozilla::detail::GkAtoms_Atoms = 1260;
            pub const GkAtoms_Atoms_treecol: root::mozilla::detail::GkAtoms_Atoms = 1261;
            pub const GkAtoms_Atoms_treecolpicker: root::mozilla::detail::GkAtoms_Atoms = 1262;
            pub const GkAtoms_Atoms_treecols: root::mozilla::detail::GkAtoms_Atoms = 1263;
            pub const GkAtoms_Atoms_treeitem: root::mozilla::detail::GkAtoms_Atoms = 1264;
            pub const GkAtoms_Atoms_treerow: root::mozilla::detail::GkAtoms_Atoms = 1265;
            pub const GkAtoms_Atoms_treeseparator: root::mozilla::detail::GkAtoms_Atoms = 1266;
            pub const GkAtoms_Atoms__true: root::mozilla::detail::GkAtoms_Atoms = 1267;
            pub const GkAtoms_Atoms_truespeed: root::mozilla::detail::GkAtoms_Atoms = 1268;
            pub const GkAtoms_Atoms_tt: root::mozilla::detail::GkAtoms_Atoms = 1269;
            pub const GkAtoms_Atoms_type_: root::mozilla::detail::GkAtoms_Atoms = 1270;
            pub const GkAtoms_Atoms_u: root::mozilla::detail::GkAtoms_Atoms = 1271;
            pub const GkAtoms_Atoms_ul: root::mozilla::detail::GkAtoms_Atoms = 1272;
            pub const GkAtoms_Atoms_unparsedEntityUri: root::mozilla::detail::GkAtoms_Atoms = 1273;
            pub const GkAtoms_Atoms_untilFound: root::mozilla::detail::GkAtoms_Atoms = 1274;
            pub const GkAtoms_Atoms_up: root::mozilla::detail::GkAtoms_Atoms = 1275;
            pub const GkAtoms_Atoms_update: root::mozilla::detail::GkAtoms_Atoms = 1276;
            pub const GkAtoms_Atoms_upperFirst: root::mozilla::detail::GkAtoms_Atoms = 1277;
            pub const GkAtoms_Atoms_use_: root::mozilla::detail::GkAtoms_Atoms = 1278;
            pub const GkAtoms_Atoms_useAttributeSets: root::mozilla::detail::GkAtoms_Atoms = 1279;
            pub const GkAtoms_Atoms_usemap: root::mozilla::detail::GkAtoms_Atoms = 1280;
            pub const GkAtoms_Atoms_user_scalable: root::mozilla::detail::GkAtoms_Atoms = 1281;
            pub const GkAtoms_Atoms_validate: root::mozilla::detail::GkAtoms_Atoms = 1282;
            pub const GkAtoms_Atoms_valign: root::mozilla::detail::GkAtoms_Atoms = 1283;
            pub const GkAtoms_Atoms_value: root::mozilla::detail::GkAtoms_Atoms = 1284;
            pub const GkAtoms_Atoms_values: root::mozilla::detail::GkAtoms_Atoms = 1285;
            pub const GkAtoms_Atoms_valueOf: root::mozilla::detail::GkAtoms_Atoms = 1286;
            pub const GkAtoms_Atoms_valuetype: root::mozilla::detail::GkAtoms_Atoms = 1287;
            pub const GkAtoms_Atoms_var: root::mozilla::detail::GkAtoms_Atoms = 1288;
            pub const GkAtoms_Atoms_variable: root::mozilla::detail::GkAtoms_Atoms = 1289;
            pub const GkAtoms_Atoms_vendor: root::mozilla::detail::GkAtoms_Atoms = 1290;
            pub const GkAtoms_Atoms_vendorUrl: root::mozilla::detail::GkAtoms_Atoms = 1291;
            pub const GkAtoms_Atoms_version: root::mozilla::detail::GkAtoms_Atoms = 1292;
            pub const GkAtoms_Atoms_vertical: root::mozilla::detail::GkAtoms_Atoms = 1293;
            pub const GkAtoms_Atoms_audio: root::mozilla::detail::GkAtoms_Atoms = 1294;
            pub const GkAtoms_Atoms_video: root::mozilla::detail::GkAtoms_Atoms = 1295;
            pub const GkAtoms_Atoms_viewport: root::mozilla::detail::GkAtoms_Atoms = 1296;
            pub const GkAtoms_Atoms_viewport_fit: root::mozilla::detail::GkAtoms_Atoms = 1297;
            pub const GkAtoms_Atoms_viewport_height: root::mozilla::detail::GkAtoms_Atoms = 1298;
            pub const GkAtoms_Atoms_viewport_initial_scale: root::mozilla::detail::GkAtoms_Atoms =
                1299;
            pub const GkAtoms_Atoms_viewport_maximum_scale: root::mozilla::detail::GkAtoms_Atoms =
                1300;
            pub const GkAtoms_Atoms_viewport_minimum_scale: root::mozilla::detail::GkAtoms_Atoms =
                1301;
            pub const GkAtoms_Atoms_viewport_user_scalable: root::mozilla::detail::GkAtoms_Atoms =
                1302;
            pub const GkAtoms_Atoms_viewport_width: root::mozilla::detail::GkAtoms_Atoms = 1303;
            pub const GkAtoms_Atoms_visibility: root::mozilla::detail::GkAtoms_Atoms = 1304;
            pub const GkAtoms_Atoms_visuallyselected: root::mozilla::detail::GkAtoms_Atoms = 1305;
            pub const GkAtoms_Atoms_vlink: root::mozilla::detail::GkAtoms_Atoms = 1306;
            pub const GkAtoms_Atoms__void: root::mozilla::detail::GkAtoms_Atoms = 1307;
            pub const GkAtoms_Atoms_vsides: root::mozilla::detail::GkAtoms_Atoms = 1308;
            pub const GkAtoms_Atoms_vspace: root::mozilla::detail::GkAtoms_Atoms = 1309;
            pub const GkAtoms_Atoms_w: root::mozilla::detail::GkAtoms_Atoms = 1310;
            pub const GkAtoms_Atoms_wbr: root::mozilla::detail::GkAtoms_Atoms = 1311;
            pub const GkAtoms_Atoms_webkitdirectory: root::mozilla::detail::GkAtoms_Atoms = 1312;
            pub const GkAtoms_Atoms_when: root::mozilla::detail::GkAtoms_Atoms = 1313;
            pub const GkAtoms_Atoms_white: root::mozilla::detail::GkAtoms_Atoms = 1314;
            pub const GkAtoms_Atoms_width: root::mozilla::detail::GkAtoms_Atoms = 1315;
            pub const GkAtoms_Atoms_willChange: root::mozilla::detail::GkAtoms_Atoms = 1316;
            pub const GkAtoms_Atoms_window: root::mozilla::detail::GkAtoms_Atoms = 1317;
            pub const GkAtoms_Atoms_headerWindowTarget: root::mozilla::detail::GkAtoms_Atoms = 1318;
            pub const GkAtoms_Atoms_windowtype: root::mozilla::detail::GkAtoms_Atoms = 1319;
            pub const GkAtoms_Atoms_withParam: root::mozilla::detail::GkAtoms_Atoms = 1320;
            pub const GkAtoms_Atoms_wrap: root::mozilla::detail::GkAtoms_Atoms = 1321;
            pub const GkAtoms_Atoms_headerDNSPrefetchControl: root::mozilla::detail::GkAtoms_Atoms =
                1322;
            pub const GkAtoms_Atoms_headerCSP: root::mozilla::detail::GkAtoms_Atoms = 1323;
            pub const GkAtoms_Atoms_headerCSPReportOnly: root::mozilla::detail::GkAtoms_Atoms =
                1324;
            pub const GkAtoms_Atoms_headerXFO: root::mozilla::detail::GkAtoms_Atoms = 1325;
            pub const GkAtoms_Atoms_x_western: root::mozilla::detail::GkAtoms_Atoms = 1326;
            pub const GkAtoms_Atoms_xml: root::mozilla::detail::GkAtoms_Atoms = 1327;
            pub const GkAtoms_Atoms_xml_stylesheet: root::mozilla::detail::GkAtoms_Atoms = 1328;
            pub const GkAtoms_Atoms_xmlns: root::mozilla::detail::GkAtoms_Atoms = 1329;
            pub const GkAtoms_Atoms_xmp: root::mozilla::detail::GkAtoms_Atoms = 1330;
            pub const GkAtoms_Atoms_xul: root::mozilla::detail::GkAtoms_Atoms = 1331;
            pub const GkAtoms_Atoms_yes: root::mozilla::detail::GkAtoms_Atoms = 1332;
            pub const GkAtoms_Atoms_z_index: root::mozilla::detail::GkAtoms_Atoms = 1333;
            pub const GkAtoms_Atoms_zeroDigit: root::mozilla::detail::GkAtoms_Atoms = 1334;
            pub const GkAtoms_Atoms_zlevel: root::mozilla::detail::GkAtoms_Atoms = 1335;
            pub const GkAtoms_Atoms_percentage: root::mozilla::detail::GkAtoms_Atoms = 1336;
            pub const GkAtoms_Atoms_A: root::mozilla::detail::GkAtoms_Atoms = 1337;
            pub const GkAtoms_Atoms_alignment_baseline: root::mozilla::detail::GkAtoms_Atoms = 1338;
            pub const GkAtoms_Atoms_amplitude: root::mozilla::detail::GkAtoms_Atoms = 1339;
            pub const GkAtoms_Atoms_animate: root::mozilla::detail::GkAtoms_Atoms = 1340;
            pub const GkAtoms_Atoms_animateColor: root::mozilla::detail::GkAtoms_Atoms = 1341;
            pub const GkAtoms_Atoms_animateMotion: root::mozilla::detail::GkAtoms_Atoms = 1342;
            pub const GkAtoms_Atoms_animateTransform: root::mozilla::detail::GkAtoms_Atoms = 1343;
            pub const GkAtoms_Atoms_arithmetic: root::mozilla::detail::GkAtoms_Atoms = 1344;
            pub const GkAtoms_Atoms_atop: root::mozilla::detail::GkAtoms_Atoms = 1345;
            pub const GkAtoms_Atoms_azimuth: root::mozilla::detail::GkAtoms_Atoms = 1346;
            pub const GkAtoms_Atoms_B: root::mozilla::detail::GkAtoms_Atoms = 1347;
            pub const GkAtoms_Atoms_background_color: root::mozilla::detail::GkAtoms_Atoms = 1348;
            pub const GkAtoms_Atoms_background_image: root::mozilla::detail::GkAtoms_Atoms = 1349;
            pub const GkAtoms_Atoms_baseFrequency: root::mozilla::detail::GkAtoms_Atoms = 1350;
            pub const GkAtoms_Atoms_baseline_shift: root::mozilla::detail::GkAtoms_Atoms = 1351;
            pub const GkAtoms_Atoms_bias: root::mozilla::detail::GkAtoms_Atoms = 1352;
            pub const GkAtoms_Atoms_caption_side: root::mozilla::detail::GkAtoms_Atoms = 1353;
            pub const GkAtoms_Atoms_clip_path: root::mozilla::detail::GkAtoms_Atoms = 1354;
            pub const GkAtoms_Atoms_clip_rule: root::mozilla::detail::GkAtoms_Atoms = 1355;
            pub const GkAtoms_Atoms_clipPath: root::mozilla::detail::GkAtoms_Atoms = 1356;
            pub const GkAtoms_Atoms_clipPathUnits: root::mozilla::detail::GkAtoms_Atoms = 1357;
            pub const GkAtoms_Atoms_cm: root::mozilla::detail::GkAtoms_Atoms = 1358;
            pub const GkAtoms_Atoms_color_burn: root::mozilla::detail::GkAtoms_Atoms = 1359;
            pub const GkAtoms_Atoms_color_dodge: root::mozilla::detail::GkAtoms_Atoms = 1360;
            pub const GkAtoms_Atoms_color_interpolation: root::mozilla::detail::GkAtoms_Atoms =
                1361;
            pub const GkAtoms_Atoms_color_interpolation_filters:
                root::mozilla::detail::GkAtoms_Atoms = 1362;
            pub const GkAtoms_Atoms_color_profile: root::mozilla::detail::GkAtoms_Atoms = 1363;
            pub const GkAtoms_Atoms_cursor: root::mozilla::detail::GkAtoms_Atoms = 1364;
            pub const GkAtoms_Atoms_cx: root::mozilla::detail::GkAtoms_Atoms = 1365;
            pub const GkAtoms_Atoms_cy: root::mozilla::detail::GkAtoms_Atoms = 1366;
            pub const GkAtoms_Atoms_d: root::mozilla::detail::GkAtoms_Atoms = 1367;
            pub const GkAtoms_Atoms_darken: root::mozilla::detail::GkAtoms_Atoms = 1368;
            pub const GkAtoms_Atoms_defs: root::mozilla::detail::GkAtoms_Atoms = 1369;
            pub const GkAtoms_Atoms_deg: root::mozilla::detail::GkAtoms_Atoms = 1370;
            pub const GkAtoms_Atoms_desc: root::mozilla::detail::GkAtoms_Atoms = 1371;
            pub const GkAtoms_Atoms_diffuseConstant: root::mozilla::detail::GkAtoms_Atoms = 1372;
            pub const GkAtoms_Atoms_dilate: root::mozilla::detail::GkAtoms_Atoms = 1373;
            pub const GkAtoms_Atoms_direction: root::mozilla::detail::GkAtoms_Atoms = 1374;
            pub const GkAtoms_Atoms_disable: root::mozilla::detail::GkAtoms_Atoms = 1375;
            pub const GkAtoms_Atoms_disc: root::mozilla::detail::GkAtoms_Atoms = 1376;
            pub const GkAtoms_Atoms_discrete: root::mozilla::detail::GkAtoms_Atoms = 1377;
            pub const GkAtoms_Atoms_divisor: root::mozilla::detail::GkAtoms_Atoms = 1378;
            pub const GkAtoms_Atoms_dominant_baseline: root::mozilla::detail::GkAtoms_Atoms = 1379;
            pub const GkAtoms_Atoms_duplicate: root::mozilla::detail::GkAtoms_Atoms = 1380;
            pub const GkAtoms_Atoms_dx: root::mozilla::detail::GkAtoms_Atoms = 1381;
            pub const GkAtoms_Atoms_dy: root::mozilla::detail::GkAtoms_Atoms = 1382;
            pub const GkAtoms_Atoms_edgeMode: root::mozilla::detail::GkAtoms_Atoms = 1383;
            pub const GkAtoms_Atoms_ellipse: root::mozilla::detail::GkAtoms_Atoms = 1384;
            pub const GkAtoms_Atoms_elevation: root::mozilla::detail::GkAtoms_Atoms = 1385;
            pub const GkAtoms_Atoms_erode: root::mozilla::detail::GkAtoms_Atoms = 1386;
            pub const GkAtoms_Atoms_ex: root::mozilla::detail::GkAtoms_Atoms = 1387;
            pub const GkAtoms_Atoms_exact: root::mozilla::detail::GkAtoms_Atoms = 1388;
            pub const GkAtoms_Atoms_exclusion: root::mozilla::detail::GkAtoms_Atoms = 1389;
            pub const GkAtoms_Atoms_exponent: root::mozilla::detail::GkAtoms_Atoms = 1390;
            pub const GkAtoms_Atoms_feBlend: root::mozilla::detail::GkAtoms_Atoms = 1391;
            pub const GkAtoms_Atoms_feColorMatrix: root::mozilla::detail::GkAtoms_Atoms = 1392;
            pub const GkAtoms_Atoms_feComponentTransfer: root::mozilla::detail::GkAtoms_Atoms =
                1393;
            pub const GkAtoms_Atoms_feComposite: root::mozilla::detail::GkAtoms_Atoms = 1394;
            pub const GkAtoms_Atoms_feConvolveMatrix: root::mozilla::detail::GkAtoms_Atoms = 1395;
            pub const GkAtoms_Atoms_feDiffuseLighting: root::mozilla::detail::GkAtoms_Atoms = 1396;
            pub const GkAtoms_Atoms_feDisplacementMap: root::mozilla::detail::GkAtoms_Atoms = 1397;
            pub const GkAtoms_Atoms_feDistantLight: root::mozilla::detail::GkAtoms_Atoms = 1398;
            pub const GkAtoms_Atoms_feDropShadow: root::mozilla::detail::GkAtoms_Atoms = 1399;
            pub const GkAtoms_Atoms_feFlood: root::mozilla::detail::GkAtoms_Atoms = 1400;
            pub const GkAtoms_Atoms_feFuncA: root::mozilla::detail::GkAtoms_Atoms = 1401;
            pub const GkAtoms_Atoms_feFuncB: root::mozilla::detail::GkAtoms_Atoms = 1402;
            pub const GkAtoms_Atoms_feFuncG: root::mozilla::detail::GkAtoms_Atoms = 1403;
            pub const GkAtoms_Atoms_feFuncR: root::mozilla::detail::GkAtoms_Atoms = 1404;
            pub const GkAtoms_Atoms_feGaussianBlur: root::mozilla::detail::GkAtoms_Atoms = 1405;
            pub const GkAtoms_Atoms_feImage: root::mozilla::detail::GkAtoms_Atoms = 1406;
            pub const GkAtoms_Atoms_feMerge: root::mozilla::detail::GkAtoms_Atoms = 1407;
            pub const GkAtoms_Atoms_feMergeNode: root::mozilla::detail::GkAtoms_Atoms = 1408;
            pub const GkAtoms_Atoms_feMorphology: root::mozilla::detail::GkAtoms_Atoms = 1409;
            pub const GkAtoms_Atoms_feOffset: root::mozilla::detail::GkAtoms_Atoms = 1410;
            pub const GkAtoms_Atoms_fePointLight: root::mozilla::detail::GkAtoms_Atoms = 1411;
            pub const GkAtoms_Atoms_feSpecularLighting: root::mozilla::detail::GkAtoms_Atoms = 1412;
            pub const GkAtoms_Atoms_feSpotLight: root::mozilla::detail::GkAtoms_Atoms = 1413;
            pub const GkAtoms_Atoms_feTile: root::mozilla::detail::GkAtoms_Atoms = 1414;
            pub const GkAtoms_Atoms_feTurbulence: root::mozilla::detail::GkAtoms_Atoms = 1415;
            pub const GkAtoms_Atoms_fill: root::mozilla::detail::GkAtoms_Atoms = 1416;
            pub const GkAtoms_Atoms_fill_opacity: root::mozilla::detail::GkAtoms_Atoms = 1417;
            pub const GkAtoms_Atoms_fill_rule: root::mozilla::detail::GkAtoms_Atoms = 1418;
            pub const GkAtoms_Atoms_filter: root::mozilla::detail::GkAtoms_Atoms = 1419;
            pub const GkAtoms_Atoms_filterUnits: root::mozilla::detail::GkAtoms_Atoms = 1420;
            pub const GkAtoms_Atoms__float: root::mozilla::detail::GkAtoms_Atoms = 1421;
            pub const GkAtoms_Atoms_flood_color: root::mozilla::detail::GkAtoms_Atoms = 1422;
            pub const GkAtoms_Atoms_flood_opacity: root::mozilla::detail::GkAtoms_Atoms = 1423;
            pub const GkAtoms_Atoms_font_face: root::mozilla::detail::GkAtoms_Atoms = 1424;
            pub const GkAtoms_Atoms_font_face_format: root::mozilla::detail::GkAtoms_Atoms = 1425;
            pub const GkAtoms_Atoms_font_face_name: root::mozilla::detail::GkAtoms_Atoms = 1426;
            pub const GkAtoms_Atoms_font_face_src: root::mozilla::detail::GkAtoms_Atoms = 1427;
            pub const GkAtoms_Atoms_font_face_uri: root::mozilla::detail::GkAtoms_Atoms = 1428;
            pub const GkAtoms_Atoms_font_family: root::mozilla::detail::GkAtoms_Atoms = 1429;
            pub const GkAtoms_Atoms_font_size: root::mozilla::detail::GkAtoms_Atoms = 1430;
            pub const GkAtoms_Atoms_font_size_adjust: root::mozilla::detail::GkAtoms_Atoms = 1431;
            pub const GkAtoms_Atoms_font_stretch: root::mozilla::detail::GkAtoms_Atoms = 1432;
            pub const GkAtoms_Atoms_font_style: root::mozilla::detail::GkAtoms_Atoms = 1433;
            pub const GkAtoms_Atoms_font_variant: root::mozilla::detail::GkAtoms_Atoms = 1434;
            pub const GkAtoms_Atoms_font_weight: root::mozilla::detail::GkAtoms_Atoms = 1435;
            pub const GkAtoms_Atoms_formatting: root::mozilla::detail::GkAtoms_Atoms = 1436;
            pub const GkAtoms_Atoms_foreignObject: root::mozilla::detail::GkAtoms_Atoms = 1437;
            pub const GkAtoms_Atoms_fractalNoise: root::mozilla::detail::GkAtoms_Atoms = 1438;
            pub const GkAtoms_Atoms_fr: root::mozilla::detail::GkAtoms_Atoms = 1439;
            pub const GkAtoms_Atoms_fx: root::mozilla::detail::GkAtoms_Atoms = 1440;
            pub const GkAtoms_Atoms_fy: root::mozilla::detail::GkAtoms_Atoms = 1441;
            pub const GkAtoms_Atoms_G: root::mozilla::detail::GkAtoms_Atoms = 1442;
            pub const GkAtoms_Atoms_g: root::mozilla::detail::GkAtoms_Atoms = 1443;
            pub const GkAtoms_Atoms_gamma: root::mozilla::detail::GkAtoms_Atoms = 1444;
            pub const GkAtoms_Atoms_glyphRef: root::mozilla::detail::GkAtoms_Atoms = 1445;
            pub const GkAtoms_Atoms_grad: root::mozilla::detail::GkAtoms_Atoms = 1446;
            pub const GkAtoms_Atoms_gradientTransform: root::mozilla::detail::GkAtoms_Atoms = 1447;
            pub const GkAtoms_Atoms_gradientUnits: root::mozilla::detail::GkAtoms_Atoms = 1448;
            pub const GkAtoms_Atoms_hardLight: root::mozilla::detail::GkAtoms_Atoms = 1449;
            pub const GkAtoms_Atoms_hue: root::mozilla::detail::GkAtoms_Atoms = 1450;
            pub const GkAtoms_Atoms_hueRotate: root::mozilla::detail::GkAtoms_Atoms = 1451;
            pub const GkAtoms_Atoms_identity: root::mozilla::detail::GkAtoms_Atoms = 1452;
            pub const GkAtoms_Atoms_image_rendering: root::mozilla::detail::GkAtoms_Atoms = 1453;
            pub const GkAtoms_Atoms_in_: root::mozilla::detail::GkAtoms_Atoms = 1454;
            pub const GkAtoms_Atoms_in2: root::mozilla::detail::GkAtoms_Atoms = 1455;
            pub const GkAtoms_Atoms_intercept: root::mozilla::detail::GkAtoms_Atoms = 1456;
            pub const GkAtoms_Atoms_k1: root::mozilla::detail::GkAtoms_Atoms = 1457;
            pub const GkAtoms_Atoms_k2: root::mozilla::detail::GkAtoms_Atoms = 1458;
            pub const GkAtoms_Atoms_k3: root::mozilla::detail::GkAtoms_Atoms = 1459;
            pub const GkAtoms_Atoms_k4: root::mozilla::detail::GkAtoms_Atoms = 1460;
            pub const GkAtoms_Atoms_kernelMatrix: root::mozilla::detail::GkAtoms_Atoms = 1461;
            pub const GkAtoms_Atoms_kernelUnitLength: root::mozilla::detail::GkAtoms_Atoms = 1462;
            pub const GkAtoms_Atoms_lengthAdjust: root::mozilla::detail::GkAtoms_Atoms = 1463;
            pub const GkAtoms_Atoms_letter_spacing: root::mozilla::detail::GkAtoms_Atoms = 1464;
            pub const GkAtoms_Atoms_lighten: root::mozilla::detail::GkAtoms_Atoms = 1465;
            pub const GkAtoms_Atoms_lighter: root::mozilla::detail::GkAtoms_Atoms = 1466;
            pub const GkAtoms_Atoms_lighting_color: root::mozilla::detail::GkAtoms_Atoms = 1467;
            pub const GkAtoms_Atoms_limitingConeAngle: root::mozilla::detail::GkAtoms_Atoms = 1468;
            pub const GkAtoms_Atoms_linear: root::mozilla::detail::GkAtoms_Atoms = 1469;
            pub const GkAtoms_Atoms_linearGradient: root::mozilla::detail::GkAtoms_Atoms = 1470;
            pub const GkAtoms_Atoms_list_item: root::mozilla::detail::GkAtoms_Atoms = 1471;
            pub const GkAtoms_Atoms_list_style_type: root::mozilla::detail::GkAtoms_Atoms = 1472;
            pub const GkAtoms_Atoms_luminanceToAlpha: root::mozilla::detail::GkAtoms_Atoms = 1473;
            pub const GkAtoms_Atoms_luminosity: root::mozilla::detail::GkAtoms_Atoms = 1474;
            pub const GkAtoms_Atoms_magnify: root::mozilla::detail::GkAtoms_Atoms = 1475;
            pub const GkAtoms_Atoms_marker: root::mozilla::detail::GkAtoms_Atoms = 1476;
            pub const GkAtoms_Atoms_marker_end: root::mozilla::detail::GkAtoms_Atoms = 1477;
            pub const GkAtoms_Atoms_marker_mid: root::mozilla::detail::GkAtoms_Atoms = 1478;
            pub const GkAtoms_Atoms_marker_start: root::mozilla::detail::GkAtoms_Atoms = 1479;
            pub const GkAtoms_Atoms_markerHeight: root::mozilla::detail::GkAtoms_Atoms = 1480;
            pub const GkAtoms_Atoms_markerUnits: root::mozilla::detail::GkAtoms_Atoms = 1481;
            pub const GkAtoms_Atoms_markerWidth: root::mozilla::detail::GkAtoms_Atoms = 1482;
            pub const GkAtoms_Atoms_mask: root::mozilla::detail::GkAtoms_Atoms = 1483;
            pub const GkAtoms_Atoms_maskContentUnits: root::mozilla::detail::GkAtoms_Atoms = 1484;
            pub const GkAtoms_Atoms_mask_type: root::mozilla::detail::GkAtoms_Atoms = 1485;
            pub const GkAtoms_Atoms_maskUnits: root::mozilla::detail::GkAtoms_Atoms = 1486;
            pub const GkAtoms_Atoms_matrix: root::mozilla::detail::GkAtoms_Atoms = 1487;
            pub const GkAtoms_Atoms_metadata: root::mozilla::detail::GkAtoms_Atoms = 1488;
            pub const GkAtoms_Atoms_missingGlyph: root::mozilla::detail::GkAtoms_Atoms = 1489;
            pub const GkAtoms_Atoms_mm: root::mozilla::detail::GkAtoms_Atoms = 1490;
            pub const GkAtoms_Atoms_mpath: root::mozilla::detail::GkAtoms_Atoms = 1491;
            pub const GkAtoms_Atoms_noStitch: root::mozilla::detail::GkAtoms_Atoms = 1492;
            pub const GkAtoms_Atoms_numOctaves: root::mozilla::detail::GkAtoms_Atoms = 1493;
            pub const GkAtoms_Atoms_multiply: root::mozilla::detail::GkAtoms_Atoms = 1494;
            pub const GkAtoms_Atoms_objectBoundingBox: root::mozilla::detail::GkAtoms_Atoms = 1495;
            pub const GkAtoms_Atoms_offset: root::mozilla::detail::GkAtoms_Atoms = 1496;
            pub const GkAtoms_Atoms_onSVGLoad: root::mozilla::detail::GkAtoms_Atoms = 1497;
            pub const GkAtoms_Atoms_onSVGScroll: root::mozilla::detail::GkAtoms_Atoms = 1498;
            pub const GkAtoms_Atoms_onzoom: root::mozilla::detail::GkAtoms_Atoms = 1499;
            pub const GkAtoms_Atoms_opacity: root::mozilla::detail::GkAtoms_Atoms = 1500;
            pub const GkAtoms_Atoms__operator: root::mozilla::detail::GkAtoms_Atoms = 1501;
            pub const GkAtoms_Atoms_out: root::mozilla::detail::GkAtoms_Atoms = 1502;
            pub const GkAtoms_Atoms_over: root::mozilla::detail::GkAtoms_Atoms = 1503;
            pub const GkAtoms_Atoms_overridePreserveAspectRatio:
                root::mozilla::detail::GkAtoms_Atoms = 1504;
            pub const GkAtoms_Atoms_pad: root::mozilla::detail::GkAtoms_Atoms = 1505;
            pub const GkAtoms_Atoms_path: root::mozilla::detail::GkAtoms_Atoms = 1506;
            pub const GkAtoms_Atoms_pathLength: root::mozilla::detail::GkAtoms_Atoms = 1507;
            pub const GkAtoms_Atoms_patternContentUnits: root::mozilla::detail::GkAtoms_Atoms =
                1508;
            pub const GkAtoms_Atoms_patternTransform: root::mozilla::detail::GkAtoms_Atoms = 1509;
            pub const GkAtoms_Atoms_patternUnits: root::mozilla::detail::GkAtoms_Atoms = 1510;
            pub const GkAtoms_Atoms_pc: root::mozilla::detail::GkAtoms_Atoms = 1511;
            pub const GkAtoms_Atoms_pointer: root::mozilla::detail::GkAtoms_Atoms = 1512;
            pub const GkAtoms_Atoms_pointer_events: root::mozilla::detail::GkAtoms_Atoms = 1513;
            pub const GkAtoms_Atoms_points: root::mozilla::detail::GkAtoms_Atoms = 1514;
            pub const GkAtoms_Atoms_pointsAtX: root::mozilla::detail::GkAtoms_Atoms = 1515;
            pub const GkAtoms_Atoms_pointsAtY: root::mozilla::detail::GkAtoms_Atoms = 1516;
            pub const GkAtoms_Atoms_pointsAtZ: root::mozilla::detail::GkAtoms_Atoms = 1517;
            pub const GkAtoms_Atoms_polyline: root::mozilla::detail::GkAtoms_Atoms = 1518;
            pub const GkAtoms_Atoms_preserveAlpha: root::mozilla::detail::GkAtoms_Atoms = 1519;
            pub const GkAtoms_Atoms_preserveAspectRatio: root::mozilla::detail::GkAtoms_Atoms =
                1520;
            pub const GkAtoms_Atoms_primitiveUnits: root::mozilla::detail::GkAtoms_Atoms = 1521;
            pub const GkAtoms_Atoms_pt: root::mozilla::detail::GkAtoms_Atoms = 1522;
            pub const GkAtoms_Atoms_px: root::mozilla::detail::GkAtoms_Atoms = 1523;
            pub const GkAtoms_Atoms_R: root::mozilla::detail::GkAtoms_Atoms = 1524;
            pub const GkAtoms_Atoms_r: root::mozilla::detail::GkAtoms_Atoms = 1525;
            pub const GkAtoms_Atoms_rad: root::mozilla::detail::GkAtoms_Atoms = 1526;
            pub const GkAtoms_Atoms_radialGradient: root::mozilla::detail::GkAtoms_Atoms = 1527;
            pub const GkAtoms_Atoms_radius: root::mozilla::detail::GkAtoms_Atoms = 1528;
            pub const GkAtoms_Atoms_reflect: root::mozilla::detail::GkAtoms_Atoms = 1529;
            pub const GkAtoms_Atoms_refX: root::mozilla::detail::GkAtoms_Atoms = 1530;
            pub const GkAtoms_Atoms_refY: root::mozilla::detail::GkAtoms_Atoms = 1531;
            pub const GkAtoms_Atoms_requiredExtensions: root::mozilla::detail::GkAtoms_Atoms = 1532;
            pub const GkAtoms_Atoms_requiredFeatures: root::mozilla::detail::GkAtoms_Atoms = 1533;
            pub const GkAtoms_Atoms_rotate: root::mozilla::detail::GkAtoms_Atoms = 1534;
            pub const GkAtoms_Atoms_rx: root::mozilla::detail::GkAtoms_Atoms = 1535;
            pub const GkAtoms_Atoms_ry: root::mozilla::detail::GkAtoms_Atoms = 1536;
            pub const GkAtoms_Atoms_saturate: root::mozilla::detail::GkAtoms_Atoms = 1537;
            pub const GkAtoms_Atoms_saturation: root::mozilla::detail::GkAtoms_Atoms = 1538;
            pub const GkAtoms_Atoms_set: root::mozilla::detail::GkAtoms_Atoms = 1539;
            pub const GkAtoms_Atoms_seed: root::mozilla::detail::GkAtoms_Atoms = 1540;
            pub const GkAtoms_Atoms_shape_rendering: root::mozilla::detail::GkAtoms_Atoms = 1541;
            pub const GkAtoms_Atoms_simpleScopeChain: root::mozilla::detail::GkAtoms_Atoms = 1542;
            pub const GkAtoms_Atoms_skewX: root::mozilla::detail::GkAtoms_Atoms = 1543;
            pub const GkAtoms_Atoms_skewY: root::mozilla::detail::GkAtoms_Atoms = 1544;
            pub const GkAtoms_Atoms_slope: root::mozilla::detail::GkAtoms_Atoms = 1545;
            pub const GkAtoms_Atoms_slot: root::mozilla::detail::GkAtoms_Atoms = 1546;
            pub const GkAtoms_Atoms_softLight: root::mozilla::detail::GkAtoms_Atoms = 1547;
            pub const GkAtoms_Atoms_spacing: root::mozilla::detail::GkAtoms_Atoms = 1548;
            pub const GkAtoms_Atoms_spacingAndGlyphs: root::mozilla::detail::GkAtoms_Atoms = 1549;
            pub const GkAtoms_Atoms_specularConstant: root::mozilla::detail::GkAtoms_Atoms = 1550;
            pub const GkAtoms_Atoms_specularExponent: root::mozilla::detail::GkAtoms_Atoms = 1551;
            pub const GkAtoms_Atoms_spreadMethod: root::mozilla::detail::GkAtoms_Atoms = 1552;
            pub const GkAtoms_Atoms_startOffset: root::mozilla::detail::GkAtoms_Atoms = 1553;
            pub const GkAtoms_Atoms_stdDeviation: root::mozilla::detail::GkAtoms_Atoms = 1554;
            pub const GkAtoms_Atoms_stitch: root::mozilla::detail::GkAtoms_Atoms = 1555;
            pub const GkAtoms_Atoms_stitchTiles: root::mozilla::detail::GkAtoms_Atoms = 1556;
            pub const GkAtoms_Atoms_stop_color: root::mozilla::detail::GkAtoms_Atoms = 1557;
            pub const GkAtoms_Atoms_stop_opacity: root::mozilla::detail::GkAtoms_Atoms = 1558;
            pub const GkAtoms_Atoms_stroke: root::mozilla::detail::GkAtoms_Atoms = 1559;
            pub const GkAtoms_Atoms_stroke_dasharray: root::mozilla::detail::GkAtoms_Atoms = 1560;
            pub const GkAtoms_Atoms_stroke_dashoffset: root::mozilla::detail::GkAtoms_Atoms = 1561;
            pub const GkAtoms_Atoms_stroke_linecap: root::mozilla::detail::GkAtoms_Atoms = 1562;
            pub const GkAtoms_Atoms_stroke_linejoin: root::mozilla::detail::GkAtoms_Atoms = 1563;
            pub const GkAtoms_Atoms_stroke_miterlimit: root::mozilla::detail::GkAtoms_Atoms = 1564;
            pub const GkAtoms_Atoms_stroke_opacity: root::mozilla::detail::GkAtoms_Atoms = 1565;
            pub const GkAtoms_Atoms_stroke_width: root::mozilla::detail::GkAtoms_Atoms = 1566;
            pub const GkAtoms_Atoms_strokeWidth: root::mozilla::detail::GkAtoms_Atoms = 1567;
            pub const GkAtoms_Atoms_surfaceScale: root::mozilla::detail::GkAtoms_Atoms = 1568;
            pub const GkAtoms_Atoms_svg: root::mozilla::detail::GkAtoms_Atoms = 1569;
            pub const GkAtoms_Atoms_svgSwitch: root::mozilla::detail::GkAtoms_Atoms = 1570;
            pub const GkAtoms_Atoms_symbol: root::mozilla::detail::GkAtoms_Atoms = 1571;
            pub const GkAtoms_Atoms_systemLanguage: root::mozilla::detail::GkAtoms_Atoms = 1572;
            pub const GkAtoms_Atoms_tableValues: root::mozilla::detail::GkAtoms_Atoms = 1573;
            pub const GkAtoms_Atoms_targetX: root::mozilla::detail::GkAtoms_Atoms = 1574;
            pub const GkAtoms_Atoms_targetY: root::mozilla::detail::GkAtoms_Atoms = 1575;
            pub const GkAtoms_Atoms_text_anchor: root::mozilla::detail::GkAtoms_Atoms = 1576;
            pub const GkAtoms_Atoms_text_overflow: root::mozilla::detail::GkAtoms_Atoms = 1577;
            pub const GkAtoms_Atoms_text_rendering: root::mozilla::detail::GkAtoms_Atoms = 1578;
            pub const GkAtoms_Atoms_textLength: root::mozilla::detail::GkAtoms_Atoms = 1579;
            pub const GkAtoms_Atoms_textPath: root::mozilla::detail::GkAtoms_Atoms = 1580;
            pub const GkAtoms_Atoms_transform_origin: root::mozilla::detail::GkAtoms_Atoms = 1581;
            pub const GkAtoms_Atoms_tref: root::mozilla::detail::GkAtoms_Atoms = 1582;
            pub const GkAtoms_Atoms_tspan: root::mozilla::detail::GkAtoms_Atoms = 1583;
            pub const GkAtoms_Atoms_turbulence: root::mozilla::detail::GkAtoms_Atoms = 1584;
            pub const GkAtoms_Atoms_unicode_bidi: root::mozilla::detail::GkAtoms_Atoms = 1585;
            pub const GkAtoms_Atoms_userSpaceOnUse: root::mozilla::detail::GkAtoms_Atoms = 1586;
            pub const GkAtoms_Atoms_view: root::mozilla::detail::GkAtoms_Atoms = 1587;
            pub const GkAtoms_Atoms_viewBox: root::mozilla::detail::GkAtoms_Atoms = 1588;
            pub const GkAtoms_Atoms_viewTarget: root::mozilla::detail::GkAtoms_Atoms = 1589;
            pub const GkAtoms_Atoms_white_space: root::mozilla::detail::GkAtoms_Atoms = 1590;
            pub const GkAtoms_Atoms_windowsmica: root::mozilla::detail::GkAtoms_Atoms = 1591;
            pub const GkAtoms_Atoms_word_spacing: root::mozilla::detail::GkAtoms_Atoms = 1592;
            pub const GkAtoms_Atoms_writing_mode: root::mozilla::detail::GkAtoms_Atoms = 1593;
            pub const GkAtoms_Atoms_x: root::mozilla::detail::GkAtoms_Atoms = 1594;
            pub const GkAtoms_Atoms_x1: root::mozilla::detail::GkAtoms_Atoms = 1595;
            pub const GkAtoms_Atoms_x2: root::mozilla::detail::GkAtoms_Atoms = 1596;
            pub const GkAtoms_Atoms_xChannelSelector: root::mozilla::detail::GkAtoms_Atoms = 1597;
            pub const GkAtoms_Atoms_xor_: root::mozilla::detail::GkAtoms_Atoms = 1598;
            pub const GkAtoms_Atoms_y: root::mozilla::detail::GkAtoms_Atoms = 1599;
            pub const GkAtoms_Atoms_y1: root::mozilla::detail::GkAtoms_Atoms = 1600;
            pub const GkAtoms_Atoms_y2: root::mozilla::detail::GkAtoms_Atoms = 1601;
            pub const GkAtoms_Atoms_yChannelSelector: root::mozilla::detail::GkAtoms_Atoms = 1602;
            pub const GkAtoms_Atoms_z: root::mozilla::detail::GkAtoms_Atoms = 1603;
            pub const GkAtoms_Atoms_zoomAndPan: root::mozilla::detail::GkAtoms_Atoms = 1604;
            pub const GkAtoms_Atoms_vector_effect: root::mozilla::detail::GkAtoms_Atoms = 1605;
            pub const GkAtoms_Atoms_vertical_align: root::mozilla::detail::GkAtoms_Atoms = 1606;
            pub const GkAtoms_Atoms_accumulate: root::mozilla::detail::GkAtoms_Atoms = 1607;
            pub const GkAtoms_Atoms_additive: root::mozilla::detail::GkAtoms_Atoms = 1608;
            pub const GkAtoms_Atoms_attributeName: root::mozilla::detail::GkAtoms_Atoms = 1609;
            pub const GkAtoms_Atoms_attributeType: root::mozilla::detail::GkAtoms_Atoms = 1610;
            pub const GkAtoms_Atoms_auto_reverse: root::mozilla::detail::GkAtoms_Atoms = 1611;
            pub const GkAtoms_Atoms_begin: root::mozilla::detail::GkAtoms_Atoms = 1612;
            pub const GkAtoms_Atoms_beginEvent: root::mozilla::detail::GkAtoms_Atoms = 1613;
            pub const GkAtoms_Atoms_by: root::mozilla::detail::GkAtoms_Atoms = 1614;
            pub const GkAtoms_Atoms_calcMode: root::mozilla::detail::GkAtoms_Atoms = 1615;
            pub const GkAtoms_Atoms_dur: root::mozilla::detail::GkAtoms_Atoms = 1616;
            pub const GkAtoms_Atoms_keyPoints: root::mozilla::detail::GkAtoms_Atoms = 1617;
            pub const GkAtoms_Atoms_keySplines: root::mozilla::detail::GkAtoms_Atoms = 1618;
            pub const GkAtoms_Atoms_keyTimes: root::mozilla::detail::GkAtoms_Atoms = 1619;
            pub const GkAtoms_Atoms_mozAnimateMotionDummyAttr:
                root::mozilla::detail::GkAtoms_Atoms = 1620;
            pub const GkAtoms_Atoms_onbegin: root::mozilla::detail::GkAtoms_Atoms = 1621;
            pub const GkAtoms_Atoms_onbeginEvent: root::mozilla::detail::GkAtoms_Atoms = 1622;
            pub const GkAtoms_Atoms_onend: root::mozilla::detail::GkAtoms_Atoms = 1623;
            pub const GkAtoms_Atoms_onendEvent: root::mozilla::detail::GkAtoms_Atoms = 1624;
            pub const GkAtoms_Atoms_onrelease: root::mozilla::detail::GkAtoms_Atoms = 1625;
            pub const GkAtoms_Atoms_onrepeat: root::mozilla::detail::GkAtoms_Atoms = 1626;
            pub const GkAtoms_Atoms_onrepeatEvent: root::mozilla::detail::GkAtoms_Atoms = 1627;
            pub const GkAtoms_Atoms_repeatCount: root::mozilla::detail::GkAtoms_Atoms = 1628;
            pub const GkAtoms_Atoms_repeatDur: root::mozilla::detail::GkAtoms_Atoms = 1629;
            pub const GkAtoms_Atoms_repeatEvent: root::mozilla::detail::GkAtoms_Atoms = 1630;
            pub const GkAtoms_Atoms_restart: root::mozilla::detail::GkAtoms_Atoms = 1631;
            pub const GkAtoms_Atoms_to: root::mozilla::detail::GkAtoms_Atoms = 1632;
            pub const GkAtoms_Atoms_abs: root::mozilla::detail::GkAtoms_Atoms = 1633;
            pub const GkAtoms_Atoms_accent: root::mozilla::detail::GkAtoms_Atoms = 1634;
            pub const GkAtoms_Atoms_accentunder: root::mozilla::detail::GkAtoms_Atoms = 1635;
            pub const GkAtoms_Atoms_actiontype: root::mozilla::detail::GkAtoms_Atoms = 1636;
            pub const GkAtoms_Atoms_alignmentscope: root::mozilla::detail::GkAtoms_Atoms = 1637;
            pub const GkAtoms_Atoms_altimg: root::mozilla::detail::GkAtoms_Atoms = 1638;
            pub const GkAtoms_Atoms_altimg_height: root::mozilla::detail::GkAtoms_Atoms = 1639;
            pub const GkAtoms_Atoms_altimg_valign: root::mozilla::detail::GkAtoms_Atoms = 1640;
            pub const GkAtoms_Atoms_altimg_width: root::mozilla::detail::GkAtoms_Atoms = 1641;
            pub const GkAtoms_Atoms_annotation: root::mozilla::detail::GkAtoms_Atoms = 1642;
            pub const GkAtoms_Atoms_annotation_xml: root::mozilla::detail::GkAtoms_Atoms = 1643;
            pub const GkAtoms_Atoms_apply: root::mozilla::detail::GkAtoms_Atoms = 1644;
            pub const GkAtoms_Atoms_approx: root::mozilla::detail::GkAtoms_Atoms = 1645;
            pub const GkAtoms_Atoms_arccos: root::mozilla::detail::GkAtoms_Atoms = 1646;
            pub const GkAtoms_Atoms_arccosh: root::mozilla::detail::GkAtoms_Atoms = 1647;
            pub const GkAtoms_Atoms_arccot: root::mozilla::detail::GkAtoms_Atoms = 1648;
            pub const GkAtoms_Atoms_arccoth: root::mozilla::detail::GkAtoms_Atoms = 1649;
            pub const GkAtoms_Atoms_arccsc: root::mozilla::detail::GkAtoms_Atoms = 1650;
            pub const GkAtoms_Atoms_arccsch: root::mozilla::detail::GkAtoms_Atoms = 1651;
            pub const GkAtoms_Atoms_arcsec: root::mozilla::detail::GkAtoms_Atoms = 1652;
            pub const GkAtoms_Atoms_arcsech: root::mozilla::detail::GkAtoms_Atoms = 1653;
            pub const GkAtoms_Atoms_arcsin: root::mozilla::detail::GkAtoms_Atoms = 1654;
            pub const GkAtoms_Atoms_arcsinh: root::mozilla::detail::GkAtoms_Atoms = 1655;
            pub const GkAtoms_Atoms_arctan: root::mozilla::detail::GkAtoms_Atoms = 1656;
            pub const GkAtoms_Atoms_arctanh: root::mozilla::detail::GkAtoms_Atoms = 1657;
            pub const GkAtoms_Atoms_arg: root::mozilla::detail::GkAtoms_Atoms = 1658;
            pub const GkAtoms_Atoms_bevelled: root::mozilla::detail::GkAtoms_Atoms = 1659;
            pub const GkAtoms_Atoms_bind: root::mozilla::detail::GkAtoms_Atoms = 1660;
            pub const GkAtoms_Atoms_bvar: root::mozilla::detail::GkAtoms_Atoms = 1661;
            pub const GkAtoms_Atoms_card: root::mozilla::detail::GkAtoms_Atoms = 1662;
            pub const GkAtoms_Atoms_cartesianproduct: root::mozilla::detail::GkAtoms_Atoms = 1663;
            pub const GkAtoms_Atoms_cbytes: root::mozilla::detail::GkAtoms_Atoms = 1664;
            pub const GkAtoms_Atoms_cd: root::mozilla::detail::GkAtoms_Atoms = 1665;
            pub const GkAtoms_Atoms_cdgroup: root::mozilla::detail::GkAtoms_Atoms = 1666;
            pub const GkAtoms_Atoms_cerror: root::mozilla::detail::GkAtoms_Atoms = 1667;
            pub const GkAtoms_Atoms_charalign: root::mozilla::detail::GkAtoms_Atoms = 1668;
            pub const GkAtoms_Atoms_ci: root::mozilla::detail::GkAtoms_Atoms = 1669;
            pub const GkAtoms_Atoms_closure: root::mozilla::detail::GkAtoms_Atoms = 1670;
            pub const GkAtoms_Atoms_cn: root::mozilla::detail::GkAtoms_Atoms = 1671;
            pub const GkAtoms_Atoms_codomain: root::mozilla::detail::GkAtoms_Atoms = 1672;
            pub const GkAtoms_Atoms_columnalign: root::mozilla::detail::GkAtoms_Atoms = 1673;
            pub const GkAtoms_Atoms_columnalignment: root::mozilla::detail::GkAtoms_Atoms = 1674;
            pub const GkAtoms_Atoms_columnlines: root::mozilla::detail::GkAtoms_Atoms = 1675;
            pub const GkAtoms_Atoms_columnspacing: root::mozilla::detail::GkAtoms_Atoms = 1676;
            pub const GkAtoms_Atoms_columnspan: root::mozilla::detail::GkAtoms_Atoms = 1677;
            pub const GkAtoms_Atoms_columnwidth: root::mozilla::detail::GkAtoms_Atoms = 1678;
            pub const GkAtoms_Atoms_complexes: root::mozilla::detail::GkAtoms_Atoms = 1679;
            pub const GkAtoms_Atoms_compose: root::mozilla::detail::GkAtoms_Atoms = 1680;
            pub const GkAtoms_Atoms_condition: root::mozilla::detail::GkAtoms_Atoms = 1681;
            pub const GkAtoms_Atoms_conjugate: root::mozilla::detail::GkAtoms_Atoms = 1682;
            pub const GkAtoms_Atoms_cos: root::mozilla::detail::GkAtoms_Atoms = 1683;
            pub const GkAtoms_Atoms_cosh: root::mozilla::detail::GkAtoms_Atoms = 1684;
            pub const GkAtoms_Atoms_cot: root::mozilla::detail::GkAtoms_Atoms = 1685;
            pub const GkAtoms_Atoms_coth: root::mozilla::detail::GkAtoms_Atoms = 1686;
            pub const GkAtoms_Atoms_crossout: root::mozilla::detail::GkAtoms_Atoms = 1687;
            pub const GkAtoms_Atoms_csc: root::mozilla::detail::GkAtoms_Atoms = 1688;
            pub const GkAtoms_Atoms_csch: root::mozilla::detail::GkAtoms_Atoms = 1689;
            pub const GkAtoms_Atoms_cs: root::mozilla::detail::GkAtoms_Atoms = 1690;
            pub const GkAtoms_Atoms_csymbol: root::mozilla::detail::GkAtoms_Atoms = 1691;
            pub const GkAtoms_Atoms_csp: root::mozilla::detail::GkAtoms_Atoms = 1692;
            pub const GkAtoms_Atoms_cspViolation: root::mozilla::detail::GkAtoms_Atoms = 1693;
            pub const GkAtoms_Atoms_curl: root::mozilla::detail::GkAtoms_Atoms = 1694;
            pub const GkAtoms_Atoms_decimalpoint: root::mozilla::detail::GkAtoms_Atoms = 1695;
            pub const GkAtoms_Atoms_definition: root::mozilla::detail::GkAtoms_Atoms = 1696;
            pub const GkAtoms_Atoms_definitionURL: root::mozilla::detail::GkAtoms_Atoms = 1697;
            pub const GkAtoms_Atoms_degree: root::mozilla::detail::GkAtoms_Atoms = 1698;
            pub const GkAtoms_Atoms_denomalign: root::mozilla::detail::GkAtoms_Atoms = 1699;
            pub const GkAtoms_Atoms_depth: root::mozilla::detail::GkAtoms_Atoms = 1700;
            pub const GkAtoms_Atoms_determinant: root::mozilla::detail::GkAtoms_Atoms = 1701;
            pub const GkAtoms_Atoms_diff: root::mozilla::detail::GkAtoms_Atoms = 1702;
            pub const GkAtoms_Atoms_displaystyle: root::mozilla::detail::GkAtoms_Atoms = 1703;
            pub const GkAtoms_Atoms_divergence: root::mozilla::detail::GkAtoms_Atoms = 1704;
            pub const GkAtoms_Atoms_divide: root::mozilla::detail::GkAtoms_Atoms = 1705;
            pub const GkAtoms_Atoms_dom_viewTransitions_enabled:
                root::mozilla::detail::GkAtoms_Atoms = 1706;
            pub const GkAtoms_Atoms_domain: root::mozilla::detail::GkAtoms_Atoms = 1707;
            pub const GkAtoms_Atoms_domainofapplication: root::mozilla::detail::GkAtoms_Atoms =
                1708;
            pub const GkAtoms_Atoms_edge: root::mozilla::detail::GkAtoms_Atoms = 1709;
            pub const GkAtoms_Atoms_el: root::mozilla::detail::GkAtoms_Atoms = 1710;
            pub const GkAtoms_Atoms_emptyset: root::mozilla::detail::GkAtoms_Atoms = 1711;
            pub const GkAtoms_Atoms_eq: root::mozilla::detail::GkAtoms_Atoms = 1712;
            pub const GkAtoms_Atoms_equalcolumns: root::mozilla::detail::GkAtoms_Atoms = 1713;
            pub const GkAtoms_Atoms_equalrows: root::mozilla::detail::GkAtoms_Atoms = 1714;
            pub const GkAtoms_Atoms_equivalent: root::mozilla::detail::GkAtoms_Atoms = 1715;
            pub const GkAtoms_Atoms_eulergamma: root::mozilla::detail::GkAtoms_Atoms = 1716;
            pub const GkAtoms_Atoms_exists: root::mozilla::detail::GkAtoms_Atoms = 1717;
            pub const GkAtoms_Atoms_exp: root::mozilla::detail::GkAtoms_Atoms = 1718;
            pub const GkAtoms_Atoms_exponentiale: root::mozilla::detail::GkAtoms_Atoms = 1719;
            pub const GkAtoms_Atoms_factorial: root::mozilla::detail::GkAtoms_Atoms = 1720;
            pub const GkAtoms_Atoms_factorof: root::mozilla::detail::GkAtoms_Atoms = 1721;
            pub const GkAtoms_Atoms_fence: root::mozilla::detail::GkAtoms_Atoms = 1722;
            pub const GkAtoms_Atoms_fn_: root::mozilla::detail::GkAtoms_Atoms = 1723;
            pub const GkAtoms_Atoms_fontfamily: root::mozilla::detail::GkAtoms_Atoms = 1724;
            pub const GkAtoms_Atoms_fontsize: root::mozilla::detail::GkAtoms_Atoms = 1725;
            pub const GkAtoms_Atoms_fontstyle: root::mozilla::detail::GkAtoms_Atoms = 1726;
            pub const GkAtoms_Atoms_fontweight: root::mozilla::detail::GkAtoms_Atoms = 1727;
            pub const GkAtoms_Atoms_forall: root::mozilla::detail::GkAtoms_Atoms = 1728;
            pub const GkAtoms_Atoms_framespacing: root::mozilla::detail::GkAtoms_Atoms = 1729;
            pub const GkAtoms_Atoms_gcd: root::mozilla::detail::GkAtoms_Atoms = 1730;
            pub const GkAtoms_Atoms_geq: root::mozilla::detail::GkAtoms_Atoms = 1731;
            pub const GkAtoms_Atoms_groupalign: root::mozilla::detail::GkAtoms_Atoms = 1732;
            pub const GkAtoms_Atoms_gt: root::mozilla::detail::GkAtoms_Atoms = 1733;
            pub const GkAtoms_Atoms_ident: root::mozilla::detail::GkAtoms_Atoms = 1734;
            pub const GkAtoms_Atoms_imaginaryi: root::mozilla::detail::GkAtoms_Atoms = 1735;
            pub const GkAtoms_Atoms_imaginary: root::mozilla::detail::GkAtoms_Atoms = 1736;
            pub const GkAtoms_Atoms_implies: root::mozilla::detail::GkAtoms_Atoms = 1737;
            pub const GkAtoms_Atoms_indentalignfirst: root::mozilla::detail::GkAtoms_Atoms = 1738;
            pub const GkAtoms_Atoms_indentalign: root::mozilla::detail::GkAtoms_Atoms = 1739;
            pub const GkAtoms_Atoms_indentalignlast: root::mozilla::detail::GkAtoms_Atoms = 1740;
            pub const GkAtoms_Atoms_indentshiftfirst: root::mozilla::detail::GkAtoms_Atoms = 1741;
            pub const GkAtoms_Atoms_indentshift: root::mozilla::detail::GkAtoms_Atoms = 1742;
            pub const GkAtoms_Atoms_indenttarget: root::mozilla::detail::GkAtoms_Atoms = 1743;
            pub const GkAtoms_Atoms_integers: root::mozilla::detail::GkAtoms_Atoms = 1744;
            pub const GkAtoms_Atoms_intersect: root::mozilla::detail::GkAtoms_Atoms = 1745;
            pub const GkAtoms_Atoms_interval: root::mozilla::detail::GkAtoms_Atoms = 1746;
            pub const GkAtoms_Atoms_int_: root::mozilla::detail::GkAtoms_Atoms = 1747;
            pub const GkAtoms_Atoms_inverse: root::mozilla::detail::GkAtoms_Atoms = 1748;
            pub const GkAtoms_Atoms_lambda: root::mozilla::detail::GkAtoms_Atoms = 1749;
            pub const GkAtoms_Atoms_laplacian: root::mozilla::detail::GkAtoms_Atoms = 1750;
            pub const GkAtoms_Atoms_largeop: root::mozilla::detail::GkAtoms_Atoms = 1751;
            pub const GkAtoms_Atoms_lcm: root::mozilla::detail::GkAtoms_Atoms = 1752;
            pub const GkAtoms_Atoms_leq: root::mozilla::detail::GkAtoms_Atoms = 1753;
            pub const GkAtoms_Atoms_limit: root::mozilla::detail::GkAtoms_Atoms = 1754;
            pub const GkAtoms_Atoms_linebreak: root::mozilla::detail::GkAtoms_Atoms = 1755;
            pub const GkAtoms_Atoms_linebreakmultchar: root::mozilla::detail::GkAtoms_Atoms = 1756;
            pub const GkAtoms_Atoms_linebreakstyle: root::mozilla::detail::GkAtoms_Atoms = 1757;
            pub const GkAtoms_Atoms_linethickness: root::mozilla::detail::GkAtoms_Atoms = 1758;
            pub const GkAtoms_Atoms_list: root::mozilla::detail::GkAtoms_Atoms = 1759;
            pub const GkAtoms_Atoms_ln: root::mozilla::detail::GkAtoms_Atoms = 1760;
            pub const GkAtoms_Atoms_location: root::mozilla::detail::GkAtoms_Atoms = 1761;
            pub const GkAtoms_Atoms_logbase: root::mozilla::detail::GkAtoms_Atoms = 1762;
            pub const GkAtoms_Atoms_log: root::mozilla::detail::GkAtoms_Atoms = 1763;
            pub const GkAtoms_Atoms_longdivstyle: root::mozilla::detail::GkAtoms_Atoms = 1764;
            pub const GkAtoms_Atoms_lowlimit: root::mozilla::detail::GkAtoms_Atoms = 1765;
            pub const GkAtoms_Atoms_lquote: root::mozilla::detail::GkAtoms_Atoms = 1766;
            pub const GkAtoms_Atoms_lspace: root::mozilla::detail::GkAtoms_Atoms = 1767;
            pub const GkAtoms_Atoms_lt: root::mozilla::detail::GkAtoms_Atoms = 1768;
            pub const GkAtoms_Atoms_maction: root::mozilla::detail::GkAtoms_Atoms = 1769;
            pub const GkAtoms_Atoms_maligngroup: root::mozilla::detail::GkAtoms_Atoms = 1770;
            pub const GkAtoms_Atoms_malignmark: root::mozilla::detail::GkAtoms_Atoms = 1771;
            pub const GkAtoms_Atoms_mathbackground: root::mozilla::detail::GkAtoms_Atoms = 1772;
            pub const GkAtoms_Atoms_mathcolor: root::mozilla::detail::GkAtoms_Atoms = 1773;
            pub const GkAtoms_Atoms_mathsize: root::mozilla::detail::GkAtoms_Atoms = 1774;
            pub const GkAtoms_Atoms_mathvariant: root::mozilla::detail::GkAtoms_Atoms = 1775;
            pub const GkAtoms_Atoms_matrixrow: root::mozilla::detail::GkAtoms_Atoms = 1776;
            pub const GkAtoms_Atoms_maxsize: root::mozilla::detail::GkAtoms_Atoms = 1777;
            pub const GkAtoms_Atoms_mean: root::mozilla::detail::GkAtoms_Atoms = 1778;
            pub const GkAtoms_Atoms_median: root::mozilla::detail::GkAtoms_Atoms = 1779;
            pub const GkAtoms_Atoms_menclose: root::mozilla::detail::GkAtoms_Atoms = 1780;
            pub const GkAtoms_Atoms_merror: root::mozilla::detail::GkAtoms_Atoms = 1781;
            pub const GkAtoms_Atoms_mfenced: root::mozilla::detail::GkAtoms_Atoms = 1782;
            pub const GkAtoms_Atoms_mfrac: root::mozilla::detail::GkAtoms_Atoms = 1783;
            pub const GkAtoms_Atoms_mglyph: root::mozilla::detail::GkAtoms_Atoms = 1784;
            pub const GkAtoms_Atoms_mi: root::mozilla::detail::GkAtoms_Atoms = 1785;
            pub const GkAtoms_Atoms_minlabelspacing: root::mozilla::detail::GkAtoms_Atoms = 1786;
            pub const GkAtoms_Atoms_minsize: root::mozilla::detail::GkAtoms_Atoms = 1787;
            pub const GkAtoms_Atoms_minus: root::mozilla::detail::GkAtoms_Atoms = 1788;
            pub const GkAtoms_Atoms_mlabeledtr: root::mozilla::detail::GkAtoms_Atoms = 1789;
            pub const GkAtoms_Atoms_mlongdiv: root::mozilla::detail::GkAtoms_Atoms = 1790;
            pub const GkAtoms_Atoms_mmultiscripts: root::mozilla::detail::GkAtoms_Atoms = 1791;
            pub const GkAtoms_Atoms_mn: root::mozilla::detail::GkAtoms_Atoms = 1792;
            pub const GkAtoms_Atoms_momentabout: root::mozilla::detail::GkAtoms_Atoms = 1793;
            pub const GkAtoms_Atoms_moment: root::mozilla::detail::GkAtoms_Atoms = 1794;
            pub const GkAtoms_Atoms_mo: root::mozilla::detail::GkAtoms_Atoms = 1795;
            pub const GkAtoms_Atoms_movablelimits: root::mozilla::detail::GkAtoms_Atoms = 1796;
            pub const GkAtoms_Atoms_mover: root::mozilla::detail::GkAtoms_Atoms = 1797;
            pub const GkAtoms_Atoms_mpadded: root::mozilla::detail::GkAtoms_Atoms = 1798;
            pub const GkAtoms_Atoms_mphantom: root::mozilla::detail::GkAtoms_Atoms = 1799;
            pub const GkAtoms_Atoms_mprescripts: root::mozilla::detail::GkAtoms_Atoms = 1800;
            pub const GkAtoms_Atoms_mroot: root::mozilla::detail::GkAtoms_Atoms = 1801;
            pub const GkAtoms_Atoms_mrow: root::mozilla::detail::GkAtoms_Atoms = 1802;
            pub const GkAtoms_Atoms_mscarries: root::mozilla::detail::GkAtoms_Atoms = 1803;
            pub const GkAtoms_Atoms_mscarry: root::mozilla::detail::GkAtoms_Atoms = 1804;
            pub const GkAtoms_Atoms_msgroup: root::mozilla::detail::GkAtoms_Atoms = 1805;
            pub const GkAtoms_Atoms_msline: root::mozilla::detail::GkAtoms_Atoms = 1806;
            pub const GkAtoms_Atoms_ms: root::mozilla::detail::GkAtoms_Atoms = 1807;
            pub const GkAtoms_Atoms_mspace: root::mozilla::detail::GkAtoms_Atoms = 1808;
            pub const GkAtoms_Atoms_msqrt: root::mozilla::detail::GkAtoms_Atoms = 1809;
            pub const GkAtoms_Atoms_msrow: root::mozilla::detail::GkAtoms_Atoms = 1810;
            pub const GkAtoms_Atoms_mstack: root::mozilla::detail::GkAtoms_Atoms = 1811;
            pub const GkAtoms_Atoms_mstyle: root::mozilla::detail::GkAtoms_Atoms = 1812;
            pub const GkAtoms_Atoms_msub: root::mozilla::detail::GkAtoms_Atoms = 1813;
            pub const GkAtoms_Atoms_msubsup: root::mozilla::detail::GkAtoms_Atoms = 1814;
            pub const GkAtoms_Atoms_msup: root::mozilla::detail::GkAtoms_Atoms = 1815;
            pub const GkAtoms_Atoms_mtable: root::mozilla::detail::GkAtoms_Atoms = 1816;
            pub const GkAtoms_Atoms_mtd: root::mozilla::detail::GkAtoms_Atoms = 1817;
            pub const GkAtoms_Atoms_mtext: root::mozilla::detail::GkAtoms_Atoms = 1818;
            pub const GkAtoms_Atoms_mtr: root::mozilla::detail::GkAtoms_Atoms = 1819;
            pub const GkAtoms_Atoms_munder: root::mozilla::detail::GkAtoms_Atoms = 1820;
            pub const GkAtoms_Atoms_munderover: root::mozilla::detail::GkAtoms_Atoms = 1821;
            pub const GkAtoms_Atoms_naturalnumbers: root::mozilla::detail::GkAtoms_Atoms = 1822;
            pub const GkAtoms_Atoms_neq: root::mozilla::detail::GkAtoms_Atoms = 1823;
            pub const GkAtoms_Atoms_notanumber: root::mozilla::detail::GkAtoms_Atoms = 1824;
            pub const GkAtoms_Atoms_notation: root::mozilla::detail::GkAtoms_Atoms = 1825;
            pub const GkAtoms_Atoms_note: root::mozilla::detail::GkAtoms_Atoms = 1826;
            pub const GkAtoms_Atoms_notin: root::mozilla::detail::GkAtoms_Atoms = 1827;
            pub const GkAtoms_Atoms_notprsubset: root::mozilla::detail::GkAtoms_Atoms = 1828;
            pub const GkAtoms_Atoms_notsubset: root::mozilla::detail::GkAtoms_Atoms = 1829;
            pub const GkAtoms_Atoms_numalign: root::mozilla::detail::GkAtoms_Atoms = 1830;
            pub const GkAtoms_Atoms_other: root::mozilla::detail::GkAtoms_Atoms = 1831;
            pub const GkAtoms_Atoms_outerproduct: root::mozilla::detail::GkAtoms_Atoms = 1832;
            pub const GkAtoms_Atoms_partialdiff: root::mozilla::detail::GkAtoms_Atoms = 1833;
            pub const GkAtoms_Atoms_piece: root::mozilla::detail::GkAtoms_Atoms = 1834;
            pub const GkAtoms_Atoms_piecewise: root::mozilla::detail::GkAtoms_Atoms = 1835;
            pub const GkAtoms_Atoms_pi: root::mozilla::detail::GkAtoms_Atoms = 1836;
            pub const GkAtoms_Atoms_plus: root::mozilla::detail::GkAtoms_Atoms = 1837;
            pub const GkAtoms_Atoms_power: root::mozilla::detail::GkAtoms_Atoms = 1838;
            pub const GkAtoms_Atoms_primes: root::mozilla::detail::GkAtoms_Atoms = 1839;
            pub const GkAtoms_Atoms_product: root::mozilla::detail::GkAtoms_Atoms = 1840;
            pub const GkAtoms_Atoms_prsubset: root::mozilla::detail::GkAtoms_Atoms = 1841;
            pub const GkAtoms_Atoms_quotient: root::mozilla::detail::GkAtoms_Atoms = 1842;
            pub const GkAtoms_Atoms_rationals: root::mozilla::detail::GkAtoms_Atoms = 1843;
            pub const GkAtoms_Atoms_real: root::mozilla::detail::GkAtoms_Atoms = 1844;
            pub const GkAtoms_Atoms_reals: root::mozilla::detail::GkAtoms_Atoms = 1845;
            pub const GkAtoms_Atoms_reln: root::mozilla::detail::GkAtoms_Atoms = 1846;
            pub const GkAtoms_Atoms_root: root::mozilla::detail::GkAtoms_Atoms = 1847;
            pub const GkAtoms_Atoms_rowalign: root::mozilla::detail::GkAtoms_Atoms = 1848;
            pub const GkAtoms_Atoms_rowlines: root::mozilla::detail::GkAtoms_Atoms = 1849;
            pub const GkAtoms_Atoms_rowspacing: root::mozilla::detail::GkAtoms_Atoms = 1850;
            pub const GkAtoms_Atoms_rquote: root::mozilla::detail::GkAtoms_Atoms = 1851;
            pub const GkAtoms_Atoms_rspace: root::mozilla::detail::GkAtoms_Atoms = 1852;
            pub const GkAtoms_Atoms_scalarproduct: root::mozilla::detail::GkAtoms_Atoms = 1853;
            pub const GkAtoms_Atoms_schemaLocation: root::mozilla::detail::GkAtoms_Atoms = 1854;
            pub const GkAtoms_Atoms_scriptlevel: root::mozilla::detail::GkAtoms_Atoms = 1855;
            pub const GkAtoms_Atoms_scriptminsize: root::mozilla::detail::GkAtoms_Atoms = 1856;
            pub const GkAtoms_Atoms_scriptsizemultiplier: root::mozilla::detail::GkAtoms_Atoms =
                1857;
            pub const GkAtoms_Atoms_scriptsize: root::mozilla::detail::GkAtoms_Atoms = 1858;
            pub const GkAtoms_Atoms_sdev: root::mozilla::detail::GkAtoms_Atoms = 1859;
            pub const GkAtoms_Atoms_sech: root::mozilla::detail::GkAtoms_Atoms = 1860;
            pub const GkAtoms_Atoms_sec: root::mozilla::detail::GkAtoms_Atoms = 1861;
            pub const GkAtoms_Atoms_selection: root::mozilla::detail::GkAtoms_Atoms = 1862;
            pub const GkAtoms_Atoms_selector: root::mozilla::detail::GkAtoms_Atoms = 1863;
            pub const GkAtoms_Atoms_semantics: root::mozilla::detail::GkAtoms_Atoms = 1864;
            pub const GkAtoms_Atoms_separator: root::mozilla::detail::GkAtoms_Atoms = 1865;
            pub const GkAtoms_Atoms_separators: root::mozilla::detail::GkAtoms_Atoms = 1866;
            pub const GkAtoms_Atoms_sep: root::mozilla::detail::GkAtoms_Atoms = 1867;
            pub const GkAtoms_Atoms_setdiff: root::mozilla::detail::GkAtoms_Atoms = 1868;
            pub const GkAtoms_Atoms_share: root::mozilla::detail::GkAtoms_Atoms = 1869;
            pub const GkAtoms_Atoms_shift: root::mozilla::detail::GkAtoms_Atoms = 1870;
            pub const GkAtoms_Atoms_side: root::mozilla::detail::GkAtoms_Atoms = 1871;
            pub const GkAtoms_Atoms_sinh: root::mozilla::detail::GkAtoms_Atoms = 1872;
            pub const GkAtoms_Atoms_sin: root::mozilla::detail::GkAtoms_Atoms = 1873;
            pub const GkAtoms_Atoms_stackalign: root::mozilla::detail::GkAtoms_Atoms = 1874;
            pub const GkAtoms_Atoms_stretchy: root::mozilla::detail::GkAtoms_Atoms = 1875;
            pub const GkAtoms_Atoms_subscriptshift: root::mozilla::detail::GkAtoms_Atoms = 1876;
            pub const GkAtoms_Atoms_subset: root::mozilla::detail::GkAtoms_Atoms = 1877;
            pub const GkAtoms_Atoms_superscriptshift: root::mozilla::detail::GkAtoms_Atoms = 1878;
            pub const GkAtoms_Atoms_symmetric: root::mozilla::detail::GkAtoms_Atoms = 1879;
            pub const GkAtoms_Atoms_tanh: root::mozilla::detail::GkAtoms_Atoms = 1880;
            pub const GkAtoms_Atoms_tan: root::mozilla::detail::GkAtoms_Atoms = 1881;
            pub const GkAtoms_Atoms_tendsto: root::mozilla::detail::GkAtoms_Atoms = 1882;
            pub const GkAtoms_Atoms_times: root::mozilla::detail::GkAtoms_Atoms = 1883;
            pub const GkAtoms_Atoms_transpose: root::mozilla::detail::GkAtoms_Atoms = 1884;
            pub const GkAtoms_Atoms_union_: root::mozilla::detail::GkAtoms_Atoms = 1885;
            pub const GkAtoms_Atoms_uplimit: root::mozilla::detail::GkAtoms_Atoms = 1886;
            pub const GkAtoms_Atoms_variance: root::mozilla::detail::GkAtoms_Atoms = 1887;
            pub const GkAtoms_Atoms_vectorproduct: root::mozilla::detail::GkAtoms_Atoms = 1888;
            pub const GkAtoms_Atoms_vector: root::mozilla::detail::GkAtoms_Atoms = 1889;
            pub const GkAtoms_Atoms_voffset: root::mozilla::detail::GkAtoms_Atoms = 1890;
            pub const GkAtoms_Atoms_xref: root::mozilla::detail::GkAtoms_Atoms = 1891;
            pub const GkAtoms_Atoms_math: root::mozilla::detail::GkAtoms_Atoms = 1892;
            pub const GkAtoms_Atoms_booleanFromString: root::mozilla::detail::GkAtoms_Atoms = 1893;
            pub const GkAtoms_Atoms_countNonEmpty: root::mozilla::detail::GkAtoms_Atoms = 1894;
            pub const GkAtoms_Atoms_daysFromDate: root::mozilla::detail::GkAtoms_Atoms = 1895;
            pub const GkAtoms_Atoms_secondsFromDateTime: root::mozilla::detail::GkAtoms_Atoms =
                1896;
            pub const GkAtoms_Atoms_tabbrowser_arrowscrollbox:
                root::mozilla::detail::GkAtoms_Atoms = 1897;
            pub const GkAtoms_Atoms_onMozSwipeGestureMayStart:
                root::mozilla::detail::GkAtoms_Atoms = 1898;
            pub const GkAtoms_Atoms_onMozSwipeGestureStart: root::mozilla::detail::GkAtoms_Atoms =
                1899;
            pub const GkAtoms_Atoms_onMozSwipeGestureUpdate: root::mozilla::detail::GkAtoms_Atoms =
                1900;
            pub const GkAtoms_Atoms_onMozSwipeGestureEnd: root::mozilla::detail::GkAtoms_Atoms =
                1901;
            pub const GkAtoms_Atoms_onMozSwipeGesture: root::mozilla::detail::GkAtoms_Atoms = 1902;
            pub const GkAtoms_Atoms_onMozMagnifyGestureStart: root::mozilla::detail::GkAtoms_Atoms =
                1903;
            pub const GkAtoms_Atoms_onMozMagnifyGestureUpdate:
                root::mozilla::detail::GkAtoms_Atoms = 1904;
            pub const GkAtoms_Atoms_onMozMagnifyGesture: root::mozilla::detail::GkAtoms_Atoms =
                1905;
            pub const GkAtoms_Atoms_onMozRotateGestureStart: root::mozilla::detail::GkAtoms_Atoms =
                1906;
            pub const GkAtoms_Atoms_onMozRotateGestureUpdate: root::mozilla::detail::GkAtoms_Atoms =
                1907;
            pub const GkAtoms_Atoms_onMozRotateGesture: root::mozilla::detail::GkAtoms_Atoms = 1908;
            pub const GkAtoms_Atoms_onMozTapGesture: root::mozilla::detail::GkAtoms_Atoms = 1909;
            pub const GkAtoms_Atoms_onMozPressTapGesture: root::mozilla::detail::GkAtoms_Atoms =
                1910;
            pub const GkAtoms_Atoms_onMozEdgeUIStarted: root::mozilla::detail::GkAtoms_Atoms = 1911;
            pub const GkAtoms_Atoms_onMozEdgeUICanceled: root::mozilla::detail::GkAtoms_Atoms =
                1912;
            pub const GkAtoms_Atoms_onMozEdgeUICompleted: root::mozilla::detail::GkAtoms_Atoms =
                1913;
            pub const GkAtoms_Atoms_onpointerdown: root::mozilla::detail::GkAtoms_Atoms = 1914;
            pub const GkAtoms_Atoms_onpointermove: root::mozilla::detail::GkAtoms_Atoms = 1915;
            pub const GkAtoms_Atoms_onpointerup: root::mozilla::detail::GkAtoms_Atoms = 1916;
            pub const GkAtoms_Atoms_onpointercancel: root::mozilla::detail::GkAtoms_Atoms = 1917;
            pub const GkAtoms_Atoms_onpointerover: root::mozilla::detail::GkAtoms_Atoms = 1918;
            pub const GkAtoms_Atoms_onpointerout: root::mozilla::detail::GkAtoms_Atoms = 1919;
            pub const GkAtoms_Atoms_onpointerenter: root::mozilla::detail::GkAtoms_Atoms = 1920;
            pub const GkAtoms_Atoms_onpointerleave: root::mozilla::detail::GkAtoms_Atoms = 1921;
            pub const GkAtoms_Atoms_onpointerrawupdate: root::mozilla::detail::GkAtoms_Atoms = 1922;
            pub const GkAtoms_Atoms_ongotpointercapture: root::mozilla::detail::GkAtoms_Atoms =
                1923;
            pub const GkAtoms_Atoms_onlostpointercapture: root::mozilla::detail::GkAtoms_Atoms =
                1924;
            pub const GkAtoms_Atoms_ondevicemotion: root::mozilla::detail::GkAtoms_Atoms = 1925;
            pub const GkAtoms_Atoms_ondeviceorientation: root::mozilla::detail::GkAtoms_Atoms =
                1926;
            pub const GkAtoms_Atoms_ondeviceorientationabsolute:
                root::mozilla::detail::GkAtoms_Atoms = 1927;
            pub const GkAtoms_Atoms_onmozorientationchange: root::mozilla::detail::GkAtoms_Atoms =
                1928;
            pub const GkAtoms_Atoms_onuserproximity: root::mozilla::detail::GkAtoms_Atoms = 1929;
            pub const GkAtoms_Atoms_ondevicelight: root::mozilla::detail::GkAtoms_Atoms = 1930;
            pub const GkAtoms_Atoms_ondevicechange: root::mozilla::detail::GkAtoms_Atoms = 1931;
            pub const GkAtoms_Atoms_onrtctransform: root::mozilla::detail::GkAtoms_Atoms = 1932;
            pub const GkAtoms_Atoms_onmozvisualresize: root::mozilla::detail::GkAtoms_Atoms = 1933;
            pub const GkAtoms_Atoms_onmozvisualscroll: root::mozilla::detail::GkAtoms_Atoms = 1934;
            pub const GkAtoms_Atoms_onDOMContentLoaded: root::mozilla::detail::GkAtoms_Atoms = 1935;
            pub const GkAtoms_Atoms_onDOMDocElementInserted: root::mozilla::detail::GkAtoms_Atoms =
                1936;
            pub const GkAtoms_Atoms_onDOMFormBeforeSubmit: root::mozilla::detail::GkAtoms_Atoms =
                1937;
            pub const GkAtoms_Atoms_onDOMFormHasPassword: root::mozilla::detail::GkAtoms_Atoms =
                1938;
            pub const GkAtoms_Atoms_onDOMFrameContentLoaded: root::mozilla::detail::GkAtoms_Atoms =
                1939;
            pub const GkAtoms_Atoms_onDOMHeadElementParsed: root::mozilla::detail::GkAtoms_Atoms =
                1940;
            pub const GkAtoms_Atoms_onDOMInputPasswordAdded: root::mozilla::detail::GkAtoms_Atoms =
                1941;
            pub const GkAtoms_Atoms_onDOMLinkAdded: root::mozilla::detail::GkAtoms_Atoms = 1942;
            pub const GkAtoms_Atoms_onDOMLinkChanged: root::mozilla::detail::GkAtoms_Atoms = 1943;
            pub const GkAtoms_Atoms_onDOMMetaAdded: root::mozilla::detail::GkAtoms_Atoms = 1944;
            pub const GkAtoms_Atoms_onDOMMetaChanged: root::mozilla::detail::GkAtoms_Atoms = 1945;
            pub const GkAtoms_Atoms_onDOMMetaRemoved: root::mozilla::detail::GkAtoms_Atoms = 1946;
            pub const GkAtoms_Atoms_onDOMPopupBlocked: root::mozilla::detail::GkAtoms_Atoms = 1947;
            pub const GkAtoms_Atoms_onDOMTitleChanged: root::mozilla::detail::GkAtoms_Atoms = 1948;
            pub const GkAtoms_Atoms_onDOMWindowClose: root::mozilla::detail::GkAtoms_Atoms = 1949;
            pub const GkAtoms_Atoms_onDOMWindowCreated: root::mozilla::detail::GkAtoms_Atoms = 1950;
            pub const GkAtoms_Atoms_onDOMWindowFocus: root::mozilla::detail::GkAtoms_Atoms = 1951;
            pub const GkAtoms_Atoms_onFullZoomChange: root::mozilla::detail::GkAtoms_Atoms = 1952;
            pub const GkAtoms_Atoms_onGloballyAutoplayBlocked:
                root::mozilla::detail::GkAtoms_Atoms = 1953;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Entered:
                root::mozilla::detail::GkAtoms_Atoms = 1954;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Exit: root::mozilla::detail::GkAtoms_Atoms =
                1955;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Exited:
                root::mozilla::detail::GkAtoms_Atoms = 1956;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_NewOrigin:
                root::mozilla::detail::GkAtoms_Atoms = 1957;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Request:
                root::mozilla::detail::GkAtoms_Atoms = 1958;
            pub const GkAtoms_Atoms_onMozDOMPointerLock_Entered:
                root::mozilla::detail::GkAtoms_Atoms = 1959;
            pub const GkAtoms_Atoms_onMozDOMPointerLock_Exited:
                root::mozilla::detail::GkAtoms_Atoms = 1960;
            pub const GkAtoms_Atoms_onMozInvalidForm: root::mozilla::detail::GkAtoms_Atoms = 1961;
            pub const GkAtoms_Atoms_onMozLocalStorageChanged: root::mozilla::detail::GkAtoms_Atoms =
                1962;
            pub const GkAtoms_Atoms_onMozOpenDateTimePicker: root::mozilla::detail::GkAtoms_Atoms =
                1963;
            pub const GkAtoms_Atoms_onMozSessionStorageChanged:
                root::mozilla::detail::GkAtoms_Atoms = 1964;
            pub const GkAtoms_Atoms_onMozTogglePictureInPicture:
                root::mozilla::detail::GkAtoms_Atoms = 1965;
            pub const GkAtoms_Atoms_onPluginCrashed: root::mozilla::detail::GkAtoms_Atoms = 1966;
            pub const GkAtoms_Atoms_onPrintingError: root::mozilla::detail::GkAtoms_Atoms = 1967;
            pub const GkAtoms_Atoms_onTextZoomChange: root::mozilla::detail::GkAtoms_Atoms = 1968;
            pub const GkAtoms_Atoms_onUAWidgetSetupOrChange: root::mozilla::detail::GkAtoms_Atoms =
                1969;
            pub const GkAtoms_Atoms_onUAWidgetTeardown: root::mozilla::detail::GkAtoms_Atoms = 1970;
            pub const GkAtoms_Atoms_onUnselectedTabHover_Disable:
                root::mozilla::detail::GkAtoms_Atoms = 1971;
            pub const GkAtoms_Atoms_onUnselectedTabHover_Enable:
                root::mozilla::detail::GkAtoms_Atoms = 1972;
            pub const GkAtoms_Atoms_onmozshowdropdown: root::mozilla::detail::GkAtoms_Atoms = 1973;
            pub const GkAtoms_Atoms_onmozshowdropdown_sourcetouch:
                root::mozilla::detail::GkAtoms_Atoms = 1974;
            pub const GkAtoms_Atoms_onprintPreviewUpdate: root::mozilla::detail::GkAtoms_Atoms =
                1975;
            pub const GkAtoms_Atoms_onscrollend: root::mozilla::detail::GkAtoms_Atoms = 1976;
            pub const GkAtoms_Atoms_onbeforetoggle: root::mozilla::detail::GkAtoms_Atoms = 1977;
            pub const GkAtoms_Atoms_moz_extension: root::mozilla::detail::GkAtoms_Atoms = 1978;
            pub const GkAtoms_Atoms_all_urlsPermission: root::mozilla::detail::GkAtoms_Atoms = 1979;
            pub const GkAtoms_Atoms_clipboardRead: root::mozilla::detail::GkAtoms_Atoms = 1980;
            pub const GkAtoms_Atoms_clipboardWrite: root::mozilla::detail::GkAtoms_Atoms = 1981;
            pub const GkAtoms_Atoms_debugger: root::mozilla::detail::GkAtoms_Atoms = 1982;
            pub const GkAtoms_Atoms_mozillaAddons: root::mozilla::detail::GkAtoms_Atoms = 1983;
            pub const GkAtoms_Atoms_tabs: root::mozilla::detail::GkAtoms_Atoms = 1984;
            pub const GkAtoms_Atoms_webRequestBlocking: root::mozilla::detail::GkAtoms_Atoms = 1985;
            pub const GkAtoms_Atoms_webRequestFilterResponse_serviceWorkerScript:
                root::mozilla::detail::GkAtoms_Atoms = 1986;
            pub const GkAtoms_Atoms_blob: root::mozilla::detail::GkAtoms_Atoms = 1987;
            pub const GkAtoms_Atoms_http: root::mozilla::detail::GkAtoms_Atoms = 1988;
            pub const GkAtoms_Atoms_https: root::mozilla::detail::GkAtoms_Atoms = 1989;
            pub const GkAtoms_Atoms_view_source: root::mozilla::detail::GkAtoms_Atoms = 1990;
            pub const GkAtoms_Atoms_ws: root::mozilla::detail::GkAtoms_Atoms = 1991;
            pub const GkAtoms_Atoms_wss: root::mozilla::detail::GkAtoms_Atoms = 1992;
            pub const GkAtoms_Atoms_ftp: root::mozilla::detail::GkAtoms_Atoms = 1993;
            pub const GkAtoms_Atoms_chrome: root::mozilla::detail::GkAtoms_Atoms = 1994;
            pub const GkAtoms_Atoms_moz: root::mozilla::detail::GkAtoms_Atoms = 1995;
            pub const GkAtoms_Atoms_moz_icon: root::mozilla::detail::GkAtoms_Atoms = 1996;
            pub const GkAtoms_Atoms_moz_gio: root::mozilla::detail::GkAtoms_Atoms = 1997;
            pub const GkAtoms_Atoms_proxy: root::mozilla::detail::GkAtoms_Atoms = 1998;
            pub const GkAtoms_Atoms_privateBrowsingAllowedPermission:
                root::mozilla::detail::GkAtoms_Atoms = 1999;
            pub const GkAtoms_Atoms_svgContextPropertiesAllowedPermission:
                root::mozilla::detail::GkAtoms_Atoms = 2000;
            pub const GkAtoms_Atoms_theme: root::mozilla::detail::GkAtoms_Atoms = 2001;
            pub const GkAtoms_Atoms_userScripts: root::mozilla::detail::GkAtoms_Atoms = 2002;
            pub const GkAtoms_Atoms_decimal_leading_zero: root::mozilla::detail::GkAtoms_Atoms =
                2003;
            pub const GkAtoms_Atoms_arabic_indic: root::mozilla::detail::GkAtoms_Atoms = 2004;
            pub const GkAtoms_Atoms_armenian: root::mozilla::detail::GkAtoms_Atoms = 2005;
            pub const GkAtoms_Atoms_upper_armenian: root::mozilla::detail::GkAtoms_Atoms = 2006;
            pub const GkAtoms_Atoms_lower_armenian: root::mozilla::detail::GkAtoms_Atoms = 2007;
            pub const GkAtoms_Atoms_bengali: root::mozilla::detail::GkAtoms_Atoms = 2008;
            pub const GkAtoms_Atoms_cambodian: root::mozilla::detail::GkAtoms_Atoms = 2009;
            pub const GkAtoms_Atoms_khmer: root::mozilla::detail::GkAtoms_Atoms = 2010;
            pub const GkAtoms_Atoms_cjk_decimal: root::mozilla::detail::GkAtoms_Atoms = 2011;
            pub const GkAtoms_Atoms_devanagari: root::mozilla::detail::GkAtoms_Atoms = 2012;
            pub const GkAtoms_Atoms_georgian: root::mozilla::detail::GkAtoms_Atoms = 2013;
            pub const GkAtoms_Atoms_gujarati: root::mozilla::detail::GkAtoms_Atoms = 2014;
            pub const GkAtoms_Atoms_gurmukhi: root::mozilla::detail::GkAtoms_Atoms = 2015;
            pub const GkAtoms_Atoms_kannada: root::mozilla::detail::GkAtoms_Atoms = 2016;
            pub const GkAtoms_Atoms_lao: root::mozilla::detail::GkAtoms_Atoms = 2017;
            pub const GkAtoms_Atoms_malayalam: root::mozilla::detail::GkAtoms_Atoms = 2018;
            pub const GkAtoms_Atoms_mongolian: root::mozilla::detail::GkAtoms_Atoms = 2019;
            pub const GkAtoms_Atoms_myanmar: root::mozilla::detail::GkAtoms_Atoms = 2020;
            pub const GkAtoms_Atoms_oriya: root::mozilla::detail::GkAtoms_Atoms = 2021;
            pub const GkAtoms_Atoms_persian: root::mozilla::detail::GkAtoms_Atoms = 2022;
            pub const GkAtoms_Atoms_lower_roman: root::mozilla::detail::GkAtoms_Atoms = 2023;
            pub const GkAtoms_Atoms_upper_roman: root::mozilla::detail::GkAtoms_Atoms = 2024;
            pub const GkAtoms_Atoms_tamil: root::mozilla::detail::GkAtoms_Atoms = 2025;
            pub const GkAtoms_Atoms_telugu: root::mozilla::detail::GkAtoms_Atoms = 2026;
            pub const GkAtoms_Atoms_thai: root::mozilla::detail::GkAtoms_Atoms = 2027;
            pub const GkAtoms_Atoms_tibetan: root::mozilla::detail::GkAtoms_Atoms = 2028;
            pub const GkAtoms_Atoms_lower_alpha: root::mozilla::detail::GkAtoms_Atoms = 2029;
            pub const GkAtoms_Atoms_lower_latin: root::mozilla::detail::GkAtoms_Atoms = 2030;
            pub const GkAtoms_Atoms_upper_alpha: root::mozilla::detail::GkAtoms_Atoms = 2031;
            pub const GkAtoms_Atoms_upper_latin: root::mozilla::detail::GkAtoms_Atoms = 2032;
            pub const GkAtoms_Atoms_cjk_heavenly_stem: root::mozilla::detail::GkAtoms_Atoms = 2033;
            pub const GkAtoms_Atoms_cjk_earthly_branch: root::mozilla::detail::GkAtoms_Atoms = 2034;
            pub const GkAtoms_Atoms_lower_greek: root::mozilla::detail::GkAtoms_Atoms = 2035;
            pub const GkAtoms_Atoms_hiragana: root::mozilla::detail::GkAtoms_Atoms = 2036;
            pub const GkAtoms_Atoms_hiragana_iroha: root::mozilla::detail::GkAtoms_Atoms = 2037;
            pub const GkAtoms_Atoms_katakana: root::mozilla::detail::GkAtoms_Atoms = 2038;
            pub const GkAtoms_Atoms_katakana_iroha: root::mozilla::detail::GkAtoms_Atoms = 2039;
            pub const GkAtoms_Atoms_cjk_ideographic: root::mozilla::detail::GkAtoms_Atoms = 2040;
            pub const GkAtoms_Atoms__moz_arabic_indic: root::mozilla::detail::GkAtoms_Atoms = 2041;
            pub const GkAtoms_Atoms__moz_persian: root::mozilla::detail::GkAtoms_Atoms = 2042;
            pub const GkAtoms_Atoms__moz_urdu: root::mozilla::detail::GkAtoms_Atoms = 2043;
            pub const GkAtoms_Atoms__moz_devanagari: root::mozilla::detail::GkAtoms_Atoms = 2044;
            pub const GkAtoms_Atoms__moz_bengali: root::mozilla::detail::GkAtoms_Atoms = 2045;
            pub const GkAtoms_Atoms__moz_gurmukhi: root::mozilla::detail::GkAtoms_Atoms = 2046;
            pub const GkAtoms_Atoms__moz_gujarati: root::mozilla::detail::GkAtoms_Atoms = 2047;
            pub const GkAtoms_Atoms__moz_oriya: root::mozilla::detail::GkAtoms_Atoms = 2048;
            pub const GkAtoms_Atoms__moz_tamil: root::mozilla::detail::GkAtoms_Atoms = 2049;
            pub const GkAtoms_Atoms__moz_telugu: root::mozilla::detail::GkAtoms_Atoms = 2050;
            pub const GkAtoms_Atoms__moz_kannada: root::mozilla::detail::GkAtoms_Atoms = 2051;
            pub const GkAtoms_Atoms__moz_malayalam: root::mozilla::detail::GkAtoms_Atoms = 2052;
            pub const GkAtoms_Atoms__moz_thai: root::mozilla::detail::GkAtoms_Atoms = 2053;
            pub const GkAtoms_Atoms__moz_lao: root::mozilla::detail::GkAtoms_Atoms = 2054;
            pub const GkAtoms_Atoms__moz_myanmar: root::mozilla::detail::GkAtoms_Atoms = 2055;
            pub const GkAtoms_Atoms__moz_khmer: root::mozilla::detail::GkAtoms_Atoms = 2056;
            pub const GkAtoms_Atoms__moz_cjk_heavenly_stem: root::mozilla::detail::GkAtoms_Atoms =
                2057;
            pub const GkAtoms_Atoms__moz_cjk_earthly_branch: root::mozilla::detail::GkAtoms_Atoms =
                2058;
            pub const GkAtoms_Atoms__moz_hangul: root::mozilla::detail::GkAtoms_Atoms = 2059;
            pub const GkAtoms_Atoms__moz_hangul_consonant: root::mozilla::detail::GkAtoms_Atoms =
                2060;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame: root::mozilla::detail::GkAtoms_Atoms =
                2061;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame_am:
                root::mozilla::detail::GkAtoms_Atoms = 2062;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame_ti_er:
                root::mozilla::detail::GkAtoms_Atoms = 2063;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame_ti_et:
                root::mozilla::detail::GkAtoms_Atoms = 2064;
            pub const GkAtoms_Atoms__moz_trad_chinese_informal:
                root::mozilla::detail::GkAtoms_Atoms = 2065;
            pub const GkAtoms_Atoms__moz_trad_chinese_formal: root::mozilla::detail::GkAtoms_Atoms =
                2066;
            pub const GkAtoms_Atoms__moz_simp_chinese_informal:
                root::mozilla::detail::GkAtoms_Atoms = 2067;
            pub const GkAtoms_Atoms__moz_simp_chinese_formal: root::mozilla::detail::GkAtoms_Atoms =
                2068;
            pub const GkAtoms_Atoms__moz_japanese_informal: root::mozilla::detail::GkAtoms_Atoms =
                2069;
            pub const GkAtoms_Atoms__moz_japanese_formal: root::mozilla::detail::GkAtoms_Atoms =
                2070;
            pub const GkAtoms_Atoms__moz_ethiopic_numeric: root::mozilla::detail::GkAtoms_Atoms =
                2071;
            pub const GkAtoms_Atoms_cdataTagName: root::mozilla::detail::GkAtoms_Atoms = 2072;
            pub const GkAtoms_Atoms_commentTagName: root::mozilla::detail::GkAtoms_Atoms = 2073;
            pub const GkAtoms_Atoms_documentNodeName: root::mozilla::detail::GkAtoms_Atoms = 2074;
            pub const GkAtoms_Atoms_documentFragmentNodeName: root::mozilla::detail::GkAtoms_Atoms =
                2075;
            pub const GkAtoms_Atoms_documentTypeNodeName: root::mozilla::detail::GkAtoms_Atoms =
                2076;
            pub const GkAtoms_Atoms_processingInstructionTagName:
                root::mozilla::detail::GkAtoms_Atoms = 2077;
            pub const GkAtoms_Atoms_textTagName: root::mozilla::detail::GkAtoms_Atoms = 2078;
            pub const GkAtoms_Atoms_placeholderFrame: root::mozilla::detail::GkAtoms_Atoms = 2079;
            pub const GkAtoms_Atoms_onloadend: root::mozilla::detail::GkAtoms_Atoms = 2080;
            pub const GkAtoms_Atoms_onloadstart: root::mozilla::detail::GkAtoms_Atoms = 2081;
            pub const GkAtoms_Atoms_onprogress: root::mozilla::detail::GkAtoms_Atoms = 2082;
            pub const GkAtoms_Atoms_onsuspend: root::mozilla::detail::GkAtoms_Atoms = 2083;
            pub const GkAtoms_Atoms_onemptied: root::mozilla::detail::GkAtoms_Atoms = 2084;
            pub const GkAtoms_Atoms_onstalled: root::mozilla::detail::GkAtoms_Atoms = 2085;
            pub const GkAtoms_Atoms_onplay: root::mozilla::detail::GkAtoms_Atoms = 2086;
            pub const GkAtoms_Atoms_onpause: root::mozilla::detail::GkAtoms_Atoms = 2087;
            pub const GkAtoms_Atoms_onloadedmetadata: root::mozilla::detail::GkAtoms_Atoms = 2088;
            pub const GkAtoms_Atoms_onloadeddata: root::mozilla::detail::GkAtoms_Atoms = 2089;
            pub const GkAtoms_Atoms_onwaiting: root::mozilla::detail::GkAtoms_Atoms = 2090;
            pub const GkAtoms_Atoms_onplaying: root::mozilla::detail::GkAtoms_Atoms = 2091;
            pub const GkAtoms_Atoms_oncanplay: root::mozilla::detail::GkAtoms_Atoms = 2092;
            pub const GkAtoms_Atoms_oncanplaythrough: root::mozilla::detail::GkAtoms_Atoms = 2093;
            pub const GkAtoms_Atoms_onseeking: root::mozilla::detail::GkAtoms_Atoms = 2094;
            pub const GkAtoms_Atoms_onseeked: root::mozilla::detail::GkAtoms_Atoms = 2095;
            pub const GkAtoms_Atoms_ontimeout: root::mozilla::detail::GkAtoms_Atoms = 2096;
            pub const GkAtoms_Atoms_ontimeupdate: root::mozilla::detail::GkAtoms_Atoms = 2097;
            pub const GkAtoms_Atoms_onended: root::mozilla::detail::GkAtoms_Atoms = 2098;
            pub const GkAtoms_Atoms_onformdata: root::mozilla::detail::GkAtoms_Atoms = 2099;
            pub const GkAtoms_Atoms_onratechange: root::mozilla::detail::GkAtoms_Atoms = 2100;
            pub const GkAtoms_Atoms_ondurationchange: root::mozilla::detail::GkAtoms_Atoms = 2101;
            pub const GkAtoms_Atoms_onvolumechange: root::mozilla::detail::GkAtoms_Atoms = 2102;
            pub const GkAtoms_Atoms_onaddtrack: root::mozilla::detail::GkAtoms_Atoms = 2103;
            pub const GkAtoms_Atoms_oncontrollerchange: root::mozilla::detail::GkAtoms_Atoms = 2104;
            pub const GkAtoms_Atoms_oncuechange: root::mozilla::detail::GkAtoms_Atoms = 2105;
            pub const GkAtoms_Atoms_onenter: root::mozilla::detail::GkAtoms_Atoms = 2106;
            pub const GkAtoms_Atoms_onexit: root::mozilla::detail::GkAtoms_Atoms = 2107;
            pub const GkAtoms_Atoms_onencrypted: root::mozilla::detail::GkAtoms_Atoms = 2108;
            pub const GkAtoms_Atoms_onwaitingforkey: root::mozilla::detail::GkAtoms_Atoms = 2109;
            pub const GkAtoms_Atoms_onkeystatuseschange: root::mozilla::detail::GkAtoms_Atoms =
                2110;
            pub const GkAtoms_Atoms_onremovetrack: root::mozilla::detail::GkAtoms_Atoms = 2111;
            pub const GkAtoms_Atoms_loadstart: root::mozilla::detail::GkAtoms_Atoms = 2112;
            pub const GkAtoms_Atoms_suspend: root::mozilla::detail::GkAtoms_Atoms = 2113;
            pub const GkAtoms_Atoms_emptied: root::mozilla::detail::GkAtoms_Atoms = 2114;
            pub const GkAtoms_Atoms_play: root::mozilla::detail::GkAtoms_Atoms = 2115;
            pub const GkAtoms_Atoms_pause: root::mozilla::detail::GkAtoms_Atoms = 2116;
            pub const GkAtoms_Atoms_loadedmetadata: root::mozilla::detail::GkAtoms_Atoms = 2117;
            pub const GkAtoms_Atoms_loadeddata: root::mozilla::detail::GkAtoms_Atoms = 2118;
            pub const GkAtoms_Atoms_waiting: root::mozilla::detail::GkAtoms_Atoms = 2119;
            pub const GkAtoms_Atoms_playing: root::mozilla::detail::GkAtoms_Atoms = 2120;
            pub const GkAtoms_Atoms_timeupdate: root::mozilla::detail::GkAtoms_Atoms = 2121;
            pub const GkAtoms_Atoms_canplay: root::mozilla::detail::GkAtoms_Atoms = 2122;
            pub const GkAtoms_Atoms_canplaythrough: root::mozilla::detail::GkAtoms_Atoms = 2123;
            pub const GkAtoms_Atoms_ondataavailable: root::mozilla::detail::GkAtoms_Atoms = 2124;
            pub const GkAtoms_Atoms_onwarning: root::mozilla::detail::GkAtoms_Atoms = 2125;
            pub const GkAtoms_Atoms_onstart: root::mozilla::detail::GkAtoms_Atoms = 2126;
            pub const GkAtoms_Atoms_onstop: root::mozilla::detail::GkAtoms_Atoms = 2127;
            pub const GkAtoms_Atoms_onphoto: root::mozilla::detail::GkAtoms_Atoms = 2128;
            pub const GkAtoms_Atoms_ongamepadbuttondown: root::mozilla::detail::GkAtoms_Atoms =
                2129;
            pub const GkAtoms_Atoms_ongamepadbuttonup: root::mozilla::detail::GkAtoms_Atoms = 2130;
            pub const GkAtoms_Atoms_ongamepadaxismove: root::mozilla::detail::GkAtoms_Atoms = 2131;
            pub const GkAtoms_Atoms_ongamepadconnected: root::mozilla::detail::GkAtoms_Atoms = 2132;
            pub const GkAtoms_Atoms_ongamepaddisconnected: root::mozilla::detail::GkAtoms_Atoms =
                2133;
            pub const GkAtoms_Atoms_onfetch: root::mozilla::detail::GkAtoms_Atoms = 2134;
            pub const GkAtoms_Atoms_afterPseudoProperty: root::mozilla::detail::GkAtoms_Atoms =
                2135;
            pub const GkAtoms_Atoms_beforePseudoProperty: root::mozilla::detail::GkAtoms_Atoms =
                2136;
            pub const GkAtoms_Atoms_cssPseudoElementBeforeProperty:
                root::mozilla::detail::GkAtoms_Atoms = 2137;
            pub const GkAtoms_Atoms_cssPseudoElementAfterProperty:
                root::mozilla::detail::GkAtoms_Atoms = 2138;
            pub const GkAtoms_Atoms_cssPseudoElementMarkerProperty:
                root::mozilla::detail::GkAtoms_Atoms = 2139;
            pub const GkAtoms_Atoms_genConInitializerProperty:
                root::mozilla::detail::GkAtoms_Atoms = 2140;
            pub const GkAtoms_Atoms_labelMouseDownPtProperty: root::mozilla::detail::GkAtoms_Atoms =
                2141;
            pub const GkAtoms_Atoms_lockedStyleStates: root::mozilla::detail::GkAtoms_Atoms = 2142;
            pub const GkAtoms_Atoms_apzCallbackTransform: root::mozilla::detail::GkAtoms_Atoms =
                2143;
            pub const GkAtoms_Atoms_apzDisabled: root::mozilla::detail::GkAtoms_Atoms = 2144;
            pub const GkAtoms_Atoms_restylableAnonymousNode: root::mozilla::detail::GkAtoms_Atoms =
                2145;
            pub const GkAtoms_Atoms_docLevelNativeAnonymousContent:
                root::mozilla::detail::GkAtoms_Atoms = 2146;
            pub const GkAtoms_Atoms_paintRequestTime: root::mozilla::detail::GkAtoms_Atoms = 2147;
            pub const GkAtoms_Atoms_pseudoProperty: root::mozilla::detail::GkAtoms_Atoms = 2148;
            pub const GkAtoms_Atoms_manualNACProperty: root::mozilla::detail::GkAtoms_Atoms = 2149;
            pub const GkAtoms_Atoms_markerPseudoProperty: root::mozilla::detail::GkAtoms_Atoms =
                2150;
            pub const GkAtoms_Atoms_Japanese: root::mozilla::detail::GkAtoms_Atoms = 2151;
            pub const GkAtoms_Atoms_Chinese: root::mozilla::detail::GkAtoms_Atoms = 2152;
            pub const GkAtoms_Atoms_Taiwanese: root::mozilla::detail::GkAtoms_Atoms = 2153;
            pub const GkAtoms_Atoms_HongKongChinese: root::mozilla::detail::GkAtoms_Atoms = 2154;
            pub const GkAtoms_Atoms_Unicode: root::mozilla::detail::GkAtoms_Atoms = 2155;
            pub const GkAtoms_Atoms_ko: root::mozilla::detail::GkAtoms_Atoms = 2156;
            pub const GkAtoms_Atoms_zh_cn: root::mozilla::detail::GkAtoms_Atoms = 2157;
            pub const GkAtoms_Atoms_zh_tw: root::mozilla::detail::GkAtoms_Atoms = 2158;
            pub const GkAtoms_Atoms_x_cyrillic: root::mozilla::detail::GkAtoms_Atoms = 2159;
            pub const GkAtoms_Atoms_he: root::mozilla::detail::GkAtoms_Atoms = 2160;
            pub const GkAtoms_Atoms_ar: root::mozilla::detail::GkAtoms_Atoms = 2161;
            pub const GkAtoms_Atoms_x_devanagari: root::mozilla::detail::GkAtoms_Atoms = 2162;
            pub const GkAtoms_Atoms_x_tamil: root::mozilla::detail::GkAtoms_Atoms = 2163;
            pub const GkAtoms_Atoms_x_armn: root::mozilla::detail::GkAtoms_Atoms = 2164;
            pub const GkAtoms_Atoms_x_beng: root::mozilla::detail::GkAtoms_Atoms = 2165;
            pub const GkAtoms_Atoms_x_cans: root::mozilla::detail::GkAtoms_Atoms = 2166;
            pub const GkAtoms_Atoms_x_ethi: root::mozilla::detail::GkAtoms_Atoms = 2167;
            pub const GkAtoms_Atoms_x_geor: root::mozilla::detail::GkAtoms_Atoms = 2168;
            pub const GkAtoms_Atoms_x_gujr: root::mozilla::detail::GkAtoms_Atoms = 2169;
            pub const GkAtoms_Atoms_x_guru: root::mozilla::detail::GkAtoms_Atoms = 2170;
            pub const GkAtoms_Atoms_x_khmr: root::mozilla::detail::GkAtoms_Atoms = 2171;
            pub const GkAtoms_Atoms_x_knda: root::mozilla::detail::GkAtoms_Atoms = 2172;
            pub const GkAtoms_Atoms_x_mlym: root::mozilla::detail::GkAtoms_Atoms = 2173;
            pub const GkAtoms_Atoms_x_orya: root::mozilla::detail::GkAtoms_Atoms = 2174;
            pub const GkAtoms_Atoms_x_sinh: root::mozilla::detail::GkAtoms_Atoms = 2175;
            pub const GkAtoms_Atoms_x_telu: root::mozilla::detail::GkAtoms_Atoms = 2176;
            pub const GkAtoms_Atoms_x_tibt: root::mozilla::detail::GkAtoms_Atoms = 2177;
            pub const GkAtoms_Atoms_az: root::mozilla::detail::GkAtoms_Atoms = 2178;
            pub const GkAtoms_Atoms_ba: root::mozilla::detail::GkAtoms_Atoms = 2179;
            pub const GkAtoms_Atoms_crh: root::mozilla::detail::GkAtoms_Atoms = 2180;
            pub const GkAtoms_Atoms_ga: root::mozilla::detail::GkAtoms_Atoms = 2181;
            pub const GkAtoms_Atoms_nl: root::mozilla::detail::GkAtoms_Atoms = 2182;
            pub const GkAtoms_Atoms_x_math: root::mozilla::detail::GkAtoms_Atoms = 2183;
            pub const GkAtoms_Atoms_zh: root::mozilla::detail::GkAtoms_Atoms = 2184;
            pub const GkAtoms_Atoms_TypingTxnName: root::mozilla::detail::GkAtoms_Atoms = 2185;
            pub const GkAtoms_Atoms_IMETxnName: root::mozilla::detail::GkAtoms_Atoms = 2186;
            pub const GkAtoms_Atoms_DeleteTxnName: root::mozilla::detail::GkAtoms_Atoms = 2187;
            pub const GkAtoms_Atoms_serif: root::mozilla::detail::GkAtoms_Atoms = 2188;
            pub const GkAtoms_Atoms_sans_serif: root::mozilla::detail::GkAtoms_Atoms = 2189;
            pub const GkAtoms_Atoms_cursive: root::mozilla::detail::GkAtoms_Atoms = 2190;
            pub const GkAtoms_Atoms_fantasy: root::mozilla::detail::GkAtoms_Atoms = 2191;
            pub const GkAtoms_Atoms_monospace: root::mozilla::detail::GkAtoms_Atoms = 2192;
            pub const GkAtoms_Atoms_mozfixed: root::mozilla::detail::GkAtoms_Atoms = 2193;
            pub const GkAtoms_Atoms_moz_fixed_pos_containing_block:
                root::mozilla::detail::GkAtoms_Atoms = 2194;
            pub const GkAtoms_Atoms_light: root::mozilla::detail::GkAtoms_Atoms = 2195;
            pub const GkAtoms_Atoms_dark: root::mozilla::detail::GkAtoms_Atoms = 2196;
            pub const GkAtoms_Atoms_RemoteId: root::mozilla::detail::GkAtoms_Atoms = 2197;
            pub const GkAtoms_Atoms_RemoteType: root::mozilla::detail::GkAtoms_Atoms = 2198;
            pub const GkAtoms_Atoms_DisplayPort: root::mozilla::detail::GkAtoms_Atoms = 2199;
            pub const GkAtoms_Atoms_DisplayPortMargins: root::mozilla::detail::GkAtoms_Atoms = 2200;
            pub const GkAtoms_Atoms_DisplayPortBase: root::mozilla::detail::GkAtoms_Atoms = 2201;
            pub const GkAtoms_Atoms_MinimalDisplayPort: root::mozilla::detail::GkAtoms_Atoms = 2202;
            pub const GkAtoms_Atoms_forceMousewheelAutodir: root::mozilla::detail::GkAtoms_Atoms =
                2203;
            pub const GkAtoms_Atoms_forceMousewheelAutodirHonourRoot:
                root::mozilla::detail::GkAtoms_Atoms = 2204;
            pub const GkAtoms_Atoms_forcemessagemanager: root::mozilla::detail::GkAtoms_Atoms =
                2205;
            pub const GkAtoms_Atoms_initialBrowsingContextGroupId:
                root::mozilla::detail::GkAtoms_Atoms = 2206;
            pub const GkAtoms_Atoms_manualactiveness: root::mozilla::detail::GkAtoms_Atoms = 2207;
            pub const GkAtoms_Atoms__moz_bool_pref: root::mozilla::detail::GkAtoms_Atoms = 2208;
            pub const GkAtoms_Atoms__moz_overlay_scrollbars: root::mozilla::detail::GkAtoms_Atoms =
                2209;
            pub const GkAtoms_Atoms__moz_overlay_scrollbar_fade_duration:
                root::mozilla::detail::GkAtoms_Atoms = 2210;
            pub const GkAtoms_Atoms__moz_windows_accent_color_in_titlebar:
                root::mozilla::detail::GkAtoms_Atoms = 2211;
            pub const GkAtoms_Atoms__moz_windows_accent_color_in_tabs:
                root::mozilla::detail::GkAtoms_Atoms = 2212;
            pub const GkAtoms_Atoms__moz_windows_mica: root::mozilla::detail::GkAtoms_Atoms = 2213;
            pub const GkAtoms_Atoms__moz_windows_mica_popups: root::mozilla::detail::GkAtoms_Atoms =
                2214;
            pub const GkAtoms_Atoms__moz_mac_big_sur_theme: root::mozilla::detail::GkAtoms_Atoms =
                2215;
            pub const GkAtoms_Atoms__moz_mac_rtl: root::mozilla::detail::GkAtoms_Atoms = 2216;
            pub const GkAtoms_Atoms__moz_mac_titlebar_height: root::mozilla::detail::GkAtoms_Atoms =
                2217;
            pub const GkAtoms_Atoms__moz_platform: root::mozilla::detail::GkAtoms_Atoms = 2218;
            pub const GkAtoms_Atoms__moz_gtk_theme_family: root::mozilla::detail::GkAtoms_Atoms =
                2219;
            pub const GkAtoms_Atoms__moz_menubar_drag: root::mozilla::detail::GkAtoms_Atoms = 2220;
            pub const GkAtoms_Atoms__moz_device_pixel_ratio: root::mozilla::detail::GkAtoms_Atoms =
                2221;
            pub const GkAtoms_Atoms__moz_device_orientation: root::mozilla::detail::GkAtoms_Atoms =
                2222;
            pub const GkAtoms_Atoms__moz_is_resource_document:
                root::mozilla::detail::GkAtoms_Atoms = 2223;
            pub const GkAtoms_Atoms__moz_swipe_animation_enabled:
                root::mozilla::detail::GkAtoms_Atoms = 2224;
            pub const GkAtoms_Atoms__moz_gtk_csd_available: root::mozilla::detail::GkAtoms_Atoms =
                2225;
            pub const GkAtoms_Atoms__moz_gtk_csd_transparency_available:
                root::mozilla::detail::GkAtoms_Atoms = 2226;
            pub const GkAtoms_Atoms__moz_gtk_csd_titlebar_radius:
                root::mozilla::detail::GkAtoms_Atoms = 2227;
            pub const GkAtoms_Atoms__moz_gtk_csd_tooltip_radius:
                root::mozilla::detail::GkAtoms_Atoms = 2228;
            pub const GkAtoms_Atoms__moz_gtk_csd_titlebar_button_spacing:
                root::mozilla::detail::GkAtoms_Atoms = 2229;
            pub const GkAtoms_Atoms__moz_gtk_csd_minimize_button:
                root::mozilla::detail::GkAtoms_Atoms = 2230;
            pub const GkAtoms_Atoms__moz_gtk_csd_minimize_button_position:
                root::mozilla::detail::GkAtoms_Atoms = 2231;
            pub const GkAtoms_Atoms__moz_gtk_csd_maximize_button:
                root::mozilla::detail::GkAtoms_Atoms = 2232;
            pub const GkAtoms_Atoms__moz_gtk_csd_maximize_button_position:
                root::mozilla::detail::GkAtoms_Atoms = 2233;
            pub const GkAtoms_Atoms__moz_gtk_csd_close_button:
                root::mozilla::detail::GkAtoms_Atoms = 2234;
            pub const GkAtoms_Atoms__moz_gtk_csd_close_button_position:
                root::mozilla::detail::GkAtoms_Atoms = 2235;
            pub const GkAtoms_Atoms__moz_gtk_csd_reversed_placement:
                root::mozilla::detail::GkAtoms_Atoms = 2236;
            pub const GkAtoms_Atoms__moz_gtk_csd_rounded_bottom_corners:
                root::mozilla::detail::GkAtoms_Atoms = 2237;
            pub const GkAtoms_Atoms__moz_content_prefers_color_scheme:
                root::mozilla::detail::GkAtoms_Atoms = 2238;
            pub const GkAtoms_Atoms__moz_content_preferred_color_scheme:
                root::mozilla::detail::GkAtoms_Atoms = 2239;
            pub const GkAtoms_Atoms__moz_system_dark_theme: root::mozilla::detail::GkAtoms_Atoms =
                2240;
            pub const GkAtoms_Atoms__moz_panel_animations: root::mozilla::detail::GkAtoms_Atoms =
                2241;
            pub const GkAtoms_Atoms_Back: root::mozilla::detail::GkAtoms_Atoms = 2242;
            pub const GkAtoms_Atoms_Forward: root::mozilla::detail::GkAtoms_Atoms = 2243;
            pub const GkAtoms_Atoms_Reload: root::mozilla::detail::GkAtoms_Atoms = 2244;
            pub const GkAtoms_Atoms_Stop: root::mozilla::detail::GkAtoms_Atoms = 2245;
            pub const GkAtoms_Atoms_Search: root::mozilla::detail::GkAtoms_Atoms = 2246;
            pub const GkAtoms_Atoms_Bookmarks: root::mozilla::detail::GkAtoms_Atoms = 2247;
            pub const GkAtoms_Atoms_Home: root::mozilla::detail::GkAtoms_Atoms = 2248;
            pub const GkAtoms_Atoms_NextTrack: root::mozilla::detail::GkAtoms_Atoms = 2249;
            pub const GkAtoms_Atoms_PreviousTrack: root::mozilla::detail::GkAtoms_Atoms = 2250;
            pub const GkAtoms_Atoms_MediaStop: root::mozilla::detail::GkAtoms_Atoms = 2251;
            pub const GkAtoms_Atoms_PlayPause: root::mozilla::detail::GkAtoms_Atoms = 2252;
            pub const GkAtoms_Atoms_New: root::mozilla::detail::GkAtoms_Atoms = 2253;
            pub const GkAtoms_Atoms_Open: root::mozilla::detail::GkAtoms_Atoms = 2254;
            pub const GkAtoms_Atoms_Close: root::mozilla::detail::GkAtoms_Atoms = 2255;
            pub const GkAtoms_Atoms_Save: root::mozilla::detail::GkAtoms_Atoms = 2256;
            pub const GkAtoms_Atoms_Find: root::mozilla::detail::GkAtoms_Atoms = 2257;
            pub const GkAtoms_Atoms_Help: root::mozilla::detail::GkAtoms_Atoms = 2258;
            pub const GkAtoms_Atoms_Print: root::mozilla::detail::GkAtoms_Atoms = 2259;
            pub const GkAtoms_Atoms_SendMail: root::mozilla::detail::GkAtoms_Atoms = 2260;
            pub const GkAtoms_Atoms_ForwardMail: root::mozilla::detail::GkAtoms_Atoms = 2261;
            pub const GkAtoms_Atoms_ReplyToMail: root::mozilla::detail::GkAtoms_Atoms = 2262;
            pub const GkAtoms_Atoms_alert: root::mozilla::detail::GkAtoms_Atoms = 2263;
            pub const GkAtoms_Atoms_alertdialog: root::mozilla::detail::GkAtoms_Atoms = 2264;
            pub const GkAtoms_Atoms_application: root::mozilla::detail::GkAtoms_Atoms = 2265;
            pub const GkAtoms_Atoms_aria_colcount: root::mozilla::detail::GkAtoms_Atoms = 2266;
            pub const GkAtoms_Atoms_aria_colindex: root::mozilla::detail::GkAtoms_Atoms = 2267;
            pub const GkAtoms_Atoms_aria_colindextext: root::mozilla::detail::GkAtoms_Atoms = 2268;
            pub const GkAtoms_Atoms_aria_colspan: root::mozilla::detail::GkAtoms_Atoms = 2269;
            pub const GkAtoms_Atoms_aria_details: root::mozilla::detail::GkAtoms_Atoms = 2270;
            pub const GkAtoms_Atoms_aria_errormessage: root::mozilla::detail::GkAtoms_Atoms = 2271;
            pub const GkAtoms_Atoms_aria_grabbed: root::mozilla::detail::GkAtoms_Atoms = 2272;
            pub const GkAtoms_Atoms_aria_keyshortcuts: root::mozilla::detail::GkAtoms_Atoms = 2273;
            pub const GkAtoms_Atoms_aria_label: root::mozilla::detail::GkAtoms_Atoms = 2274;
            pub const GkAtoms_Atoms_aria_modal: root::mozilla::detail::GkAtoms_Atoms = 2275;
            pub const GkAtoms_Atoms_aria_orientation: root::mozilla::detail::GkAtoms_Atoms = 2276;
            pub const GkAtoms_Atoms_aria_placeholder: root::mozilla::detail::GkAtoms_Atoms = 2277;
            pub const GkAtoms_Atoms_aria_roledescription: root::mozilla::detail::GkAtoms_Atoms =
                2278;
            pub const GkAtoms_Atoms_aria_rowcount: root::mozilla::detail::GkAtoms_Atoms = 2279;
            pub const GkAtoms_Atoms_aria_rowindex: root::mozilla::detail::GkAtoms_Atoms = 2280;
            pub const GkAtoms_Atoms_aria_rowindextext: root::mozilla::detail::GkAtoms_Atoms = 2281;
            pub const GkAtoms_Atoms_aria_rowspan: root::mozilla::detail::GkAtoms_Atoms = 2282;
            pub const GkAtoms_Atoms_aria_valuetext: root::mozilla::detail::GkAtoms_Atoms = 2283;
            pub const GkAtoms_Atoms_assertive: root::mozilla::detail::GkAtoms_Atoms = 2284;
            pub const GkAtoms_Atoms_auto_generated: root::mozilla::detail::GkAtoms_Atoms = 2285;
            pub const GkAtoms_Atoms_banner: root::mozilla::detail::GkAtoms_Atoms = 2286;
            pub const GkAtoms_Atoms_checkable: root::mozilla::detail::GkAtoms_Atoms = 2287;
            pub const GkAtoms_Atoms_columnheader: root::mozilla::detail::GkAtoms_Atoms = 2288;
            pub const GkAtoms_Atoms_complementary: root::mozilla::detail::GkAtoms_Atoms = 2289;
            pub const GkAtoms_Atoms_containerAtomic: root::mozilla::detail::GkAtoms_Atoms = 2290;
            pub const GkAtoms_Atoms_containerBusy: root::mozilla::detail::GkAtoms_Atoms = 2291;
            pub const GkAtoms_Atoms_containerLive: root::mozilla::detail::GkAtoms_Atoms = 2292;
            pub const GkAtoms_Atoms_containerLiveRole: root::mozilla::detail::GkAtoms_Atoms = 2293;
            pub const GkAtoms_Atoms_containerRelevant: root::mozilla::detail::GkAtoms_Atoms = 2294;
            pub const GkAtoms_Atoms_contentinfo: root::mozilla::detail::GkAtoms_Atoms = 2295;
            pub const GkAtoms_Atoms_cycles: root::mozilla::detail::GkAtoms_Atoms = 2296;
            pub const GkAtoms_Atoms_datatable: root::mozilla::detail::GkAtoms_Atoms = 2297;
            pub const GkAtoms_Atoms_feed: root::mozilla::detail::GkAtoms_Atoms = 2298;
            pub const GkAtoms_Atoms_grammar: root::mozilla::detail::GkAtoms_Atoms = 2299;
            pub const GkAtoms_Atoms_gridcell: root::mozilla::detail::GkAtoms_Atoms = 2300;
            pub const GkAtoms_Atoms_heading: root::mozilla::detail::GkAtoms_Atoms = 2301;
            pub const GkAtoms_Atoms_inlinevalue: root::mozilla::detail::GkAtoms_Atoms = 2302;
            pub const GkAtoms_Atoms_inline_size: root::mozilla::detail::GkAtoms_Atoms = 2303;
            pub const GkAtoms_Atoms_invalid: root::mozilla::detail::GkAtoms_Atoms = 2304;
            pub const GkAtoms_Atoms_lineNumber: root::mozilla::detail::GkAtoms_Atoms = 2305;
            pub const GkAtoms_Atoms_menuitemcheckbox: root::mozilla::detail::GkAtoms_Atoms = 2306;
            pub const GkAtoms_Atoms_menuitemradio: root::mozilla::detail::GkAtoms_Atoms = 2307;
            pub const GkAtoms_Atoms_navigation: root::mozilla::detail::GkAtoms_Atoms = 2308;
            pub const GkAtoms_Atoms_polite: root::mozilla::detail::GkAtoms_Atoms = 2309;
            pub const GkAtoms_Atoms_posinset: root::mozilla::detail::GkAtoms_Atoms = 2310;
            pub const GkAtoms_Atoms_presentation: root::mozilla::detail::GkAtoms_Atoms = 2311;
            pub const GkAtoms_Atoms_progressbar: root::mozilla::detail::GkAtoms_Atoms = 2312;
            pub const GkAtoms_Atoms_region: root::mozilla::detail::GkAtoms_Atoms = 2313;
            pub const GkAtoms_Atoms_rowgroup: root::mozilla::detail::GkAtoms_Atoms = 2314;
            pub const GkAtoms_Atoms_rowheader: root::mozilla::detail::GkAtoms_Atoms = 2315;
            pub const GkAtoms_Atoms_search: root::mozilla::detail::GkAtoms_Atoms = 2316;
            pub const GkAtoms_Atoms_searchbox: root::mozilla::detail::GkAtoms_Atoms = 2317;
            pub const GkAtoms_Atoms_setsize: root::mozilla::detail::GkAtoms_Atoms = 2318;
            pub const GkAtoms_Atoms_spelling: root::mozilla::detail::GkAtoms_Atoms = 2319;
            pub const GkAtoms_Atoms_spinbutton: root::mozilla::detail::GkAtoms_Atoms = 2320;
            pub const GkAtoms_Atoms_status: root::mozilla::detail::GkAtoms_Atoms = 2321;
            pub const GkAtoms_Atoms_tableCellIndex: root::mozilla::detail::GkAtoms_Atoms = 2322;
            pub const GkAtoms_Atoms_tablist: root::mozilla::detail::GkAtoms_Atoms = 2323;
            pub const GkAtoms_Atoms_textIndent: root::mozilla::detail::GkAtoms_Atoms = 2324;
            pub const GkAtoms_Atoms_textInputType: root::mozilla::detail::GkAtoms_Atoms = 2325;
            pub const GkAtoms_Atoms_textLineThroughColor: root::mozilla::detail::GkAtoms_Atoms =
                2326;
            pub const GkAtoms_Atoms_textLineThroughStyle: root::mozilla::detail::GkAtoms_Atoms =
                2327;
            pub const GkAtoms_Atoms_textPosition: root::mozilla::detail::GkAtoms_Atoms = 2328;
            pub const GkAtoms_Atoms_textUnderlineColor: root::mozilla::detail::GkAtoms_Atoms = 2329;
            pub const GkAtoms_Atoms_textUnderlineStyle: root::mozilla::detail::GkAtoms_Atoms = 2330;
            pub const GkAtoms_Atoms_timer: root::mozilla::detail::GkAtoms_Atoms = 2331;
            pub const GkAtoms_Atoms_toolbarname: root::mozilla::detail::GkAtoms_Atoms = 2332;
            pub const GkAtoms_Atoms_toolbarseparator: root::mozilla::detail::GkAtoms_Atoms = 2333;
            pub const GkAtoms_Atoms_toolbarspacer: root::mozilla::detail::GkAtoms_Atoms = 2334;
            pub const GkAtoms_Atoms_toolbarspring: root::mozilla::detail::GkAtoms_Atoms = 2335;
            pub const GkAtoms_Atoms_treegrid: root::mozilla::detail::GkAtoms_Atoms = 2336;
            pub const GkAtoms_Atoms__undefined: root::mozilla::detail::GkAtoms_Atoms = 2337;
            pub const GkAtoms_Atoms_xmlroles: root::mozilla::detail::GkAtoms_Atoms = 2338;
            pub const GkAtoms_Atoms_close_fence: root::mozilla::detail::GkAtoms_Atoms = 2339;
            pub const GkAtoms_Atoms_denominator: root::mozilla::detail::GkAtoms_Atoms = 2340;
            pub const GkAtoms_Atoms_numerator: root::mozilla::detail::GkAtoms_Atoms = 2341;
            pub const GkAtoms_Atoms_open_fence: root::mozilla::detail::GkAtoms_Atoms = 2342;
            pub const GkAtoms_Atoms_overscript: root::mozilla::detail::GkAtoms_Atoms = 2343;
            pub const GkAtoms_Atoms_presubscript: root::mozilla::detail::GkAtoms_Atoms = 2344;
            pub const GkAtoms_Atoms_presuperscript: root::mozilla::detail::GkAtoms_Atoms = 2345;
            pub const GkAtoms_Atoms_root_index: root::mozilla::detail::GkAtoms_Atoms = 2346;
            pub const GkAtoms_Atoms_subscript: root::mozilla::detail::GkAtoms_Atoms = 2347;
            pub const GkAtoms_Atoms_superscript: root::mozilla::detail::GkAtoms_Atoms = 2348;
            pub const GkAtoms_Atoms_underscript: root::mozilla::detail::GkAtoms_Atoms = 2349;
            pub const GkAtoms_Atoms_onaudiostart: root::mozilla::detail::GkAtoms_Atoms = 2350;
            pub const GkAtoms_Atoms_onaudioend: root::mozilla::detail::GkAtoms_Atoms = 2351;
            pub const GkAtoms_Atoms_onsoundstart: root::mozilla::detail::GkAtoms_Atoms = 2352;
            pub const GkAtoms_Atoms_onsoundend: root::mozilla::detail::GkAtoms_Atoms = 2353;
            pub const GkAtoms_Atoms_onspeechstart: root::mozilla::detail::GkAtoms_Atoms = 2354;
            pub const GkAtoms_Atoms_onspeechend: root::mozilla::detail::GkAtoms_Atoms = 2355;
            pub const GkAtoms_Atoms_onresult: root::mozilla::detail::GkAtoms_Atoms = 2356;
            pub const GkAtoms_Atoms_onnomatch: root::mozilla::detail::GkAtoms_Atoms = 2357;
            pub const GkAtoms_Atoms_onresume: root::mozilla::detail::GkAtoms_Atoms = 2358;
            pub const GkAtoms_Atoms_onmark: root::mozilla::detail::GkAtoms_Atoms = 2359;
            pub const GkAtoms_Atoms_onboundary: root::mozilla::detail::GkAtoms_Atoms = 2360;
            pub const GkAtoms_Atoms_onactivated: root::mozilla::detail::GkAtoms_Atoms = 2361;
            pub const GkAtoms_Atoms_ondeactivated: root::mozilla::detail::GkAtoms_Atoms = 2362;
            pub const GkAtoms_Atoms_onmetadatachange: root::mozilla::detail::GkAtoms_Atoms = 2363;
            pub const GkAtoms_Atoms_onplaybackstatechange: root::mozilla::detail::GkAtoms_Atoms =
                2364;
            pub const GkAtoms_Atoms_onpositionstatechange: root::mozilla::detail::GkAtoms_Atoms =
                2365;
            pub const GkAtoms_Atoms_onsupportedkeyschange: root::mozilla::detail::GkAtoms_Atoms =
                2366;
            pub const GkAtoms_Atoms_mathml_legacy_mathvariant_attribute_disabled:
                root::mozilla::detail::GkAtoms_Atoms = 2367;
            pub const GkAtoms_Atoms_layout_css_always_underline_links:
                root::mozilla::detail::GkAtoms_Atoms = 2368;
            pub const GkAtoms_Atoms_layout_css_android_pip_enabled:
                root::mozilla::detail::GkAtoms_Atoms = 2369;
            pub const GkAtoms_Atoms_layout_css_cached_scrollbar_styles_enabled:
                root::mozilla::detail::GkAtoms_Atoms = 2370;
            pub const GkAtoms_Atoms_layout_testing_scrollbars_always_hidden:
                root::mozilla::detail::GkAtoms_Atoms = 2371;
            pub const GkAtoms_Atoms_usercontextid: root::mozilla::detail::GkAtoms_Atoms = 2372;
            pub const GkAtoms_Atoms_geckoViewSessionContextId:
                root::mozilla::detail::GkAtoms_Atoms = 2373;
            pub const GkAtoms_Atoms_nsuri_xmlns: root::mozilla::detail::GkAtoms_Atoms = 2374;
            pub const GkAtoms_Atoms_nsuri_xml: root::mozilla::detail::GkAtoms_Atoms = 2375;
            pub const GkAtoms_Atoms_nsuri_xhtml: root::mozilla::detail::GkAtoms_Atoms = 2376;
            pub const GkAtoms_Atoms_nsuri_xlink: root::mozilla::detail::GkAtoms_Atoms = 2377;
            pub const GkAtoms_Atoms_nsuri_xslt: root::mozilla::detail::GkAtoms_Atoms = 2378;
            pub const GkAtoms_Atoms_nsuri_mathml: root::mozilla::detail::GkAtoms_Atoms = 2379;
            pub const GkAtoms_Atoms_nsuri_rdf: root::mozilla::detail::GkAtoms_Atoms = 2380;
            pub const GkAtoms_Atoms_nsuri_xul: root::mozilla::detail::GkAtoms_Atoms = 2381;
            pub const GkAtoms_Atoms_nsuri_svg: root::mozilla::detail::GkAtoms_Atoms = 2382;
            pub const GkAtoms_Atoms_nsuri_parsererror: root::mozilla::detail::GkAtoms_Atoms = 2383;
            pub const GkAtoms_Atoms_onsourceopen: root::mozilla::detail::GkAtoms_Atoms = 2384;
            pub const GkAtoms_Atoms_onsourceended: root::mozilla::detail::GkAtoms_Atoms = 2385;
            pub const GkAtoms_Atoms_onsourceclose: root::mozilla::detail::GkAtoms_Atoms = 2386;
            pub const GkAtoms_Atoms_onupdatestart: root::mozilla::detail::GkAtoms_Atoms = 2387;
            pub const GkAtoms_Atoms_onupdate: root::mozilla::detail::GkAtoms_Atoms = 2388;
            pub const GkAtoms_Atoms_onupdateend: root::mozilla::detail::GkAtoms_Atoms = 2389;
            pub const GkAtoms_Atoms_onaddsourcebuffer: root::mozilla::detail::GkAtoms_Atoms = 2390;
            pub const GkAtoms_Atoms_onremovesourcebuffer: root::mozilla::detail::GkAtoms_Atoms =
                2391;
            pub const GkAtoms_Atoms_ondequeue: root::mozilla::detail::GkAtoms_Atoms = 2392;
            pub const GkAtoms_Atoms_about: root::mozilla::detail::GkAtoms_Atoms = 2393;
            pub const GkAtoms_Atoms_ID: root::mozilla::detail::GkAtoms_Atoms = 2394;
            pub const GkAtoms_Atoms_nodeID: root::mozilla::detail::GkAtoms_Atoms = 2395;
            pub const GkAtoms_Atoms_aboutEach: root::mozilla::detail::GkAtoms_Atoms = 2396;
            pub const GkAtoms_Atoms_resource: root::mozilla::detail::GkAtoms_Atoms = 2397;
            pub const GkAtoms_Atoms_RDF: root::mozilla::detail::GkAtoms_Atoms = 2398;
            pub const GkAtoms_Atoms_Description: root::mozilla::detail::GkAtoms_Atoms = 2399;
            pub const GkAtoms_Atoms_Bag: root::mozilla::detail::GkAtoms_Atoms = 2400;
            pub const GkAtoms_Atoms_Seq: root::mozilla::detail::GkAtoms_Atoms = 2401;
            pub const GkAtoms_Atoms_Alt: root::mozilla::detail::GkAtoms_Atoms = 2402;
            pub const GkAtoms_Atoms_parseType: root::mozilla::detail::GkAtoms_Atoms = 2403;
            pub const GkAtoms_Atoms_DirectoryService_CurrentProcess:
                root::mozilla::detail::GkAtoms_Atoms = 2404;
            pub const GkAtoms_Atoms_DirectoryService_GRE_Directory:
                root::mozilla::detail::GkAtoms_Atoms = 2405;
            pub const GkAtoms_Atoms_DirectoryService_GRE_BinDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2406;
            pub const GkAtoms_Atoms_DirectoryService_OS_TemporaryDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2407;
            pub const GkAtoms_Atoms_DirectoryService_OS_CurrentProcessDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2408;
            pub const GkAtoms_Atoms_DirectoryService_OS_CurrentWorkingDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2409;
            pub const GkAtoms_Atoms_DirectoryService_OS_SystemConfigDir:
                root::mozilla::detail::GkAtoms_Atoms = 2410;
            pub const GkAtoms_Atoms_DirectoryService_OS_DesktopDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2411;
            pub const GkAtoms_Atoms_DirectoryService_OS_DocumentsDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2412;
            pub const GkAtoms_Atoms_DirectoryService_InitCurrentProcess_dummy:
                root::mozilla::detail::GkAtoms_Atoms = 2413;
            pub const GkAtoms_Atoms_DirectoryService_SystemDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2414;
            pub const GkAtoms_Atoms_DirectoryService_UserLibDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2415;
            pub const GkAtoms_Atoms_DirectoryService_DefaultDownloadDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2416;
            pub const GkAtoms_Atoms_DirectoryService_LocalApplicationsDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2417;
            pub const GkAtoms_Atoms_DirectoryService_UserPreferencesDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2418;
            pub const GkAtoms_Atoms_DirectoryService_PictureDocumentsDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2419;
            pub const GkAtoms_Atoms_DirectoryService_DefaultScreenshotDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2420;
            pub const GkAtoms_Atoms_DirectoryService_WindowsDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2421;
            pub const GkAtoms_Atoms_DirectoryService_WindowsProgramFiles:
                root::mozilla::detail::GkAtoms_Atoms = 2422;
            pub const GkAtoms_Atoms_DirectoryService_Programs:
                root::mozilla::detail::GkAtoms_Atoms = 2423;
            pub const GkAtoms_Atoms_DirectoryService_Favorites:
                root::mozilla::detail::GkAtoms_Atoms = 2424;
            pub const GkAtoms_Atoms_DirectoryService_Appdata: root::mozilla::detail::GkAtoms_Atoms =
                2425;
            pub const GkAtoms_Atoms_DirectoryService_LocalAppdata:
                root::mozilla::detail::GkAtoms_Atoms = 2426;
            pub const GkAtoms_Atoms_DirectoryService_WinCookiesDirectory:
                root::mozilla::detail::GkAtoms_Atoms = 2427;
            pub const GkAtoms_Atoms__ua_view_transition_fade_out:
                root::mozilla::detail::GkAtoms_Atoms = 2428;
            pub const GkAtoms_Atoms__ua_view_transition_fade_in:
                root::mozilla::detail::GkAtoms_Atoms = 2429;
            pub const GkAtoms_Atoms__ua_mix_blend_mode_plus_lighter:
                root::mozilla::detail::GkAtoms_Atoms = 2430;
            pub const GkAtoms_Atoms_PseudoElement_after: root::mozilla::detail::GkAtoms_Atoms =
                2431;
            pub const GkAtoms_Atoms_PseudoElement_before: root::mozilla::detail::GkAtoms_Atoms =
                2432;
            pub const GkAtoms_Atoms_PseudoElement_marker: root::mozilla::detail::GkAtoms_Atoms =
                2433;
            pub const GkAtoms_Atoms_PseudoElement_backdrop: root::mozilla::detail::GkAtoms_Atoms =
                2434;
            pub const GkAtoms_Atoms_PseudoElement_cue: root::mozilla::detail::GkAtoms_Atoms = 2435;
            pub const GkAtoms_Atoms_PseudoElement_firstLetter:
                root::mozilla::detail::GkAtoms_Atoms = 2436;
            pub const GkAtoms_Atoms_PseudoElement_firstLine: root::mozilla::detail::GkAtoms_Atoms =
                2437;
            pub const GkAtoms_Atoms_PseudoElement_highlight: root::mozilla::detail::GkAtoms_Atoms =
                2438;
            pub const GkAtoms_Atoms_PseudoElement_selection: root::mozilla::detail::GkAtoms_Atoms =
                2439;
            pub const GkAtoms_Atoms_PseudoElement_targetText: root::mozilla::detail::GkAtoms_Atoms =
                2440;
            pub const GkAtoms_Atoms_PseudoElement_viewTransition:
                root::mozilla::detail::GkAtoms_Atoms = 2441;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionGroup:
                root::mozilla::detail::GkAtoms_Atoms = 2442;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionImagePair:
                root::mozilla::detail::GkAtoms_Atoms = 2443;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionOld:
                root::mozilla::detail::GkAtoms_Atoms = 2444;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionNew:
                root::mozilla::detail::GkAtoms_Atoms = 2445;
            pub const GkAtoms_Atoms_PseudoElement_mozSnapshotContainingBlock:
                root::mozilla::detail::GkAtoms_Atoms = 2446;
            pub const GkAtoms_Atoms_PseudoElement_mozNumberSpinBox:
                root::mozilla::detail::GkAtoms_Atoms = 2447;
            pub const GkAtoms_Atoms_PseudoElement_mozNumberSpinUp:
                root::mozilla::detail::GkAtoms_Atoms = 2448;
            pub const GkAtoms_Atoms_PseudoElement_mozNumberSpinDown:
                root::mozilla::detail::GkAtoms_Atoms = 2449;
            pub const GkAtoms_Atoms_PseudoElement_mozSearchClearButton:
                root::mozilla::detail::GkAtoms_Atoms = 2450;
            pub const GkAtoms_Atoms_PseudoElement_mozProgressBar:
                root::mozilla::detail::GkAtoms_Atoms = 2451;
            pub const GkAtoms_Atoms_PseudoElement_mozRangeTrack:
                root::mozilla::detail::GkAtoms_Atoms = 2452;
            pub const GkAtoms_Atoms_PseudoElement_mozRangeProgress:
                root::mozilla::detail::GkAtoms_Atoms = 2453;
            pub const GkAtoms_Atoms_PseudoElement_mozRangeThumb:
                root::mozilla::detail::GkAtoms_Atoms = 2454;
            pub const GkAtoms_Atoms_PseudoElement_mozMeterBar:
                root::mozilla::detail::GkAtoms_Atoms = 2455;
            pub const GkAtoms_Atoms_PseudoElement_placeholder:
                root::mozilla::detail::GkAtoms_Atoms = 2456;
            pub const GkAtoms_Atoms_PseudoElement_mozColorSwatch:
                root::mozilla::detail::GkAtoms_Atoms = 2457;
            pub const GkAtoms_Atoms_PseudoElement_mozTextControlEditingRoot:
                root::mozilla::detail::GkAtoms_Atoms = 2458;
            pub const GkAtoms_Atoms_PseudoElement_mozTextControlPreview:
                root::mozilla::detail::GkAtoms_Atoms = 2459;
            pub const GkAtoms_Atoms_PseudoElement_mozReveal: root::mozilla::detail::GkAtoms_Atoms =
                2460;
            pub const GkAtoms_Atoms_PseudoElement_fileSelectorButton:
                root::mozilla::detail::GkAtoms_Atoms = 2461;
            pub const GkAtoms_Atoms_PseudoElement_sliderTrack:
                root::mozilla::detail::GkAtoms_Atoms = 2462;
            pub const GkAtoms_Atoms_PseudoElement_sliderThumb:
                root::mozilla::detail::GkAtoms_Atoms = 2463;
            pub const GkAtoms_Atoms_PseudoElement_sliderFill: root::mozilla::detail::GkAtoms_Atoms =
                2464;
            pub const GkAtoms_Atoms_PseudoElement_detailsContent:
                root::mozilla::detail::GkAtoms_Atoms = 2465;
            pub const GkAtoms_Atoms_AnonBox_oofPlaceholder: root::mozilla::detail::GkAtoms_Atoms =
                2466;
            pub const GkAtoms_Atoms_AnonBox_horizontalFramesetBorder:
                root::mozilla::detail::GkAtoms_Atoms = 2467;
            pub const GkAtoms_Atoms_AnonBox_verticalFramesetBorder:
                root::mozilla::detail::GkAtoms_Atoms = 2468;
            pub const GkAtoms_Atoms_AnonBox_framesetBlank: root::mozilla::detail::GkAtoms_Atoms =
                2469;
            pub const GkAtoms_Atoms_AnonBox_tableColGroup: root::mozilla::detail::GkAtoms_Atoms =
                2470;
            pub const GkAtoms_Atoms_AnonBox_tableCol: root::mozilla::detail::GkAtoms_Atoms = 2471;
            pub const GkAtoms_Atoms_AnonBox_page: root::mozilla::detail::GkAtoms_Atoms = 2472;
            pub const GkAtoms_Atoms_AnonBox_pageBreak: root::mozilla::detail::GkAtoms_Atoms = 2473;
            pub const GkAtoms_Atoms_AnonBox_pageContent: root::mozilla::detail::GkAtoms_Atoms =
                2474;
            pub const GkAtoms_Atoms_AnonBox_printedSheet: root::mozilla::detail::GkAtoms_Atoms =
                2475;
            pub const GkAtoms_Atoms_AnonBox_columnSpanWrapper:
                root::mozilla::detail::GkAtoms_Atoms = 2476;
            pub const GkAtoms_Atoms_AnonBox_mozText: root::mozilla::detail::GkAtoms_Atoms = 2477;
            pub const GkAtoms_Atoms_AnonBox_firstLetterContinuation:
                root::mozilla::detail::GkAtoms_Atoms = 2478;
            pub const GkAtoms_Atoms_AnonBox_mozBlockInsideInlineWrapper:
                root::mozilla::detail::GkAtoms_Atoms = 2479;
            pub const GkAtoms_Atoms_AnonBox_mozMathMLAnonymousBlock:
                root::mozilla::detail::GkAtoms_Atoms = 2480;
            pub const GkAtoms_Atoms_AnonBox_mozLineFrame: root::mozilla::detail::GkAtoms_Atoms =
                2481;
            pub const GkAtoms_Atoms_AnonBox_cellContent: root::mozilla::detail::GkAtoms_Atoms =
                2482;
            pub const GkAtoms_Atoms_AnonBox_dropDownList: root::mozilla::detail::GkAtoms_Atoms =
                2483;
            pub const GkAtoms_Atoms_AnonBox_fieldsetContent: root::mozilla::detail::GkAtoms_Atoms =
                2484;
            pub const GkAtoms_Atoms_AnonBox_htmlCanvasContent:
                root::mozilla::detail::GkAtoms_Atoms = 2485;
            pub const GkAtoms_Atoms_AnonBox_inlineTable: root::mozilla::detail::GkAtoms_Atoms =
                2486;
            pub const GkAtoms_Atoms_AnonBox_table: root::mozilla::detail::GkAtoms_Atoms = 2487;
            pub const GkAtoms_Atoms_AnonBox_tableCell: root::mozilla::detail::GkAtoms_Atoms = 2488;
            pub const GkAtoms_Atoms_AnonBox_tableWrapper: root::mozilla::detail::GkAtoms_Atoms =
                2489;
            pub const GkAtoms_Atoms_AnonBox_tableRowGroup: root::mozilla::detail::GkAtoms_Atoms =
                2490;
            pub const GkAtoms_Atoms_AnonBox_tableRow: root::mozilla::detail::GkAtoms_Atoms = 2491;
            pub const GkAtoms_Atoms_AnonBox_canvas: root::mozilla::detail::GkAtoms_Atoms = 2492;
            pub const GkAtoms_Atoms_AnonBox_pageSequence: root::mozilla::detail::GkAtoms_Atoms =
                2493;
            pub const GkAtoms_Atoms_AnonBox_scrolledContent: root::mozilla::detail::GkAtoms_Atoms =
                2494;
            pub const GkAtoms_Atoms_AnonBox_scrolledCanvas: root::mozilla::detail::GkAtoms_Atoms =
                2495;
            pub const GkAtoms_Atoms_AnonBox_columnSet: root::mozilla::detail::GkAtoms_Atoms = 2496;
            pub const GkAtoms_Atoms_AnonBox_columnContent: root::mozilla::detail::GkAtoms_Atoms =
                2497;
            pub const GkAtoms_Atoms_AnonBox_viewport: root::mozilla::detail::GkAtoms_Atoms = 2498;
            pub const GkAtoms_Atoms_AnonBox_viewportScroll: root::mozilla::detail::GkAtoms_Atoms =
                2499;
            pub const GkAtoms_Atoms_AnonBox_anonymousItem: root::mozilla::detail::GkAtoms_Atoms =
                2500;
            pub const GkAtoms_Atoms_AnonBox_blockRubyContent: root::mozilla::detail::GkAtoms_Atoms =
                2501;
            pub const GkAtoms_Atoms_AnonBox_ruby: root::mozilla::detail::GkAtoms_Atoms = 2502;
            pub const GkAtoms_Atoms_AnonBox_rubyBase: root::mozilla::detail::GkAtoms_Atoms = 2503;
            pub const GkAtoms_Atoms_AnonBox_rubyBaseContainer:
                root::mozilla::detail::GkAtoms_Atoms = 2504;
            pub const GkAtoms_Atoms_AnonBox_rubyText: root::mozilla::detail::GkAtoms_Atoms = 2505;
            pub const GkAtoms_Atoms_AnonBox_rubyTextContainer:
                root::mozilla::detail::GkAtoms_Atoms = 2506;
            pub const GkAtoms_Atoms_AnonBox_mozTreeColumn: root::mozilla::detail::GkAtoms_Atoms =
                2507;
            pub const GkAtoms_Atoms_AnonBox_mozTreeRow: root::mozilla::detail::GkAtoms_Atoms = 2508;
            pub const GkAtoms_Atoms_AnonBox_mozTreeSeparator: root::mozilla::detail::GkAtoms_Atoms =
                2509;
            pub const GkAtoms_Atoms_AnonBox_mozTreeCell: root::mozilla::detail::GkAtoms_Atoms =
                2510;
            pub const GkAtoms_Atoms_AnonBox_mozTreeIndentation:
                root::mozilla::detail::GkAtoms_Atoms = 2511;
            pub const GkAtoms_Atoms_AnonBox_mozTreeLine: root::mozilla::detail::GkAtoms_Atoms =
                2512;
            pub const GkAtoms_Atoms_AnonBox_mozTreeTwisty: root::mozilla::detail::GkAtoms_Atoms =
                2513;
            pub const GkAtoms_Atoms_AnonBox_mozTreeImage: root::mozilla::detail::GkAtoms_Atoms =
                2514;
            pub const GkAtoms_Atoms_AnonBox_mozTreeCellText: root::mozilla::detail::GkAtoms_Atoms =
                2515;
            pub const GkAtoms_Atoms_AnonBox_mozTreeCheckbox: root::mozilla::detail::GkAtoms_Atoms =
                2516;
            pub const GkAtoms_Atoms_AnonBox_mozTreeDropFeedback:
                root::mozilla::detail::GkAtoms_Atoms = 2517;
            pub const GkAtoms_Atoms_AnonBox_mozSVGMarkerAnonChild:
                root::mozilla::detail::GkAtoms_Atoms = 2518;
            pub const GkAtoms_Atoms_AnonBox_mozSVGOuterSVGAnonChild:
                root::mozilla::detail::GkAtoms_Atoms = 2519;
            pub const GkAtoms_Atoms_AnonBox_mozSVGForeignContent:
                root::mozilla::detail::GkAtoms_Atoms = 2520;
            pub const GkAtoms_Atoms_AnonBox_mozSVGText: root::mozilla::detail::GkAtoms_Atoms = 2521;
            pub const GkAtoms_Atoms_xlink: root::mozilla::detail::GkAtoms_Atoms = 2522;
            pub const GkAtoms_Atoms_xml_space: root::mozilla::detail::GkAtoms_Atoms = 2523;
            pub const GkAtoms_Atoms_xml_lang: root::mozilla::detail::GkAtoms_Atoms = 2524;
            pub const GkAtoms_Atoms_aria_grab: root::mozilla::detail::GkAtoms_Atoms = 2525;
            pub const GkAtoms_Atoms_aria_channel: root::mozilla::detail::GkAtoms_Atoms = 2526;
            pub const GkAtoms_Atoms_aria_secret: root::mozilla::detail::GkAtoms_Atoms = 2527;
            pub const GkAtoms_Atoms_aria_templateid: root::mozilla::detail::GkAtoms_Atoms = 2528;
            pub const GkAtoms_Atoms_aria_datatype: root::mozilla::detail::GkAtoms_Atoms = 2529;
            pub const GkAtoms_Atoms_local: root::mozilla::detail::GkAtoms_Atoms = 2530;
            pub const GkAtoms_Atoms_xchannelselector: root::mozilla::detail::GkAtoms_Atoms = 2531;
            pub const GkAtoms_Atoms_ychannelselector: root::mozilla::detail::GkAtoms_Atoms = 2532;
            pub const GkAtoms_Atoms_enable_background: root::mozilla::detail::GkAtoms_Atoms = 2533;
            pub const GkAtoms_Atoms_calcmode: root::mozilla::detail::GkAtoms_Atoms = 2534;
            pub const GkAtoms_Atoms_specularexponent: root::mozilla::detail::GkAtoms_Atoms = 2535;
            pub const GkAtoms_Atoms_specularconstant: root::mozilla::detail::GkAtoms_Atoms = 2536;
            pub const GkAtoms_Atoms_gradienttransform: root::mozilla::detail::GkAtoms_Atoms = 2537;
            pub const GkAtoms_Atoms_gradientunits: root::mozilla::detail::GkAtoms_Atoms = 2538;
            pub const GkAtoms_Atoms_rendering_intent: root::mozilla::detail::GkAtoms_Atoms = 2539;
            pub const GkAtoms_Atoms_shadowrootmode: root::mozilla::detail::GkAtoms_Atoms = 2540;
            pub const GkAtoms_Atoms_shadowrootclonable: root::mozilla::detail::GkAtoms_Atoms = 2541;
            pub const GkAtoms_Atoms_shadowrootserializable: root::mozilla::detail::GkAtoms_Atoms =
                2542;
            pub const GkAtoms_Atoms_stddeviation: root::mozilla::detail::GkAtoms_Atoms = 2543;
            pub const GkAtoms_Atoms_shadowrootdelegatesfocus: root::mozilla::detail::GkAtoms_Atoms =
                2544;
            pub const GkAtoms_Atoms_basefrequency: root::mozilla::detail::GkAtoms_Atoms = 2545;
            pub const GkAtoms_Atoms_baseprofile: root::mozilla::detail::GkAtoms_Atoms = 2546;
            pub const GkAtoms_Atoms_baseProfile: root::mozilla::detail::GkAtoms_Atoms = 2547;
            pub const GkAtoms_Atoms_edgemode: root::mozilla::detail::GkAtoms_Atoms = 2548;
            pub const GkAtoms_Atoms_repeatcount: root::mozilla::detail::GkAtoms_Atoms = 2549;
            pub const GkAtoms_Atoms_repeatdur: root::mozilla::detail::GkAtoms_Atoms = 2550;
            pub const GkAtoms_Atoms_spreadmethod: root::mozilla::detail::GkAtoms_Atoms = 2551;
            pub const GkAtoms_Atoms_diffuseconstant: root::mozilla::detail::GkAtoms_Atoms = 2552;
            pub const GkAtoms_Atoms_surfacescale: root::mozilla::detail::GkAtoms_Atoms = 2553;
            pub const GkAtoms_Atoms_lengthadjust: root::mozilla::detail::GkAtoms_Atoms = 2554;
            pub const GkAtoms_Atoms_origin: root::mozilla::detail::GkAtoms_Atoms = 2555;
            pub const GkAtoms_Atoms_targetx: root::mozilla::detail::GkAtoms_Atoms = 2556;
            pub const GkAtoms_Atoms_targety: root::mozilla::detail::GkAtoms_Atoms = 2557;
            pub const GkAtoms_Atoms_pathlength: root::mozilla::detail::GkAtoms_Atoms = 2558;
            pub const GkAtoms_Atoms_definitionurl: root::mozilla::detail::GkAtoms_Atoms = 2559;
            pub const GkAtoms_Atoms_limitingconeangle: root::mozilla::detail::GkAtoms_Atoms = 2560;
            pub const GkAtoms_Atoms_markerheight: root::mozilla::detail::GkAtoms_Atoms = 2561;
            pub const GkAtoms_Atoms_markerwidth: root::mozilla::detail::GkAtoms_Atoms = 2562;
            pub const GkAtoms_Atoms_maskunits: root::mozilla::detail::GkAtoms_Atoms = 2563;
            pub const GkAtoms_Atoms_markerunits: root::mozilla::detail::GkAtoms_Atoms = 2564;
            pub const GkAtoms_Atoms_maskcontentunits: root::mozilla::detail::GkAtoms_Atoms = 2565;
            pub const GkAtoms_Atoms_tablevalues: root::mozilla::detail::GkAtoms_Atoms = 2566;
            pub const GkAtoms_Atoms_primitiveunits: root::mozilla::detail::GkAtoms_Atoms = 2567;
            pub const GkAtoms_Atoms_zoomandpan: root::mozilla::detail::GkAtoms_Atoms = 2568;
            pub const GkAtoms_Atoms_kernelmatrix: root::mozilla::detail::GkAtoms_Atoms = 2569;
            pub const GkAtoms_Atoms_kerning: root::mozilla::detail::GkAtoms_Atoms = 2570;
            pub const GkAtoms_Atoms_kernelunitlength: root::mozilla::detail::GkAtoms_Atoms = 2571;
            pub const GkAtoms_Atoms_pointsatx: root::mozilla::detail::GkAtoms_Atoms = 2572;
            pub const GkAtoms_Atoms_pointsaty: root::mozilla::detail::GkAtoms_Atoms = 2573;
            pub const GkAtoms_Atoms_pointsatz: root::mozilla::detail::GkAtoms_Atoms = 2574;
            pub const GkAtoms_Atoms_xlink_href: root::mozilla::detail::GkAtoms_Atoms = 2575;
            pub const GkAtoms_Atoms_xlink_title: root::mozilla::detail::GkAtoms_Atoms = 2576;
            pub const GkAtoms_Atoms_xlink_role: root::mozilla::detail::GkAtoms_Atoms = 2577;
            pub const GkAtoms_Atoms_xlink_arcrole: root::mozilla::detail::GkAtoms_Atoms = 2578;
            pub const GkAtoms_Atoms_arcrole: root::mozilla::detail::GkAtoms_Atoms = 2579;
            pub const GkAtoms_Atoms_xmlns_xlink: root::mozilla::detail::GkAtoms_Atoms = 2580;
            pub const GkAtoms_Atoms_xlink_type: root::mozilla::detail::GkAtoms_Atoms = 2581;
            pub const GkAtoms_Atoms_xlink_show: root::mozilla::detail::GkAtoms_Atoms = 2582;
            pub const GkAtoms_Atoms_xlink_actuate: root::mozilla::detail::GkAtoms_Atoms = 2583;
            pub const GkAtoms_Atoms_autocorrect: root::mozilla::detail::GkAtoms_Atoms = 2584;
            pub const GkAtoms_Atoms_color_rendering: root::mozilla::detail::GkAtoms_Atoms = 2585;
            pub const GkAtoms_Atoms_numoctaves: root::mozilla::detail::GkAtoms_Atoms = 2586;
            pub const GkAtoms_Atoms_onmousewheel: root::mozilla::detail::GkAtoms_Atoms = 2587;
            pub const GkAtoms_Atoms_clippathunits: root::mozilla::detail::GkAtoms_Atoms = 2588;
            pub const GkAtoms_Atoms_glyph_orientation_vertical:
                root::mozilla::detail::GkAtoms_Atoms = 2589;
            pub const GkAtoms_Atoms_glyph_orientation_horizontal:
                root::mozilla::detail::GkAtoms_Atoms = 2590;
            pub const GkAtoms_Atoms_glyphref: root::mozilla::detail::GkAtoms_Atoms = 2591;
            pub const GkAtoms_Atoms_keypoints: root::mozilla::detail::GkAtoms_Atoms = 2592;
            pub const GkAtoms_Atoms_attributename: root::mozilla::detail::GkAtoms_Atoms = 2593;
            pub const GkAtoms_Atoms_attributetype: root::mozilla::detail::GkAtoms_Atoms = 2594;
            pub const GkAtoms_Atoms_startoffset: root::mozilla::detail::GkAtoms_Atoms = 2595;
            pub const GkAtoms_Atoms_keysplines: root::mozilla::detail::GkAtoms_Atoms = 2596;
            pub const GkAtoms_Atoms_preservealpha: root::mozilla::detail::GkAtoms_Atoms = 2597;
            pub const GkAtoms_Atoms_preserveaspectratio: root::mozilla::detail::GkAtoms_Atoms =
                2598;
            pub const GkAtoms_Atoms_alttext: root::mozilla::detail::GkAtoms_Atoms = 2599;
            pub const GkAtoms_Atoms_filterunits: root::mozilla::detail::GkAtoms_Atoms = 2600;
            pub const GkAtoms_Atoms_keytimes: root::mozilla::detail::GkAtoms_Atoms = 2601;
            pub const GkAtoms_Atoms_patterntransform: root::mozilla::detail::GkAtoms_Atoms = 2602;
            pub const GkAtoms_Atoms_patternunits: root::mozilla::detail::GkAtoms_Atoms = 2603;
            pub const GkAtoms_Atoms_patterncontentunits: root::mozilla::detail::GkAtoms_Atoms =
                2604;
            pub const GkAtoms_Atoms_stitchtiles: root::mozilla::detail::GkAtoms_Atoms = 2605;
            pub const GkAtoms_Atoms_systemlanguage: root::mozilla::detail::GkAtoms_Atoms = 2606;
            pub const GkAtoms_Atoms_textlength: root::mozilla::detail::GkAtoms_Atoms = 2607;
            pub const GkAtoms_Atoms_requiredfeatures: root::mozilla::detail::GkAtoms_Atoms = 2608;
            pub const GkAtoms_Atoms_requiredextensions: root::mozilla::detail::GkAtoms_Atoms = 2609;
            pub const GkAtoms_Atoms_viewtarget: root::mozilla::detail::GkAtoms_Atoms = 2610;
            pub const GkAtoms_Atoms_viewbox: root::mozilla::detail::GkAtoms_Atoms = 2611;
            pub const GkAtoms_Atoms_refx: root::mozilla::detail::GkAtoms_Atoms = 2612;
            pub const GkAtoms_Atoms_refy: root::mozilla::detail::GkAtoms_Atoms = 2613;
            pub const GkAtoms_Atoms_fefunca: root::mozilla::detail::GkAtoms_Atoms = 2614;
            pub const GkAtoms_Atoms_fefuncb: root::mozilla::detail::GkAtoms_Atoms = 2615;
            pub const GkAtoms_Atoms_feblend: root::mozilla::detail::GkAtoms_Atoms = 2616;
            pub const GkAtoms_Atoms_feflood: root::mozilla::detail::GkAtoms_Atoms = 2617;
            pub const GkAtoms_Atoms_feturbulence: root::mozilla::detail::GkAtoms_Atoms = 2618;
            pub const GkAtoms_Atoms_femergenode: root::mozilla::detail::GkAtoms_Atoms = 2619;
            pub const GkAtoms_Atoms_feimage: root::mozilla::detail::GkAtoms_Atoms = 2620;
            pub const GkAtoms_Atoms_femerge: root::mozilla::detail::GkAtoms_Atoms = 2621;
            pub const GkAtoms_Atoms_fetile: root::mozilla::detail::GkAtoms_Atoms = 2622;
            pub const GkAtoms_Atoms_fecomposite: root::mozilla::detail::GkAtoms_Atoms = 2623;
            pub const GkAtoms_Atoms_altglyphdef: root::mozilla::detail::GkAtoms_Atoms = 2624;
            pub const GkAtoms_Atoms_altGlyphDef: root::mozilla::detail::GkAtoms_Atoms = 2625;
            pub const GkAtoms_Atoms_fefuncg: root::mozilla::detail::GkAtoms_Atoms = 2626;
            pub const GkAtoms_Atoms_fediffuselighting: root::mozilla::detail::GkAtoms_Atoms = 2627;
            pub const GkAtoms_Atoms_fespecularlighting: root::mozilla::detail::GkAtoms_Atoms = 2628;
            pub const GkAtoms_Atoms_altglyph: root::mozilla::detail::GkAtoms_Atoms = 2629;
            pub const GkAtoms_Atoms_altGlyph: root::mozilla::detail::GkAtoms_Atoms = 2630;
            pub const GkAtoms_Atoms_clippath: root::mozilla::detail::GkAtoms_Atoms = 2631;
            pub const GkAtoms_Atoms_textpath: root::mozilla::detail::GkAtoms_Atoms = 2632;
            pub const GkAtoms_Atoms_altglyphitem: root::mozilla::detail::GkAtoms_Atoms = 2633;
            pub const GkAtoms_Atoms_altGlyphItem: root::mozilla::detail::GkAtoms_Atoms = 2634;
            pub const GkAtoms_Atoms_animatetransform: root::mozilla::detail::GkAtoms_Atoms = 2635;
            pub const GkAtoms_Atoms_animatemotion: root::mozilla::detail::GkAtoms_Atoms = 2636;
            pub const GkAtoms_Atoms_fedisplacementmap: root::mozilla::detail::GkAtoms_Atoms = 2637;
            pub const GkAtoms_Atoms_animatecolor: root::mozilla::detail::GkAtoms_Atoms = 2638;
            pub const GkAtoms_Atoms_fefuncr: root::mozilla::detail::GkAtoms_Atoms = 2639;
            pub const GkAtoms_Atoms_fecomponenttransfer: root::mozilla::detail::GkAtoms_Atoms =
                2640;
            pub const GkAtoms_Atoms_fegaussianblur: root::mozilla::detail::GkAtoms_Atoms = 2641;
            pub const GkAtoms_Atoms_foreignobject: root::mozilla::detail::GkAtoms_Atoms = 2642;
            pub const GkAtoms_Atoms_feoffset: root::mozilla::detail::GkAtoms_Atoms = 2643;
            pub const GkAtoms_Atoms_fespotlight: root::mozilla::detail::GkAtoms_Atoms = 2644;
            pub const GkAtoms_Atoms_fepointlight: root::mozilla::detail::GkAtoms_Atoms = 2645;
            pub const GkAtoms_Atoms_fedistantlight: root::mozilla::detail::GkAtoms_Atoms = 2646;
            pub const GkAtoms_Atoms_lineargradient: root::mozilla::detail::GkAtoms_Atoms = 2647;
            pub const GkAtoms_Atoms_radialgradient: root::mozilla::detail::GkAtoms_Atoms = 2648;
            pub const GkAtoms_Atoms_fedropshadow: root::mozilla::detail::GkAtoms_Atoms = 2649;
            pub const GkAtoms_Atoms_fecolormatrix: root::mozilla::detail::GkAtoms_Atoms = 2650;
            pub const GkAtoms_Atoms_feconvolvematrix: root::mozilla::detail::GkAtoms_Atoms = 2651;
            pub const GkAtoms_Atoms_femorphology: root::mozilla::detail::GkAtoms_Atoms = 2652;
            pub const GkAtoms_Atoms_AtomsCount: root::mozilla::detail::GkAtoms_Atoms = 2653;
            pub type GkAtoms_Atoms = ::std::os::raw::c_int;
            #[test]
            fn bindgen_test_layout_GkAtoms() {
                const UNINIT: ::std::mem::MaybeUninit<GkAtoms> = ::std::mem::MaybeUninit::uninit();
                let ptr = UNINIT.as_ptr();
                assert_eq!(
                    ::std::mem::size_of::<GkAtoms>(),
                    95268usize,
                    concat!("Size of: ", stringify!(GkAtoms))
                );
                assert_eq!(
                    ::std::mem::align_of::<GkAtoms>(),
                    4usize,
                    concat!("Alignment of ", stringify!(GkAtoms))
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).SystemPrincipal_string) as usize - ptr as usize
                    },
                    0usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(SystemPrincipal_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._empty_string) as usize - ptr as usize },
                    38usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_empty_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._0_string) as usize - ptr as usize },
                    40usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_0_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._1_string) as usize - ptr as usize },
                    44usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_1_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozframetype_string) as usize - ptr as usize
                    },
                    48usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozframetype_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_abspos_string) as usize - ptr as usize
                    },
                    74usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_abspos_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_activated_string) as usize - ptr as usize
                    },
                    98usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_activated_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_anonclass_string) as usize - ptr as usize
                    },
                    128usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_anonclass_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_resizing_string) as usize - ptr as usize
                    },
                    158usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_resizing_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).moztype_string) as usize - ptr as usize },
                    186usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(moztype_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).mozdirty_string) as usize - ptr as usize },
                    206usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozdirty_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozdisallowselectionprint_string) as usize
                            - ptr as usize
                    },
                    228usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozdisallowselectionprint_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozdonotsend_string) as usize - ptr as usize
                    },
                    280usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozdonotsend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozfwcontainer_string) as usize - ptr as usize
                    },
                    312usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozfwcontainer_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozgeneratedcontentbefore_string) as usize
                            - ptr as usize
                    },
                    356usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozgeneratedcontentbefore_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozgeneratedcontentafter_string) as usize
                            - ptr as usize
                    },
                    416usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozgeneratedcontentafter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozgeneratedcontentmarker_string) as usize
                            - ptr as usize
                    },
                    474usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozgeneratedcontentmarker_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozgeneratedcontentimage_string) as usize
                            - ptr as usize
                    },
                    534usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozgeneratedcontentimage_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).mozquote_string) as usize - ptr as usize },
                    592usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozquote_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozsignature_string) as usize - ptr as usize
                    },
                    614usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozsignature_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_bullet_font_string) as usize - ptr as usize
                    },
                    642usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_bullet_font_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_is_glyph_string) as usize - ptr as usize
                    },
                    676usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_is_glyph_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_in_android_pip_mode_string) as usize
                            - ptr as usize
                    },
                    704usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_in_android_pip_mode_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_original_size_string) as usize
                            - ptr as usize
                    },
                    754usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_original_size_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._moz_print_preview_string) as usize
                            - ptr as usize
                    },
                    792usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_moz_print_preview_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).menuactive_string) as usize - ptr as usize
                    },
                    830usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menuactive_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._poundDefault_string) as usize - ptr as usize
                    },
                    862usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_poundDefault_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._asterisk_string) as usize - ptr as usize
                    },
                    880usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_asterisk_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).a_string) as usize - ptr as usize },
                    884usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(a_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).abbr_string) as usize - ptr as usize },
                    888usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(abbr_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).abort_string) as usize - ptr as usize },
                    898usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(abort_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).above_string) as usize - ptr as usize },
                    910usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(above_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).acceltext_string) as usize - ptr as usize
                    },
                    922usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(acceltext_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).accept_string) as usize - ptr as usize },
                    942usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(accept_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).acceptcharset_string) as usize - ptr as usize
                    },
                    956usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(acceptcharset_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).accessiblenode_string) as usize - ptr as usize
                    },
                    986usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(accessiblenode_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).accesskey_string) as usize - ptr as usize
                    },
                    1018usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(accesskey_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).acronym_string) as usize - ptr as usize },
                    1038usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(acronym_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).action_string) as usize - ptr as usize },
                    1054usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(action_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).active_string) as usize - ptr as usize },
                    1068usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(active_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).activateontab_string) as usize - ptr as usize
                    },
                    1082usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(activateontab_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).actuate_string) as usize - ptr as usize },
                    1110usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(actuate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).address_string) as usize - ptr as usize },
                    1126usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(address_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).adoptedsheetclones_string) as usize
                            - ptr as usize
                    },
                    1142usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(adoptedsheetclones_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).after_string) as usize - ptr as usize },
                    1180usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(after_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).align_string) as usize - ptr as usize },
                    1192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(align_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).alink_string) as usize - ptr as usize },
                    1204usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(alink_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).all_string) as usize - ptr as usize },
                    1216usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(all_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).allow_string) as usize - ptr as usize },
                    1224usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowdownloads_string) as usize - ptr as usize
                    },
                    1236usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowdownloads_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowevents_string) as usize - ptr as usize
                    },
                    1268usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowevents_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowforms_string) as usize - ptr as usize
                    },
                    1292usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowforms_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowfullscreen_string) as usize - ptr as usize
                    },
                    1316usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowfullscreen_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowmodals_string) as usize - ptr as usize
                    },
                    1348usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowmodals_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).alloworientationlock_string) as usize
                            - ptr as usize
                    },
                    1374usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(alloworientationlock_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowpointerlock_string) as usize - ptr as usize
                    },
                    1420usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowpointerlock_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowpopupstoescapesandbox_string) as usize
                            - ptr as usize
                    },
                    1458usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowpopupstoescapesandbox_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowpopups_string) as usize - ptr as usize
                    },
                    1520usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowpopups_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowpresentation_string) as usize
                            - ptr as usize
                    },
                    1546usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowpresentation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowstorageaccessbyuseractivatetion_string)
                            as usize
                            - ptr as usize
                    },
                    1584usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowstorageaccessbyuseractivatetion_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowsameorigin_string) as usize - ptr as usize
                    },
                    1664usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowsameorigin_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowscripts_string) as usize - ptr as usize
                    },
                    1700usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowscripts_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowscriptstoclose_string) as usize
                            - ptr as usize
                    },
                    1728usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowscriptstoclose_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowtopnavigation_string) as usize
                            - ptr as usize
                    },
                    1768usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowtopnavigation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowtopnavigationbyuseractivation_string)
                            as usize
                            - ptr as usize
                    },
                    1810usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowtopnavigationbyuseractivation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowtopnavigationcustomprotocols_string)
                            as usize
                            - ptr as usize
                    },
                    1890usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowtopnavigationcustomprotocols_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).allowuntrusted_string) as usize - ptr as usize
                    },
                    1972usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(allowuntrusted_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).alt_string) as usize - ptr as usize },
                    2002usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(alt_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).alternate_string) as usize - ptr as usize
                    },
                    2010usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(alternate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).always_string) as usize - ptr as usize },
                    2030usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(always_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ancestor_string) as usize - ptr as usize },
                    2044usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ancestor_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ancestorOrSelf_string) as usize - ptr as usize
                    },
                    2062usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ancestorOrSelf_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).anchor_string) as usize - ptr as usize },
                    2096usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(anchor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._and_string) as usize - ptr as usize },
                    2110usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_and_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).animations_string) as usize - ptr as usize
                    },
                    2118usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(animations_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).anonid_string) as usize - ptr as usize },
                    2140usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(anonid_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).anonlocation_string) as usize - ptr as usize
                    },
                    2154usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(anonlocation_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).any_string) as usize - ptr as usize },
                    2180usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(any_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).any_hover_string) as usize - ptr as usize
                    },
                    2188usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(any_hover_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).any_pointer_string) as usize - ptr as usize
                    },
                    2208usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(any_pointer_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).applet_string) as usize - ptr as usize },
                    2232usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(applet_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).applyImports_string) as usize - ptr as usize
                    },
                    2246usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(applyImports_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).applyTemplates_string) as usize - ptr as usize
                    },
                    2274usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(applyTemplates_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).archive_string) as usize - ptr as usize },
                    2306usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(archive_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).area_string) as usize - ptr as usize },
                    2322usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(area_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).aria_string) as usize - ptr as usize },
                    2332usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_activedescendant_string) as usize
                            - ptr as usize
                    },
                    2342usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_activedescendant_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_atomic_string) as usize - ptr as usize
                    },
                    2386usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_atomic_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_autocomplete_string) as usize
                            - ptr as usize
                    },
                    2410usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_autocomplete_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_braillelabel_string) as usize
                            - ptr as usize
                    },
                    2446usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_braillelabel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_brailleroledescription_string) as usize
                            - ptr as usize
                    },
                    2482usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_brailleroledescription_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_busy_string) as usize - ptr as usize
                    },
                    2538usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_busy_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_checked_string) as usize - ptr as usize
                    },
                    2558usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_checked_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_controls_string) as usize - ptr as usize
                    },
                    2584usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_controls_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_current_string) as usize - ptr as usize
                    },
                    2612usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_current_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_describedby_string) as usize - ptr as usize
                    },
                    2638usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_describedby_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_description_string) as usize - ptr as usize
                    },
                    2672usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_description_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_disabled_string) as usize - ptr as usize
                    },
                    2706usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_disabled_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_dropeffect_string) as usize - ptr as usize
                    },
                    2734usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_dropeffect_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_expanded_string) as usize - ptr as usize
                    },
                    2766usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_expanded_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_flowto_string) as usize - ptr as usize
                    },
                    2794usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_flowto_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_haspopup_string) as usize - ptr as usize
                    },
                    2818usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_haspopup_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_hidden_string) as usize - ptr as usize
                    },
                    2846usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_hidden_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_invalid_string) as usize - ptr as usize
                    },
                    2870usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_invalid_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_labelledby_string) as usize - ptr as usize
                    },
                    2896usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_labelledby_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_level_string) as usize - ptr as usize
                    },
                    2928usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_level_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_live_string) as usize - ptr as usize
                    },
                    2950usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_live_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_multiline_string) as usize - ptr as usize
                    },
                    2970usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_multiline_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_multiselectable_string) as usize
                            - ptr as usize
                    },
                    3000usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_multiselectable_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_owns_string) as usize - ptr as usize
                    },
                    3042usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_owns_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_posinset_string) as usize - ptr as usize
                    },
                    3062usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_posinset_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_pressed_string) as usize - ptr as usize
                    },
                    3090usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_pressed_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_readonly_string) as usize - ptr as usize
                    },
                    3116usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_readonly_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_relevant_string) as usize - ptr as usize
                    },
                    3144usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_relevant_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_required_string) as usize - ptr as usize
                    },
                    3172usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_required_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_selected_string) as usize - ptr as usize
                    },
                    3200usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_selected_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_setsize_string) as usize - ptr as usize
                    },
                    3228usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_setsize_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_sort_string) as usize - ptr as usize
                    },
                    3254usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_sort_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_valuemax_string) as usize - ptr as usize
                    },
                    3274usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_valuemax_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_valuemin_string) as usize - ptr as usize
                    },
                    3302usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_valuemin_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aria_valuenow_string) as usize - ptr as usize
                    },
                    3330usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aria_valuenow_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).arrow_string) as usize - ptr as usize },
                    3358usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(arrow_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).article_string) as usize - ptr as usize },
                    3370usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(article_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).as_string) as usize - ptr as usize },
                    3386usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(as_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ascending_string) as usize - ptr as usize
                    },
                    3392usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ascending_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).aside_string) as usize - ptr as usize },
                    3412usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aside_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).aspectRatio_string) as usize - ptr as usize
                    },
                    3424usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(aspectRatio_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).async_string) as usize - ptr as usize },
                    3450usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(async_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).attribute_string) as usize - ptr as usize
                    },
                    3462usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(attribute_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).attributes_string) as usize - ptr as usize
                    },
                    3482usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(attributes_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).attributeSet_string) as usize - ptr as usize
                    },
                    3504usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(attributeSet_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._auto_string) as usize - ptr as usize },
                    3532usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_auto_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).autocapitalize_string) as usize - ptr as usize
                    },
                    3542usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(autocapitalize_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).autocheck_string) as usize - ptr as usize
                    },
                    3572usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(autocheck_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).autocomplete_string) as usize - ptr as usize
                    },
                    3592usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(autocomplete_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).autocomplete_richlistbox_string) as usize
                            - ptr as usize
                    },
                    3618usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(autocomplete_richlistbox_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).autofocus_string) as usize - ptr as usize
                    },
                    3668usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(autofocus_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).autoplay_string) as usize - ptr as usize },
                    3688usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(autoplay_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).axis_string) as usize - ptr as usize },
                    3706usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(axis_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).b_string) as usize - ptr as usize },
                    3716usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(b_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).background_string) as usize - ptr as usize
                    },
                    3720usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(background_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).badge_string) as usize - ptr as usize },
                    3742usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(badge_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).bar_string) as usize - ptr as usize },
                    3754usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bar_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).base_string) as usize - ptr as usize },
                    3762usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(base_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).basefont_string) as usize - ptr as usize },
                    3772usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(basefont_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).baseline_string) as usize - ptr as usize },
                    3790usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(baseline_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).bdi_string) as usize - ptr as usize },
                    3808usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bdi_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).bdo_string) as usize - ptr as usize },
                    3816usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bdo_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).before_string) as usize - ptr as usize },
                    3824usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(before_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).behavior_string) as usize - ptr as usize },
                    3838usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(behavior_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).below_string) as usize - ptr as usize },
                    3856usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(below_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).bgcolor_string) as usize - ptr as usize },
                    3868usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bgcolor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).bgsound_string) as usize - ptr as usize },
                    3884usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bgsound_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).big_string) as usize - ptr as usize },
                    3900usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(big_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).binding_string) as usize - ptr as usize },
                    3908usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(binding_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).bindings_string) as usize - ptr as usize },
                    3924usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bindings_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).bindToUntrustedContent_string) as usize
                            - ptr as usize
                    },
                    3942usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bindToUntrustedContent_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).black_string) as usize - ptr as usize },
                    3988usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(black_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).block_string) as usize - ptr as usize },
                    4000usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(block_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).block_size_string) as usize - ptr as usize
                    },
                    4012usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(block_size_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).blocking_string) as usize - ptr as usize },
                    4034usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(blocking_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).blockquote_string) as usize - ptr as usize
                    },
                    4052usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(blockquote_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).blur_string) as usize - ptr as usize },
                    4074usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(blur_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).body_string) as usize - ptr as usize },
                    4084usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(body_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).boolean_string) as usize - ptr as usize },
                    4094usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(boolean_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).border_string) as usize - ptr as usize },
                    4110usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(border_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).bordercolor_string) as usize - ptr as usize
                    },
                    4124usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bordercolor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).both_string) as usize - ptr as usize },
                    4148usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(both_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).bottom_string) as usize - ptr as usize },
                    4158usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bottom_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).bottomend_string) as usize - ptr as usize
                    },
                    4172usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bottomend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).bottomstart_string) as usize - ptr as usize
                    },
                    4192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bottomstart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).bottomleft_string) as usize - ptr as usize
                    },
                    4216usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bottomleft_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).bottommargin_string) as usize - ptr as usize
                    },
                    4238usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bottommargin_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).bottomright_string) as usize - ptr as usize
                    },
                    4264usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(bottomright_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).box_string) as usize - ptr as usize },
                    4288usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(box_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).br_string) as usize - ptr as usize },
                    4296usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(br_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).browser_string) as usize - ptr as usize },
                    4302usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(browser_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).button_string) as usize - ptr as usize },
                    4318usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(button_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).callTemplate_string) as usize - ptr as usize
                    },
                    4332usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(callTemplate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).canvas_string) as usize - ptr as usize },
                    4360usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(canvas_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).caption_string) as usize - ptr as usize },
                    4374usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(caption_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).captionBox_string) as usize - ptr as usize
                    },
                    4390usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(captionBox_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).capture_string) as usize - ptr as usize },
                    4414usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(capture_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).caseOrder_string) as usize - ptr as usize
                    },
                    4430usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(caseOrder_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).cdataSectionElements_string) as usize
                            - ptr as usize
                    },
                    4452usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cdataSectionElements_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ceiling_string) as usize - ptr as usize },
                    4498usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ceiling_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).cell_string) as usize - ptr as usize },
                    4514usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cell_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).cellpadding_string) as usize - ptr as usize
                    },
                    4524usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cellpadding_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).cellspacing_string) as usize - ptr as usize
                    },
                    4548usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cellspacing_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).center_string) as usize - ptr as usize },
                    4572usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(center_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).change_string) as usize - ptr as usize },
                    4586usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(change_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._char_string) as usize - ptr as usize },
                    4600usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_char_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).characterData_string) as usize - ptr as usize
                    },
                    4610usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(characterData_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).charcode_string) as usize - ptr as usize },
                    4638usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(charcode_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).charoff_string) as usize - ptr as usize },
                    4656usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(charoff_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).charset_string) as usize - ptr as usize },
                    4672usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(charset_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).checkbox_string) as usize - ptr as usize },
                    4688usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(checkbox_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).checkboxLabel_string) as usize - ptr as usize
                    },
                    4706usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(checkboxLabel_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).checked_string) as usize - ptr as usize },
                    4736usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(checked_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).child_string) as usize - ptr as usize },
                    4752usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(child_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).children_string) as usize - ptr as usize },
                    4764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(children_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).childList_string) as usize - ptr as usize
                    },
                    4782usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(childList_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).child_item_count_string) as usize - ptr as usize
                    },
                    4802usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(child_item_count_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).choose_string) as usize - ptr as usize },
                    4836usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(choose_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).customtitlebar_string) as usize - ptr as usize
                    },
                    4850usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(customtitlebar_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).exposeToUntrustedContent_string) as usize
                            - ptr as usize
                    },
                    4880usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(exposeToUntrustedContent_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).circ_string) as usize - ptr as usize },
                    4930usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(circ_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).circle_string) as usize - ptr as usize },
                    4940usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(circle_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).cite_string) as usize - ptr as usize },
                    4954usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cite_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._class_string) as usize - ptr as usize },
                    4964usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_class_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).classid_string) as usize - ptr as usize },
                    4976usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(classid_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).clear_string) as usize - ptr as usize },
                    4992usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(clear_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).click_string) as usize - ptr as usize },
                    5004usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(click_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).clickcount_string) as usize - ptr as usize
                    },
                    5016usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(clickcount_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).movetoclick_string) as usize - ptr as usize
                    },
                    5038usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(movetoclick_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).clip_string) as usize - ptr as usize },
                    5062usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(clip_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).close_string) as usize - ptr as usize },
                    5072usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(close_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).closed_string) as usize - ptr as usize },
                    5084usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(closed_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).closedby_string) as usize - ptr as usize },
                    5098usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(closedby_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).closemenu_string) as usize - ptr as usize
                    },
                    5116usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(closemenu_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).code_string) as usize - ptr as usize },
                    5136usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(code_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).codebase_string) as usize - ptr as usize },
                    5146usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(codebase_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).codetype_string) as usize - ptr as usize },
                    5164usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(codetype_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).col_string) as usize - ptr as usize },
                    5182usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(col_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).colgroup_string) as usize - ptr as usize },
                    5190usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(colgroup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).collapse_string) as usize - ptr as usize },
                    5208usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(collapse_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).collapsed_string) as usize - ptr as usize
                    },
                    5226usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(collapsed_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).color_string) as usize - ptr as usize },
                    5246usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(color_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).color_gamut_string) as usize - ptr as usize
                    },
                    5258usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(color_gamut_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).color_index_string) as usize - ptr as usize
                    },
                    5282usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(color_index_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).color_scheme_string) as usize - ptr as usize
                    },
                    5306usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(color_scheme_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).cols_string) as usize - ptr as usize },
                    5332usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cols_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).colspan_string) as usize - ptr as usize },
                    5342usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(colspan_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).combobox_string) as usize - ptr as usize },
                    5358usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(combobox_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).command_string) as usize - ptr as usize },
                    5376usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(command_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).commandfor_string) as usize - ptr as usize
                    },
                    5392usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(commandfor_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).commandupdater_string) as usize - ptr as usize
                    },
                    5414usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(commandupdater_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).comment_string) as usize - ptr as usize },
                    5444usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(comment_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).compact_string) as usize - ptr as usize },
                    5460usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(compact_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).concat_string) as usize - ptr as usize },
                    5476usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(concat_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).constructor_string) as usize - ptr as usize
                    },
                    5490usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(constructor_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).consumeoutsideclicks_string) as usize
                            - ptr as usize
                    },
                    5514usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(consumeoutsideclicks_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).container_string) as usize - ptr as usize
                    },
                    5556usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(container_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).contains_string) as usize - ptr as usize },
                    5576usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(contains_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).content_string) as usize - ptr as usize },
                    5594usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(content_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).contenteditable_string) as usize - ptr as usize
                    },
                    5610usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(contenteditable_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).headerContentDisposition_string) as usize
                            - ptr as usize
                    },
                    5642usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headerContentDisposition_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).headerContentLanguage_string) as usize
                            - ptr as usize
                    },
                    5682usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headerContentLanguage_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).contentLocation_string) as usize - ptr as usize
                    },
                    5716usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(contentLocation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).headerContentScriptType_string) as usize
                            - ptr as usize
                    },
                    5750usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headerContentScriptType_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).headerContentStyleType_string) as usize
                            - ptr as usize
                    },
                    5790usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headerContentStyleType_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).headerContentType_string) as usize
                            - ptr as usize
                    },
                    5828usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headerContentType_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).consumeanchor_string) as usize - ptr as usize
                    },
                    5854usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(consumeanchor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).context_string) as usize - ptr as usize },
                    5882usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(context_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).contextmenu_string) as usize - ptr as usize
                    },
                    5898usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(contextmenu_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).control_string) as usize - ptr as usize },
                    5922usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(control_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).controls_string) as usize - ptr as usize },
                    5938usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(controls_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).coords_string) as usize - ptr as usize },
                    5956usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(coords_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).copy_string) as usize - ptr as usize },
                    5970usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(copy_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).copyOf_string) as usize - ptr as usize },
                    5980usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(copyOf_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).count_string) as usize - ptr as usize },
                    5996usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(count_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).crop_string) as usize - ptr as usize },
                    6008usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(crop_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).crossorigin_string) as usize - ptr as usize
                    },
                    6018usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(crossorigin_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).curpos_string) as usize - ptr as usize },
                    6042usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(curpos_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).current_string) as usize - ptr as usize },
                    6056usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(current_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).cutoutregion_string) as usize - ptr as usize
                    },
                    6072usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cutoutregion_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).cycler_string) as usize - ptr as usize },
                    6098usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(cycler_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dashed_string) as usize - ptr as usize },
                    6112usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dashed_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).data_string) as usize - ptr as usize },
                    6126usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(data_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).dataAtShortcutkeys_string) as usize
                            - ptr as usize
                    },
                    6136usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dataAtShortcutkeys_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).datalist_string) as usize - ptr as usize },
                    6178usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datalist_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).datal10nid_string) as usize - ptr as usize
                    },
                    6196usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datal10nid_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).datal10nargs_string) as usize - ptr as usize
                    },
                    6222usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datal10nargs_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).datal10nattrs_string) as usize - ptr as usize
                    },
                    6252usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datal10nattrs_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).datal10nname_string) as usize - ptr as usize
                    },
                    6284usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datal10nname_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).datal10nsync_string) as usize - ptr as usize
                    },
                    6314usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datal10nsync_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dataType_string) as usize - ptr as usize },
                    6344usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dataType_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dateTime_string) as usize - ptr as usize },
                    6364usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dateTime_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).date_string) as usize - ptr as usize },
                    6384usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(date_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).datetime_string) as usize - ptr as usize },
                    6394usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datetime_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).datetime_local_string) as usize - ptr as usize
                    },
                    6412usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datetime_local_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).datetimeInputBoxWrapper_string) as usize
                            - ptr as usize
                    },
                    6442usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(datetimeInputBoxWrapper_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dd_string) as usize - ptr as usize },
                    6496usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dd_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).decimal_string) as usize - ptr as usize },
                    6502usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(decimal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).decimalFormat_string) as usize - ptr as usize
                    },
                    6518usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(decimalFormat_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).decimalSeparator_string) as usize - ptr as usize
                    },
                    6548usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(decimalSeparator_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).declare_string) as usize - ptr as usize },
                    6584usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(declare_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).decoderDoctor_string) as usize - ptr as usize
                    },
                    6600usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(decoderDoctor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).decoding_string) as usize - ptr as usize },
                    6630usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(decoding_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).decrement_string) as usize - ptr as usize
                    },
                    6648usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(decrement_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._default_string) as usize - ptr as usize },
                    6668usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_default_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).headerDefaultStyle_string) as usize
                            - ptr as usize
                    },
                    6684usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headerDefaultStyle_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).defer_string) as usize - ptr as usize },
                    6712usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(defer_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).del_string) as usize - ptr as usize },
                    6724usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(del_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).delegatesanchor_string) as usize - ptr as usize
                    },
                    6732usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(delegatesanchor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).deletion_string) as usize - ptr as usize },
                    6764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(deletion_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).deprecation_string) as usize - ptr as usize
                    },
                    6782usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(deprecation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).descendant_string) as usize - ptr as usize
                    },
                    6806usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(descendant_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).descendantOrSelf_string) as usize - ptr as usize
                    },
                    6828usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(descendantOrSelf_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).descending_string) as usize - ptr as usize
                    },
                    6866usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(descending_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).description_string) as usize - ptr as usize
                    },
                    6888usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(description_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).destructor_string) as usize - ptr as usize
                    },
                    6912usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(destructor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).details_string) as usize - ptr as usize },
                    6934usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(details_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).deviceAspectRatio_string) as usize
                            - ptr as usize
                    },
                    6950usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(deviceAspectRatio_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).deviceHeight_string) as usize - ptr as usize
                    },
                    6990usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(deviceHeight_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).devicePixelRatio_string) as usize - ptr as usize
                    },
                    7018usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(devicePixelRatio_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).deviceWidth_string) as usize - ptr as usize
                    },
                    7056usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(deviceWidth_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dfn_string) as usize - ptr as usize },
                    7082usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dfn_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dialog_string) as usize - ptr as usize },
                    7090usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dialog_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).difference_string) as usize - ptr as usize
                    },
                    7104usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(difference_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).digit_string) as usize - ptr as usize },
                    7126usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(digit_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dir_string) as usize - ptr as usize },
                    7138usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dir_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).directory_string) as usize - ptr as usize
                    },
                    7146usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(directory_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dirname_string) as usize - ptr as usize },
                    7166usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dirname_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).disableOutputEscaping_string) as usize
                            - ptr as usize
                    },
                    7182usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disableOutputEscaping_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).disabled_string) as usize - ptr as usize },
                    7230usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disabled_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).disableglobalhistory_string) as usize
                            - ptr as usize
                    },
                    7248usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disableglobalhistory_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).disablehistory_string) as usize - ptr as usize
                    },
                    7290usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disablehistory_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).disablefullscreen_string) as usize
                            - ptr as usize
                    },
                    7320usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disablefullscreen_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).disablepictureinpicture_string) as usize
                            - ptr as usize
                    },
                    7356usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disablepictureinpicture_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).disclosure_closed_string) as usize
                            - ptr as usize
                    },
                    7404usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disclosure_closed_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).disclosure_open_string) as usize - ptr as usize
                    },
                    7440usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(disclosure_open_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).display_string) as usize - ptr as usize },
                    7472usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(display_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).displayMode_string) as usize - ptr as usize
                    },
                    7488usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(displayMode_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).distinct_string) as usize - ptr as usize },
                    7514usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(distinct_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).div_string) as usize - ptr as usize },
                    7532usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(div_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dl_string) as usize - ptr as usize },
                    7540usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dl_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docAbstract_string) as usize - ptr as usize
                    },
                    7546usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docAbstract_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docAcknowledgments_string) as usize
                            - ptr as usize
                    },
                    7572usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docAcknowledgments_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docAfterword_string) as usize - ptr as usize
                    },
                    7612usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docAfterword_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docAppendix_string) as usize - ptr as usize
                    },
                    7640usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docAppendix_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docBacklink_string) as usize - ptr as usize
                    },
                    7666usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docBacklink_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docBiblioentry_string) as usize - ptr as usize
                    },
                    7692usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docBiblioentry_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docBibliography_string) as usize - ptr as usize
                    },
                    7724usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docBibliography_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docBiblioref_string) as usize - ptr as usize
                    },
                    7758usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docBiblioref_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docChapter_string) as usize - ptr as usize
                    },
                    7786usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docChapter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docColophon_string) as usize - ptr as usize
                    },
                    7810usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docColophon_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docConclusion_string) as usize - ptr as usize
                    },
                    7836usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docConclusion_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).docCover_string) as usize - ptr as usize },
                    7866usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docCover_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docCredit_string) as usize - ptr as usize
                    },
                    7886usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docCredit_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docCredits_string) as usize - ptr as usize
                    },
                    7908usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docCredits_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docDedication_string) as usize - ptr as usize
                    },
                    7932usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docDedication_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docEndnote_string) as usize - ptr as usize
                    },
                    7962usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docEndnote_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docEndnotes_string) as usize - ptr as usize
                    },
                    7986usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docEndnotes_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docEpigraph_string) as usize - ptr as usize
                    },
                    8012usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docEpigraph_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docEpilogue_string) as usize - ptr as usize
                    },
                    8038usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docEpilogue_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docErrata_string) as usize - ptr as usize
                    },
                    8064usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docErrata_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docExample_string) as usize - ptr as usize
                    },
                    8086usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docExample_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docFootnote_string) as usize - ptr as usize
                    },
                    8110usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docFootnote_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docForeword_string) as usize - ptr as usize
                    },
                    8136usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docForeword_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docGlossary_string) as usize - ptr as usize
                    },
                    8162usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docGlossary_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docGlossref_string) as usize - ptr as usize
                    },
                    8188usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docGlossref_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).docIndex_string) as usize - ptr as usize },
                    8214usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docIndex_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docIntroduction_string) as usize - ptr as usize
                    },
                    8234usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docIntroduction_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docNoteref_string) as usize - ptr as usize
                    },
                    8268usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docNoteref_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docNotice_string) as usize - ptr as usize
                    },
                    8292usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docNotice_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docPagebreak_string) as usize - ptr as usize
                    },
                    8314usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPagebreak_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docPagefooter_string) as usize - ptr as usize
                    },
                    8342usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPagefooter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docPageheader_string) as usize - ptr as usize
                    },
                    8372usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPageheader_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docPagelist_string) as usize - ptr as usize
                    },
                    8402usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPagelist_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).docPart_string) as usize - ptr as usize },
                    8428usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docPreface_string) as usize - ptr as usize
                    },
                    8446usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPreface_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docPrologue_string) as usize - ptr as usize
                    },
                    8470usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPrologue_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docPullquote_string) as usize - ptr as usize
                    },
                    8496usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docPullquote_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).docQna_string) as usize - ptr as usize },
                    8524usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docQna_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).docSubtitle_string) as usize - ptr as usize
                    },
                    8540usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docSubtitle_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).docTip_string) as usize - ptr as usize },
                    8566usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docTip_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).docToc_string) as usize - ptr as usize },
                    8582usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(docToc_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).doctypePublic_string) as usize - ptr as usize
                    },
                    8598usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(doctypePublic_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).doctypeSystem_string) as usize - ptr as usize
                    },
                    8628usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(doctypeSystem_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).document_string) as usize - ptr as usize },
                    8658usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(document_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).down_string) as usize - ptr as usize },
                    8676usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(down_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).download_string) as usize - ptr as usize },
                    8686usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(download_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).drag_string) as usize - ptr as usize },
                    8704usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(drag_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).draggable_string) as usize - ptr as usize
                    },
                    8714usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(draggable_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dragging_string) as usize - ptr as usize },
                    8734usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dragging_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).dragSession_string) as usize - ptr as usize
                    },
                    8752usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dragSession_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).drawtitle_string) as usize - ptr as usize
                    },
                    8776usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(drawtitle_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).dropAfter_string) as usize - ptr as usize
                    },
                    8796usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dropAfter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).dropBefore_string) as usize - ptr as usize
                    },
                    8816usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dropBefore_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dropOn_string) as usize - ptr as usize },
                    8838usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dropOn_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).dropMarker_string) as usize - ptr as usize
                    },
                    8852usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dropMarker_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).dt_string) as usize - ptr as usize },
                    8874usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dt_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).e_string) as usize - ptr as usize },
                    8880usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(e_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).editable_string) as usize - ptr as usize },
                    8884usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(editable_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).editing_string) as usize - ptr as usize },
                    8902usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(editing_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).editor_string) as usize - ptr as usize },
                    8918usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(editor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).element_string) as usize - ptr as usize },
                    8932usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(element_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).elementAvailable_string) as usize - ptr as usize
                    },
                    8948usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(elementAvailable_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).elements_string) as usize - ptr as usize },
                    8984usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(elements_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).em_string) as usize - ptr as usize },
                    9002usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(em_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).embed_string) as usize - ptr as usize },
                    9008usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(embed_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).emphasis_string) as usize - ptr as usize },
                    9020usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(emphasis_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).empty_string) as usize - ptr as usize },
                    9038usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(empty_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).encoding_string) as usize - ptr as usize },
                    9050usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(encoding_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).enctype_string) as usize - ptr as usize },
                    9068usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(enctype_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).end_string) as usize - ptr as usize },
                    9084usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(end_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).endEvent_string) as usize - ptr as usize },
                    9092usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(endEvent_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).enterkeyhint_string) as usize - ptr as usize
                    },
                    9110usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(enterkeyhint_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).error_string) as usize - ptr as usize },
                    9136usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(error_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ethiopic_numeric_string) as usize - ptr as usize
                    },
                    9148usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ethiopic_numeric_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).even_string) as usize - ptr as usize },
                    9182usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(even_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).event_string) as usize - ptr as usize },
                    9192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(event_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).events_string) as usize - ptr as usize },
                    9204usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(events_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).excludeResultPrefixes_string) as usize
                            - ptr as usize
                    },
                    9218usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(excludeResultPrefixes_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).exportparts_string) as usize - ptr as usize
                    },
                    9266usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(exportparts_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).explicit_name_string) as usize - ptr as usize
                    },
                    9290usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(explicit_name_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).extends_string) as usize - ptr as usize },
                    9318usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(extends_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).extensionElementPrefixes_string) as usize
                            - ptr as usize
                    },
                    9334usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(extensionElementPrefixes_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).face_string) as usize - ptr as usize },
                    9388usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(face_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).fallback_string) as usize - ptr as usize },
                    9398usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(fallback_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._false_string) as usize - ptr as usize },
                    9416usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_false_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).farthest_string) as usize - ptr as usize },
                    9428usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(farthest_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).featurePolicyViolation_string) as usize
                            - ptr as usize
                    },
                    9446usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(featurePolicyViolation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).fetchpriority_string) as usize - ptr as usize
                    },
                    9496usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(fetchpriority_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).field_string) as usize - ptr as usize },
                    9524usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(field_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).fieldset_string) as usize - ptr as usize },
                    9536usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(fieldset_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).file_string) as usize - ptr as usize },
                    9554usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(file_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).figcaption_string) as usize - ptr as usize
                    },
                    9564usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(figcaption_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).figure_string) as usize - ptr as usize },
                    9586usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(figure_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).findbar_string) as usize - ptr as usize },
                    9600usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(findbar_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).firstColumn_string) as usize - ptr as usize
                    },
                    9616usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(firstColumn_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).firstInput_string) as usize - ptr as usize
                    },
                    9642usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(firstInput_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).fixed_string) as usize - ptr as usize },
                    9666usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(fixed_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).flags_string) as usize - ptr as usize },
                    9678usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(flags_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).flex_string) as usize - ptr as usize },
                    9690usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(flex_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).flip_string) as usize - ptr as usize },
                    9700usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(flip_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).floor_string) as usize - ptr as usize },
                    9710usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(floor_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).flowlength_string) as usize - ptr as usize
                    },
                    9722usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(flowlength_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).focus_string) as usize - ptr as usize },
                    9744usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(focus_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).focused_string) as usize - ptr as usize },
                    9756usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(focused_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).followanchor_string) as usize - ptr as usize
                    },
                    9772usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(followanchor_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).following_string) as usize - ptr as usize
                    },
                    9798usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(following_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).followingSibling_string) as usize - ptr as usize
                    },
                    9818usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(followingSibling_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).font_string) as usize - ptr as usize },
                    9854usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(font_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).footer_string) as usize - ptr as usize },
                    9864usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(footer_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._for_string) as usize - ptr as usize },
                    9878usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_for_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).forEach_string) as usize - ptr as usize },
                    9886usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(forEach_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).forcedColors_string) as usize - ptr as usize
                    },
                    9904usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(forcedColors_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).invertedColors_string) as usize - ptr as usize
                    },
                    9932usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(invertedColors_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).forceOwnRefreshDriver_string) as usize
                            - ptr as usize
                    },
                    9964usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(forceOwnRefreshDriver_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).form_string) as usize - ptr as usize },
                    10008usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(form_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).formaction_string) as usize - ptr as usize
                    },
                    10018usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(formaction_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).format_string) as usize - ptr as usize },
                    10040usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(format_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).formatNumber_string) as usize - ptr as usize
                    },
                    10054usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(formatNumber_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).formenctype_string) as usize - ptr as usize
                    },
                    10082usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(formenctype_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).formmethod_string) as usize - ptr as usize
                    },
                    10106usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(formmethod_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).formnovalidate_string) as usize - ptr as usize
                    },
                    10128usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(formnovalidate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).formtarget_string) as usize - ptr as usize
                    },
                    10158usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(formtarget_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).frame_string) as usize - ptr as usize },
                    10180usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(frame_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).frameborder_string) as usize - ptr as usize
                    },
                    10192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(frameborder_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).frameset_string) as usize - ptr as usize },
                    10216usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(frameset_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).from_string) as usize - ptr as usize },
                    10234usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(from_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).fullscreenchange_string) as usize - ptr as usize
                    },
                    10244usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(fullscreenchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).fullscreenerror_string) as usize - ptr as usize
                    },
                    10278usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(fullscreenerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).functionAvailable_string) as usize
                            - ptr as usize
                    },
                    10310usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(functionAvailable_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).generateId_string) as usize - ptr as usize
                    },
                    10348usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(generateId_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).generic_string) as usize - ptr as usize },
                    10372usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(generic_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).getter_string) as usize - ptr as usize },
                    10388usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(getter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).graphicsDocument_string) as usize - ptr as usize
                    },
                    10402usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(graphicsDocument_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).graphicsObject_string) as usize - ptr as usize
                    },
                    10438usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(graphicsObject_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).graphicsSymbol_string) as usize - ptr as usize
                    },
                    10470usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(graphicsSymbol_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).grid_string) as usize - ptr as usize },
                    10502usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(grid_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).group_string) as usize - ptr as usize },
                    10512usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(group_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).groups_string) as usize - ptr as usize },
                    10524usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(groups_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).groupbox_string) as usize - ptr as usize },
                    10538usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(groupbox_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).groupingSeparator_string) as usize
                            - ptr as usize
                    },
                    10556usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(groupingSeparator_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).groupingSize_string) as usize - ptr as usize
                    },
                    10594usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(groupingSize_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).grow_string) as usize - ptr as usize },
                    10622usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(grow_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).h1_string) as usize - ptr as usize },
                    10632usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(h1_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).h2_string) as usize - ptr as usize },
                    10638usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(h2_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).h3_string) as usize - ptr as usize },
                    10644usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(h3_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).h4_string) as usize - ptr as usize },
                    10650usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(h4_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).h5_string) as usize - ptr as usize },
                    10656usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(h5_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).h6_string) as usize - ptr as usize },
                    10662usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(h6_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hairline_string) as usize - ptr as usize },
                    10668usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hairline_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).handheldFriendly_string) as usize - ptr as usize
                    },
                    10686usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(handheldFriendly_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).handler_string) as usize - ptr as usize },
                    10720usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(handler_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).handlers_string) as usize - ptr as usize },
                    10736usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(handlers_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).HARD_string) as usize - ptr as usize },
                    10754usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(HARD_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).hasSameNode_string) as usize - ptr as usize
                    },
                    10764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hasSameNode_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hbox_string) as usize - ptr as usize },
                    10792usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hbox_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).head_string) as usize - ptr as usize },
                    10802usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(head_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).header_string) as usize - ptr as usize },
                    10812usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(header_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).headers_string) as usize - ptr as usize },
                    10826usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headers_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hebrew_string) as usize - ptr as usize },
                    10842usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hebrew_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).height_string) as usize - ptr as usize },
                    10856usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(height_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hgroup_string) as usize - ptr as usize },
                    10870usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hgroup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hidden_string) as usize - ptr as usize },
                    10884usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hidden_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).hidechrome_string) as usize - ptr as usize
                    },
                    10898usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hidechrome_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).hidecolumnpicker_string) as usize - ptr as usize
                    },
                    10920usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hidecolumnpicker_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).hide_popover_string) as usize - ptr as usize
                    },
                    10954usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hide_popover_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).high_string) as usize - ptr as usize },
                    10980usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(high_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).highest_string) as usize - ptr as usize },
                    10990usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(highest_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).horizontal_string) as usize - ptr as usize
                    },
                    11006usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(horizontal_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hover_string) as usize - ptr as usize },
                    11028usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hover_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hr_string) as usize - ptr as usize },
                    11040usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hr_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).href_string) as usize - ptr as usize },
                    11046usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(href_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hreflang_string) as usize - ptr as usize },
                    11056usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hreflang_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hsides_string) as usize - ptr as usize },
                    11074usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hsides_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).hspace_string) as usize - ptr as usize },
                    11088usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(hspace_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).html_string) as usize - ptr as usize },
                    11102usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(html_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).httpEquiv_string) as usize - ptr as usize
                    },
                    11112usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(httpEquiv_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).i_string) as usize - ptr as usize },
                    11134usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(i_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).icon_string) as usize - ptr as usize },
                    11138usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(icon_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).id_string) as usize - ptr as usize },
                    11148usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(id_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._if_string) as usize - ptr as usize },
                    11154usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_if_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).iframe_string) as usize - ptr as usize },
                    11160usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(iframe_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ignorekeys_string) as usize - ptr as usize
                    },
                    11174usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ignorekeys_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ignoreuserfocus_string) as usize - ptr as usize
                    },
                    11196usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ignoreuserfocus_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).image_string) as usize - ptr as usize },
                    11228usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(image_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).imageClickedPoint_string) as usize
                            - ptr as usize
                    },
                    11240usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(imageClickedPoint_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).imagesizes_string) as usize - ptr as usize
                    },
                    11280usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(imagesizes_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).imagesrcset_string) as usize - ptr as usize
                    },
                    11302usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(imagesrcset_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).img_string) as usize - ptr as usize },
                    11326usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(img_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).implementation_string) as usize - ptr as usize
                    },
                    11334usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(implementation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).implements_string) as usize - ptr as usize
                    },
                    11364usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(implements_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).import_string) as usize - ptr as usize },
                    11386usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(import_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).include_string) as usize - ptr as usize },
                    11400usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(include_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).includes_string) as usize - ptr as usize },
                    11416usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(includes_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).incontentshell_string) as usize - ptr as usize
                    },
                    11434usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(incontentshell_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).increment_string) as usize - ptr as usize
                    },
                    11464usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(increment_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).indent_string) as usize - ptr as usize },
                    11484usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(indent_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).indeterminate_string) as usize - ptr as usize
                    },
                    11498usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(indeterminate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).index_string) as usize - ptr as usize },
                    11526usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(index_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).inert_string) as usize - ptr as usize },
                    11538usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(inert_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).innerHTML_string) as usize - ptr as usize
                    },
                    11550usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(innerHTML_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).innerText_string) as usize - ptr as usize
                    },
                    11570usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(innerText_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).infinity_string) as usize - ptr as usize },
                    11590usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(infinity_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).inherits_string) as usize - ptr as usize },
                    11608usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(inherits_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).inheritOverflow_string) as usize - ptr as usize
                    },
                    11626usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(inheritOverflow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).inheritstyle_string) as usize - ptr as usize
                    },
                    11660usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(inheritstyle_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).initial_scale_string) as usize - ptr as usize
                    },
                    11686usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(initial_scale_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).input_string) as usize - ptr as usize },
                    11714usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(input_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).inputmode_string) as usize - ptr as usize
                    },
                    11726usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(inputmode_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ins_string) as usize - ptr as usize },
                    11746usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ins_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).insertafter_string) as usize - ptr as usize
                    },
                    11754usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(insertafter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).insertbefore_string) as usize - ptr as usize
                    },
                    11778usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(insertbefore_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).insertion_string) as usize - ptr as usize
                    },
                    11804usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(insertion_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).integer_string) as usize - ptr as usize },
                    11824usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(integer_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).integrity_string) as usize - ptr as usize
                    },
                    11840usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(integrity_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).interactive_widget_string) as usize
                            - ptr as usize
                    },
                    11860usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(interactive_widget_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).internal_string) as usize - ptr as usize },
                    11898usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(internal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).internals_string) as usize - ptr as usize
                    },
                    11916usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(internals_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).intersection_string) as usize - ptr as usize
                    },
                    11936usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(intersection_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).is_string) as usize - ptr as usize },
                    11962usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(is_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ismap_string) as usize - ptr as usize },
                    11968usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ismap_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ispopup_string) as usize - ptr as usize },
                    11980usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ispopup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).itemid_string) as usize - ptr as usize },
                    11996usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(itemid_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).itemprop_string) as usize - ptr as usize },
                    12010usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(itemprop_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).itemref_string) as usize - ptr as usize },
                    12028usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(itemref_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).itemscope_string) as usize - ptr as usize
                    },
                    12044usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(itemscope_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).itemtype_string) as usize - ptr as usize },
                    12064usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(itemtype_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).japanese_formal_string) as usize - ptr as usize
                    },
                    12082usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(japanese_formal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).japanese_informal_string) as usize
                            - ptr as usize
                    },
                    12114usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(japanese_informal_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).kbd_string) as usize - ptr as usize },
                    12150usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(kbd_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).keepcurrentinview_string) as usize
                            - ptr as usize
                    },
                    12158usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keepcurrentinview_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).key_string) as usize - ptr as usize },
                    12194usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(key_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).keycode_string) as usize - ptr as usize },
                    12202usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keycode_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).keydown_string) as usize - ptr as usize },
                    12218usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keydown_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).keygen_string) as usize - ptr as usize },
                    12234usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keygen_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).keypress_string) as usize - ptr as usize },
                    12248usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keypress_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).keyset_string) as usize - ptr as usize },
                    12266usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keyset_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).keysystem_string) as usize - ptr as usize
                    },
                    12280usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keysystem_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).keyup_string) as usize - ptr as usize },
                    12300usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(keyup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).kind_string) as usize - ptr as usize },
                    12312usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(kind_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).korean_hangul_formal_string) as usize
                            - ptr as usize
                    },
                    12322usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(korean_hangul_formal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).korean_hanja_formal_string) as usize
                            - ptr as usize
                    },
                    12364usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(korean_hanja_formal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).korean_hanja_informal_string) as usize
                            - ptr as usize
                    },
                    12404usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(korean_hanja_informal_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).label_string) as usize - ptr as usize },
                    12448usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(label_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).lang_string) as usize - ptr as usize },
                    12460usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(lang_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).language_string) as usize - ptr as usize },
                    12470usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(language_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).last_string) as usize - ptr as usize },
                    12488usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(last_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).layer_string) as usize - ptr as usize },
                    12498usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(layer_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).LayerActivity_string) as usize - ptr as usize
                    },
                    12510usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(LayerActivity_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).layout_guess_string) as usize - ptr as usize
                    },
                    12538usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(layout_guess_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).leading_string) as usize - ptr as usize },
                    12564usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(leading_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).leaf_string) as usize - ptr as usize },
                    12580usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(leaf_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).left_string) as usize - ptr as usize },
                    12590usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(left_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).leftmargin_string) as usize - ptr as usize
                    },
                    12600usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(leftmargin_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).legend_string) as usize - ptr as usize },
                    12622usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(legend_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).length_string) as usize - ptr as usize },
                    12636usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(length_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).letterValue_string) as usize - ptr as usize
                    },
                    12650usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(letterValue_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).level_string) as usize - ptr as usize },
                    12676usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(level_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).lhs_string) as usize - ptr as usize },
                    12688usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(lhs_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).li_string) as usize - ptr as usize },
                    12696usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(li_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).line_string) as usize - ptr as usize },
                    12702usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(line_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).link_string) as usize - ptr as usize },
                    12712usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(link_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).linkset_string) as usize - ptr as usize },
                    12722usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(linkset_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).listbox_string) as usize - ptr as usize },
                    12738usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(listbox_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).listener_string) as usize - ptr as usize },
                    12754usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(listener_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).listheader_string) as usize - ptr as usize
                    },
                    12772usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(listheader_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).listing_string) as usize - ptr as usize },
                    12794usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(listing_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).listitem_string) as usize - ptr as usize },
                    12810usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(listitem_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).load_string) as usize - ptr as usize },
                    12828usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(load_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).loading_string) as usize - ptr as usize },
                    12838usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(loading_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).touchmode_string) as usize - ptr as usize
                    },
                    12854usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(touchmode_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).triggeringprincipal_string) as usize
                            - ptr as usize
                    },
                    12874usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(triggeringprincipal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).localedir_string) as usize - ptr as usize
                    },
                    12914usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(localedir_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).localName_string) as usize - ptr as usize
                    },
                    12934usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(localName_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).localization_string) as usize - ptr as usize
                    },
                    12956usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(localization_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).longdesc_string) as usize - ptr as usize },
                    12982usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(longdesc_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).loop_string) as usize - ptr as usize },
                    13000usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(loop_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).low_string) as usize - ptr as usize },
                    13010usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(low_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).lowerFirst_string) as usize - ptr as usize
                    },
                    13018usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(lowerFirst_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).lowest_string) as usize - ptr as usize },
                    13042usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(lowest_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).lowsrc_string) as usize - ptr as usize },
                    13056usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(lowsrc_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ltr_string) as usize - ptr as usize },
                    13070usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ltr_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).main_string) as usize - ptr as usize },
                    13078usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(main_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).map_string) as usize - ptr as usize },
                    13088usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(map_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).manifest_string) as usize - ptr as usize },
                    13096usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(manifest_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).marginBottom_string) as usize - ptr as usize
                    },
                    13114usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(marginBottom_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).marginLeft_string) as usize - ptr as usize
                    },
                    13142usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(marginLeft_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).marginRight_string) as usize - ptr as usize
                    },
                    13166usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(marginRight_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).marginTop_string) as usize - ptr as usize
                    },
                    13192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(marginTop_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).marginheight_string) as usize - ptr as usize
                    },
                    13214usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(marginheight_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).marginwidth_string) as usize - ptr as usize
                    },
                    13240usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(marginwidth_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).mark_string) as usize - ptr as usize },
                    13264usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mark_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).marquee_string) as usize - ptr as usize },
                    13274usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(marquee_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).match_string) as usize - ptr as usize },
                    13290usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(match_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).max_string) as usize - ptr as usize },
                    13302usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(max_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).maxheight_string) as usize - ptr as usize
                    },
                    13310usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(maxheight_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).maximum_scale_string) as usize - ptr as usize
                    },
                    13330usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(maximum_scale_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).maxlength_string) as usize - ptr as usize
                    },
                    13358usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(maxlength_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).maxpos_string) as usize - ptr as usize },
                    13378usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(maxpos_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).maxwidth_string) as usize - ptr as usize },
                    13392usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(maxwidth_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).measure_string) as usize - ptr as usize },
                    13410usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(measure_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).media_string) as usize - ptr as usize },
                    13426usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(media_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mediaType_string) as usize - ptr as usize
                    },
                    13438usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mediaType_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).menu_string) as usize - ptr as usize },
                    13460usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menu_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).menubar_string) as usize - ptr as usize },
                    13470usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menubar_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).menucaption_string) as usize - ptr as usize
                    },
                    13486usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menucaption_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).menugroup_string) as usize - ptr as usize
                    },
                    13510usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menugroup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).menuitem_string) as usize - ptr as usize },
                    13530usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menuitem_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).menulist_string) as usize - ptr as usize },
                    13548usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menulist_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).menupopup_string) as usize - ptr as usize
                    },
                    13566usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menupopup_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).menuseparator_string) as usize - ptr as usize
                    },
                    13586usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(menuseparator_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).mesh_string) as usize - ptr as usize },
                    13614usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mesh_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).message_string) as usize - ptr as usize },
                    13624usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(message_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).meta_string) as usize - ptr as usize },
                    13640usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(meta_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).referrer_string) as usize - ptr as usize },
                    13650usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(referrer_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).referrerpolicy_string) as usize - ptr as usize
                    },
                    13668usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(referrerpolicy_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).renderroot_string) as usize - ptr as usize
                    },
                    13698usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(renderroot_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).headerReferrerPolicy_string) as usize
                            - ptr as usize
                    },
                    13720usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(headerReferrerPolicy_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).meter_string) as usize - ptr as usize },
                    13752usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(meter_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).method_string) as usize - ptr as usize },
                    13764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(method_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).middle_string) as usize - ptr as usize },
                    13778usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(middle_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).min_string) as usize - ptr as usize },
                    13792usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(min_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).minheight_string) as usize - ptr as usize
                    },
                    13800usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(minheight_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).minimum_scale_string) as usize - ptr as usize
                    },
                    13820usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(minimum_scale_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).minlength_string) as usize - ptr as usize
                    },
                    13848usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(minlength_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).minpos_string) as usize - ptr as usize },
                    13868usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(minpos_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).minusSign_string) as usize - ptr as usize
                    },
                    13882usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(minusSign_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).minwidth_string) as usize - ptr as usize },
                    13904usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(minwidth_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).mixed_string) as usize - ptr as usize },
                    13922usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mixed_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).messagemanagergroup_string) as usize
                            - ptr as usize
                    },
                    13934usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(messagemanagergroup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).mod_string) as usize - ptr as usize },
                    13974usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mod_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._module_string) as usize - ptr as usize },
                    13982usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_module_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).mode_string) as usize - ptr as usize },
                    13996usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mode_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).modifiers_string) as usize - ptr as usize
                    },
                    14006usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(modifiers_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).monochrome_string) as usize - ptr as usize
                    },
                    14026usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(monochrome_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mouseover_string) as usize - ptr as usize
                    },
                    14048usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mouseover_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozAccessiblecaret_string) as usize
                            - ptr as usize
                    },
                    14068usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozAccessiblecaret_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozCustomContentContainer_string) as usize
                            - ptr as usize
                    },
                    14108usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozCustomContentContainer_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozGrabber_string) as usize - ptr as usize
                    },
                    14166usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozGrabber_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozNativeAnonymous_string) as usize
                            - ptr as usize
                    },
                    14188usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozNativeAnonymous_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozprivatebrowsing_string) as usize
                            - ptr as usize
                    },
                    14232usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozprivatebrowsing_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozResizer_string) as usize - ptr as usize
                    },
                    14270usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozResizer_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozResizingInfo_string) as usize - ptr as usize
                    },
                    14292usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozResizingInfo_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozResizingShadow_string) as usize
                            - ptr as usize
                    },
                    14324usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozResizingShadow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozTableAddColumnAfter_string) as usize
                            - ptr as usize
                    },
                    14360usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozTableAddColumnAfter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozTableAddColumnBefore_string) as usize
                            - ptr as usize
                    },
                    14406usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozTableAddColumnBefore_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozTableAddRowAfter_string) as usize
                            - ptr as usize
                    },
                    14454usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozTableAddRowAfter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozTableAddRowBefore_string) as usize
                            - ptr as usize
                    },
                    14494usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozTableAddRowBefore_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozTableRemoveRow_string) as usize
                            - ptr as usize
                    },
                    14536usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozTableRemoveRow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).mozTableRemoveColumn_string) as usize
                            - ptr as usize
                    },
                    14572usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(mozTableRemoveColumn_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).moz_opaque_string) as usize - ptr as usize
                    },
                    14614usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(moz_opaque_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).multicol_string) as usize - ptr as usize },
                    14636usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(multicol_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).multiple_string) as usize - ptr as usize },
                    14654usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(multiple_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).muted_string) as usize - ptr as usize },
                    14672usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(muted_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).name_string) as usize - ptr as usize },
                    14684usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(name_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).native_string) as usize - ptr as usize },
                    14694usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(native_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._namespace_string) as usize - ptr as usize
                    },
                    14708usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_namespace_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).namespaceAlias_string) as usize - ptr as usize
                    },
                    14728usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(namespaceAlias_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).namespaceUri_string) as usize - ptr as usize
                    },
                    14760usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(namespaceUri_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).NaN_string) as usize - ptr as usize },
                    14788usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(NaN_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).n_string) as usize - ptr as usize },
                    14796usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(n_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nav_string) as usize - ptr as usize },
                    14800usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nav_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ne_string) as usize - ptr as usize },
                    14808usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ne_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).never_string) as usize - ptr as usize },
                    14814usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(never_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).neverhidden_string) as usize - ptr as usize
                    },
                    14826usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(neverhidden_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._new_string) as usize - ptr as usize },
                    14850usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_new_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).newline_string) as usize - ptr as usize },
                    14858usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(newline_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).nextRemoteTabId_string) as usize - ptr as usize
                    },
                    14874usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nextRemoteTabId_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).no_string) as usize - ptr as usize },
                    14906usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(no_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).noautofocus_string) as usize - ptr as usize
                    },
                    14912usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noautofocus_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).noautohide_string) as usize - ptr as usize
                    },
                    14936usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noautohide_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).norolluponanchor_string) as usize - ptr as usize
                    },
                    14958usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(norolluponanchor_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).noBar_string) as usize - ptr as usize },
                    14992usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noBar_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nobr_string) as usize - ptr as usize },
                    15006usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nobr_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).nodefaultsrc_string) as usize - ptr as usize
                    },
                    15016usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nodefaultsrc_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nodeSet_string) as usize - ptr as usize },
                    15042usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nodeSet_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).noembed_string) as usize - ptr as usize },
                    15060usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noembed_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).noframes_string) as usize - ptr as usize },
                    15076usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noframes_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nohref_string) as usize - ptr as usize },
                    15094usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nohref_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).noinitialselection_string) as usize
                            - ptr as usize
                    },
                    15108usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noinitialselection_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nomodule_string) as usize - ptr as usize },
                    15146usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nomodule_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nonce_string) as usize - ptr as usize },
                    15164usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nonce_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).none_string) as usize - ptr as usize },
                    15176usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(none_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).noresize_string) as usize - ptr as usize },
                    15186usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noresize_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).normal_string) as usize - ptr as usize },
                    15204usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(normal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).normalizeSpace_string) as usize - ptr as usize
                    },
                    15218usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(normalizeSpace_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).noscript_string) as usize - ptr as usize },
                    15250usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noscript_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).noshade_string) as usize - ptr as usize },
                    15268usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(noshade_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).notification_string) as usize - ptr as usize
                    },
                    15284usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(notification_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).novalidate_string) as usize - ptr as usize
                    },
                    15310usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(novalidate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._not_string) as usize - ptr as usize },
                    15332usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_not_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nowrap_string) as usize - ptr as usize },
                    15340usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nowrap_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).number_string) as usize - ptr as usize },
                    15354usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(number_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).nw_string) as usize - ptr as usize },
                    15368usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(nw_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).object_string) as usize - ptr as usize },
                    15374usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(object_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).objectType_string) as usize - ptr as usize
                    },
                    15388usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(objectType_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).observes_string) as usize - ptr as usize },
                    15412usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(observes_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).odd_string) as usize - ptr as usize },
                    15430usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(odd_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).OFF_string) as usize - ptr as usize },
                    15438usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(OFF_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ol_string) as usize - ptr as usize },
                    15446usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ol_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).omitXmlDeclaration_string) as usize
                            - ptr as usize
                    },
                    15452usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(omitXmlDeclaration_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onabort_string) as usize - ptr as usize },
                    15494usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onabort_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmozaccesskeynotfound_string) as usize
                            - ptr as usize
                    },
                    15510usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmozaccesskeynotfound_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onactivate_string) as usize - ptr as usize
                    },
                    15556usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onactivate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onafterprint_string) as usize - ptr as usize
                    },
                    15578usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onafterprint_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onafterscriptexecute_string) as usize
                            - ptr as usize
                    },
                    15604usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onafterscriptexecute_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onanimationcancel_string) as usize
                            - ptr as usize
                    },
                    15646usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onanimationcancel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onanimationend_string) as usize - ptr as usize
                    },
                    15682usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onanimationend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onanimationiteration_string) as usize
                            - ptr as usize
                    },
                    15712usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onanimationiteration_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onanimationstart_string) as usize - ptr as usize
                    },
                    15754usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onanimationstart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onAppCommand_string) as usize - ptr as usize
                    },
                    15788usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onAppCommand_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onaudioprocess_string) as usize - ptr as usize
                    },
                    15814usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onaudioprocess_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onauxclick_string) as usize - ptr as usize
                    },
                    15844usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onauxclick_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforecopy_string) as usize - ptr as usize
                    },
                    15866usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforecopy_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforecut_string) as usize - ptr as usize
                    },
                    15892usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforecut_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforeinput_string) as usize - ptr as usize
                    },
                    15916usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforeinput_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforematch_string) as usize - ptr as usize
                    },
                    15944usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforematch_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforepaste_string) as usize - ptr as usize
                    },
                    15972usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforepaste_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforeprint_string) as usize - ptr as usize
                    },
                    16000usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforeprint_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforescriptexecute_string) as usize
                            - ptr as usize
                    },
                    16028usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforescriptexecute_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbeforeunload_string) as usize - ptr as usize
                    },
                    16072usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbeforeunload_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onblocked_string) as usize - ptr as usize
                    },
                    16102usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onblocked_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onblur_string) as usize - ptr as usize },
                    16122usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onblur_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onboundschange_string) as usize - ptr as usize
                    },
                    16136usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onboundschange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbroadcast_string) as usize - ptr as usize
                    },
                    16166usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbroadcast_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onbufferedamountlow_string) as usize
                            - ptr as usize
                    },
                    16190usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onbufferedamountlow_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).oncached_string) as usize - ptr as usize },
                    16230usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncached_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).oncancel_string) as usize - ptr as usize },
                    16248usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncancel_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onchange_string) as usize - ptr as usize },
                    16266usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onchargingchange_string) as usize - ptr as usize
                    },
                    16284usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onchargingchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onchargingtimechange_string) as usize
                            - ptr as usize
                    },
                    16318usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onchargingtimechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onchecking_string) as usize - ptr as usize
                    },
                    16360usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onchecking_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onCheckboxStateChange_string) as usize
                            - ptr as usize
                    },
                    16382usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onCheckboxStateChange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onCheckKeyPressEventModel_string) as usize
                            - ptr as usize
                    },
                    16426usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onCheckKeyPressEventModel_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onclick_string) as usize - ptr as usize },
                    16478usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onclick_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onclose_string) as usize - ptr as usize },
                    16494usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onclose_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncontentvisibilityautostatechange_string)
                            as usize
                            - ptr as usize
                    },
                    16510usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncontentvisibilityautostatechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncommand_string) as usize - ptr as usize
                    },
                    16580usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncommand_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncommandupdate_string) as usize - ptr as usize
                    },
                    16600usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncommandupdate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncomplete_string) as usize - ptr as usize
                    },
                    16632usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncomplete_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncompositionend_string) as usize - ptr as usize
                    },
                    16654usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncompositionend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncompositionstart_string) as usize
                            - ptr as usize
                    },
                    16688usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncompositionstart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncompositionupdate_string) as usize
                            - ptr as usize
                    },
                    16726usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncompositionupdate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onconnect_string) as usize - ptr as usize
                    },
                    16766usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onconnect_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onconnectionavailable_string) as usize
                            - ptr as usize
                    },
                    16786usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onconnectionavailable_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncontextmenu_string) as usize - ptr as usize
                    },
                    16830usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncontextmenu_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncontextlost_string) as usize - ptr as usize
                    },
                    16858usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncontextlost_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncontextrestored_string) as usize
                            - ptr as usize
                    },
                    16886usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncontextrestored_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncookiechange_string) as usize - ptr as usize
                    },
                    16922usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncookiechange_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).oncopy_string) as usize - ptr as usize },
                    16952usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncopy_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).oncut_string) as usize - ptr as usize },
                    16966usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncut_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oncurrententrychange_string) as usize
                            - ptr as usize
                    },
                    16978usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oncurrententrychange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondblclick_string) as usize - ptr as usize
                    },
                    17020usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondblclick_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondischargingtimechange_string) as usize
                            - ptr as usize
                    },
                    17042usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondischargingtimechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondispose_string) as usize - ptr as usize
                    },
                    17090usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondispose_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondownloading_string) as usize - ptr as usize
                    },
                    17110usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondownloading_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMActivate_string) as usize - ptr as usize
                    },
                    17138usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMActivate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMAttrModified_string) as usize
                            - ptr as usize
                    },
                    17166usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMAttrModified_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMCharacterDataModified_string) as usize
                            - ptr as usize
                    },
                    17202usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMCharacterDataModified_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMFocusIn_string) as usize - ptr as usize
                    },
                    17256usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMFocusIn_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMFocusOut_string) as usize - ptr as usize
                    },
                    17282usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMFocusOut_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMMouseScroll_string) as usize - ptr as usize
                    },
                    17310usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMMouseScroll_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMNodeInserted_string) as usize
                            - ptr as usize
                    },
                    17344usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMNodeInserted_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMNodeInsertedIntoDocument_string) as usize
                            - ptr as usize
                    },
                    17380usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMNodeInsertedIntoDocument_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMNodeRemoved_string) as usize - ptr as usize
                    },
                    17440usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMNodeRemoved_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMNodeRemovedFromDocument_string) as usize
                            - ptr as usize
                    },
                    17474usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMNodeRemovedFromDocument_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onDOMSubtreeModified_string) as usize
                            - ptr as usize
                    },
                    17532usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onDOMSubtreeModified_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ondata_string) as usize - ptr as usize },
                    17574usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondata_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ondrag_string) as usize - ptr as usize },
                    17588usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondrag_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondragdrop_string) as usize - ptr as usize
                    },
                    17602usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondragdrop_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondragend_string) as usize - ptr as usize
                    },
                    17624usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondragend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondragenter_string) as usize - ptr as usize
                    },
                    17644usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondragenter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondragexit_string) as usize - ptr as usize
                    },
                    17668usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondragexit_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondragleave_string) as usize - ptr as usize
                    },
                    17690usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondragleave_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondragover_string) as usize - ptr as usize
                    },
                    17714usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondragover_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ondragstart_string) as usize - ptr as usize
                    },
                    17736usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondragstart_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ondrain_string) as usize - ptr as usize },
                    17760usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondrain_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ondrop_string) as usize - ptr as usize },
                    17776usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ondrop_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onerror_string) as usize - ptr as usize },
                    17790usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onerror_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onfinish_string) as usize - ptr as usize },
                    17806usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onfinish_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onfocus_string) as usize - ptr as usize },
                    17824usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onfocus_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onfocusin_string) as usize - ptr as usize
                    },
                    17840usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onfocusin_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onfocusout_string) as usize - ptr as usize
                    },
                    17860usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onfocusout_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onfullscreenchange_string) as usize
                            - ptr as usize
                    },
                    17882usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onfullscreenchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onfullscreenerror_string) as usize
                            - ptr as usize
                    },
                    17920usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onfullscreenerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ongatheringstatechange_string) as usize
                            - ptr as usize
                    },
                    17956usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ongatheringstatechange_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onget_string) as usize - ptr as usize },
                    18002usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onget_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onhashchange_string) as usize - ptr as usize
                    },
                    18014usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onhashchange_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).oninput_string) as usize - ptr as usize },
                    18040usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oninput_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oninputsourceschange_string) as usize
                            - ptr as usize
                    },
                    18056usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oninputsourceschange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oninstall_string) as usize - ptr as usize
                    },
                    18098usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oninstall_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).oninvalid_string) as usize - ptr as usize
                    },
                    18118usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(oninvalid_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onkeydown_string) as usize - ptr as usize
                    },
                    18138usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onkeydown_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onkeypress_string) as usize - ptr as usize
                    },
                    18158usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onkeypress_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onkeyup_string) as usize - ptr as usize },
                    18180usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onkeyup_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onlanguagechange_string) as usize - ptr as usize
                    },
                    18196usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onlanguagechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onlevelchange_string) as usize - ptr as usize
                    },
                    18230usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onlevelchange_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onload_string) as usize - ptr as usize },
                    18258usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onload_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onloading_string) as usize - ptr as usize
                    },
                    18272usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onloading_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onloadingdone_string) as usize - ptr as usize
                    },
                    18292usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onloadingdone_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onloadingerror_string) as usize - ptr as usize
                    },
                    18320usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onloadingerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpopstate_string) as usize - ptr as usize
                    },
                    18350usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpopstate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).only_string) as usize - ptr as usize },
                    18372usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(only_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmerchantvalidation_string) as usize
                            - ptr as usize
                    },
                    18382usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmerchantvalidation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmessage_string) as usize - ptr as usize
                    },
                    18424usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmessage_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmessageerror_string) as usize - ptr as usize
                    },
                    18444usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmessageerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmidimessage_string) as usize - ptr as usize
                    },
                    18474usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmidimessage_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmousedown_string) as usize - ptr as usize
                    },
                    18502usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmousedown_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmouseenter_string) as usize - ptr as usize
                    },
                    18526usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmouseenter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmouseleave_string) as usize - ptr as usize
                    },
                    18552usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmouseleave_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmouselongtap_string) as usize - ptr as usize
                    },
                    18578usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmouselongtap_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmousemove_string) as usize - ptr as usize
                    },
                    18608usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmousemove_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmouseout_string) as usize - ptr as usize
                    },
                    18632usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmouseout_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmouseover_string) as usize - ptr as usize
                    },
                    18654usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmouseover_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onMozMouseHittest_string) as usize
                            - ptr as usize
                    },
                    18678usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onMozMouseHittest_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onMozMouseExploreByTouch_string) as usize
                            - ptr as usize
                    },
                    18714usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onMozMouseExploreByTouch_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmouseup_string) as usize - ptr as usize
                    },
                    18764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmouseup_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onMozAfterPaint_string) as usize - ptr as usize
                    },
                    18784usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onMozAfterPaint_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmozfullscreenchange_string) as usize
                            - ptr as usize
                    },
                    18816usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmozfullscreenchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmozfullscreenerror_string) as usize
                            - ptr as usize
                    },
                    18860usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmozfullscreenerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmozpointerlockchange_string) as usize
                            - ptr as usize
                    },
                    18902usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmozpointerlockchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onmozpointerlockerror_string) as usize
                            - ptr as usize
                    },
                    18948usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmozpointerlockerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onMozMousePixelScroll_string) as usize
                            - ptr as usize
                    },
                    18992usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onMozMousePixelScroll_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onMozScrolledAreaChanged_string) as usize
                            - ptr as usize
                    },
                    19036usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onMozScrolledAreaChanged_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onmute_string) as usize - ptr as usize },
                    19086usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onmute_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onnavigate_string) as usize - ptr as usize
                    },
                    19100usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onnavigate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onnavigatesuccess_string) as usize
                            - ptr as usize
                    },
                    19122usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onnavigatesuccess_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onnavigateerror_string) as usize - ptr as usize
                    },
                    19158usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onnavigateerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onnotificationclick_string) as usize
                            - ptr as usize
                    },
                    19190usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onnotificationclick_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onnotificationclose_string) as usize
                            - ptr as usize
                    },
                    19230usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onnotificationclose_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onnoupdate_string) as usize - ptr as usize
                    },
                    19270usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onnoupdate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onobsolete_string) as usize - ptr as usize
                    },
                    19292usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onobsolete_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ononline_string) as usize - ptr as usize },
                    19314usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ononline_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onoffline_string) as usize - ptr as usize
                    },
                    19332usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onoffline_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onopen_string) as usize - ptr as usize },
                    19352usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onopen_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onorientationchange_string) as usize
                            - ptr as usize
                    },
                    19366usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onorientationchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onoverflow_string) as usize - ptr as usize
                    },
                    19406usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onoverflow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpagehide_string) as usize - ptr as usize
                    },
                    19428usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpagehide_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpageshow_string) as usize - ptr as usize
                    },
                    19450usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpageshow_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onpaste_string) as usize - ptr as usize },
                    19472usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpaste_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpayerdetailchange_string) as usize
                            - ptr as usize
                    },
                    19488usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpayerdetailchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpaymentmethodchange_string) as usize
                            - ptr as usize
                    },
                    19528usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpaymentmethodchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpointerlockchange_string) as usize
                            - ptr as usize
                    },
                    19572usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpointerlockchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpointerlockerror_string) as usize
                            - ptr as usize
                    },
                    19612usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpointerlockerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpopuphidden_string) as usize - ptr as usize
                    },
                    19650usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpopuphidden_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpopuphiding_string) as usize - ptr as usize
                    },
                    19678usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpopuphiding_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpopuppositioned_string) as usize
                            - ptr as usize
                    },
                    19706usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpopuppositioned_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpopupshowing_string) as usize - ptr as usize
                    },
                    19742usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpopupshowing_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpopupshown_string) as usize - ptr as usize
                    },
                    19772usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpopupshown_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onprocessorerror_string) as usize - ptr as usize
                    },
                    19798usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onprocessorerror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onprioritychange_string) as usize - ptr as usize
                    },
                    19832usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onprioritychange_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onpush_string) as usize - ptr as usize },
                    19866usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpush_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onpushsubscriptionchange_string) as usize
                            - ptr as usize
                    },
                    19880usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onpushsubscriptionchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onRadioStateChange_string) as usize
                            - ptr as usize
                    },
                    19930usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onRadioStateChange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onreadystatechange_string) as usize
                            - ptr as usize
                    },
                    19968usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onreadystatechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onrejectionhandled_string) as usize
                            - ptr as usize
                    },
                    20006usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onrejectionhandled_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onremove_string) as usize - ptr as usize },
                    20044usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onremove_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onrequestprogress_string) as usize
                            - ptr as usize
                    },
                    20062usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onrequestprogress_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onresourcetimingbufferfull_string) as usize
                            - ptr as usize
                    },
                    20098usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onresourcetimingbufferfull_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onresponseprogress_string) as usize
                            - ptr as usize
                    },
                    20152usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onresponseprogress_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onRequest_string) as usize - ptr as usize
                    },
                    20190usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onRequest_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onreset_string) as usize - ptr as usize },
                    20210usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onreset_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onresize_string) as usize - ptr as usize },
                    20226usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onresize_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onscroll_string) as usize - ptr as usize },
                    20244usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onscroll_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onsecuritypolicyviolation_string) as usize
                            - ptr as usize
                    },
                    20262usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onsecuritypolicyviolation_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onselect_string) as usize - ptr as usize },
                    20314usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onselect_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onselectionchange_string) as usize
                            - ptr as usize
                    },
                    20332usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onselectionchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onselectend_string) as usize - ptr as usize
                    },
                    20368usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onselectend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onselectstart_string) as usize - ptr as usize
                    },
                    20392usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onselectstart_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onset_string) as usize - ptr as usize },
                    20420usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onset_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onshippingaddresschange_string) as usize
                            - ptr as usize
                    },
                    20432usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onshippingaddresschange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onshippingoptionchange_string) as usize
                            - ptr as usize
                    },
                    20480usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onshippingoptionchange_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onshow_string) as usize - ptr as usize },
                    20526usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onshow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onslotchange_string) as usize - ptr as usize
                    },
                    20540usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onslotchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onsqueeze_string) as usize - ptr as usize
                    },
                    20566usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onsqueeze_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onsqueezeend_string) as usize - ptr as usize
                    },
                    20586usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onsqueezeend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onsqueezestart_string) as usize - ptr as usize
                    },
                    20612usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onsqueezestart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onstatechange_string) as usize - ptr as usize
                    },
                    20642usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onstatechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onstorage_string) as usize - ptr as usize
                    },
                    20670usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onstorage_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onsubmit_string) as usize - ptr as usize },
                    20690usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onsubmit_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onsuccess_string) as usize - ptr as usize
                    },
                    20708usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onsuccess_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onsystemstatusbarclick_string) as usize
                            - ptr as usize
                    },
                    20728usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onsystemstatusbarclick_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontypechange_string) as usize - ptr as usize
                    },
                    20774usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontypechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onterminate_string) as usize - ptr as usize
                    },
                    20800usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onterminate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ontext_string) as usize - ptr as usize },
                    20824usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontext_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontextInput_string) as usize - ptr as usize
                    },
                    20838usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontextInput_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ontoggle_string) as usize - ptr as usize },
                    20862usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontoggle_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontonechange_string) as usize - ptr as usize
                    },
                    20880usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontonechange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontouchstart_string) as usize - ptr as usize
                    },
                    20906usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontouchstart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontouchend_string) as usize - ptr as usize
                    },
                    20932usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontouchend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontouchmove_string) as usize - ptr as usize
                    },
                    20954usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontouchmove_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontouchcancel_string) as usize - ptr as usize
                    },
                    20978usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontouchcancel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontransitioncancel_string) as usize
                            - ptr as usize
                    },
                    21006usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontransitioncancel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontransitionend_string) as usize - ptr as usize
                    },
                    21044usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontransitionend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontransitionrun_string) as usize - ptr as usize
                    },
                    21076usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontransitionrun_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).ontransitionstart_string) as usize
                            - ptr as usize
                    },
                    21108usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ontransitionstart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onuncapturederror_string) as usize
                            - ptr as usize
                    },
                    21144usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onuncapturederror_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onunderflow_string) as usize - ptr as usize
                    },
                    21180usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onunderflow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onunhandledrejection_string) as usize
                            - ptr as usize
                    },
                    21204usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onunhandledrejection_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onunload_string) as usize - ptr as usize },
                    21246usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onunload_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onunmute_string) as usize - ptr as usize },
                    21264usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onunmute_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onupdatefound_string) as usize - ptr as usize
                    },
                    21282usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onupdatefound_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onupdateready_string) as usize - ptr as usize
                    },
                    21310usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onupdateready_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onupgradeneeded_string) as usize - ptr as usize
                    },
                    21338usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onupgradeneeded_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onversionchange_string) as usize - ptr as usize
                    },
                    21370usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onversionchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onvisibilitychange_string) as usize
                            - ptr as usize
                    },
                    21402usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onvisibilitychange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onvoiceschanged_string) as usize - ptr as usize
                    },
                    21440usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onvoiceschanged_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onvrdisplayactivate_string) as usize
                            - ptr as usize
                    },
                    21472usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onvrdisplayactivate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onvrdisplayconnect_string) as usize
                            - ptr as usize
                    },
                    21512usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onvrdisplayconnect_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onvrdisplaydeactivate_string) as usize
                            - ptr as usize
                    },
                    21550usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onvrdisplaydeactivate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onvrdisplaydisconnect_string) as usize
                            - ptr as usize
                    },
                    21594usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onvrdisplaydisconnect_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onvrdisplaypresentchange_string) as usize
                            - ptr as usize
                    },
                    21638usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onvrdisplaypresentchange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkitAnimationEnd_string) as usize
                            - ptr as usize
                    },
                    21688usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkitAnimationEnd_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkitAnimationIteration_string) as usize
                            - ptr as usize
                    },
                    21730usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkitAnimationIteration_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkitAnimationStart_string) as usize
                            - ptr as usize
                    },
                    21784usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkitAnimationStart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkitTransitionEnd_string) as usize
                            - ptr as usize
                    },
                    21830usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkitTransitionEnd_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkitanimationend_string) as usize
                            - ptr as usize
                    },
                    21874usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkitanimationend_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkitanimationiteration_string) as usize
                            - ptr as usize
                    },
                    21916usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkitanimationiteration_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkitanimationstart_string) as usize
                            - ptr as usize
                    },
                    21970usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkitanimationstart_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).onwebkittransitionend_string) as usize
                            - ptr as usize
                    },
                    22016usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwebkittransitionend_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).onwheel_string) as usize - ptr as usize },
                    22060usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(onwheel_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).open_string) as usize - ptr as usize },
                    22076usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(open_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).optgroup_string) as usize - ptr as usize },
                    22086usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(optgroup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).optimum_string) as usize - ptr as usize },
                    22104usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(optimum_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).option_string) as usize - ptr as usize },
                    22120usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(option_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr)._or_string) as usize - ptr as usize },
                    22134usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_or_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).order_string) as usize - ptr as usize },
                    22140usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(order_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ordinal_string) as usize - ptr as usize },
                    22152usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ordinal_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).orient_string) as usize - ptr as usize },
                    22168usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(orient_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).orientation_string) as usize - ptr as usize
                    },
                    22182usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(orientation_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).origin_trial_string) as usize - ptr as usize
                    },
                    22206usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(origin_trial_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).otherwise_string) as usize - ptr as usize
                    },
                    22232usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(otherwise_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).outerHTML_string) as usize - ptr as usize
                    },
                    22252usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(outerHTML_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).output_string) as usize - ptr as usize },
                    22272usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(output_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).overflow_string) as usize - ptr as usize },
                    22286usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(overflow_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).overflowBlock_string) as usize - ptr as usize
                    },
                    22304usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(overflowBlock_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).overflowInline_string) as usize - ptr as usize
                    },
                    22334usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(overflowInline_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).overlay_string) as usize - ptr as usize },
                    22366usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(overlay_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).p_string) as usize - ptr as usize },
                    22382usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(p_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).pack_string) as usize - ptr as usize },
                    22386usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(pack_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).page_string) as usize - ptr as usize },
                    22396usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(page_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).pageincrement_string) as usize - ptr as usize
                    },
                    22406usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(pageincrement_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).paint_string) as usize - ptr as usize },
                    22434usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(paint_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).paint_order_string) as usize - ptr as usize
                    },
                    22446usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(paint_order_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).panel_string) as usize - ptr as usize },
                    22470usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(panel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).paragraph_string) as usize - ptr as usize
                    },
                    22482usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(paragraph_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).param_string) as usize - ptr as usize },
                    22502usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(param_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).parameter_string) as usize - ptr as usize
                    },
                    22514usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(parameter_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).parent_string) as usize - ptr as usize },
                    22534usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(parent_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).parsererror_string) as usize - ptr as usize
                    },
                    22548usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(parsererror_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).part_string) as usize - ptr as usize },
                    22572usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(part_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).password_string) as usize - ptr as usize },
                    22582usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(password_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).pattern_string) as usize - ptr as usize },
                    22600usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(pattern_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).patternSeparator_string) as usize - ptr as usize
                    },
                    22616usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(patternSeparator_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).perMille_string) as usize - ptr as usize },
                    22652usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(perMille_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).percent_string) as usize - ptr as usize },
                    22672usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(percent_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).persist_string) as usize - ptr as usize },
                    22688usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(persist_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).phase_string) as usize - ptr as usize },
                    22704usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(phase_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).picture_string) as usize - ptr as usize },
                    22716usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(picture_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ping_string) as usize - ptr as usize },
                    22732usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ping_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).pinned_string) as usize - ptr as usize },
                    22742usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(pinned_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).placeholder_string) as usize - ptr as usize
                    },
                    22756usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(placeholder_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).plaintext_string) as usize - ptr as usize
                    },
                    22780usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(plaintext_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).plaintextOnly_string) as usize - ptr as usize
                    },
                    22800usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(plaintextOnly_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).playbackrate_string) as usize - ptr as usize
                    },
                    22830usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(playbackrate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).pointSize_string) as usize - ptr as usize
                    },
                    22856usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(pointSize_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).poly_string) as usize - ptr as usize },
                    22878usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(poly_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).polygon_string) as usize - ptr as usize },
                    22888usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(polygon_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).popover_string) as usize - ptr as usize },
                    22904usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popover_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).popovertarget_string) as usize - ptr as usize
                    },
                    22920usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popovertarget_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).popovertargetaction_string) as usize
                            - ptr as usize
                    },
                    22948usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popovertargetaction_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).popup_string) as usize - ptr as usize },
                    22988usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popup_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).popupalign_string) as usize - ptr as usize
                    },
                    23000usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popupalign_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).popupanchor_string) as usize - ptr as usize
                    },
                    23022usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popupanchor_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).popupgroup_string) as usize - ptr as usize
                    },
                    23046usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popupgroup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).popupset_string) as usize - ptr as usize },
                    23068usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popupset_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).popupsinherittooltip_string) as usize
                            - ptr as usize
                    },
                    23086usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(popupsinherittooltip_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).portal_string) as usize - ptr as usize },
                    23128usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(portal_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).position_string) as usize - ptr as usize },
                    23142usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(position_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).poster_string) as usize - ptr as usize },
                    23160usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(poster_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).pre_string) as usize - ptr as usize },
                    23174usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(pre_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).preceding_string) as usize - ptr as usize
                    },
                    23182usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(preceding_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).precedingSibling_string) as usize - ptr as usize
                    },
                    23202usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(precedingSibling_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).prefersReducedMotion_string) as usize
                            - ptr as usize
                    },
                    23238usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(prefersReducedMotion_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).prefersReducedTransparency_string) as usize
                            - ptr as usize
                    },
                    23284usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(prefersReducedTransparency_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).prefersColorScheme_string) as usize
                            - ptr as usize
                    },
                    23342usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(prefersColorScheme_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).prefersContrast_string) as usize - ptr as usize
                    },
                    23384usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(prefersContrast_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).prefix_string) as usize - ptr as usize },
                    23418usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(prefix_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).prefwidth_string) as usize - ptr as usize
                    },
                    23432usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(prefwidth_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).queue_string) as usize - ptr as usize },
                    23452usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(queue_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).dynamicRange_string) as usize - ptr as usize
                    },
                    23464usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(dynamicRange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).videoDynamicRange_string) as usize
                            - ptr as usize
                    },
                    23492usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(videoDynamicRange_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scripting_string) as usize - ptr as usize
                    },
                    23532usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scripting_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).preload_string) as usize - ptr as usize },
                    23552usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(preload_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).preserve_string) as usize - ptr as usize },
                    23568usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(preserve_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).preserveSpace_string) as usize - ptr as usize
                    },
                    23586usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(preserveSpace_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).preventdefault_string) as usize - ptr as usize
                    },
                    23616usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(preventdefault_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).previewDiv_string) as usize - ptr as usize
                    },
                    23646usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(previewDiv_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).primary_string) as usize - ptr as usize },
                    23670usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(primary_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).print_string) as usize - ptr as usize },
                    23686usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(print_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).printisfocuseddoc_string) as usize
                            - ptr as usize
                    },
                    23698usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(printisfocuseddoc_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).printselectionranges_string) as usize
                            - ptr as usize
                    },
                    23734usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(printselectionranges_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).priority_string) as usize - ptr as usize },
                    23776usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(priority_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).processingInstruction_string) as usize
                            - ptr as usize
                    },
                    23794usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(processingInstruction_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).profile_string) as usize - ptr as usize },
                    23840usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(profile_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).progress_string) as usize - ptr as usize },
                    23856usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(progress_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).prompt_string) as usize - ptr as usize },
                    23874usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(prompt_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).properties_string) as usize - ptr as usize
                    },
                    23888usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(properties_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).property_string) as usize - ptr as usize },
                    23910usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(property_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).pubdate_string) as usize - ptr as usize },
                    23928usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(pubdate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).q_string) as usize - ptr as usize },
                    23944usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(q_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).radio_string) as usize - ptr as usize },
                    23948usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(radio_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).radioLabel_string) as usize - ptr as usize
                    },
                    23960usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(radioLabel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).radiogroup_string) as usize - ptr as usize
                    },
                    23984usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(radiogroup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).range_string) as usize - ptr as usize },
                    24006usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(range_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).readonly_string) as usize - ptr as usize },
                    24018usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(readonly_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rect_string) as usize - ptr as usize },
                    24036usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rect_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).rectangle_string) as usize - ptr as usize
                    },
                    24046usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rectangle_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).refresh_string) as usize - ptr as usize },
                    24066usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(refresh_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rel_string) as usize - ptr as usize },
                    24082usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).relativeBounds_string) as usize - ptr as usize
                    },
                    24090usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(relativeBounds_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rem_string) as usize - ptr as usize },
                    24122usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rem_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).remote_string) as usize - ptr as usize },
                    24130usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(remote_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).removeelement_string) as usize - ptr as usize
                    },
                    24144usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(removeelement_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).render_string) as usize - ptr as usize },
                    24172usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(render_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).renderingobserverset_string) as usize
                            - ptr as usize
                    },
                    24186usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(renderingobserverset_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).repeat_string) as usize - ptr as usize },
                    24228usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(repeat_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).replace_string) as usize - ptr as usize },
                    24242usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(replace_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).requestcontextid_string) as usize - ptr as usize
                    },
                    24258usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(requestcontextid_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).required_string) as usize - ptr as usize },
                    24292usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(required_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).reserved_string) as usize - ptr as usize },
                    24310usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(reserved_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).reset_string) as usize - ptr as usize },
                    24328usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(reset_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).resizeafter_string) as usize - ptr as usize
                    },
                    24340usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(resizeafter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).resizebefore_string) as usize - ptr as usize
                    },
                    24364usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(resizebefore_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).resizer_string) as usize - ptr as usize },
                    24390usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(resizer_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).resolution_string) as usize - ptr as usize
                    },
                    24406usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(resolution_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).resources_string) as usize - ptr as usize
                    },
                    24428usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(resources_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).result_string) as usize - ptr as usize },
                    24448usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(result_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).resultPrefix_string) as usize - ptr as usize
                    },
                    24462usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(resultPrefix_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).retargetdocumentfocus_string) as usize
                            - ptr as usize
                    },
                    24490usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(retargetdocumentfocus_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rev_string) as usize - ptr as usize },
                    24534usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rev_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).reverse_string) as usize - ptr as usize },
                    24542usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(reverse_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).reversed_string) as usize - ptr as usize },
                    24558usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(reversed_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rhs_string) as usize - ptr as usize },
                    24576usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rhs_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).richlistbox_string) as usize - ptr as usize
                    },
                    24584usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(richlistbox_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).richlistitem_string) as usize - ptr as usize
                    },
                    24608usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(richlistitem_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).right_string) as usize - ptr as usize },
                    24634usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(right_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).rightmargin_string) as usize - ptr as usize
                    },
                    24646usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rightmargin_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).role_string) as usize - ptr as usize },
                    24670usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(role_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).rolluponmousewheel_string) as usize
                            - ptr as usize
                    },
                    24680usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rolluponmousewheel_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).round_string) as usize - ptr as usize },
                    24718usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(round_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).row_string) as usize - ptr as usize },
                    24730usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(row_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rows_string) as usize - ptr as usize },
                    24738usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rows_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rowspan_string) as usize - ptr as usize },
                    24748usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rowspan_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rb_string) as usize - ptr as usize },
                    24764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rb_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rp_string) as usize - ptr as usize },
                    24770usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rp_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rt_string) as usize - ptr as usize },
                    24776usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rt_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rtc_string) as usize - ptr as usize },
                    24782usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rtc_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rtl_string) as usize - ptr as usize },
                    24790usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rtl_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).ruby_string) as usize - ptr as usize },
                    24798usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(ruby_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rubyBase_string) as usize - ptr as usize },
                    24808usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rubyBase_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).rubyBaseContainer_string) as usize
                            - ptr as usize
                    },
                    24828usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rubyBaseContainer_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rubyText_string) as usize - ptr as usize },
                    24868usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rubyText_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).rubyTextContainer_string) as usize
                            - ptr as usize
                    },
                    24888usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rubyTextContainer_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).rules_string) as usize - ptr as usize },
                    24928usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(rules_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).s_string) as usize - ptr as usize },
                    24940usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(s_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).safe_area_inset_top_string) as usize
                            - ptr as usize
                    },
                    24944usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(safe_area_inset_top_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).safe_area_inset_bottom_string) as usize
                            - ptr as usize
                    },
                    24984usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(safe_area_inset_bottom_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).safe_area_inset_left_string) as usize
                            - ptr as usize
                    },
                    25030usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(safe_area_inset_left_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).safe_area_inset_right_string) as usize
                            - ptr as usize
                    },
                    25072usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(safe_area_inset_right_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).samp_string) as usize - ptr as usize },
                    25116usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(samp_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sandbox_string) as usize - ptr as usize },
                    25126usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sandbox_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sbattr_string) as usize - ptr as usize },
                    25142usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sbattr_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).scale_string) as usize - ptr as usize },
                    25156usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scale_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).scan_string) as usize - ptr as usize },
                    25168usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scan_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).scheme_string) as usize - ptr as usize },
                    25178usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scheme_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).scope_string) as usize - ptr as usize },
                    25192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scope_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).scoped_string) as usize - ptr as usize },
                    25204usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scoped_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).screen_string) as usize - ptr as usize },
                    25218usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(screen_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).screenX_string) as usize - ptr as usize },
                    25232usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(screenX_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).screenx_string) as usize - ptr as usize },
                    25248usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(screenx_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).screenY_string) as usize - ptr as usize },
                    25264usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(screenY_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).screeny_string) as usize - ptr as usize },
                    25280usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(screeny_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).script_string) as usize - ptr as usize },
                    25296usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(script_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbar_string) as usize - ptr as usize
                    },
                    25310usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbar_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbarThumb_string) as usize - ptr as usize
                    },
                    25330usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbarThumb_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollamount_string) as usize - ptr as usize
                    },
                    25362usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollamount_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbarbutton_string) as usize - ptr as usize
                    },
                    25388usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbarbutton_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbarDownBottom_string) as usize
                            - ptr as usize
                    },
                    25420usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbarDownBottom_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbarDownTop_string) as usize - ptr as usize
                    },
                    25464usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbarDownTop_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbarInlineSize_string) as usize
                            - ptr as usize
                    },
                    25502usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbarInlineSize_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbarUpBottom_string) as usize
                            - ptr as usize
                    },
                    25546usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbarUpBottom_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbarUpTop_string) as usize - ptr as usize
                    },
                    25586usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbarUpTop_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollbox_string) as usize - ptr as usize
                    },
                    25620usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollbox_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollcorner_string) as usize - ptr as usize
                    },
                    25640usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollcorner_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrolldelay_string) as usize - ptr as usize
                    },
                    25666usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrolldelay_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrolling_string) as usize - ptr as usize
                    },
                    25690usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrolling_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).scrollPosition_string) as usize - ptr as usize
                    },
                    25710usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(scrollPosition_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).se_string) as usize - ptr as usize },
                    25742usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(se_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).section_string) as usize - ptr as usize },
                    25748usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(section_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).select_string) as usize - ptr as usize },
                    25764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(select_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).selected_string) as usize - ptr as usize },
                    25778usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(selected_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).selectedIndex_string) as usize - ptr as usize
                    },
                    25796usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(selectedIndex_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).selectedindex_string) as usize - ptr as usize
                    },
                    25824usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(selectedindex_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).selectmenu_string) as usize - ptr as usize
                    },
                    25852usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(selectmenu_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).self_string) as usize - ptr as usize },
                    25874usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(self_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).seltype_string) as usize - ptr as usize },
                    25884usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(seltype_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).setcookie_string) as usize - ptr as usize
                    },
                    25900usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(setcookie_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).setter_string) as usize - ptr as usize },
                    25922usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(setter_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).shadow_string) as usize - ptr as usize },
                    25936usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(shadow_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).shape_string) as usize - ptr as usize },
                    25950usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(shape_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).show_string) as usize - ptr as usize },
                    25962usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(show_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).showcaret_string) as usize - ptr as usize
                    },
                    25972usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(showcaret_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).show_modal_string) as usize - ptr as usize
                    },
                    25992usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(show_modal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).show_popover_string) as usize - ptr as usize
                    },
                    26014usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(show_popover_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).showservicesmenu_string) as usize - ptr as usize
                    },
                    26040usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(showservicesmenu_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sibling_string) as usize - ptr as usize },
                    26074usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sibling_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).simple_string) as usize - ptr as usize },
                    26090usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(simple_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).simp_chinese_formal_string) as usize
                            - ptr as usize
                    },
                    26104usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(simp_chinese_formal_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).simp_chinese_informal_string) as usize
                            - ptr as usize
                    },
                    26144usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(simp_chinese_informal_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).single_string) as usize - ptr as usize },
                    26188usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(single_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).size_string) as usize - ptr as usize },
                    26202usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(size_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sizes_string) as usize - ptr as usize },
                    26212usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sizes_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sizemode_string) as usize - ptr as usize },
                    26224usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sizemode_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).sizetopopup_string) as usize - ptr as usize
                    },
                    26242usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sizetopopup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).slider_string) as usize - ptr as usize },
                    26266usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(slider_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).small_string) as usize - ptr as usize },
                    26280usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(small_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).smooth_string) as usize - ptr as usize },
                    26292usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(smooth_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).snap_string) as usize - ptr as usize },
                    26306usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(snap_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).solid_string) as usize - ptr as usize },
                    26316usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(solid_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sort_string) as usize - ptr as usize },
                    26328usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sort_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).sortActive_string) as usize - ptr as usize
                    },
                    26338usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sortActive_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).sortDirection_string) as usize - ptr as usize
                    },
                    26360usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sortDirection_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sorted_string) as usize - ptr as usize },
                    26388usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sorted_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).sorthints_string) as usize - ptr as usize
                    },
                    26402usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sorthints_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).source_string) as usize - ptr as usize },
                    26422usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(source_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).sourcetext_string) as usize - ptr as usize
                    },
                    26436usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sourcetext_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).space_string) as usize - ptr as usize },
                    26458usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(space_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).spacer_string) as usize - ptr as usize },
                    26470usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(spacer_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).span_string) as usize - ptr as usize },
                    26484usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(span_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).spellcheck_string) as usize - ptr as usize
                    },
                    26494usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(spellcheck_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).split_string) as usize - ptr as usize },
                    26516usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(split_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).splitter_string) as usize - ptr as usize },
                    26528usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(splitter_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).square_string) as usize - ptr as usize },
                    26546usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(square_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).src_string) as usize - ptr as usize },
                    26560usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(src_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).srcdoc_string) as usize - ptr as usize },
                    26568usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(srcdoc_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).srclang_string) as usize - ptr as usize },
                    26582usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(srclang_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).srcset_string) as usize - ptr as usize },
                    26598usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(srcset_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).standalone_string) as usize - ptr as usize
                    },
                    26612usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(standalone_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).standby_string) as usize - ptr as usize },
                    26634usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(standby_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).start_string) as usize - ptr as usize },
                    26650usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(start_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).startsWith_string) as usize - ptr as usize
                    },
                    26662usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(startsWith_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).state_string) as usize - ptr as usize },
                    26686usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(state_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).statusbar_string) as usize - ptr as usize
                    },
                    26698usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(statusbar_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).step_string) as usize - ptr as usize },
                    26718usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(step_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).stop_string) as usize - ptr as usize },
                    26728usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(stop_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).stretch_string) as usize - ptr as usize },
                    26738usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(stretch_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).strike_string) as usize - ptr as usize },
                    26754usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(strike_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).string_string) as usize - ptr as usize },
                    26768usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(string_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).stringLength_string) as usize - ptr as usize
                    },
                    26782usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(stringLength_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).stripSpace_string) as usize - ptr as usize
                    },
                    26810usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(stripSpace_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).strong_string) as usize - ptr as usize },
                    26834usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(strong_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).style_string) as usize - ptr as usize },
                    26848usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(style_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).stylesheet_string) as usize - ptr as usize
                    },
                    26860usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(stylesheet_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).stylesheetPrefix_string) as usize - ptr as usize
                    },
                    26882usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(stylesheetPrefix_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).submit_string) as usize - ptr as usize },
                    26918usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(submit_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).substate_string) as usize - ptr as usize },
                    26932usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(substate_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).substring_string) as usize - ptr as usize
                    },
                    26950usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(substring_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).substringAfter_string) as usize - ptr as usize
                    },
                    26970usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(substringAfter_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).substringBefore_string) as usize - ptr as usize
                    },
                    27002usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(substringBefore_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sub_string) as usize - ptr as usize },
                    27036usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sub_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).suggestion_string) as usize - ptr as usize
                    },
                    27044usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(suggestion_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sum_string) as usize - ptr as usize },
                    27066usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sum_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sup_string) as usize - ptr as usize },
                    27074usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sup_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).summary_string) as usize - ptr as usize },
                    27082usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(summary_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).sw_string) as usize - ptr as usize },
                    27098usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(sw_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).systemProperty_string) as usize - ptr as usize
                    },
                    27104usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(systemProperty_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tab_string) as usize - ptr as usize },
                    27136usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tab_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tabindex_string) as usize - ptr as usize },
                    27144usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tabindex_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).table_string) as usize - ptr as usize },
                    27162usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(table_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tabpanel_string) as usize - ptr as usize },
                    27174usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tabpanel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).tabpanels_string) as usize - ptr as usize
                    },
                    27192usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tabpanels_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tag_string) as usize - ptr as usize },
                    27212usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tag_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).target_string) as usize - ptr as usize },
                    27220usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(target_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).targets_string) as usize - ptr as usize },
                    27234usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(targets_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tbody_string) as usize - ptr as usize },
                    27250usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tbody_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).td_string) as usize - ptr as usize },
                    27262usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(td_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tel_string) as usize - ptr as usize },
                    27268usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tel_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr)._template_string) as usize - ptr as usize
                    },
                    27276usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(_template_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).text_decoration_string) as usize - ptr as usize
                    },
                    27294usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(text_decoration_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).terminate_string) as usize - ptr as usize
                    },
                    27326usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(terminate_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).term_string) as usize - ptr as usize },
                    27346usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(term_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).test_string) as usize - ptr as usize },
                    27356usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(test_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).text_string) as usize - ptr as usize },
                    27366usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(text_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).textAlign_string) as usize - ptr as usize
                    },
                    27376usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(textAlign_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).textarea_string) as usize - ptr as usize },
                    27398usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(textarea_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).textbox_string) as usize - ptr as usize },
                    27416usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(textbox_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).textContent_string) as usize - ptr as usize
                    },
                    27432usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(textContent_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).textLink_string) as usize - ptr as usize },
                    27456usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(textLink_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).textOverlay_string) as usize - ptr as usize
                    },
                    27476usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(textOverlay_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tfoot_string) as usize - ptr as usize },
                    27502usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tfoot_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).th_string) as usize - ptr as usize },
                    27514usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(th_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).thead_string) as usize - ptr as usize },
                    27520usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(thead_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).thumb_string) as usize - ptr as usize },
                    27532usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(thumb_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).time_string) as usize - ptr as usize },
                    27544usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(time_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).title_string) as usize - ptr as usize },
                    27554usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(title_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).titletip_string) as usize - ptr as usize },
                    27566usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(titletip_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).toggle_string) as usize - ptr as usize },
                    27584usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(toggle_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).toggle_popover_string) as usize - ptr as usize
                    },
                    27598usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(toggle_popover_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).token_string) as usize - ptr as usize },
                    27628usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(token_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tokenize_string) as usize - ptr as usize },
                    27640usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tokenize_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).toolbar_string) as usize - ptr as usize },
                    27658usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(toolbar_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).toolbarbutton_string) as usize - ptr as usize
                    },
                    27674usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(toolbarbutton_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).toolbaritem_string) as usize - ptr as usize
                    },
                    27702usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(toolbaritem_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).toolbarpaletteitem_string) as usize
                            - ptr as usize
                    },
                    27726usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(toolbarpaletteitem_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).toolbox_string) as usize - ptr as usize },
                    27764usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(toolbox_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).tooltip_string) as usize - ptr as usize },
                    27780usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tooltip_string)
                    )
                );
                assert_eq!(
                    unsafe {
                        ::std::ptr::addr_of!((*ptr).tooltiptext_string) as usize - ptr as usize
                    },
                    27796usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        "::",
                        stringify!(tooltiptext_string)
                    )
                );
                assert_eq!(
                    unsafe { ::std::ptr::addr_of!((*ptr).top_string) as usize - ptr as usize },
                    27820usize,
                    concat!(
                        "Offset of field: ",
                        stringify!(GkAtoms),
                        