//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/hal_sandbox/PHalChild.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/dom/ReferrerInfoUtils.h"

#include "mozilla/dom/PContentChild.h"
#include "mozilla/dom/PBrowserChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace hal_sandbox {


MOZ_IMPLICIT PHalChild::PHalChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PHalChild);
}

PHalChild::~PHalChild()
{
    MOZ_COUNT_DTOR(PHalChild);
}

auto PHalChild::ActorAlloc() -> void
{
}

auto PHalChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PHalChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PHalChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PHalChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PHalChild::Manager() const -> PContentChild*
{
    return static_cast<PContentChild*>(IProtocol::Manager());
}

auto PHalChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PHalChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PHalChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PHalChild::SendVibrate(
        mozilla::Span<uint32_t const> pattern,
        mozilla::Span<uint64_t const> id,
        mozilla::NotNull<PBrowserChild*> browser) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_Vibrate(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pattern);
    // Sentinel = 'pattern'
    ((&(writer__)))->WriteSentinel(200409855);
    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), browser);
    // Sentinel = 'browser'
    ((&(writer__)))->WriteSentinel(201130757);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_Vibrate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendCancelVibrate(
        mozilla::Span<uint64_t const> id,
        mozilla::NotNull<PBrowserChild*> browser) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_CancelVibrate(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), browser);
    // Sentinel = 'browser'
    ((&(writer__)))->WriteSentinel(201130757);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_CancelVibrate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendEnableBatteryNotifications() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_EnableBatteryNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_EnableBatteryNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendDisableBatteryNotifications() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_DisableBatteryNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_DisableBatteryNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendGetCurrentBatteryInformation(BatteryInformation* aBatteryInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_GetCurrentBatteryInformation(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};


    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_GetCurrentBatteryInformation", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PHal::Msg_GetCurrentBatteryInformation", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__aBatteryInfo__reply = IPC::ReadParam<BatteryInformation>((&(reader__)));
    if (!maybe__aBatteryInfo__reply) {
        FatalError("Error deserializing 'BatteryInformation'");
        return false;

    }
    auto& aBatteryInfo__reply = *maybe__aBatteryInfo__reply;
    // Sentinel = 'aBatteryInfo'
    if ((!(((&(reader__)))->ReadSentinel(509674697)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'BatteryInformation'");
        return false;
    }
    (*(aBatteryInfo)) = std::move(aBatteryInfo__reply);
    reader__.EndRead();

    return true;
}

auto PHalChild::SendEnableNetworkNotifications() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_EnableNetworkNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_EnableNetworkNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendDisableNetworkNotifications() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_DisableNetworkNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_DisableNetworkNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendGetCurrentNetworkInformation(NetworkInformation* aNetworkInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_GetCurrentNetworkInformation(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};


    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_GetCurrentNetworkInformation", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PHal::Msg_GetCurrentNetworkInformation", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__aNetworkInfo__reply = IPC::ReadParam<NetworkInformation>((&(reader__)));
    if (!maybe__aNetworkInfo__reply) {
        FatalError("Error deserializing 'NetworkInformation'");
        return false;

    }
    auto& aNetworkInfo__reply = *maybe__aNetworkInfo__reply;
    // Sentinel = 'aNetworkInfo'
    if ((!(((&(reader__)))->ReadSentinel(522519768)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'NetworkInformation'");
        return false;
    }
    (*(aNetworkInfo)) = std::move(aNetworkInfo__reply);
    reader__.EndRead();

    return true;
}

auto PHalChild::SendModifyWakeLock(
        const nsAString& aTopic,
        const WakeLockControl& aLockAdjust,
        const WakeLockControl& aHiddenAdjust) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_ModifyWakeLock(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aTopic);
    // Sentinel = 'aTopic'
    ((&(writer__)))->WriteSentinel(137429601);
    IPC::WriteParam((&(writer__)), aLockAdjust);
    // Sentinel = 'aLockAdjust'
    ((&(writer__)))->WriteSentinel(418710614);
    IPC::WriteParam((&(writer__)), aHiddenAdjust);
    // Sentinel = 'aHiddenAdjust'
    ((&(writer__)))->WriteSentinel(575538457);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_ModifyWakeLock", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendEnableWakeLockNotifications() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_EnableWakeLockNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_EnableWakeLockNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendDisableWakeLockNotifications() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_DisableWakeLockNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_DisableWakeLockNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendGetWakeLockInfo(
        const nsAString& aTopic,
        WakeLockInformation* aWakeLockInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_GetWakeLockInfo(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aTopic);
    // Sentinel = 'aTopic'
    ((&(writer__)))->WriteSentinel(137429601);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_GetWakeLockInfo", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PHal::Msg_GetWakeLockInfo", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__aWakeLockInfo__reply = IPC::ReadParam<WakeLockInformation>((&(reader__)));
    if (!maybe__aWakeLockInfo__reply) {
        FatalError("Error deserializing 'WakeLockInformation'");
        return false;

    }
    auto& aWakeLockInfo__reply = *maybe__aWakeLockInfo__reply;
    // Sentinel = 'aWakeLockInfo'
    if ((!(((&(reader__)))->ReadSentinel(577701119)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'WakeLockInformation'");
        return false;
    }
    (*(aWakeLockInfo)) = std::move(aWakeLockInfo__reply);
    reader__.EndRead();

    return true;
}

auto PHalChild::SendLockScreenOrientation(
        const ScreenOrientation& aOrientation,
        mozilla::ipc::ResolveCallback<nsresult>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_LockScreenOrientation(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aOrientation);
    // Sentinel = 'aOrientation'
    ((&(writer__)))->WriteSentinel(524289262);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_LockScreenOrientation", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PHal::Reply_LockScreenOrientation__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__result = IPC::ReadParam<nsresult>(aReader);
            if (!maybe__result) {
                (aReader)->FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& result = *maybe__result;
            // Sentinel = 'result'
            if ((!((aReader)->ReadSentinel(153223840)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(result));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PHalChild::SendLockScreenOrientation(const ScreenOrientation& aOrientation) -> RefPtr<LockScreenOrientationPromise>
{
    RefPtr<MozPromise<nsresult, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsresult, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendLockScreenOrientation(std::move(aOrientation), [promise__](nsresult&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PHalChild::SendUnlockScreenOrientation() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_UnlockScreenOrientation(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_UnlockScreenOrientation", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendPerformHapticFeedback(const int32_t& aType) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_PerformHapticFeedback(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aType);
    // Sentinel = 'aType'
    ((&(writer__)))->WriteSentinel(99222020);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_PerformHapticFeedback", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendEnableSensorNotifications(const SensorType& aSensor) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_EnableSensorNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSensor);
    // Sentinel = 'aSensor'
    ((&(writer__)))->WriteSentinel(184156892);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_EnableSensorNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::SendDisableSensorNotifications(const SensorType& aSensor) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_DisableSensorNotifications(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSensor);
    // Sentinel = 'aSensor'
    ((&(writer__)))->WriteSentinel(184156892);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_DisableSensorNotifications", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalChild::Send__delete__(PHalChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PHal::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PHalChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PHalChild::OnMessageReceived(const Message& msg__) -> PHalChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PHal::Msg_NotifyBatteryChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_NotifyBatteryChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aBatteryInfo = IPC::ReadParam<BatteryInformation>((&(reader__)));
            if (!maybe__aBatteryInfo) {
                FatalError("Error deserializing 'BatteryInformation'");
                return MsgValueError;

            }
            auto& aBatteryInfo = *maybe__aBatteryInfo;
            // Sentinel = 'aBatteryInfo'
            if ((!(((&(reader__)))->ReadSentinel(509674697)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'BatteryInformation'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNotifyBatteryChange(std::move(aBatteryInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_NotifyNetworkChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_NotifyNetworkChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aNetworkInfo = IPC::ReadParam<NetworkInformation>((&(reader__)));
            if (!maybe__aNetworkInfo) {
                FatalError("Error deserializing 'NetworkInformation'");
                return MsgValueError;

            }
            auto& aNetworkInfo = *maybe__aNetworkInfo;
            // Sentinel = 'aNetworkInfo'
            if ((!(((&(reader__)))->ReadSentinel(522519768)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NetworkInformation'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNotifyNetworkChange(std::move(aNetworkInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_NotifyWakeLockChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_NotifyWakeLockChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aWakeLockInfo = IPC::ReadParam<WakeLockInformation>((&(reader__)));
            if (!maybe__aWakeLockInfo) {
                FatalError("Error deserializing 'WakeLockInformation'");
                return MsgValueError;

            }
            auto& aWakeLockInfo = *maybe__aWakeLockInfo;
            // Sentinel = 'aWakeLockInfo'
            if ((!(((&(reader__)))->ReadSentinel(577701119)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WakeLockInformation'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNotifyWakeLockChange(std::move(aWakeLockInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Reply_LockScreenOrientation__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PHal::Msg_LockScreenOrientation", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PHal::Msg_NotifySensorChange__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_NotifySensorChange", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSensorData = IPC::ReadParam<SensorData>((&(reader__)));
            if (!maybe__aSensorData) {
                FatalError("Error deserializing 'SensorData'");
                return MsgValueError;

            }
            auto& aSensorData = *maybe__aSensorData;
            // Sentinel = 'aSensorData'
            if ((!(((&(reader__)))->ReadSentinel(434504790)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SensorData'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNotifySensorChange(std::move(aSensorData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PHalChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PHalChild::Result
{
    return MsgNotKnown;
}



} // namespace hal_sandbox
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::hal_sandbox::PHalChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PHal'
    (aWriter)->WriteSentinel(55181670);
}

auto ParamTraits<::mozilla::hal_sandbox::PHalChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PHal actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PHal'
    if ((!((aReader)->ReadSentinel(55181670)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PHal actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PHalMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PHal)");

        return {};
    }
    return static_cast<::mozilla::hal_sandbox::PHalChild*>(actor);
}

} // namespace IPC
