//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PClientSourceParent.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingIPCUtils.h"
#include "mozilla/dom/ClientIPCUtils.h"

#include "mozilla/dom/PClientManagerParent.h"
#include "mozilla/dom/PClientSourceOpParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


MOZ_IMPLICIT PClientSourceParent::PClientSourceParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PClientSourceParent);
}

PClientSourceParent::~PClientSourceParent()
{
    MOZ_COUNT_DTOR(PClientSourceParent);
}

auto PClientSourceParent::ActorAlloc() -> void
{
    AddRef();
}

auto PClientSourceParent::ActorDealloc() -> void
{
    Release();
}

auto PClientSourceParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PClientSourceParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PClientSourceParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PClientSourceParent::Manager() const -> PClientManagerParent*
{
    return static_cast<PClientManagerParent*>(IProtocol::Manager());
}

auto PClientSourceParent::ManagedPClientSourceOpParent(nsTArray<PClientSourceOpParent*>& aArr) const -> void
{
    mManagedPClientSourceOpParent.ToArray(aArr);
}

auto PClientSourceParent::ManagedPClientSourceOpParent() const -> const ManagedContainer<PClientSourceOpParent>&
{
    return mManagedPClientSourceOpParent;
}

auto PClientSourceParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PClientSourceOpMsgStart
    };
    return sIds;
}

auto PClientSourceParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PClientSourceOpMsgStart:
        return (&(mManagedPClientSourceOpParent));
    default:
        return nullptr;
    }
}

auto PClientSourceParent::OpenPClientSourceOpEndpoint(PClientSourceOpParent* aActor) -> ManagedEndpoint<PClientSourceOpChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientSourceOpParent actor");
        return ManagedEndpoint<PClientSourceOpChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientSourceOpParent actor");
        return ManagedEndpoint<PClientSourceOpChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientSourceOpChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientSourceParent::BindPClientSourceOpEndpoint(
        ManagedEndpoint<PClientSourceOpParent> aEndpoint,
        PClientSourceOpParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientSourceParent::SendPClientSourceOpConstructor(const ClientOpConstructorArgs& aArgs) -> PClientSourceOpParent*
{
    PClientSourceOpParent* actor = (this)->AllocPClientSourceOpParent(aArgs);
    return SendPClientSourceOpConstructor(std::move(actor), std::move(aArgs));
}

auto PClientSourceParent::SendPClientSourceOpConstructor(
        PClientSourceOpParent* actor,
        const ClientOpConstructorArgs& aArgs) -> PClientSourceOpParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PClientSourceOpParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientSourceOpParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PClientSource::Msg_PClientSourceOpConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientSourceParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientSource::Msg_PClientSourceOpConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PClientSourceOpParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PClientSourceParent::SendEvictFromBFCache() -> bool
{
    UniquePtr<IPC::Message> msg__ = PClientSource::Msg_EvictFromBFCache(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientSourceParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientSource::Msg_EvictFromBFCache", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PClientSourceParent::Send__delete__(PClientSourceParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PClientSource::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientSourceParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientSource::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PClientSourceParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PClientSourceOpMsgStart:
        this->DeallocPClientSourceOpParent(static_cast<PClientSourceOpParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PClientSourceParent::OnMessageReceived(const Message& msg__) -> PClientSourceParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PClientSource::Msg_Teardown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientSource::Msg_Teardown", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvTeardown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientSource::Msg_ExecutionReady__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientSource::Msg_ExecutionReady", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aArgs = IPC::ReadParam<ClientSourceExecutionReadyArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ClientSourceExecutionReadyArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClientSourceExecutionReadyArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvExecutionReady(std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientSource::Msg_Freeze__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientSource::Msg_Freeze", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvFreeze();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientSource::Msg_Thaw__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientSource::Msg_Thaw", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvThaw();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientSource::Msg_InheritController__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientSource::Msg_InheritController", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aArgs = IPC::ReadParam<ClientControlledArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ClientControlledArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClientControlledArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvInheritController(std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientSource::Msg_NoteDOMContentLoaded__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientSource::Msg_NoteDOMContentLoaded", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvNoteDOMContentLoaded();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientSource::Reply_PClientSourceOpConstructor__ID:
        {
            return MsgProcessed;
        }
    case PClientSource::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PClientSourceParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PClientSourceParent::Result
{
    switch (msg__.type()) {
    case PClientSource::Msg_WorkerSyncPing__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientSource::Msg_WorkerSyncPing", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            mozilla::ipc::IPCResult __ok = (this)->RecvWorkerSyncPing();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PClientSource::Reply_WorkerSyncPing(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            if (mozilla::ipc::LoggingEnabledFor("PClientSource", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientSourceParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PClientSourceParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PClientSource'
    (aWriter)->WriteSentinel(580519201);
}

auto ParamTraits<::mozilla::dom::PClientSourceParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PClientSource actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PClientSource'
    if ((!((aReader)->ReadSentinel(580519201)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PClientSource actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PClientSourceMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PClientSource)");

        return {};
    }
    return static_cast<::mozilla::dom::PClientSourceParent*>(actor);
}

} // namespace IPC
