/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM TCPSocketEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "TCPSocketEvent.h"
#include "TCPSocketEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/TCPSocket.h"
#include "mozilla/dom/TCPSocketEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(TCPSocketEvent)

NS_IMPL_ADDREF_INHERITED(TCPSocketEvent, Event)
NS_IMPL_RELEASE_INHERITED(TCPSocketEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(TCPSocketEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(TCPSocketEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRACE_JS_MEMBER_CALLBACK(mData)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(TCPSocketEvent, Event)
  tmp->mData.setUndefined();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(TCPSocketEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

TCPSocketEvent::TCPSocketEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

TCPSocketEvent::~TCPSocketEvent()
{
  mozilla::DropJSObjects(this);
}

void
TCPSocketEvent::GetData(JS::MutableHandle<JS::Value> aRetVal) const
{
  JS::ExposeValueToActiveJS(mData);
  aRetVal.set(mData);
}

TCPSocketEvent*
TCPSocketEvent::AsTCPSocketEvent()
{
  return this;
}

JSObject*
TCPSocketEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return TCPSocketEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<TCPSocketEvent>
TCPSocketEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const TCPSocketEventInit& aEventInitDict)
{
  RefPtr<TCPSocketEvent> e = new TCPSocketEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mData = aEventInitDict.mData;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  mozilla::HoldJSObjects(e.get());
  return e.forget();
}

already_AddRefed<TCPSocketEvent>
TCPSocketEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const TCPSocketEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
TCPSocketEvent::GetData(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const
{
  GetData(aRetVal);
}


} // namespace mozilla::dom
