/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM MediaStreamEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "DOMMediaStream.h"
#include "EventBinding.h"
#include "MediaStreamEvent.h"
#include "MediaStreamEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/MediaStreamEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(MediaStreamEvent)

NS_IMPL_ADDREF_INHERITED(MediaStreamEvent, Event)
NS_IMPL_RELEASE_INHERITED(MediaStreamEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(MediaStreamEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mStream)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(MediaStreamEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(MediaStreamEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mStream)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(MediaStreamEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

MediaStreamEvent::MediaStreamEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

MediaStreamEvent::~MediaStreamEvent()
{
}

MediaStreamEvent*
MediaStreamEvent::AsMediaStreamEvent()
{
  return this;
}

JSObject*
MediaStreamEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return MediaStreamEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<MediaStreamEvent>
MediaStreamEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const MediaStreamEventInit& aEventInitDict)
{
  RefPtr<MediaStreamEvent> e = new MediaStreamEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mStream = aEventInitDict.mStream;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<MediaStreamEvent>
MediaStreamEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const MediaStreamEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

DOMMediaStream*
MediaStreamEvent::GetStream() const
{
  return mStream;
}


} // namespace mozilla::dom
