/* THIS FILE IS AUTOGENERATED FROM CSSNumericValue.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_CSSNUMERICVALUEBINDING_H_
#define DOM_CSSNUMERICVALUEBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct CSSNumericTypeAtoms;
class CSSNumericValue;
struct NativePropertyHooks;
class OwningDoubleOrCSSNumericValue;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class CSSNumericBaseType : uint8_t {
  Length,
  Angle,
  Time,
  Frequency,
  Resolution,
  Flex,
  Percent,
};

namespace binding_detail {
template <> struct EnumStrings<CSSNumericBaseType> {
  static constexpr nsLiteralCString Values[7] {
    "length"_ns,
    "angle"_ns,
    "time"_ns,
    "frequency"_ns,
    "resolution"_ns,
    "flex"_ns,
    "percent"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, CSSNumericBaseType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningDoubleOrCSSNumericValue& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningDoubleOrCSSNumericValue& aUnion);


struct CSSNumericType : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mAngle;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mFlex;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mFrequency;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mLength;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPercent;
  MOZ_INIT_OUTSIDE_CTOR Optional<CSSNumericBaseType> mPercentHint;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mResolution;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mTime;

  CSSNumericType();

  explicit inline CSSNumericType(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CSSNumericType(CSSNumericType&& aOther) = default;

  explicit inline CSSNumericType(const CSSNumericType& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  CSSNumericType&
  operator=(const CSSNumericType& aOther);

private:
  static bool
  InitIds(JSContext* cx, CSSNumericTypeAtoms* atomsCache);
};

namespace binding_detail {
struct FastCSSNumericType : public CSSNumericType
{
  inline FastCSSNumericType()
    : CSSNumericType(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class DoubleOrCSSNumericValue : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eCSSNumericValue
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eCSSNumericValue = TypeOrUninit::eCSSNumericValue
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<NonNull<mozilla::dom::CSSNumericValue> > mCSSNumericValue;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrCSSNumericValue(const DoubleOrCSSNumericValue&) = delete;
  DoubleOrCSSNumericValue& operator=(const DoubleOrCSSNumericValue&) = delete;
public:
  explicit inline DoubleOrCSSNumericValue()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrCSSNumericValue()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CSSNumericValue>&
  RawSetAsCSSNumericValue()
  {
    if (mType == eCSSNumericValue) {
      return mValue.mCSSNumericValue.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eCSSNumericValue;
    return mValue.mCSSNumericValue.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::CSSNumericValue>&
  SetAsCSSNumericValue()
  {
    if (mType == eCSSNumericValue) {
      return mValue.mCSSNumericValue.Value();
    }
    Uninit();
    mType = eCSSNumericValue;
    return mValue.mCSSNumericValue.SetValue();
  }

  inline bool
  IsCSSNumericValue() const
  {
    return mType == eCSSNumericValue;
  }

  inline NonNull<mozilla::dom::CSSNumericValue>&
  GetAsCSSNumericValue()
  {
    MOZ_RELEASE_ASSERT(IsCSSNumericValue(), "Wrong type!");
    return mValue.mCSSNumericValue.Value();
  }

  inline mozilla::dom::CSSNumericValue&
  GetAsCSSNumericValue() const
  {
    MOZ_RELEASE_ASSERT(IsCSSNumericValue(), "Wrong type!");
    return mValue.mCSSNumericValue.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eCSSNumericValue: {
        DestroyCSSNumericValue();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToCSSNumericValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCSSNumericValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyCSSNumericValue()
  {
    MOZ_RELEASE_ASSERT(IsCSSNumericValue(), "Wrong type!");
    mValue.mCSSNumericValue.Destroy();
    mType = eUninitialized;
  }
};


class OwningDoubleOrCSSNumericValue : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningDoubleOrCSSNumericValue& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eCSSNumericValue
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eCSSNumericValue = TypeOrUninit::eCSSNumericValue
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<OwningNonNull<mozilla::dom::CSSNumericValue> > mCSSNumericValue;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrCSSNumericValue()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrCSSNumericValue(OwningDoubleOrCSSNumericValue&& aOther);

  explicit inline OwningDoubleOrCSSNumericValue(const OwningDoubleOrCSSNumericValue& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrCSSNumericValue()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::CSSNumericValue>&
  RawSetAsCSSNumericValue();

  [[nodiscard]] OwningNonNull<mozilla::dom::CSSNumericValue>&
  SetAsCSSNumericValue();

  inline bool
  IsCSSNumericValue() const
  {
    return mType == eCSSNumericValue;
  }

  inline OwningNonNull<mozilla::dom::CSSNumericValue>&
  GetAsCSSNumericValue()
  {
    MOZ_RELEASE_ASSERT(IsCSSNumericValue(), "Wrong type!");
    return mValue.mCSSNumericValue.Value();
  }

  inline OwningNonNull<mozilla::dom::CSSNumericValue> const &
  GetAsCSSNumericValue() const
  {
    MOZ_RELEASE_ASSERT(IsCSSNumericValue(), "Wrong type!");
    return mValue.mCSSNumericValue.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrCSSNumericValue&
  operator=(OwningDoubleOrCSSNumericValue&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrCSSNumericValue&
  operator=(const OwningDoubleOrCSSNumericValue& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToCSSNumericValue(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToCSSNumericValue(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyCSSNumericValue();
};


namespace CSSNumericValue_Binding {

  typedef mozilla::dom::CSSNumericValue NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::CSSNumericValue* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSNumericValue,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace CSSNumericValue_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::CSSNumericBaseType>
{
  static constexpr dom::CSSNumericBaseType value = dom::CSSNumericBaseType::Percent;

  static_assert(static_cast<uint8_t>(dom::CSSNumericBaseType::Length) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::CSSNumericBaseType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_CSSNUMERICVALUEBINDING_H_
