/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM FrameCrashedEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "FrameCrashedEvent.h"
#include "FrameCrashedEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/FrameCrashedEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


FrameCrashedEvent::FrameCrashedEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

FrameCrashedEvent::~FrameCrashedEvent()
{
}

FrameCrashedEvent*
FrameCrashedEvent::AsFrameCrashedEvent()
{
  return this;
}

JSObject*
FrameCrashedEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return FrameCrashedEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<FrameCrashedEvent>
FrameCrashedEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const FrameCrashedEventInit& aEventInitDict)
{
  RefPtr<FrameCrashedEvent> e = new FrameCrashedEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mBrowsingContextId = aEventInitDict.mBrowsingContextId;
  e->mIsTopFrame = aEventInitDict.mIsTopFrame;
  e->mChildID = aEventInitDict.mChildID;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<FrameCrashedEvent>
FrameCrashedEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const FrameCrashedEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

uint64_t
FrameCrashedEvent::BrowsingContextId() const
{
  return mBrowsingContextId;
}

bool
FrameCrashedEvent::IsTopFrame() const
{
  return mIsTopFrame;
}

uint64_t
FrameCrashedEvent::ChildID() const
{
  return mChildID;
}


} // namespace mozilla::dom
