/* THIS FILE IS AUTOGENERATED FROM AudioDecoder.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_AUDIODECODERBINDING_H_
#define DOM_AUDIODECODERBINDING_H_

#include "BufferSourceBinding.h"
#include "VideoDecoderBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

class AudioData;
class AudioDataOutputCallback;
class AudioDecoder;
struct AudioDecoderConfig;
struct AudioDecoderConfigAtoms;
struct AudioDecoderInitAtoms;
struct AudioDecoderSupportAtoms;
class MaybeSharedArrayBufferOrMaybeSharedArrayBufferView;
struct NativePropertyHooks;
class OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferView;
class ProtoAndIfaceCache;
class WebCodecsErrorCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

class AudioDataOutputCallback : public CallbackFunction
{
public:
  explicit inline AudioDataOutputCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline AudioDataOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline AudioDataOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline AudioDataOutputCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, AudioData& output, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "AudioDataOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, output, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(AudioData& output, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "AudioDataOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, output, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, AudioData& output, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, output, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(AudioData& output, const char* aExecutionReason = nullptr)
  {
    return Call(output, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const AudioDataOutputCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, AudioData& output, ErrorResult& aRv);
};


namespace binding_detail {
class FastAudioDataOutputCallback : public AudioDataOutputCallback
{
public:
  explicit inline FastAudioDataOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : AudioDataOutputCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    AudioDataOutputCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    AudioDataOutputCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct AudioDecoderConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mCodec;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferView> mDescription;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mNumberOfChannels;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleRate;

  AudioDecoderConfig();

  explicit inline AudioDecoderConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AudioDecoderConfig(AudioDecoderConfig&& aOther) = default;

private:
  AudioDecoderConfig(const AudioDecoderConfig&) = delete;
  AudioDecoderConfig& operator=(const AudioDecoderConfig&) = delete;

  static bool
  InitIds(JSContext* cx, AudioDecoderConfigAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastAudioDecoderConfig : public AudioDecoderConfig
{
  inline FastAudioDecoderConfig()
    : AudioDecoderConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AudioDecoderInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<WebCodecsErrorCallback> mError;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<AudioDataOutputCallback> mOutput;

  AudioDecoderInit();

  explicit inline AudioDecoderInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AudioDecoderInit(AudioDecoderInit&& aOther) = default;

private:
  AudioDecoderInit(const AudioDecoderInit&) = delete;
  AudioDecoderInit& operator=(const AudioDecoderInit&) = delete;

  static bool
  InitIds(JSContext* cx, AudioDecoderInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mError, "mError", aFlags);
    ImplCycleCollectionTraverse(aCallback, mOutput, "mOutput", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mError);
    ImplCycleCollectionUnlink(mOutput);
  }
};

namespace binding_detail {
struct FastAudioDecoderInit : public AudioDecoderInit
{
  inline FastAudioDecoderInit()
    : AudioDecoderInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AudioDecoderSupport : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<AudioDecoderConfig> mConfig;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mSupported;

  AudioDecoderSupport();

  explicit inline AudioDecoderSupport(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AudioDecoderSupport(AudioDecoderSupport&& aOther) = default;

private:
  AudioDecoderSupport(const AudioDecoderSupport&) = delete;
  AudioDecoderSupport& operator=(const AudioDecoderSupport&) = delete;

  static bool
  InitIds(JSContext* cx, AudioDecoderSupportAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastAudioDecoderSupport : public AudioDecoderSupport
{
  inline FastAudioDecoderSupport()
    : AudioDecoderSupport(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace AudioDecoder_Binding {

  typedef mozilla::dom::AudioDecoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::AudioDecoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::AudioDecoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace AudioDecoder_Binding



} // namespace mozilla::dom

#endif // DOM_AUDIODECODERBINDING_H_
