/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_MediaDeviceInfo_h
#define mozilla_dom_MediaDeviceInfo_h

#include "js/RootingAPI.h"
#include "mozilla/dom/MediaDeviceInfoBinding.h"
#include "nsCycleCollectionParticipant.h"
#include "nsID.h"
#include "nsISupports.h"
#include "nsStringFwd.h"
#include "nsWrapperCache.h"

namespace mozilla::dom {

#define MOZILLA_DOM_MEDIADEVICEINFO_IMPLEMENTATION_IID \
  {0x25091870, 0x84d6, 0x4acf, {0xaf, 0x97, 0x6e, 0xd5, 0x5b, 0xe0, 0x47, 0xb2}}

class MediaDeviceInfo final : public nsISupports, public nsWrapperCache {
 public:
  explicit MediaDeviceInfo(const nsAString& aDeviceId, MediaDeviceKind aKind,
                           const nsAString& aLabel, const nsAString& aGroupId);

  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_WRAPPERCACHE_CLASS(MediaDeviceInfo)
  NS_INLINE_DECL_STATIC_IID(MOZILLA_DOM_MEDIADEVICEINFO_IMPLEMENTATION_IID)

  JSObject* WrapObject(JSContext* cx,
                       JS::Handle<JSObject*> aGivenProto) override;

  nsISupports* GetParentObject();

  void GetDeviceId(nsString& retval);
  MediaDeviceKind Kind();
  void GetLabel(nsString& retval);
  void GetGroupId(nsString& retval);

 private:
  MediaDeviceKind mKind;
  nsString mDeviceId;
  nsString mLabel;
  nsString mGroupId;

  virtual ~MediaDeviceInfo() = default;
};

}  // namespace mozilla::dom

#endif  // mozilla_dom_MediaDeviceInfo_h
