// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanSidebarMetrics_h
#define mozilla_GleanSidebarMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace bookmarks {
  /**
   * generated from bookmarks.sidebar_toggle
   */
  struct SidebarToggleExtra {
    mozilla::Maybe<bool> opened;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The Bookmarks sidebar panel was loaded or unloaded.
   */
  constexpr impl::EventMetric<SidebarToggleExtra> sidebar_toggle(859);
}

namespace contextual_manager {
  /**
   * generated from contextual_manager.passwords_enabled
   */
  struct PasswordsEnabledExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked on the checkbox corresponding to the "Passwords" entry on sidebar customization settings.
   */
  constexpr impl::EventMetric<PasswordsEnabledExtra> passwords_enabled(860);

  /**
   * generated from contextual_manager.sidebar_toggle
   */
  struct SidebarToggleExtra {
    mozilla::Maybe<bool> opened;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Client opens Contextual Manager.
   */
  constexpr impl::EventMetric<SidebarToggleExtra> sidebar_toggle(861);
}

namespace extension {
  /**
   * generated from extension.sidebar_toggle
   */
  struct SidebarToggleExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonName;
    mozilla::Maybe<bool> opened;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonName) {
        extraKeys.AppendElement()->AssignASCII("addon_name");
        extraValues.EmplaceBack(addonName.value());
      }
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A sidebar extension panel was loaded or unloaded.
   */
  constexpr impl::EventMetric<SidebarToggleExtra> sidebar_toggle(867);
}

namespace history {
  /**
   * generated from history.sidebar_toggle
   */
  struct SidebarToggleExtra {
    mozilla::Maybe<bool> opened;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The History sidebar panel was loaded or unloaded.
   */
  constexpr impl::EventMetric<SidebarToggleExtra> sidebar_toggle(868);
}

namespace pinned_tabs {
  /**
   * generated from pinned_tabs.activations
   */
  enum class ActivationsLabel: uint16_t {
    eSidebar = 0,
    eHorizontalBar = 1,
    e__Other__,
  };
  /**
   * Records how many times a pinned tab gets activated.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ActivationsLabel> activations(869);

  /**
   * generated from pinned_tabs.close
   */
  struct CloseExtra {
    mozilla::Maybe<nsCString> layout;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (layout) {
        extraKeys.AppendElement()->AssignASCII("layout");
        extraValues.EmplaceBack(layout.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user closes a pinned tab.
   */
  constexpr impl::EventMetric<CloseExtra> close(870);

  /**
   * generated from pinned_tabs.count
   */
  enum class CountLabel: uint16_t {
    eSidebar = 0,
    eHorizontalBar = 1,
    e__Other__,
  };
  /**
   * Records how many pinned tabs the user currently has across all windows.
   */
  constexpr impl::Labeled<impl::QuantityMetric, CountLabel> count(871);

  /**
   * generated from pinned_tabs.pin
   */
  struct PinExtra {
    mozilla::Maybe<nsCString> layout;
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (layout) {
        extraKeys.AppendElement()->AssignASCII("layout");
        extraValues.EmplaceBack(layout.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user pins a tab.
   */
  constexpr impl::EventMetric<PinExtra> pin(872);
}

namespace sidebar {
  /**
   * generated from sidebar.addon_icon_click
   */
  struct AddonIconClickExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<bool> sidebarOpen;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (sidebarOpen) {
        extraKeys.AppendElement()->AssignASCII("sidebar_open");
        extraValues.AppendElement()->AssignASCII(sidebarOpen.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An extension icon was clicked.
   */
  constexpr impl::EventMetric<AddonIconClickExtra> addon_icon_click(873);

  /**
   * generated from sidebar.bookmarks_icon_click
   */
  struct BookmarksIconClickExtra {
    mozilla::Maybe<bool> sidebarOpen;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sidebarOpen) {
        extraKeys.AppendElement()->AssignASCII("sidebar_open");
        extraValues.AppendElement()->AssignASCII(sidebarOpen.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The bookmarks icon was clicked.
   */
  constexpr impl::EventMetric<BookmarksIconClickExtra> bookmarks_icon_click(874);

  /**
   * generated from sidebar.chatbot_icon_click
   */
  struct ChatbotIconClickExtra {
    mozilla::Maybe<bool> sidebarOpen;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sidebarOpen) {
        extraKeys.AppendElement()->AssignASCII("sidebar_open");
        extraValues.AppendElement()->AssignASCII(sidebarOpen.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The chatbot icon was clicked.
   */
  constexpr impl::EventMetric<ChatbotIconClickExtra> chatbot_icon_click(875);

  /**
   * generated from sidebar.display_settings
   * Setting for sidebar display (either "always", "expand-on-hover", or "hide").
   */
  constexpr impl::StringMetric display_settings(876);

  /**
   * generated from sidebar.expand
   */
  /**
   * The sidebar was expanded.
   */
  constexpr impl::EventMetric<NoExtraKeys> expand(877);

  /**
   * generated from sidebar.history_icon_click
   */
  struct HistoryIconClickExtra {
    mozilla::Maybe<bool> sidebarOpen;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sidebarOpen) {
        extraKeys.AppendElement()->AssignASCII("sidebar_open");
        extraValues.AppendElement()->AssignASCII(sidebarOpen.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The history icon was clicked.
   */
  constexpr impl::EventMetric<HistoryIconClickExtra> history_icon_click(878);

  /**
   * generated from sidebar.keyboard_shortcut
   */
  struct KeyboardShortcutExtra {
    mozilla::Maybe<bool> opened;
    mozilla::Maybe<nsCString> panel;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      if (panel) {
        extraKeys.AppendElement()->AssignASCII("panel");
        extraValues.EmplaceBack(panel.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Revamped sidebar toggled with keyboard shortcut.
   */
  constexpr impl::EventMetric<KeyboardShortcutExtra> keyboard_shortcut(879);

  /**
   * generated from sidebar.link
   * The number of history items opened from the History sidebar. This metric was generated to correspond to the Legacy Telemetry scalar sidebar.link.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> link(880);

  /**
   * generated from sidebar.position_settings
   * Setting for sidebar position (either "left" or "right").
   */
  constexpr impl::StringMetric position_settings(881);

  /**
   * generated from sidebar.resize
   */
  struct ResizeExtra {
    mozilla::Maybe<uint32_t> current;
    mozilla::Maybe<uint32_t> percentage;
    mozilla::Maybe<uint32_t> previous;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (current) {
        extraKeys.AppendElement()->AssignASCII("current");
        extraValues.AppendElement()->AppendInt(current.value());
      }
      if (percentage) {
        extraKeys.AppendElement()->AssignASCII("percentage");
        extraValues.AppendElement()->AppendInt(percentage.value());
      }
      if (previous) {
        extraKeys.AppendElement()->AssignASCII("previous");
        extraValues.AppendElement()->AppendInt(previous.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User resized the sidebar.
   */
  constexpr impl::EventMetric<ResizeExtra> resize(882);

  /**
   * generated from sidebar.search
   * The number of searches from the sidebar, per view (e.g.: bookmarks, history). This metric was generated to correspond to the Legacy Telemetry scalar sidebar.search.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> search(883);

  /**
   * generated from sidebar.synced_tabs_icon_click
   */
  struct SyncedTabsIconClickExtra {
    mozilla::Maybe<bool> sidebarOpen;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sidebarOpen) {
        extraKeys.AppendElement()->AssignASCII("sidebar_open");
        extraValues.AppendElement()->AssignASCII(sidebarOpen.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The synced tabs icon was clicked.
   */
  constexpr impl::EventMetric<SyncedTabsIconClickExtra> synced_tabs_icon_click(884);

  /**
   * generated from sidebar.tabs_layout
   * Setting for tabs orientation (either "horizontal" or "vertical").
   */
  constexpr impl::StringMetric tabs_layout(885);

  /**
   * generated from sidebar.width
   * Width of the sidebar, in pixels.
   */
  constexpr impl::QuantityMetric width(886);
}

namespace sidebar_customize {
  /**
   * generated from sidebar.customize.bookmarks_enabled
   */
  struct BookmarksEnabledExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked on the checkbox corresponding to bookmarks on sidebar customization settings.
   */
  constexpr impl::EventMetric<BookmarksEnabledExtra> bookmarks_enabled(887);

  /**
   * generated from sidebar.customize.chatbot_enabled
   */
  struct ChatbotEnabledExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked on the checkbox corresponding to chatbot on sidebar customization settings.
   */
  constexpr impl::EventMetric<ChatbotEnabledExtra> chatbot_enabled(888);

  /**
   * generated from sidebar.customize.expand_on_hover_enabled
   */
  struct ExpandOnHoverEnabledExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked on the checkbox corresponding to expand on hover on sidebar customization settings.
   */
  constexpr impl::EventMetric<ExpandOnHoverEnabledExtra> expand_on_hover_enabled(889);

  /**
   * generated from sidebar.customize.extensions_clicked
   */
  /**
   * User clicked on the link to go to Browser Extensions on sidebar customization settings.
   */
  constexpr impl::EventMetric<NoExtraKeys> extensions_clicked(890);

  /**
   * generated from sidebar.customize.firefox_settings_clicked
   */
  /**
   * User clicked on the link to Manage Firefox Settings on sidebar customization settings.
   */
  constexpr impl::EventMetric<NoExtraKeys> firefox_settings_clicked(891);

  /**
   * generated from sidebar.customize.history_enabled
   */
  struct HistoryEnabledExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked on the checkbox corresponding to history on sidebar customization settings.
   */
  constexpr impl::EventMetric<HistoryEnabledExtra> history_enabled(892);

  /**
   * generated from sidebar.customize.icon_click
   */
  /**
   * User clicked on the gear icon to customize the sidebar.
   */
  constexpr impl::EventMetric<NoExtraKeys> icon_click(893);

  /**
   * generated from sidebar.customize.panel_toggle
   */
  struct PanelToggleExtra {
    mozilla::Maybe<bool> opened;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The Customize sidebar panel was loaded or unloaded.
   */
  constexpr impl::EventMetric<PanelToggleExtra> panel_toggle(894);

  /**
   * generated from sidebar.customize.sidebar_display
   */
  struct SidebarDisplayExtra {
    mozilla::Maybe<nsCString> preference;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (preference) {
        extraKeys.AppendElement()->AssignASCII("preference");
        extraValues.EmplaceBack(preference.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User selected an option of when the sidebar is shown on sidebar customization settings.
   */
  constexpr impl::EventMetric<SidebarDisplayExtra> sidebar_display(895);

  /**
   * generated from sidebar.customize.sidebar_position
   */
  struct SidebarPositionExtra {
    mozilla::Maybe<nsCString> position;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.EmplaceBack(position.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User selected an option of in which side the sidebar is displayed from the sidebar customization settings.
   */
  constexpr impl::EventMetric<SidebarPositionExtra> sidebar_position(896);

  /**
   * generated from sidebar.customize.synced_tabs_enabled
   */
  struct SyncedTabsEnabledExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked on the checkbox corresponding to synced tabs on sidebar customization settings.
   */
  constexpr impl::EventMetric<SyncedTabsEnabledExtra> synced_tabs_enabled(897);

  /**
   * generated from sidebar.customize.tabs_display
   */
  struct TabsDisplayExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked on the checkbox corresponding to hiding horizontal tabs on sidebar customization settings.
   */
  constexpr impl::EventMetric<TabsDisplayExtra> tabs_display(898);

  /**
   * generated from sidebar.customize.tabs_layout
   */
  struct TabsLayoutExtra {
    mozilla::Maybe<nsCString> orientation;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (orientation) {
        extraKeys.AppendElement()->AssignASCII("orientation");
        extraValues.EmplaceBack(orientation.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User selected between horizontal or vertical tabs on sidebar customization settings.
   */
  constexpr impl::EventMetric<TabsLayoutExtra> tabs_layout(899);
}

namespace synced_tabs {
  /**
   * generated from synced_tabs.sidebar_toggle
   */
  struct SidebarToggleExtra {
    mozilla::Maybe<bool> opened;
    mozilla::Maybe<bool> syncedTabsLoaded;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      if (syncedTabsLoaded) {
        extraKeys.AppendElement()->AssignASCII("synced_tabs_loaded");
        extraValues.AppendElement()->AssignASCII(syncedTabsLoaded.value() ? "true" : "false");
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The Synced Tabs sidebar panel was loaded or unloaded.
   */
  constexpr impl::EventMetric<SidebarToggleExtra> sidebar_toggle(900);
}

} // namespace mozilla::glean

#endif // mozilla_GleanSidebarMetrics_h
