// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanPrivatebrowsingMetrics_h
#define mozilla_GleanPrivatebrowsingMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace aboutprivatebrowsing {
  /**
   * generated from aboutprivatebrowsing.click_dismiss_button
   */
  /**
   * This is recorded when a user clicks a link on the private browsing newtab. This event was generated to correspond to the Legacy Telemetry event aboutprivatebrowsing.click#dismiss_button.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_dismiss_button(681);

  /**
   * generated from aboutprivatebrowsing.click_info_link
   */
  /**
   * This is recorded when a user clicks a link on the private browsing newtab. This event was generated to correspond to the Legacy Telemetry event aboutprivatebrowsing.click#info_link.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_info_link(682);

  /**
   * generated from aboutprivatebrowsing.click_promo_link
   */
  /**
   * This is recorded when a user clicks a link on the private browsing newtab. This event was generated to correspond to the Legacy Telemetry event aboutprivatebrowsing.click#promo_link.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_promo_link(683);
}

namespace private_browsing_reset_pbm {
  /**
   * generated from private_browsing.reset_pbm.confirm_panel
   */
  struct ConfirmPanelExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Confirm panel show / hide event.
   */
  constexpr impl::EventMetric<ConfirmPanelExtra> confirm_panel(684);

  /**
   * generated from private_browsing.reset_pbm.reset_action
   */
  struct ResetActionExtra {
    mozilla::Maybe<bool> didConfirm;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (didConfirm) {
        extraKeys.AppendElement()->AssignASCII("did_confirm");
        extraValues.AppendElement()->AssignASCII(didConfirm.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched whenever PBM is restarted / reset via the resetPBM feature.
   */
  constexpr impl::EventMetric<ResetActionExtra> reset_action(685);
}

} // namespace mozilla::glean

#endif // mozilla_GleanPrivatebrowsingMetrics_h
