// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanPdfjsMetrics_h
#define mozilla_GleanPdfjsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace glam_experiment {
  /**
   * generated from glam_experiment.used
   * Duplicate of: `pdfjs.used`
   * Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::CounterMetric used(302);
}

namespace pdfjs {
  /**
   * generated from pdfjs.buttons
   */
  enum class ButtonsLabel: uint16_t {
    ePresentationMode = 0,
    ePresentationModeKeyboard = 1,
    eViewBookmark = 2,
    eFirstPage = 3,
    eLastPage = 4,
    ePageRotateCw = 5,
    ePageRotateCcw = 6,
    eCursorSelectTool = 7,
    eCursorHandTool = 8,
    eScrollPage = 9,
    eScrollVertical = 10,
    eScrollHorizontal = 11,
    eScrollWrapped = 12,
    eSpreadNone = 13,
    eSpreadOdd = 14,
    eSpreadEven = 15,
    eDocumentProperties = 16,
    e__Other__,
  };
  /**
   * Counts the number of times some actions are executed in the PDF viewer.
   */
  constexpr impl::Labeled<impl::CounterMetric, ButtonsLabel> buttons(5050);

  /**
   * generated from pdfjs.editing
   */
  enum class EditingLabel: uint16_t {
    eInk = 0,
    eFreetext = 1,
    eStamp = 2,
    eSignature = 3,
    eSave = 4,
    ePrint = 5,
    e__Other__,
  };
  /**
   * Counts the number of times some PDF editing features are used.
   */
  constexpr impl::Labeled<impl::CounterMetric, EditingLabel> editing(5051);

  /**
   * generated from pdfjs.geckoview
   */
  enum class GeckoviewLabel: uint16_t {
    eDownloadTapped = 0,
    eOpenInAppTapped = 1,
    eOpenInAppJustOnce = 2,
    eOpenInAppAlways = 3,
    eDownloadFailed = 4,
    eDownloadSucceeded = 5,
    eSaveAsPdfTapped = 6,
    e__Other__,
  };
  /**
   * Counts the number of times some actions are executed in the PDF viewer.
   */
  constexpr impl::Labeled<impl::CounterMetric, GeckoviewLabel> geckoview(5052);

  /**
   * generated from pdfjs.stamp
   */
  enum class StampLabel: uint16_t {
    eInsertedImage = 0,
    eAltTextSave = 1,
    eAltTextCancel = 2,
    eAltTextTooltip = 3,
    eAltTextEdit = 4,
    eAltTextDescription = 5,
    eAltTextDecorative = 6,
    eAltTextKeyboard = 7,
    e__Other__,
  };
  /**
   * Counts the number of times some PDF editing features are used.
   */
  constexpr impl::Labeled<impl::CounterMetric, StampLabel> stamp(5053);

  /**
   * generated from pdfjs.time_to_view
   * Time spent to display first page in PDF Viewer (ms).
   */
  constexpr impl::CustomDistributionMetric time_to_view(5054);

  /**
   * generated from pdfjs.used
   * How many times PDF Viewer was used.
   */
  constexpr impl::CounterMetric used(5055);
}

namespace pdfjs_editing_highlight {
  /**
   * generated from pdfjs.editing.highlight.color
   */
  enum class ColorLabel: uint16_t {
    eYellow = 0,
    eGreen = 1,
    eBlue = 2,
    ePink = 3,
    eRed = 4,
    e__Other__,
  };
  /**
   * Counts the number of times a given color is used to highlight.
   */
  constexpr impl::Labeled<impl::CounterMetric, ColorLabel> color(5056);

  /**
   * generated from pdfjs.editing.highlight.color_changed
   * Counts the number of times the user changes the color of a highlight.
   */
  constexpr impl::CounterMetric color_changed(5057);

  /**
   * generated from pdfjs.editing.highlight.deleted
   * Counts the number of times the user deletes highlights.
   */
  constexpr impl::CounterMetric deleted(5058);

  /**
   * generated from pdfjs.editing.highlight.edited
   * Counts the number of times the user edits highlights.
   */
  constexpr impl::CounterMetric edited(5059);

  /**
   * generated from pdfjs.editing.highlight.kind
   */
  enum class KindLabel: uint16_t {
    eFreeHighlight = 0,
    eHighlight = 1,
    e__Other__,
  };
  /**
   * Counts the number of times a given kind is used to highlight.
   */
  constexpr impl::Labeled<impl::CounterMetric, KindLabel> kind(5060);

  /**
   * generated from pdfjs.editing.highlight.method
   */
  enum class MethodLabel: uint16_t {
    eContextMenu = 0,
    eMainToolbar = 1,
    eFloatingButton = 2,
    e__Other__,
  };
  /**
   * Counts the number of times a given method is used to highlight.
   */
  constexpr impl::Labeled<impl::CounterMetric, MethodLabel> method(5061);

  /**
   * generated from pdfjs.editing.highlight.number_of_colors
   */
  enum class NumberOfColorsLabel: uint16_t {
    eOne = 0,
    eTwo = 1,
    eThree = 2,
    eFour = 3,
    eFive = 4,
    e__Other__,
  };
  /**
   * Counts the number of different colors used to highlight.
   */
  constexpr impl::Labeled<impl::CounterMetric, NumberOfColorsLabel> number_of_colors(5062);

  /**
   * generated from pdfjs.editing.highlight.print
   * Counts the number of times the user prints a PDF with highlights.
   */
  constexpr impl::CounterMetric print(5063);

  /**
   * generated from pdfjs.editing.highlight.save
   * Counts the number of times the user saves a PDF with highlights.
   */
  constexpr impl::CounterMetric save(5064);

  /**
   * generated from pdfjs.editing.highlight.thickness
   * The thickness used to draw a free highlight.
   */
  constexpr impl::CustomDistributionMetric thickness(5065);

  /**
   * generated from pdfjs.editing.highlight.thickness_changed
   * Counts the number of times the user changes the thickness of a free highlight.
   */
  constexpr impl::CounterMetric thickness_changed(5066);

  /**
   * generated from pdfjs.editing.highlight.toggle_visibility
   * Counts the number of times the user toggles the visibility of highlights.
   */
  constexpr impl::CounterMetric toggle_visibility(5067);
}

namespace pdfjs_image {
  /**
   * generated from pdfjs.image.add_image_click
   */
  /**
   * Recorded when the Add Image label is clicked.
   */
  constexpr impl::EventMetric<NoExtraKeys> add_image_click(5068);

  /**
   * generated from pdfjs.image.added
   */
  enum class AddedLabel: uint16_t {
    eWithAltText = 0,
    eWithoutAltText = 1,
    e__Other__,
  };
  /**
   * Number of images added with/without alt text.
   */
  constexpr impl::Labeled<impl::CounterMetric, AddedLabel> added(5069);

  /**
   * generated from pdfjs.image.alt_text_edit
   */
  enum class AltTextEditLabel: uint16_t {
    eAskToEdit = 0,
    eAiGeneration = 1,
    e__Other__,
  };
  /**
   * Stores alt text modal settings for the user.
   */
  constexpr impl::Labeled<impl::BooleanMetric, AltTextEditLabel> alt_text_edit(5070);

  /**
   * generated from pdfjs.image.icon_click
   */
  /**
   * Recorded when the image toolbar icon is clicked.
   */
  constexpr impl::EventMetric<NoExtraKeys> icon_click(5071);

  /**
   * generated from pdfjs.image.image_added
   */
  struct ImageAddedExtra {
    mozilla::Maybe<bool> altTextModal;
    mozilla::Maybe<nsCString> altTextType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (altTextModal) {
        extraKeys.AppendElement()->AssignASCII("alt_text_modal");
        extraValues.AppendElement()->AssignASCII(altTextModal.value() ? "true" : "false");
      }
      if (altTextType) {
        extraKeys.AppendElement()->AssignASCII("alt_text_type");
        extraValues.EmplaceBack(altTextType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded once the image is added to the pdf.
   */
  constexpr impl::EventMetric<ImageAddedExtra> image_added(5072);

  /**
   * generated from pdfjs.image.image_selected
   */
  struct ImageSelectedExtra {
    mozilla::Maybe<bool> altTextModal;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (altTextModal) {
        extraKeys.AppendElement()->AssignASCII("alt_text_modal");
        extraValues.AppendElement()->AssignASCII(altTextModal.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects an image file from their computer.
   */
  constexpr impl::EventMetric<ImageSelectedExtra> image_selected(5073);
}

namespace pdfjs_image_alt_text {
  /**
   * generated from pdfjs.image.alt_text.ai_generation_check
   */
  struct AiGenerationCheckExtra {
    mozilla::Maybe<bool> status;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.AppendElement()->AssignASCII(status.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user interacts with the alt text setting in the alt text modal to create alt text with AI.
   */
  constexpr impl::EventMetric<AiGenerationCheckExtra> ai_generation_check(5074);

  /**
   * generated from pdfjs.image.alt_text.callout_dismissed
   */
  /**
   * Recorded when the callout describing automatic alt text generation is dismissed.
   */
  constexpr impl::EventMetric<NoExtraKeys> callout_dismissed(5075);

  /**
   * generated from pdfjs.image.alt_text.callout_displayed
   */
  /**
   * Recorded when the callout describing automatic alt text generation is displayed.
   */
  constexpr impl::EventMetric<NoExtraKeys> callout_displayed(5076);

  /**
   * generated from pdfjs.image.alt_text.dismiss
   */
  struct DismissExtra {
    mozilla::Maybe<nsCString> altTextType;
    mozilla::Maybe<nsCString> flow;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (altTextType) {
        extraKeys.AppendElement()->AssignASCII("alt_text_type");
        extraValues.EmplaceBack(altTextType.value());
      }
      if (flow) {
        extraKeys.AppendElement()->AssignASCII("flow");
        extraValues.EmplaceBack(flow.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks Not now or Cancel on the alt text modal.
   */
  constexpr impl::EventMetric<DismissExtra> dismiss(5077);

  /**
   * generated from pdfjs.image.alt_text.image_status_label_clicked
   */
  struct ImageStatusLabelClickedExtra {
    mozilla::Maybe<nsCString> label;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (label) {
        extraKeys.AppendElement()->AssignASCII("label");
        extraValues.EmplaceBack(label.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks on the alt text status button.
   */
  constexpr impl::EventMetric<ImageStatusLabelClickedExtra> image_status_label_clicked(5078);

  /**
   * generated from pdfjs.image.alt_text.image_status_label_displayed
   */
  struct ImageStatusLabelDisplayedExtra {
    mozilla::Maybe<nsCString> label;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (label) {
        extraKeys.AppendElement()->AssignASCII("label");
        extraValues.EmplaceBack(label.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the alt text status button on an image is shown .
   */
  constexpr impl::EventMetric<ImageStatusLabelDisplayedExtra> image_status_label_displayed(5079);

  /**
   * generated from pdfjs.image.alt_text.info
   */
  struct InfoExtra {
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded on the alt text modal when the user clicks on "i" to learn about alt text or "Learn More" to learn about AI generation.
   */
  constexpr impl::EventMetric<InfoExtra> info(5080);

  /**
   * generated from pdfjs.image.alt_text.model_deleted
   */
  /**
   * Recorded when the user clicks to delete the model from the alt text settings.
   */
  constexpr impl::EventMetric<NoExtraKeys> model_deleted(5081);

  /**
   * generated from pdfjs.image.alt_text.model_download_complete
   */
  /**
   * Recorded when download completes for the alt text generation model.
   */
  constexpr impl::EventMetric<NoExtraKeys> model_download_complete(5082);

  /**
   * generated from pdfjs.image.alt_text.model_download_error
   */
  struct ModelDownloadErrorExtra {
    mozilla::Maybe<nsCString> error;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when an error occurs during the download for the alt text generation model.
   */
  constexpr impl::EventMetric<ModelDownloadErrorExtra> model_download_error(5083);

  /**
   * generated from pdfjs.image.alt_text.model_download_start
   */
  /**
   * Recorded when download starts for the alt text generation model.
   */
  constexpr impl::EventMetric<NoExtraKeys> model_download_start(5084);

  /**
   * generated from pdfjs.image.alt_text.model_result
   */
  struct ModelResultExtra {
    mozilla::Maybe<uint32_t> length;
    mozilla::Maybe<uint32_t> time;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (length) {
        extraKeys.AppendElement()->AssignASCII("length");
        extraValues.AppendElement()->AppendInt(length.value());
      }
      if (time) {
        extraKeys.AppendElement()->AssignASCII("time");
        extraValues.AppendElement()->AppendInt(time.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records how long it takes to generate the alt text and what is the length of the result.
   */
  constexpr impl::EventMetric<ModelResultExtra> model_result(5085);

  /**
   * generated from pdfjs.image.alt_text.save
   */
  struct SaveExtra {
    mozilla::Maybe<nsCString> altTextType;
    mozilla::Maybe<nsCString> flow;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (altTextType) {
        extraKeys.AppendElement()->AssignASCII("alt_text_type");
        extraValues.EmplaceBack(altTextType.value());
      }
      if (flow) {
        extraKeys.AppendElement()->AssignASCII("flow");
        extraValues.EmplaceBack(flow.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks Save on the alt text modal.
   */
  constexpr impl::EventMetric<SaveExtra> save(5086);

  /**
   * generated from pdfjs.image.alt_text.settings_ai_generation_check
   */
  struct SettingsAiGenerationCheckExtra {
    mozilla::Maybe<bool> status;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.AppendElement()->AssignASCII(status.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user interacts with the alt text setting to create alt text with AI.
   */
  constexpr impl::EventMetric<SettingsAiGenerationCheckExtra> settings_ai_generation_check(5087);

  /**
   * generated from pdfjs.image.alt_text.settings_displayed
   */
  /**
   * Recorded when alt text settings dialog is displayed to a user.
   */
  constexpr impl::EventMetric<NoExtraKeys> settings_displayed(5088);

  /**
   * generated from pdfjs.image.alt_text.settings_edit_alt_text_check
   */
  struct SettingsEditAltTextCheckExtra {
    mozilla::Maybe<bool> status;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.AppendElement()->AssignASCII(status.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user interacts with the alt text modal setting to edit alt text on this pdf.
   */
  constexpr impl::EventMetric<SettingsEditAltTextCheckExtra> settings_edit_alt_text_check(5089);

  /**
   * generated from pdfjs.image.alt_text.user_edit
   */
  struct UserEditExtra {
    mozilla::Maybe<uint32_t> totalWords;
    mozilla::Maybe<uint32_t> wordsAdded;
    mozilla::Maybe<uint32_t> wordsRemoved;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (totalWords) {
        extraKeys.AppendElement()->AssignASCII("total_words");
        extraValues.AppendElement()->AppendInt(totalWords.value());
      }
      if (wordsAdded) {
        extraKeys.AppendElement()->AssignASCII("words_added");
        extraValues.AppendElement()->AppendInt(wordsAdded.value());
      }
      if (wordsRemoved) {
        extraKeys.AppendElement()->AssignASCII("words_removed");
        extraValues.AppendElement()->AppendInt(wordsRemoved.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded once the alt text is confirmed, when the user makes changes to the alt text generated. By comparing the initially generated text with the final version, quantifies how many words were changed.
   */
  constexpr impl::EventMetric<UserEditExtra> user_edit(5090);
}

namespace pdfjs_signature {
  /**
   * generated from pdfjs.signature.added
   */
  struct AddedExtra {
    mozilla::Maybe<uint32_t> hasAltText;
    mozilla::Maybe<uint32_t> hasNoAltText;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasAltText) {
        extraKeys.AppendElement()->AssignASCII("has_alt_text");
        extraValues.AppendElement()->AppendInt(hasAltText.value());
      }
      if (hasNoAltText) {
        extraKeys.AppendElement()->AssignASCII("has_no_alt_text");
        extraValues.AppendElement()->AppendInt(hasNoAltText.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user print/save a pdf containing some added signatures.
   */
  constexpr impl::EventMetric<AddedExtra> added(5091);

  /**
   * generated from pdfjs.signature.clear
   */
  enum class ClearLabel: uint16_t {
    eType = 0,
    eDraw = 1,
    eText = 2,
    e__Other__,
  };
  /**
   * Counts the number of times the user clears the signature while editing it.
   */
  constexpr impl::Labeled<impl::CounterMetric, ClearLabel> clear(5092);

  /**
   * generated from pdfjs.signature.created
   */
  struct CreatedExtra {
    mozilla::Maybe<bool> descriptionChanged;
    mozilla::Maybe<bool> saved;
    mozilla::Maybe<uint32_t> savedCount;
    mozilla::Maybe<nsCString> type;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (descriptionChanged) {
        extraKeys.AppendElement()->AssignASCII("description_changed");
        extraValues.AppendElement()->AssignASCII(descriptionChanged.value() ? "true" : "false");
      }
      if (saved) {
        extraKeys.AppendElement()->AssignASCII("saved");
        extraValues.AppendElement()->AssignASCII(saved.value() ? "true" : "false");
      }
      if (savedCount) {
        extraKeys.AppendElement()->AssignASCII("saved_count");
        extraValues.AppendElement()->AppendInt(savedCount.value());
      }
      if (type) {
        extraKeys.AppendElement()->AssignASCII("type");
        extraValues.EmplaceBack(type.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user creates a new signature.
   */
  constexpr impl::EventMetric<CreatedExtra> created(5093);

  /**
   * generated from pdfjs.signature.delete_saved
   */
  struct DeleteSavedExtra {
    mozilla::Maybe<uint32_t> savedCount;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (savedCount) {
        extraKeys.AppendElement()->AssignASCII("saved_count");
        extraValues.AppendElement()->AppendInt(savedCount.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a saved signature is deleted.
   */
  constexpr impl::EventMetric<DeleteSavedExtra> delete_saved(5094);

  /**
   * generated from pdfjs.signature.edit_description
   */
  enum class EditDescriptionLabel: uint16_t {
    eSaved = 0,
    eUnsaved = 1,
    e__Other__,
  };
  /**
   * Counts the number of times the user edit the description of a signature instance.
   */
  constexpr impl::Labeled<impl::CounterMetric, EditDescriptionLabel> edit_description(5095);

  /**
   * generated from pdfjs.signature.inserted
   */
  struct InsertedExtra {
    mozilla::Maybe<bool> hasBeenSaved;
    mozilla::Maybe<bool> hasDescription;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasBeenSaved) {
        extraKeys.AppendElement()->AssignASCII("has_been_saved");
        extraValues.AppendElement()->AssignASCII(hasBeenSaved.value() ? "true" : "false");
      }
      if (hasDescription) {
        extraKeys.AppendElement()->AssignASCII("has_description");
        extraValues.AppendElement()->AssignASCII(hasDescription.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user inserts a signature in a pdf (can be from the UI, copy & paste, ...).
   */
  constexpr impl::EventMetric<InsertedExtra> inserted(5096);
}

} // namespace mozilla::glean

#endif // mozilla_GleanPdfjsMetrics_h
