/* This file was autogenerated by toolkit/crashreporter/generate_crash_reporter_sources.py. DO NOT EDIT */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef CrashAnnotations_h
#define CrashAnnotations_h

#include <cstddef>
#include <cstdint>

namespace CrashReporter {

// Typed enum representing all crash annotations
enum class Annotation : uint32_t {
  AbortMessage = 0,
  Accessibility = 1,
  AccessibilityClient = 2,
  AccessibilityInProcClient = 3,
  AdapterDeviceID = 4,
  AdapterDriverVendor = 5,
  AdapterDriverVersion = 6,
  AdapterSubsysID = 7,
  AdapterVendorID = 8,
  Addons = 9,
  AppInitDLLs = 10,
  ApplicationBuildID = 11,
  AsyncShutdownTimeout = 12,
  AvailablePageFile = 13,
  AvailablePhysicalMemory = 14,
  AvailableSwapMemory = 15,
  AvailableVirtualMemory = 16,
  BackgroundTaskMode = 17,
  BackgroundTaskName = 18,
  BlockedDllList = 19,
  BlocklistInitFailed = 20,
  Breadcrumbs = 21,
  BuildID = 22,
  CPUMicrocodeVersion = 23,
  ClassRegistrationInfoChild = 24,
  ClassRegistrationInfoParent = 25,
  ContentSandboxCapabilities = 26,
  ContentSandboxCapable = 27,
  ContentSandboxEnabled = 28,
  ContentSandboxLevel = 29,
  ContentSandboxWin32kState = 30,
  CrashAddressLikelyWrong = 31,
  CrashTime = 32,
  CycleCollector = 33,
  DOMFissionEnabled = 34,
  DOMIPCEnabled = 35,
  DesktopEnvironment = 36,
  DeviceResetReason = 37,
  DistributionID = 38,
  DumperError = 39,
  EMCheckCompatibility = 40,
  EventLoopNestingLevel = 41,
  ExperimentalFeatures = 42,
  FontName = 43,
  GMPLibraryPath = 44,
  GMPPlugin = 45,
  GPUProcessLaunchCount = 46,
  GPUProcessStatus = 47,
  GpuSandboxLevel = 48,
  GraphicsCompileShader = 49,
  GraphicsCriticalError = 50,
  GraphicsDrawShader = 51,
  GraphicsNumActiveRenderers = 52,
  GraphicsNumRenderers = 53,
  GraphicsStartupTest = 54,
  HasDeviceTouchScreen = 55,
  HeadlessMode = 56,
  IAccessibleConfig = 57,
  IPCFatalErrorMsg = 58,
  IPCFatalErrorProtocol = 59,
  IPCMessageName = 60,
  IPCMessageSize = 61,
  IPCReadErrorReason = 62,
  IPCShutdownState = 63,
  IPCSystemError = 64,
  IPCTransportFailureReason = 65,
  InstallTime = 66,
  IpcCreateEndpointsNsresult = 67,
  IpcCreatePipeCloExecErrno = 68,
  IpcCreatePipeFcntlErrno = 69,
  IpcCreatePipeSocketPairErrno = 70,
  IpcCreateTransportDupErrno = 71,
  IsGarbageCollecting = 72,
  IsWayland = 73,
  IsWebRenderResourcePathOverridden = 74,
  JSActorMessage = 75,
  JSActorName = 76,
  JSLargeAllocationFailure = 77,
  JSModuleLoadError = 78,
  JSOutOfMemory = 79,
  JavaException = 80,
  JavaStackTrace = 81,
  LastInteractionDuration = 82,
  LastStartupWasCrash = 83,
  LauncherProcessState = 84,
  LinuxUnderMemoryPressure = 85,
  LowPhysicalMemoryEvents = 86,
  MacAvailableMemorySysctl = 87,
  MacMemoryPressure = 88,
  MacMemoryPressureCriticalTime = 89,
  MacMemoryPressureNormalTime = 90,
  MacMemoryPressureSysctl = 91,
  MacMemoryPressureWarningTime = 92,
  MainThreadRunnableName = 93,
  MozCrashReason = 94,
  Notes = 95,
  OOMAllocationSize = 96,
  PHCAllocStack = 97,
  PHCBaseAddress = 98,
  PHCFreeStack = 99,
  PHCKind = 100,
  PHCUsableSize = 101,
  PluginFilename = 102,
  PluginName = 103,
  PluginVersion = 104,
  ProcessType = 105,
  ProductID = 106,
  ProductName = 107,
  ProfilerChildShutdownPhase = 108,
  PurgeablePhysicalMemory = 109,
  QuotaManagerShutdownTimeout = 110,
  RDDProcessStatus = 111,
  ReleaseChannel = 112,
  RemoteType = 113,
  SafeMode = 114,
  SecondsSinceLastCrash = 115,
  ServerURL = 116,
  ShutdownProgress = 117,
  ShutdownReason = 118,
  StartupCacheValid = 119,
  StartupCrash = 120,
  StartupTime = 121,
  StorageConnectionNotClosed = 122,
  SubmittedFrom = 123,
  SystemMemoryUsePercentage = 124,
  TelemetryClientId = 125,
  TelemetryEnvironment = 126,
  TelemetryServerURL = 127,
  TelemetrySessionId = 128,
  TestKey = 129,
  TestUnicode = 130,
  TextureUsage = 131,
  Throttleable = 132,
  TotalPageFile = 133,
  TotalPhysicalMemory = 134,
  TotalVirtualMemory = 135,
  URL = 136,
  URLSegments = 137,
  UnknownNetAddrSocketFamily = 138,
  UptimeTS = 139,
  User32BeforeBlocklist = 140,
  UtilityActorsName = 141,
  UtilityProcessStatus = 142,
  VRProcessStatus = 143,
  Vendor = 144,
  Version = 145,
  WasmLibrarySandboxMallocFailed = 146,
  WindowsErrorReporting = 147,
  WindowsPackageFamilyName = 148,
  Winsock_LSP = 149,
  XPCOMSpinEventLoopStack = 150,
  additional_minidumps = 151,
  ipc_channel_error = 152,
  useragent_locale = 153,
  Count = 154
};

// Stringified crash annotation names
const char* const kAnnotationStrings[] = {
  "AbortMessage",
  "Accessibility",
  "AccessibilityClient",
  "AccessibilityInProcClient",
  "AdapterDeviceID",
  "AdapterDriverVendor",
  "AdapterDriverVersion",
  "AdapterSubsysID",
  "AdapterVendorID",
  "Add-ons",
  "AppInitDLLs",
  "ApplicationBuildID",
  "AsyncShutdownTimeout",
  "AvailablePageFile",
  "AvailablePhysicalMemory",
  "AvailableSwapMemory",
  "AvailableVirtualMemory",
  "BackgroundTaskMode",
  "BackgroundTaskName",
  "BlockedDllList",
  "BlocklistInitFailed",
  "Breadcrumbs",
  "BuildID",
  "CPUMicrocodeVersion",
  "ClassRegistrationInfoChild",
  "ClassRegistrationInfoParent",
  "ContentSandboxCapabilities",
  "ContentSandboxCapable",
  "ContentSandboxEnabled",
  "ContentSandboxLevel",
  "ContentSandboxWin32kState",
  "CrashAddressLikelyWrong",
  "CrashTime",
  "CycleCollector",
  "DOMFissionEnabled",
  "DOMIPCEnabled",
  "DesktopEnvironment",
  "DeviceResetReason",
  "DistributionID",
  "DumperError",
  "EMCheckCompatibility",
  "EventLoopNestingLevel",
  "ExperimentalFeatures",
  "FontName",
  "GMPLibraryPath",
  "GMPPlugin",
  "GPUProcessLaunchCount",
  "GPUProcessStatus",
  "GpuSandboxLevel",
  "GraphicsCompileShader",
  "GraphicsCriticalError",
  "GraphicsDrawShader",
  "GraphicsNumActiveRenderers",
  "GraphicsNumRenderers",
  "GraphicsStartupTest",
  "HasDeviceTouchScreen",
  "HeadlessMode",
  "IAccessibleConfig",
  "IPCFatalErrorMsg",
  "IPCFatalErrorProtocol",
  "IPCMessageName",
  "IPCMessageSize",
  "IPCReadErrorReason",
  "IPCShutdownState",
  "IPCSystemError",
  "IPCTransportFailureReason",
  "InstallTime",
  "IpcCreateEndpointsNsresult",
  "IpcCreatePipeCloExecErrno",
  "IpcCreatePipeFcntlErrno",
  "IpcCreatePipeSocketPairErrno",
  "IpcCreateTransportDupErrno",
  "IsGarbageCollecting",
  "IsWayland",
  "IsWebRenderResourcePathOverridden",
  "JSActorMessage",
  "JSActorName",
  "JSLargeAllocationFailure",
  "JSModuleLoadError",
  "JSOutOfMemory",
  "JavaException",
  "JavaStackTrace",
  "LastInteractionDuration",
  "LastStartupWasCrash",
  "LauncherProcessState",
  "LinuxUnderMemoryPressure",
  "LowPhysicalMemoryEvents",
  "MacAvailableMemorySysctl",
  "MacMemoryPressure",
  "MacMemoryPressureCriticalTime",
  "MacMemoryPressureNormalTime",
  "MacMemoryPressureSysctl",
  "MacMemoryPressureWarningTime",
  "MainThreadRunnableName",
  "MozCrashReason",
  "Notes",
  "OOMAllocationSize",
  "PHCAllocStack",
  "PHCBaseAddress",
  "PHCFreeStack",
  "PHCKind",
  "PHCUsableSize",
  "PluginFilename",
  "PluginName",
  "PluginVersion",
  "ProcessType",
  "ProductID",
  "ProductName",
  "ProfilerChildShutdownPhase",
  "PurgeablePhysicalMemory",
  "QuotaManagerShutdownTimeout",
  "RDDProcessStatus",
  "ReleaseChannel",
  "RemoteType",
  "SafeMode",
  "SecondsSinceLastCrash",
  "ServerURL",
  "ShutdownProgress",
  "ShutdownReason",
  "StartupCacheValid",
  "StartupCrash",
  "StartupTime",
  "StorageConnectionNotClosed",
  "SubmittedFrom",
  "SystemMemoryUsePercentage",
  "TelemetryClientId",
  "TelemetryEnvironment",
  "TelemetryServerURL",
  "TelemetrySessionId",
  "TestKey",
  "TestUnicode",
  "TextureUsage",
  "Throttleable",
  "TotalPageFile",
  "TotalPhysicalMemory",
  "TotalVirtualMemory",
  "URL",
  "URLSegments",
  "UnknownNetAddrSocketFamily",
  "UptimeTS",
  "User32BeforeBlocklist",
  "UtilityActorsName",
  "UtilityProcessStatus",
  "VRProcessStatus",
  "Vendor",
  "Version",
  "WasmLibrarySandboxMallocFailed",
  "WindowsErrorReporting",
  "WindowsPackageFamilyName",
  "Winsock_LSP",
  "XPCOMSpinEventLoopStack",
  "additional_minidumps",
  "ipc_channel_error",
  "useragent_locale"
};

// Allowlist of crash annotations that can be included in a crash ping
const Annotation kCrashPingAllowlist[] = {
  Annotation::AsyncShutdownTimeout,
  Annotation::AvailablePageFile,
  Annotation::AvailablePhysicalMemory,
  Annotation::AvailableSwapMemory,
  Annotation::AvailableVirtualMemory,
  Annotation::BackgroundTaskName,
  Annotation::BlockedDllList,
  Annotation::BlocklistInitFailed,
  Annotation::BuildID,
  Annotation::CrashTime,
  Annotation::DOMFissionEnabled,
  Annotation::EventLoopNestingLevel,
  Annotation::ExperimentalFeatures,
  Annotation::FontName,
  Annotation::GPUProcessLaunchCount,
  Annotation::HeadlessMode,
  Annotation::IsGarbageCollecting,
  Annotation::LastInteractionDuration,
  Annotation::LowPhysicalMemoryEvents,
  Annotation::MainThreadRunnableName,
  Annotation::MozCrashReason,
  Annotation::OOMAllocationSize,
  Annotation::ProductID,
  Annotation::ProductName,
  Annotation::ProfilerChildShutdownPhase,
  Annotation::PurgeablePhysicalMemory,
  Annotation::QuotaManagerShutdownTimeout,
  Annotation::ReleaseChannel,
  Annotation::RemoteType,
  Annotation::SecondsSinceLastCrash,
  Annotation::ShutdownProgress,
  Annotation::ShutdownReason,
  Annotation::StartupCrash,
  Annotation::SystemMemoryUsePercentage,
  Annotation::TextureUsage,
  Annotation::TotalPageFile,
  Annotation::TotalPhysicalMemory,
  Annotation::TotalVirtualMemory,
  Annotation::UptimeTS,
  Annotation::User32BeforeBlocklist,
  Annotation::UtilityActorsName,
  Annotation::WindowsErrorReporting,
  Annotation::WindowsPackageFamilyName,
  Annotation::ipc_channel_error
};

/**
 * Return the string representation of a crash annotation.
 *
 * @param aAnnotation a crash annotation
 * @returns A constant string holding the annotation name
 */
static inline const char* AnnotationToString(Annotation aAnnotation) {
  return kAnnotationStrings[static_cast<uint32_t>(aAnnotation)];
}

/**
 * Converts a string to its corresponding crash annotation.
 *
 * @param aResult a reference where the annotation will be stored
 * @param aValue the string to be converted
 * @return true if the string was successfully converted, false if it did not
 *         correspond to any known annotation
 */
bool AnnotationFromString(Annotation& aResult, const char* aValue);

/**
 * Checks if the given crash annotation is allowlisted for inclusion in the
 * crash ping.
 *
 * @param aAnnotation the crash annotation to be checked
 * @return true if the annotation can be included in the crash ping, false
 *         otherwise
 */
bool IsAnnotationAllowlistedForPing(Annotation aAnnotation);

/**
 * Abstract annotation writer, this is needed only for code that writes out
 * annotations in the exception handler.
 */
class AnnotationWriter {
 public:
  virtual void Write(Annotation aAnnotation, const char* aValue,
                     size_t aLen = 0) = 0;
  virtual void Write(Annotation aAnnotation, uint64_t aValue) = 0;
};

}  // namespace CrashReporter

#endif  // CrashAnnotations_h
