// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanProfilesMetrics_h
#define mozilla_GleanProfilesMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace profile_lock {
  /**
   * generated from profile.lock.failed_lock_count
   * The number of failed profile lock attempts that occurred prior to
   * successfully locking the profile and starting the app.
   * Previously collected in the "main" ping's `simpleMeasurements`.
   */
  constexpr impl::QuantityMetric failed_lock_count(696);
}

namespace profiles_default {
  /**
   * generated from profiles.default.updated
   */
  /**
   * Recorded when a new profile from a profile group becomes the default startup profile for the group. This may happen when a profile other than the current default is launched from the profile selector window, or when the user has multiple profiles running at the same time and switches app focus to a profile other than the current default. An event is not recorded if the current default profile is launched or gains app focus.
   */
  constexpr impl::EventMetric<NoExtraKeys> updated(697);
}

namespace profiles_delete {
  /**
   * generated from profiles.delete.cancel
   */
  /**
   * Recorded when the user clicks the "Cancel" button on the about:deleteprofile page, canceling deletion of the current profile and closing the page.
   */
  constexpr impl::EventMetric<NoExtraKeys> cancel(698);

  /**
   * generated from profiles.delete.confirm
   */
  /**
   * Recorded when the user clicks the "Delete" button on the about:deleteprofile page, triggering deletion of the current profile.
   */
  constexpr impl::EventMetric<NoExtraKeys> confirm(699);

  /**
   * generated from profiles.delete.displayed
   */
  /**
   * Recorded when the about:deleteprofile page is loaded.
   */
  constexpr impl::EventMetric<NoExtraKeys> displayed(700);
}

namespace profiles_existing {
  /**
   * generated from profiles.existing.alert
   */
  struct AlertExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user tries to close the about:editprofile page without setting a name. A beforeunload alert is then displayed. We record the user's decision to stay on the page or leave in the `extra` value.
   */
  constexpr impl::EventMetric<AlertExtra> alert(701);

  /**
   * generated from profiles.existing.avatar
   */
  struct AvatarExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects a different avatar.
   */
  constexpr impl::EventMetric<AvatarExtra> avatar(702);

  /**
   * generated from profiles.existing.closed
   */
  struct ClosedExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the page is closed.
   */
  constexpr impl::EventMetric<ClosedExtra> closed(703);

  /**
   * generated from profiles.existing.deleted
   */
  /**
   * Recorded when the user clicks the delete button.
   */
  constexpr impl::EventMetric<NoExtraKeys> deleted(704);

  /**
   * generated from profiles.existing.displayed
   */
  /**
   * Recorded when the page is loaded.
   */
  constexpr impl::EventMetric<NoExtraKeys> displayed(705);

  /**
   * generated from profiles.existing.learn_more
   */
  /**
   * Recorded when the "explore more addons" link is clicked.
   */
  constexpr impl::EventMetric<NoExtraKeys> learn_more(706);

  /**
   * generated from profiles.existing.name
   */
  /**
   * Recorded when the name is changed. This event is fired either after the user has stopped typing in the name input field for 2 seconds, or if they have edited the name, then quickly closed the tab.
   */
  constexpr impl::EventMetric<NoExtraKeys> name(707);

  /**
   * generated from profiles.existing.shortcut
   */
  struct ShortcutExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks the desktop shortcut toggle.
   */
  constexpr impl::EventMetric<ShortcutExtra> shortcut(708);

  /**
   * generated from profiles.existing.theme
   */
  struct ThemeExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects a different theme.
   */
  constexpr impl::EventMetric<ThemeExtra> theme(709);
}

namespace profiles_new {
  /**
   * generated from profiles.new.alert
   */
  struct AlertExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user tries to close the about:newprofile page without setting a name. A beforeunload alert is then displayed. We record the user's decision to stay on the page or leave in the `extra` value.
   */
  constexpr impl::EventMetric<AlertExtra> alert(710);

  /**
   * generated from profiles.new.avatar
   */
  struct AvatarExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects a different avatar.
   */
  constexpr impl::EventMetric<AvatarExtra> avatar(711);

  /**
   * generated from profiles.new.closed
   */
  struct ClosedExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the page is closed.
   */
  constexpr impl::EventMetric<ClosedExtra> closed(712);

  /**
   * generated from profiles.new.deleted
   */
  /**
   * Recorded when the user clicks the delete button.
   */
  constexpr impl::EventMetric<NoExtraKeys> deleted(713);

  /**
   * generated from profiles.new.displayed
   */
  /**
   * Recorded when the page is loaded.
   */
  constexpr impl::EventMetric<NoExtraKeys> displayed(714);

  /**
   * generated from profiles.new.learn_more
   */
  /**
   * Recorded when the "explore more addons" link is clicked.
   */
  constexpr impl::EventMetric<NoExtraKeys> learn_more(715);

  /**
   * generated from profiles.new.name
   */
  /**
   * Recorded when the name is changed. This event is fired either after the user has stopped typing in the name input field for 2 seconds, or if they have edited the name, then quickly closed the tab.
   */
  constexpr impl::EventMetric<NoExtraKeys> name(716);

  /**
   * generated from profiles.new.theme
   */
  struct ThemeExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects a different theme.
   */
  constexpr impl::EventMetric<ThemeExtra> theme(717);
}

namespace profiles_selector_window {
  /**
   * generated from profiles.selector_window.launch
   */
  /**
   * Recorded when the user clicks a profile card in the profile selector window, launching the profile in a new Firefox instance.
   */
  constexpr impl::EventMetric<NoExtraKeys> launch(718);

  /**
   * generated from profiles.selector_window.show_at_startup
   */
  struct ShowAtStartupExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user toggles the checkbox that determines if the profile selector window is shown at startup.
   */
  constexpr impl::EventMetric<ShowAtStartupExtra> show_at_startup(719);
}

} // namespace mozilla::glean

#endif // mozilla_GleanProfilesMetrics_h
