// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanPasswordmgrMetrics_h
#define mozilla_GleanPasswordmgrMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace form_autocomplete {
  /**
   * generated from form_autocomplete.show_logins
   */
  struct ShowLoginsExtra {
    mozilla::Maybe<nsCString> acfieldname;
    mozilla::Maybe<nsCString> fieldtype;
    mozilla::Maybe<nsCString> generatedpasswo;
    mozilla::Maybe<nsCString> hadprevious;
    mozilla::Maybe<nsCString> importablelogin;
    mozilla::Maybe<nsCString> insecurewarning;
    mozilla::Maybe<nsCString> login;
    mozilla::Maybe<nsCString> loginsfooter;
    mozilla::Maybe<nsCString> stringlength;
    mozilla::Maybe<nsCString> typewaspassword;
    mozilla::Maybe<uint32_t> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (acfieldname) {
        extraKeys.AppendElement()->AssignASCII("acFieldName");
        extraValues.EmplaceBack(acfieldname.value());
      }
      if (fieldtype) {
        extraKeys.AppendElement()->AssignASCII("fieldType");
        extraValues.EmplaceBack(fieldtype.value());
      }
      if (generatedpasswo) {
        extraKeys.AppendElement()->AssignASCII("generatedPasswo");
        extraValues.EmplaceBack(generatedpasswo.value());
      }
      if (hadprevious) {
        extraKeys.AppendElement()->AssignASCII("hadPrevious");
        extraValues.EmplaceBack(hadprevious.value());
      }
      if (importablelogin) {
        extraKeys.AppendElement()->AssignASCII("importableLogin");
        extraValues.EmplaceBack(importablelogin.value());
      }
      if (insecurewarning) {
        extraKeys.AppendElement()->AssignASCII("insecureWarning");
        extraValues.EmplaceBack(insecurewarning.value());
      }
      if (login) {
        extraKeys.AppendElement()->AssignASCII("login");
        extraValues.EmplaceBack(login.value());
      }
      if (loginsfooter) {
        extraKeys.AppendElement()->AssignASCII("loginsFooter");
        extraValues.EmplaceBack(loginsfooter.value());
      }
      if (stringlength) {
        extraKeys.AppendElement()->AssignASCII("stringLength");
        extraValues.EmplaceBack(stringlength.value());
      }
      if (typewaspassword) {
        extraKeys.AppendElement()->AssignASCII("typeWasPassword");
        extraValues.EmplaceBack(typewaspassword.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.AppendElement()->AppendInt(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An content form autocomplete popup was shown. Details on the timing and context are provided. This event was generated to correspond to the Legacy Telemetry event form_autocomplete.show#logins.
   */
  constexpr impl::EventMetric<ShowLoginsExtra> show_logins(5125);
}

namespace pwmgr {
  /**
   * generated from pwmgr.autocomplete_field_generatedpassword
   */
  /**
   * "autocomplete_field": The first time each unique generated password is used to fill a login field - i.e. the user selects it from from the autocomplete dropdown on a password input "autocomplete_shown": The first time the password generation option is shown in the autocomplete dropdown on a password input for a site per session This event was generated to correspond to the Legacy Telemetry event pwmgr.autocomplete_field#generatedpassword.
   */
  constexpr impl::EventMetric<NoExtraKeys> autocomplete_field_generatedpassword(5126);

  /**
   * generated from pwmgr.autocomplete_shown_generatedpassword
   */
  /**
   * "autocomplete_field": The first time each unique generated password is used to fill a login field - i.e. the user selects it from from the autocomplete dropdown on a password input "autocomplete_shown": The first time the password generation option is shown in the autocomplete dropdown on a password input for a site per session This event was generated to correspond to the Legacy Telemetry event pwmgr.autocomplete_shown#generatedpassword.
   */
  constexpr impl::EventMetric<NoExtraKeys> autocomplete_shown_generatedpassword(5127);

  /**
   * generated from pwmgr.cancel_existing_login
   */
  struct CancelExistingLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.cancel#existing_login.
   */
  constexpr impl::EventMetric<CancelExistingLoginExtra> cancel_existing_login(5128);

  /**
   * generated from pwmgr.cancel_new_login
   */
  struct CancelNewLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.cancel#new_login.
   */
  constexpr impl::EventMetric<CancelNewLoginExtra> cancel_new_login(5129);

  /**
   * generated from pwmgr.copy_password
   */
  struct CopyPasswordExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.copy#password.
   */
  constexpr impl::EventMetric<CopyPasswordExtra> copy_password(5130);

  /**
   * generated from pwmgr.copy_username
   */
  struct CopyUsernameExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.copy#username.
   */
  constexpr impl::EventMetric<CopyUsernameExtra> copy_username(5131);

  /**
   * generated from pwmgr.delete_existing_login
   */
  struct DeleteExistingLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.delete#existing_login.
   */
  constexpr impl::EventMetric<DeleteExistingLoginExtra> delete_existing_login(5132);

  /**
   * generated from pwmgr.delete_new_login
   */
  struct DeleteNewLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.delete#new_login.
   */
  constexpr impl::EventMetric<DeleteNewLoginExtra> delete_new_login(5133);

  /**
   * generated from pwmgr.doorhanger_submitted_save
   */
  struct DoorhangerSubmittedSaveExtra {
    mozilla::Maybe<bool> didEditPw;
    mozilla::Maybe<bool> didEditUn;
    mozilla::Maybe<bool> didSelectPw;
    mozilla::Maybe<bool> didSelectUn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (didEditPw) {
        extraKeys.AppendElement()->AssignASCII("did_edit_pw");
        extraValues.AppendElement()->AssignASCII(didEditPw.value() ? "true" : "false");
      }
      if (didEditUn) {
        extraKeys.AppendElement()->AssignASCII("did_edit_un");
        extraValues.AppendElement()->AssignASCII(didEditUn.value() ? "true" : "false");
      }
      if (didSelectPw) {
        extraKeys.AppendElement()->AssignASCII("did_select_pw");
        extraValues.AppendElement()->AssignASCII(didSelectPw.value() ? "true" : "false");
      }
      if (didSelectUn) {
        extraKeys.AppendElement()->AssignASCII("did_select_un");
        extraValues.AppendElement()->AssignASCII(didSelectUn.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A login is saved or updated via the capture doorhanger. Carries information about whether the username and password _that were saved/updated by the user_ were modified in the doorhanger, selected from the suggestion autocomplete, or neither. `did_edit_X` and `did_select_X` will never both be true in the same event. The `object` describes the type of doorhanger when it was originally created. Note that user updates to the doorhanger may change whether a login is actually saved or updated, but will not impact the sent object. This event was generated to correspond to the Legacy Telemetry event pwmgr.doorhanger_submitted#save.
   */
  constexpr impl::EventMetric<DoorhangerSubmittedSaveExtra> doorhanger_submitted_save(5134);

  /**
   * generated from pwmgr.doorhanger_submitted_update
   */
  struct DoorhangerSubmittedUpdateExtra {
    mozilla::Maybe<bool> didEditPw;
    mozilla::Maybe<bool> didEditUn;
    mozilla::Maybe<bool> didSelectPw;
    mozilla::Maybe<bool> didSelectUn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (didEditPw) {
        extraKeys.AppendElement()->AssignASCII("did_edit_pw");
        extraValues.AppendElement()->AssignASCII(didEditPw.value() ? "true" : "false");
      }
      if (didEditUn) {
        extraKeys.AppendElement()->AssignASCII("did_edit_un");
        extraValues.AppendElement()->AssignASCII(didEditUn.value() ? "true" : "false");
      }
      if (didSelectPw) {
        extraKeys.AppendElement()->AssignASCII("did_select_pw");
        extraValues.AppendElement()->AssignASCII(didSelectPw.value() ? "true" : "false");
      }
      if (didSelectUn) {
        extraKeys.AppendElement()->AssignASCII("did_select_un");
        extraValues.AppendElement()->AssignASCII(didSelectUn.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A login is saved or updated via the capture doorhanger. Carries information about whether the username and password _that were saved/updated by the user_ were modified in the doorhanger, selected from the suggestion autocomplete, or neither. `did_edit_X` and `did_select_X` will never both be true in the same event. The `object` describes the type of doorhanger when it was originally created. Note that user updates to the doorhanger may change whether a login is actually saved or updated, but will not impact the sent object. This event was generated to correspond to the Legacy Telemetry event pwmgr.doorhanger_submitted#update.
   */
  constexpr impl::EventMetric<DoorhangerSubmittedUpdateExtra> doorhanger_submitted_update(5135);

  /**
   * generated from pwmgr.edit_existing_login
   */
  struct EditExistingLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.edit#existing_login.
   */
  constexpr impl::EventMetric<EditExistingLoginExtra> edit_existing_login(5136);

  /**
   * generated from pwmgr.filled_field_edited_generatedpassword
   */
  /**
   * The first time each generated password filled in a website form field is edited by the user in a field it was filled in This event was generated to correspond to the Legacy Telemetry event pwmgr.filled_field_edited#generatedpassword.
   */
  constexpr impl::EventMetric<NoExtraKeys> filled_field_edited_generatedpassword(5137);

  /**
   * generated from pwmgr.filter_list
   */
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.filter#list.
   */
  constexpr impl::EventMetric<NoExtraKeys> filter_list(5138);

  /**
   * generated from pwmgr.form_autofill_result
   */
  enum class FormAutofillResultLabel: uint16_t {
    eFilled = 0,
    eNoPasswordField = 1,
    ePasswordDisabledReadonly = 2,
    eNoLoginsFit = 3,
    eNoSavedLogins = 4,
    eExistingPassword = 5,
    eExistingUsername = 6,
    eMultipleLogins = 7,
    eNoAutofillForms = 8,
    eAutocompleteOff = 9,
    eInsecure = 10,
    ePasswordAutocompleteNewPassword = 11,
    eTypeNoLongerPassword = 12,
    eFormInCrossoriginSubframe = 13,
    eFilledUsernameOnlyForm = 14,
    e__Other__,
  };
  /**
   * The result of auto-filling a login form.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FormAutofillResultLabel> form_autofill_result(5139);

  /**
   * generated from pwmgr.hide_password
   */
  struct HidePasswordExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.hide#password.
   */
  constexpr impl::EventMetric<HidePasswordExtra> hide_password(5140);

  /**
   * generated from pwmgr.import_logins_from_file_categorical
   */
  enum class ImportLoginsFromFileCategoricalLabel: uint16_t {
    eAdded = 0,
    eModified = 1,
    eError = 2,
    eNoChange = 3,
    e__Other__,
  };
  /**
   * Results of login import from a CSV/TSV file, by category
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram PWMGR_IMPORT_LOGINS_FROM_FILE_CATEGORICAL.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ImportLoginsFromFileCategoricalLabel> import_logins_from_file_categorical(5141);

  /**
   * generated from pwmgr.is_username_only_form
   */
  enum class IsUsernameOnlyFormLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a <form> is a username-only form. (0=Form has a possible username field but is not considered as a username-only form, 1=Form is considered as a username-only form)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram PWMGR_IS_USERNAME_ONLY_FORM.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, IsUsernameOnlyFormLabel> is_username_only_form(5142);

  /**
   * generated from pwmgr.learn_more_vuln_existing_login
   */
  struct LearnMoreVulnExistingLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.learn_more_vuln#existing_login.
   */
  constexpr impl::EventMetric<LearnMoreVulnExistingLoginExtra> learn_more_vuln_existing_login(5143);

  /**
   * generated from pwmgr.login_page_safety
   * The safety of a page where we see a password field. (0: safe page & safe submit; 1: safe page & unsafe submit; 2: safe page & unknown submit; 3: unsafe page & safe submit; 4: unsafe page & unsafe submit; 5: unsafe page & unknown submit)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PWMGR_LOGIN_PAGE_SAFETY.
   */
  constexpr impl::CustomDistributionMetric login_page_safety(5144);

  /**
   * generated from pwmgr.mgmt_menu_item_used_export
   */
  /**
   * Record interactions with the about:logins menu. This event was generated to correspond to the Legacy Telemetry event pwmgr.mgmt_menu_item_used#export.
   */
  constexpr impl::EventMetric<NoExtraKeys> mgmt_menu_item_used_export(5145);

  /**
   * generated from pwmgr.mgmt_menu_item_used_export_complete
   */
  /**
   * Record interactions with the about:logins menu. This event was generated to correspond to the Legacy Telemetry event pwmgr.mgmt_menu_item_used#export_complete.
   */
  constexpr impl::EventMetric<NoExtraKeys> mgmt_menu_item_used_export_complete(5146);

  /**
   * generated from pwmgr.mgmt_menu_item_used_import_csv_complete
   */
  /**
   * Record interactions with the about:logins menu. This event was generated to correspond to the Legacy Telemetry event pwmgr.mgmt_menu_item_used#import_csv_complete.
   */
  constexpr impl::EventMetric<NoExtraKeys> mgmt_menu_item_used_import_csv_complete(5147);

  /**
   * generated from pwmgr.mgmt_menu_item_used_import_from_browser
   */
  /**
   * Record interactions with the about:logins menu. This event was generated to correspond to the Legacy Telemetry event pwmgr.mgmt_menu_item_used#import_from_browser.
   */
  constexpr impl::EventMetric<NoExtraKeys> mgmt_menu_item_used_import_from_browser(5148);

  /**
   * generated from pwmgr.mgmt_menu_item_used_import_from_csv
   */
  /**
   * Record interactions with the about:logins menu. This event was generated to correspond to the Legacy Telemetry event pwmgr.mgmt_menu_item_used#import_from_csv.
   */
  constexpr impl::EventMetric<NoExtraKeys> mgmt_menu_item_used_import_from_csv(5149);

  /**
   * generated from pwmgr.mgmt_menu_item_used_preferences
   */
  /**
   * Record interactions with the about:logins menu. This event was generated to correspond to the Legacy Telemetry event pwmgr.mgmt_menu_item_used#preferences.
   */
  constexpr impl::EventMetric<NoExtraKeys> mgmt_menu_item_used_preferences(5150);

  /**
   * generated from pwmgr.migration
   */
  struct MigrationExtra {
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Emitted multiple times during the desktop login migration triggered by the signon.reencryptionNeeded pref.
   */
  constexpr impl::EventMetric<MigrationExtra> migration(5151);

  /**
   * generated from pwmgr.new_new_login
   */
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.new#new_login.
   */
  constexpr impl::EventMetric<NoExtraKeys> new_new_login(5152);

  /**
   * generated from pwmgr.num_improved_generated_passwords
   */
  enum class NumImprovedGeneratedPasswordsLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * The number of passwords generated when 'signon.improvedPasswordRules.enabled' is true. 0 = Password generated by default rules, 1 = Password generated by custom rules
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram PWMGR_NUM_IMPROVED_GENERATED_PASSWORDS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NumImprovedGeneratedPasswordsLabel> num_improved_generated_passwords(5153);

  /**
   * generated from pwmgr.num_saved_passwords
   * The number of saved logins, including those that cannot be decrypted.
   * Similar to the legacy telemetry histogram PWMGR_NUM_SAVED_PASSWORDS.
   */
  constexpr impl::QuantityMetric num_saved_passwords(5154);

  /**
   * generated from pwmgr.open_management_aboutprotections
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#aboutprotections.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_aboutprotections(5155);

  /**
   * generated from pwmgr.open_management_autocomplete
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#autocomplete.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_autocomplete(5156);

  /**
   * generated from pwmgr.open_management_contextmenu
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#contextmenu.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_contextmenu(5157);

  /**
   * generated from pwmgr.open_management_direct
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#direct.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_direct(5158);

  /**
   * generated from pwmgr.open_management_mainmenu
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#mainmenu.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_mainmenu(5159);

  /**
   * generated from pwmgr.open_management_pageinfo
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#pageinfo.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_pageinfo(5160);

  /**
   * generated from pwmgr.open_management_preferences
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#preferences.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_preferences(5161);

  /**
   * generated from pwmgr.open_management_snippet
   */
  /**
   * Sent when opening the password management UI. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_management#snippet.
   */
  constexpr impl::EventMetric<NoExtraKeys> open_management_snippet(5162);

  /**
   * generated from pwmgr.open_site_existing_login
   */
  struct OpenSiteExistingLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.open_site#existing_login.
   */
  constexpr impl::EventMetric<OpenSiteExistingLoginExtra> open_site_existing_login(5163);

  /**
   * generated from pwmgr.os_auth_enabled
   * Check at startup whether OS Authentication has been enabled for passwords.
   */
  constexpr impl::BooleanMetric os_auth_enabled(5164);

  /**
   * generated from pwmgr.potentially_breached_passwords
   * The number of potentially breached passwords, as determined by LoginBreaches.getPotentialBreachesByLoginGUID. This metric was generated to correspond to the Legacy Telemetry scalar pwmgr.potentially_breached_passwords.
   */
  constexpr impl::QuantityMetric potentially_breached_passwords(5165);

  /**
   * generated from pwmgr.prompt_remember_action
   * Action taken by user through prompt for creating a login. (0=Prompt displayed [always recorded], 1=Add login, 2=Don't save now, 3=Never save)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PWMGR_PROMPT_REMEMBER_ACTION.
   */
  constexpr impl::CustomDistributionMetric prompt_remember_action(5166);

  /**
   * generated from pwmgr.prompt_shown_os_reauth
   */
  struct PromptShownOsReauthExtra {
    mozilla::Maybe<nsCString> result;
    mozilla::Maybe<nsCString> trigger;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Captures the method of user interaction initiating the prompt and the result of the prompt. Possible triggers include:
   *   "copy_logins" when a user copies a password in about:logins
   *   "copy_cpm" when a user copies a password in contextual password manager
   *   "edit_logins" when a user edits a login in about:logins
   *   "edit_cpm" when a user edits a login in contextual password manager
   *   "export_logins" when a user exports all passwords in about:logins
   *   "export_cpm" when a user exports all passwords in contextual password manager
   *   "reveal_logins" when a user reveals a password a login in about:logins
   *   "reveal_cpm" when a user reveals a password a login in contextual password manager
   *   "toggle_pref_primary_password" when a user toggles "Use a Primary Password" in about:preferences
   *   "toggle_pref_os_auth" when a user toggles "Passwords / Require device sign in" in about:preferences
   * Possible results include:
   *   "success" should be used when the user is shown the OS Auth prompt and successfully authenticates.
   *   "fail_user_canceled" should be used when the user cancels the authentication prompt. The user may or may not have provided an incorrect password before cancelling.
   *   "fail_error" should be used when an unexpected exception is encountered.
   */
  constexpr impl::EventMetric<PromptShownOsReauthExtra> prompt_shown_os_reauth(5167);

  /**
   * generated from pwmgr.prompt_update_action
   * Action taken by user through prompt for modifying a login. (0=Prompt displayed [always recorded], 1=Update login, 2=Don't update, 3=Remove saved login)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram PWMGR_PROMPT_UPDATE_ACTION.
   */
  constexpr impl::CustomDistributionMetric prompt_update_action(5168);

  /**
   * generated from pwmgr.reauthenticate_master_password
   */
  struct ReauthenticateMasterPasswordExtra {
    mozilla::Maybe<nsCString> autoAdmin;
    mozilla::Maybe<nsCString> requireSignon;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (autoAdmin) {
        extraKeys.AppendElement()->AssignASCII("auto_admin");
        extraValues.EmplaceBack(autoAdmin.value());
      }
      if (requireSignon) {
        extraKeys.AppendElement()->AssignASCII("require_signon");
        extraValues.EmplaceBack(requireSignon.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Measure how often users are asked to authenticate with their Operating System or Master Password to gain access to stored passwords. Possible values are as follows,
   *   "success" should be used when the user authenticates and provides a password or other authentication factor.
   *   "success_no_prompt" should be used when the feature is enabled but no prompt is given to the user because they have recently authenticated.
   *   "success_disabled" is used when the feature is disabled.
   *   "success_unsupported_platform" should be set when the user attempts to authenticate on an unsupported platform.
   *   "success_no_password" should be used when the user doesn't have an OS password set.
   *   "fail" should be used when the user cancels the authentication prompt or an unexpected exception is encountered. The user may or may not have provided an incorrect password before cancelling.
   * This event was generated to correspond to the Legacy Telemetry event pwmgr.reauthenticate#master_password.
   */
  constexpr impl::EventMetric<ReauthenticateMasterPasswordExtra> reauthenticate_master_password(5169);

  /**
   * generated from pwmgr.reauthenticate_os_auth
   */
  struct ReauthenticateOsAuthExtra {
    mozilla::Maybe<nsCString> autoAdmin;
    mozilla::Maybe<nsCString> requireSignon;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (autoAdmin) {
        extraKeys.AppendElement()->AssignASCII("auto_admin");
        extraValues.EmplaceBack(autoAdmin.value());
      }
      if (requireSignon) {
        extraKeys.AppendElement()->AssignASCII("require_signon");
        extraValues.EmplaceBack(requireSignon.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Measure how often users are asked to authenticate with their Operating System or Master Password to gain access to stored passwords. Possible values are as follows,
   *   "success" should be used when the user authenticates and provides a password or other authentication factor.
   *   "success_no_prompt" should be used when the feature is enabled but no prompt is given to the user because they have recently authenticated.
   *   "success_disabled" is used when the feature is disabled.
   *   "success_unsupported_platform" should be set when the user attempts to authenticate on an unsupported platform.
   *   "success_no_password" should be used when the user doesn't have an OS password set.
   *   "fail" should be used when the user cancels the authentication prompt or an unexpected exception is encountered. The user may or may not have provided an incorrect password before cancelling.
   * This event was generated to correspond to the Legacy Telemetry event pwmgr.reauthenticate#os_auth.
   */
  constexpr impl::EventMetric<ReauthenticateOsAuthExtra> reauthenticate_os_auth(5170);

  /**
   * generated from pwmgr.require_os_reauth_toggle
   */
  struct RequireOsReauthToggleExtra {
    mozilla::Maybe<bool> toggleState;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (toggleState) {
        extraKeys.AppendElement()->AssignASCII("toggle_state");
        extraValues.AppendElement()->AssignASCII(toggleState.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Captures the state of the toggle after the change was made. Toggle states include:
   *   True means the OS Auth preference is enabeled.
   *   False means it is disabled.
   */
  constexpr impl::EventMetric<RequireOsReauthToggleExtra> require_os_reauth_toggle(5171);

  /**
   * generated from pwmgr.rust_migration_status
   */
  struct RustMigrationStatusExtra {
    mozilla::Maybe<uint32_t> durationMs;
    mozilla::Maybe<bool> hadErrors;
    mozilla::Maybe<nsCString> metricVersion;
    mozilla::Maybe<uint32_t> numberOfLoginsMigrated;
    mozilla::Maybe<uint32_t> numberOfLoginsToMigrate;
    mozilla::Maybe<nsCString> runId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (durationMs) {
        extraKeys.AppendElement()->AssignASCII("duration_ms");
        extraValues.AppendElement()->AppendInt(durationMs.value());
      }
      if (hadErrors) {
        extraKeys.AppendElement()->AssignASCII("had_errors");
        extraValues.AppendElement()->AssignASCII(hadErrors.value() ? "true" : "false");
      }
      if (metricVersion) {
        extraKeys.AppendElement()->AssignASCII("metric_version");
        extraValues.EmplaceBack(metricVersion.value());
      }
      if (numberOfLoginsMigrated) {
        extraKeys.AppendElement()->AssignASCII("number_of_logins_migrated");
        extraValues.AppendElement()->AppendInt(numberOfLoginsMigrated.value());
      }
      if (numberOfLoginsToMigrate) {
        extraKeys.AppendElement()->AssignASCII("number_of_logins_to_migrate");
        extraValues.AppendElement()->AppendInt(numberOfLoginsToMigrate.value());
      }
      if (runId) {
        extraKeys.AppendElement()->AssignASCII("run_id");
        extraValues.EmplaceBack(runId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * One record per rolling migration run, recording duration, total number of logins migrated and whether there have been errors.
   */
  constexpr impl::EventMetric<RustMigrationStatusExtra> rust_migration_status(5172);

  /**
   * generated from pwmgr.rust_mirror_status
   */
  struct RustMirrorStatusExtra {
    mozilla::Maybe<nsCString> metricVersion;
    mozilla::Maybe<nsCString> operation;
    mozilla::Maybe<nsCString> runId;
    mozilla::Maybe<nsCString> status;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (metricVersion) {
        extraKeys.AppendElement()->AssignASCII("metric_version");
        extraValues.EmplaceBack(metricVersion.value());
      }
      if (operation) {
        extraKeys.AppendElement()->AssignASCII("operation");
        extraValues.EmplaceBack(operation.value());
      }
      if (runId) {
        extraKeys.AppendElement()->AssignASCII("run_id");
        extraValues.EmplaceBack(runId.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records the outcome of each operation mirrored into the Rust password store. Each record contains the operation type and whether it succeeded or failed.
   */
  constexpr impl::EventMetric<RustMirrorStatusExtra> rust_mirror_status(5173);

  /**
   * generated from pwmgr.rust_write_failure
   */
  struct RustWriteFailureExtra {
    mozilla::Maybe<nsCString> errorMessage;
    mozilla::Maybe<nsCString> formActionOriginError;
    mozilla::Maybe<bool> formActionOriginFixable;
    mozilla::Maybe<bool> hasEmptyPassword;
    mozilla::Maybe<bool> hasPunycodeFormActionOrigin;
    mozilla::Maybe<bool> hasPunycodeOrigin;
    mozilla::Maybe<bool> hasUsernameLineBreak;
    mozilla::Maybe<bool> hasUsernameNul;
    mozilla::Maybe<bool> isDeleted;
    mozilla::Maybe<nsCString> metricVersion;
    mozilla::Maybe<nsCString> operation;
    mozilla::Maybe<nsCString> originError;
    mozilla::Maybe<bool> originFixable;
    mozilla::Maybe<bool> poisoned;
    mozilla::Maybe<nsCString> runId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorMessage) {
        extraKeys.AppendElement()->AssignASCII("error_message");
        extraValues.EmplaceBack(errorMessage.value());
      }
      if (formActionOriginError) {
        extraKeys.AppendElement()->AssignASCII("form_action_origin_error");
        extraValues.EmplaceBack(formActionOriginError.value());
      }
      if (formActionOriginFixable) {
        extraKeys.AppendElement()->AssignASCII("form_action_origin_fixable");
        extraValues.AppendElement()->AssignASCII(formActionOriginFixable.value() ? "true" : "false");
      }
      if (hasEmptyPassword) {
        extraKeys.AppendElement()->AssignASCII("has_empty_password");
        extraValues.AppendElement()->AssignASCII(hasEmptyPassword.value() ? "true" : "false");
      }
      if (hasPunycodeFormActionOrigin) {
        extraKeys.AppendElement()->AssignASCII("has_punycode_form_action_origin");
        extraValues.AppendElement()->AssignASCII(hasPunycodeFormActionOrigin.value() ? "true" : "false");
      }
      if (hasPunycodeOrigin) {
        extraKeys.AppendElement()->AssignASCII("has_punycode_origin");
        extraValues.AppendElement()->AssignASCII(hasPunycodeOrigin.value() ? "true" : "false");
      }
      if (hasUsernameLineBreak) {
        extraKeys.AppendElement()->AssignASCII("has_username_line_break");
        extraValues.AppendElement()->AssignASCII(hasUsernameLineBreak.value() ? "true" : "false");
      }
      if (hasUsernameNul) {
        extraKeys.AppendElement()->AssignASCII("has_username_nul");
        extraValues.AppendElement()->AssignASCII(hasUsernameNul.value() ? "true" : "false");
      }
      if (isDeleted) {
        extraKeys.AppendElement()->AssignASCII("is_deleted");
        extraValues.AppendElement()->AssignASCII(isDeleted.value() ? "true" : "false");
      }
      if (metricVersion) {
        extraKeys.AppendElement()->AssignASCII("metric_version");
        extraValues.EmplaceBack(metricVersion.value());
      }
      if (operation) {
        extraKeys.AppendElement()->AssignASCII("operation");
        extraValues.EmplaceBack(operation.value());
      }
      if (originError) {
        extraKeys.AppendElement()->AssignASCII("origin_error");
        extraValues.EmplaceBack(originError.value());
      }
      if (originFixable) {
        extraKeys.AppendElement()->AssignASCII("origin_fixable");
        extraValues.AppendElement()->AssignASCII(originFixable.value() ? "true" : "false");
      }
      if (poisoned) {
        extraKeys.AppendElement()->AssignASCII("poisoned");
        extraValues.AppendElement()->AssignASCII(poisoned.value() ? "true" : "false");
      }
      if (runId) {
        extraKeys.AppendElement()->AssignASCII("run_id");
        extraValues.EmplaceBack(runId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records errors during mirror or migration run.
   */
  constexpr impl::EventMetric<RustWriteFailureExtra> rust_write_failure(5174);

  /**
   * generated from pwmgr.save_existing_login
   */
  struct SaveExistingLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.save#existing_login.
   */
  constexpr impl::EventMetric<SaveExistingLoginExtra> save_existing_login(5175);

  /**
   * generated from pwmgr.save_new_login
   */
  struct SaveNewLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.save#new_login.
   */
  constexpr impl::EventMetric<SaveNewLoginExtra> save_new_login(5176);

  /**
   * generated from pwmgr.saved_login_used_auth_login
   */
  struct SavedLoginUsedAuthLoginExtra {
    mozilla::Maybe<bool> filled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filled) {
        extraKeys.AppendElement()->AssignASCII("filled");
        extraValues.AppendElement()->AssignASCII(filled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Each time a saved login is used in a form or authentication dialog. This event was generated to correspond to the Legacy Telemetry event pwmgr.saved_login_used#auth_login.
   */
  constexpr impl::EventMetric<SavedLoginUsedAuthLoginExtra> saved_login_used_auth_login(5177);

  /**
   * generated from pwmgr.saved_login_used_form_login
   */
  struct SavedLoginUsedFormLoginExtra {
    mozilla::Maybe<bool> filled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filled) {
        extraKeys.AppendElement()->AssignASCII("filled");
        extraValues.AppendElement()->AssignASCII(filled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Each time a saved login is used in a form or authentication dialog. This event was generated to correspond to the Legacy Telemetry event pwmgr.saved_login_used#form_login.
   */
  constexpr impl::EventMetric<SavedLoginUsedFormLoginExtra> saved_login_used_form_login(5178);

  /**
   * generated from pwmgr.saved_login_used_form_password
   */
  struct SavedLoginUsedFormPasswordExtra {
    mozilla::Maybe<bool> filled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filled) {
        extraKeys.AppendElement()->AssignASCII("filled");
        extraValues.AppendElement()->AssignASCII(filled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Each time a saved login is used in a form or authentication dialog. This event was generated to correspond to the Legacy Telemetry event pwmgr.saved_login_used#form_password.
   */
  constexpr impl::EventMetric<SavedLoginUsedFormPasswordExtra> saved_login_used_form_password(5179);

  /**
   * generated from pwmgr.saved_login_used_prompt_login
   */
  struct SavedLoginUsedPromptLoginExtra {
    mozilla::Maybe<bool> filled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filled) {
        extraKeys.AppendElement()->AssignASCII("filled");
        extraValues.AppendElement()->AssignASCII(filled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Each time a saved login is used in a form or authentication dialog. This event was generated to correspond to the Legacy Telemetry event pwmgr.saved_login_used#prompt_login.
   */
  constexpr impl::EventMetric<SavedLoginUsedPromptLoginExtra> saved_login_used_prompt_login(5180);

  /**
   * generated from pwmgr.saving_enabled
   * Whether password saving is enabled globally.
   * Tracks the pref `signon.rememberSignons`.
   */
  constexpr impl::BooleanMetric saving_enabled(5181);

  /**
   * generated from pwmgr.select_existing_login
   */
  struct SelectExistingLoginExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.select#existing_login.
   */
  constexpr impl::EventMetric<SelectExistingLoginExtra> select_existing_login(5182);

  /**
   * generated from pwmgr.show_password
   */
  struct ShowPasswordExtra {
    mozilla::Maybe<bool> breached;
    mozilla::Maybe<bool> vulnerable;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (breached) {
        extraKeys.AppendElement()->AssignASCII("breached");
        extraValues.AppendElement()->AssignASCII(breached.value() ? "true" : "false");
      }
      if (vulnerable) {
        extraKeys.AppendElement()->AssignASCII("vulnerable");
        extraValues.AppendElement()->AssignASCII(vulnerable.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.show#password.
   */
  constexpr impl::EventMetric<ShowPasswordExtra> show_password(5183);

  /**
   * generated from pwmgr.signup_form_detection
   * Elapsed time to detect whether a <form> element is a signup form.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PWMGR_SIGNUP_FORM_DETECTION_MS.
   */
  constexpr impl::TimingDistributionMetric signup_form_detection(5184);

  /**
   * generated from pwmgr.sort_list
   */
  struct SortListExtra {
    mozilla::Maybe<nsCString> sortKey;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sortKey) {
        extraKeys.AppendElement()->AssignASCII("sort_key");
        extraValues.EmplaceBack(sortKey.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events record interactions on the about:logins page. This event was generated to correspond to the Legacy Telemetry event pwmgr.sort#list.
   */
  constexpr impl::EventMetric<SortListExtra> sort_list(5185);
}

namespace relay_integration {
  /**
   * generated from relay_integration.clicked_fill_username
   */
  struct ClickedFillUsernameExtra {
    mozilla::Maybe<nsCString> errorCode;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorCode) {
        extraKeys.AppendElement()->AssignASCII("error_code");
        extraValues.EmplaceBack(errorCode.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Firefox relay integration autocomplete popup. Note: this event does NOT fire when a user places an email mask
   *   during their first Relay opt-in flow.
   *   So, we also fire `placed_email_mask`, defined below.
   * This event was generated to correspond to the Legacy Telemetry event relay_integration.clicked#fill_username.
   */
  constexpr impl::EventMetric<ClickedFillUsernameExtra> clicked_fill_username(5186);

  /**
   * generated from relay_integration.clicked_offer_relay
   */
  struct ClickedOfferRelayExtra {
    mozilla::Maybe<nsCString> scenario;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (scenario) {
        extraKeys.AppendElement()->AssignASCII("scenario");
        extraValues.EmplaceBack(scenario.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Firefox relay integration autocomplete popup This event was generated to correspond to the Legacy Telemetry event relay_integration.clicked#offer_relay.
   */
  constexpr impl::EventMetric<ClickedOfferRelayExtra> clicked_offer_relay(5187);

  /**
   * generated from relay_integration.disabled_opt_in_panel
   */
  struct DisabledOptInPanelExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Panel to opt-in Firefox Relay Integration This event was generated to correspond to the Legacy Telemetry event relay_integration.disabled#opt_in_panel.
   */
  constexpr impl::EventMetric<DisabledOptInPanelExtra> disabled_opt_in_panel(5188);

  /**
   * generated from relay_integration.disabled_pref_change
   */
  /**
   * Checkbox in the settings page to enable/disable relay This event was generated to correspond to the Legacy Telemetry event relay_integration.disabled#pref_change.
   */
  constexpr impl::EventMetric<NoExtraKeys> disabled_pref_change(5189);

  /**
   * generated from relay_integration.enabled_opt_in_panel
   */
  struct EnabledOptInPanelExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Panel to opt-in Firefox Relay Integration This event was generated to correspond to the Legacy Telemetry event relay_integration.enabled#opt_in_panel.
   */
  constexpr impl::EventMetric<EnabledOptInPanelExtra> enabled_opt_in_panel(5190);

  /**
   * generated from relay_integration.enabled_pref_change
   */
  /**
   * Checkbox in the settings page to enable/disable relay This event was generated to correspond to the Legacy Telemetry event relay_integration.enabled#pref_change.
   */
  constexpr impl::EventMetric<NoExtraKeys> enabled_pref_change(5191);

  /**
   * generated from relay_integration.get_unlimited_masks_reuse_panel
   */
  struct GetUnlimitedMasksReusePanelExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Panels to show the state of the email alias generation This event was generated to correspond to the Legacy Telemetry event relay_integration.get_unlimited_masks#reuse_panel.
   */
  constexpr impl::EventMetric<GetUnlimitedMasksReusePanelExtra> get_unlimited_masks_reuse_panel(5192);

  /**
   * generated from relay_integration.placed_email_mask
   */
  struct PlacedEmailMaskExtra {
    mozilla::Maybe<nsCString> errorCode;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorCode) {
        extraKeys.AppendElement()->AssignASCII("error_code");
        extraValues.EmplaceBack(errorCode.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a Firefox Relay mask is placed (filled) in a form field, e.g., when the user selects a Relay-provided mask fromautocompleteautocomplete, or after successful opt-in.
   */
  constexpr impl::EventMetric<PlacedEmailMaskExtra> placed_email_mask(5193);

  /**
   * generated from relay_integration.postponed_opt_in_panel
   */
  struct PostponedOptInPanelExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Panel to opt-in Firefox Relay Integration This event was generated to correspond to the Legacy Telemetry event relay_integration.postponed#opt_in_panel.
   */
  constexpr impl::EventMetric<PostponedOptInPanelExtra> postponed_opt_in_panel(5194);

  /**
   * generated from relay_integration.reuse_mask_reuse_panel
   */
  struct ReuseMaskReusePanelExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Panels to show the state of the email alias generation This event was generated to correspond to the Legacy Telemetry event relay_integration.reuse_mask#reuse_panel.
   */
  constexpr impl::EventMetric<ReuseMaskReusePanelExtra> reuse_mask_reuse_panel(5195);

  /**
   * generated from relay_integration.shown_fill_username
   */
  struct ShownFillUsernameExtra {
    mozilla::Maybe<nsCString> errorCode;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorCode) {
        extraKeys.AppendElement()->AssignASCII("error_code");
        extraValues.EmplaceBack(errorCode.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Firefox relay integration autocomplete popup This event was generated to correspond to the Legacy Telemetry event relay_integration.shown#fill_username.
   */
  constexpr impl::EventMetric<ShownFillUsernameExtra> shown_fill_username(5196);

  /**
   * generated from relay_integration.shown_offer_relay
   */
  struct ShownOfferRelayExtra {
    mozilla::Maybe<nsCString> scenario;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (scenario) {
        extraKeys.AppendElement()->AssignASCII("scenario");
        extraValues.EmplaceBack(scenario.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Firefox relay integration autocomplete popup This event was generated to correspond to the Legacy Telemetry event relay_integration.shown#offer_relay.
   */
  constexpr impl::EventMetric<ShownOfferRelayExtra> shown_offer_relay(5197);

  /**
   * generated from relay_integration.shown_opt_in_panel
   */
  struct ShownOptInPanelExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Panel to opt-in Firefox Relay Integration This event was generated to correspond to the Legacy Telemetry event relay_integration.shown#opt_in_panel.
   */
  constexpr impl::EventMetric<ShownOptInPanelExtra> shown_opt_in_panel(5198);

  /**
   * generated from relay_integration.shown_reuse_panel
   */
  struct ShownReusePanelExtra {
    mozilla::Maybe<nsCString> errorCode;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorCode) {
        extraKeys.AppendElement()->AssignASCII("error_code");
        extraValues.EmplaceBack(errorCode.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Panels to show the state of the email alias generation This event was generated to correspond to the Legacy Telemetry event relay_integration.shown#reuse_panel.
   */
  constexpr impl::EventMetric<ShownReusePanelExtra> shown_reuse_panel(5199);
}

} // namespace mozilla::glean

#endif // mozilla_GleanPasswordmgrMetrics_h
