// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDohMetrics_h
#define mozilla_GleanDohMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace networking {
  /**
   * generated from networking.doh_heuristic_ever_tripped
   * True if this heuristic (key) was ever tripped during the session. This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristic_ever_tripped.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> doh_heuristic_ever_tripped(189);

  /**
   * generated from networking.doh_heuristics_attempts
   * The number of times we ran DoH heuristics. This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristics_attempts.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> doh_heuristics_attempts(190);

  /**
   * generated from networking.doh_heuristics_pass_count
   * The number of times we passed DoH heuristics. This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristics_pass_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> doh_heuristics_pass_count(191);

  /**
   * generated from networking.doh_heuristics_result
   * The value of this scalar indicates the result of the last heuristic run. 0: "incomplete" 1: "pass" 2: "opt-out" 3: "manually-disabled" 4: "manually-enabled" 5: "enterprise-disabled" 6: "enterprise- present" 7: "enterprise-enabled" 8: "vpn" 9: "proxy" 10: "nrpt" 11: "parental" 12: "modifiedRoots" 13: "thirdPartyRoots" 14: "google" 15: "youtube" 16: "zscaler" 17: "canary" 18: "ignored" This metric was generated to correspond to the Legacy Telemetry scalar networking.doh_heuristics_result.
   */
  constexpr impl::QuantityMetric doh_heuristics_result(192);
}

namespace doh {
  /**
   * generated from doh.evaluate_v2_heuristics
   */
  struct EvaluateV2HeuristicsExtra {
    mozilla::Maybe<nsCString> canaries;
    mozilla::Maybe<nsCString> captivestate;
    mozilla::Maybe<nsCString> enterprise;
    mozilla::Maybe<nsCString> evaluatereason;
    mozilla::Maybe<nsCString> filtering;
    mozilla::Maybe<nsCString> networkid;
    mozilla::Maybe<nsCString> platform;
    mozilla::Maybe<nsCString> steeredprovider;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (canaries) {
        extraKeys.AppendElement()->AssignASCII("canaries");
        extraValues.EmplaceBack(canaries.value());
      }
      if (captivestate) {
        extraKeys.AppendElement()->AssignASCII("captiveState");
        extraValues.EmplaceBack(captivestate.value());
      }
      if (enterprise) {
        extraKeys.AppendElement()->AssignASCII("enterprise");
        extraValues.EmplaceBack(enterprise.value());
      }
      if (evaluatereason) {
        extraKeys.AppendElement()->AssignASCII("evaluateReason");
        extraValues.EmplaceBack(evaluatereason.value());
      }
      if (filtering) {
        extraKeys.AppendElement()->AssignASCII("filtering");
        extraValues.EmplaceBack(filtering.value());
      }
      if (networkid) {
        extraKeys.AppendElement()->AssignASCII("networkID");
        extraValues.EmplaceBack(networkid.value());
      }
      if (platform) {
        extraKeys.AppendElement()->AssignASCII("platform");
        extraValues.EmplaceBack(platform.value());
      }
      if (steeredprovider) {
        extraKeys.AppendElement()->AssignASCII("steeredProvider");
        extraValues.EmplaceBack(steeredprovider.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.evaluate_v2#heuristics.
   */
  constexpr impl::EventMetric<EvaluateV2HeuristicsExtra> evaluate_v2_heuristics(4770);

  /**
   * generated from doh.state_disabled
   */
  struct StateDisabledExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#disabled.
   */
  constexpr impl::EventMetric<StateDisabledExtra> state_disabled(4771);

  /**
   * generated from doh.state_enabled
   */
  struct StateEnabledExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#enabled.
   */
  constexpr impl::EventMetric<StateEnabledExtra> state_enabled(4772);

  /**
   * generated from doh.state_manually_disabled
   */
  struct StateManuallyDisabledExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#manuallyDisabled.
   */
  constexpr impl::EventMetric<StateManuallyDisabledExtra> state_manually_disabled(4773);

  /**
   * generated from doh.state_policy_disabled
   */
  struct StatePolicyDisabledExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#policyDisabled.
   */
  constexpr impl::EventMetric<StatePolicyDisabledExtra> state_policy_disabled(4774);

  /**
   * generated from doh.state_rollback
   */
  struct StateRollbackExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#rollback.
   */
  constexpr impl::EventMetric<StateRollbackExtra> state_rollback(4775);

  /**
   * generated from doh.state_shutdown
   */
  struct StateShutdownExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#shutdown.
   */
  constexpr impl::EventMetric<StateShutdownExtra> state_shutdown(4776);

  /**
   * generated from doh.state_uidisabled
   */
  struct StateUidisabledExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#UIDisabled.
   */
  constexpr impl::EventMetric<StateUidisabledExtra> state_uidisabled(4777);

  /**
   * generated from doh.state_uiok
   */
  struct StateUiokExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#UIOk.
   */
  constexpr impl::EventMetric<StateUiokExtra> state_uiok(4778);

  /**
   * generated from doh.state_uninstalled
   */
  struct StateUninstalledExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Results of DoH heuristics at startup and after network changes. This event was generated to correspond to the Legacy Telemetry event doh.state#uninstalled.
   */
  constexpr impl::EventMetric<StateUninstalledExtra> state_uninstalled(4779);
}

namespace security_doh_trr_performance {
  /**
   * generated from security.doh.trr_performance.resolved_record
   */
  struct ResolvedRecordExtra {
    mozilla::Maybe<nsCString> captiveportal;
    mozilla::Maybe<nsCString> domain;
    mozilla::Maybe<nsCString> networkunstable;
    mozilla::Maybe<nsCString> retrycount;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<nsCString> time;
    mozilla::Maybe<nsCString> trr;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (captiveportal) {
        extraKeys.AppendElement()->AssignASCII("captivePortal");
        extraValues.EmplaceBack(captiveportal.value());
      }
      if (domain) {
        extraKeys.AppendElement()->AssignASCII("domain");
        extraValues.EmplaceBack(domain.value());
      }
      if (networkunstable) {
        extraKeys.AppendElement()->AssignASCII("networkUnstable");
        extraValues.EmplaceBack(networkunstable.value());
      }
      if (retrycount) {
        extraKeys.AppendElement()->AssignASCII("retryCount");
        extraValues.EmplaceBack(retrycount.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (time) {
        extraKeys.AppendElement()->AssignASCII("time");
        extraValues.EmplaceBack(time.value());
      }
      if (trr) {
        extraKeys.AppendElement()->AssignASCII("trr");
        extraValues.EmplaceBack(trr.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * How long it took to resolve a test domain using TRR. This event was generated to correspond to the Legacy Telemetry event security.doh.trrPerformance.resolved#record.
   */
  constexpr impl::EventMetric<ResolvedRecordExtra> resolved_record(4780);

  /**
   * generated from security.doh.trr_performance.trrselect_dryrunresult
   */
  struct TrrselectDryrunresultExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The URL of the DoH provider chosen by the TRR selection dry-run This event was generated to correspond to the Legacy Telemetry event security.doh.trrPerformance.trrselect#dryrunresult.
   */
  constexpr impl::EventMetric<TrrselectDryrunresultExtra> trrselect_dryrunresult(4781);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDohMetrics_h
